# 一种自动化超宽带无线信号采集传输系统

## 基本信息

- **专利名称**：一种自动化超宽带无线信号采集传输系统
- **撰写时间**：2021.09.23
- **拟申请类型**：发明专利
- **发明人**：张三
- **撰写人**：张三
- **联系方式**：12345678

---

## 一、所属技术领域

本发明适用于宽带无线信号自动化采集及传输领域，系统包括射频变频单元、滤波单元、ADC单元、FPGA单元、主控单元、网络传输单元及服务器单元。本发明射频信号采集范围覆盖10M至8GHz，通过一次变频技术将射频信号转换至中频，并通过滤波器滤除镜像，保留待量化中频，然后通过采样时钟1.2288GHz的高速ADC进行量化，保证分析带宽达到500MHz。系统中ADC通过JESD204B接口与FPGA连接，采用4X链路，单根Lane速率达到12.288Gbps。

本发明采用FPGA作为DSP处理功能单元，主要完成量化数据接口、数字低通滤波、数字宽带均衡、数字下变频及采样率变换，使用DDR4进行数据缓存并通过PCIE接口与上位机通信，将缓存数据上传至主控单元，在节拍信号的控制下实现自动化数据包网络上传。服务器端运行数据接收服务，并产生节拍信号，引导并控制采集端设备自动化网络传输。

本发明可解决无线产品自动产线测试效率问题，通过自动化循环处理流程，大大提高了无线信号采集及IQ数据上传效率。

---

## 二、背景技术

通用信号分析仪均具备宽带信号采集并网络传输的能力，操作场景为信号分析仪通过射频缆线连接待测设备，通过千兆网卡连接至局域网络，网络中存在远程控制主机，主机通过发送SCPI指令设置分析仪的频点、参考电平或采样时长等参数，每次设置需要一个单独的SCPI指令操作，耗时较长，待参数配置完毕后再发送SCPI数据请求指令，完成IQ数据的网络传输。

上述操作流程均由远程控制主机发起，通过编写脚本逐条运行，交互频繁，操作时间长，如果应用于流水线等产线场景，效率极低。

本发明将参数设置脚本放置于FPGA中执行，配备有网络中心服务器，该服务器提供数据缓存池及节拍信号，保证信号采集端在统一的步调下执行，具有操作时刻可控、运行效率高、系统带宽使用率高的特点，完全满足产线测试效率要求高，测试范例固定的特定需求。

另外，本发明采用硬件功率校准技术，将海量校准数据预先缓存至FPGA的DDR外设，实现功率实时补偿。为进一步提高频谱分析速度，FFT等数据分析操作也作为选件在FPGA中实现。

---

## 三、本发明创造要解决的技术问题

本发明所要解决的技术问题是：

1. 超大带宽、超高采样率模数转换电路的设计
2. 低相位噪声本振源设计
3. JESD204B电路同步、信号同步以及数据流同步的FPGA实现和方法问题
4. 采用多项技术实现数字带通、均衡滤波器的问题
5. 采用海量预存校准数据实现带内均衡及功率实时补偿的问题
6. 采用预存脚本，正本及副本可切换固定范式操作的问题
7. 中心服务器数据缓存池设计及同步节拍控制的问题

---

## 四、本发明创造的技术方案

本发明为解决上述技术问题采用以下技术方案：

### 4.1 总体技术方案

本发明提供了一种利用中心服务器提供数据缓存池并提供同步节拍信号，控制网络中无线信号采集设备实现流水线测试自动化的方案。

### 4.2 系统组成

该方案功能结构如图1所示，主要由十部分组成，分别是：

![图1：发明方案概念框图](images/figure_1.png)

1. **一次射频变频单元**：覆盖10MHz至8GHz频率范围，将待测高频射频信号变频至中频频率，中频频点设置为307.2MHz
2. **宽带滤波器单元**：对中频信号进行滤波，滤除镜像频率，并实现ADC前端抗混叠滤波器功能
3. **高速ADC单元**：采用1.2288GHz采样时钟对中频宽带信号进行数字量化，保证500MHz分析带宽，通过JESD204B接口与FPGA通信，将量化信号传输给FPGA进行后续DSP处理
4. **参考时钟单元**：对10MHz高稳高精度时钟进行锁定，控制122.88MHz的VCXO产生相噪优良的稳定信号，并以122.88MHz信号为基础频率，10倍频产生采样时钟
5. **本振单元**：对122.88MHz参考信号进行锁定，采用小数分频，控制宽带VCO，产生混频器所需的本振信号
6. **FPGA信号处理单元**：提供DSP处理逻辑，采用JESD204B与高速ADC通信，采用DDR4作为外部缓存器，采用PCIe与上位机通信，提供了匹配的接口带宽，保证500Mhz带宽信号的接收、多项滤波器、数字下变频、数据缓存及数据上传
7. **主控单元**：实现硬件初始化及控制，实现数据采集上传，实现网络数据传输，支持SCPI指令解析
8. **网络传输接口**：实现指令及数据的网络传输
9. **同步信号接口**：实现系统的定时同步信号的传递
10. **中心服务器**：在本地网络中承载数据池服务，支持采集设备数据的上传和存储，实现同步节拍信号发起及控制功能，是网络系统中的控制中枢

### 4.3 各功能单元详细描述

#### 4.3.1 一次射频变频单元

采用有源混频器，频率范围覆盖10MHz至8GHz，其主要功能是实现不同频点的射频信号变频转换至固定中频输出，中频频点设定为307.2MHz；射频前端通过开关形成两路预处理通道，一路为处理大功率信号，采用数控衰减器，可对大信号做可编程功率衰减，另外一路为处理小信号通路，采用固定增益低噪放，降低链路噪声系数，增强信号灵敏度。

#### 4.3.2 宽带滤波器单元

低通设计，使用腔体滤波器，改善过渡带矩形系数，通带带宽为500MHz，主要作用为混频后镜像抑制及ADC前端抗混叠。

#### 4.3.3 高速ADC单元

使用采样率为1.2288GHz的高速ADC，数据接口为JESD204B，链路采用4X接口，单根Lane速率为12.288GHz；该ADC内部包括DDC及半带滤波数字信号处理链路，可编程实现不同的信号处理模式。

#### 4.3.4 参考时钟单元

具有内外参考切换功能，板载高精度10MHz OCXO，通过锁相环路与122.88MHz VCXO时钟进行锁相，从而产生高精度122.88MHz的基准时钟，该时钟分别提供给本振单元及FPGA单元作为参考，同时10倍频后产生1.2288GHz时钟作为ADC的采样时钟。

#### 4.3.5 本振单元

使用集成套片电路结构，具有小数分频能力，以122.88MHz参考作为基准锁相时钟，通过软件控制，产生不同的混频本振信号，本振信号功率可调，实现混频器3阶等性能最优化。

#### 4.3.6 FPGA信号处理单元

采用Kintex Ultrascale低功耗FPGA，实现量化信号的数字处理功能，具体功能模块包括：

- 与ADC的JESD204B高速数据接口
- 多相FIR低通滤波器
- 多相FIR任意响应滤波器
- 数字下变频单元
- DDR4数据缓冲接口单元
- PCIe上位机通信接口单元

#### 4.3.7 主控单元

采用X86架构CPU，通过PCIe与FPGA进行通信，实现硬件初始化及控制，实现数据采集上传，实现网络数据传输，支持SCPI指令解析。

### 4.4 详细处理流程

#### 4.4.1 射频信号处理流程

无线信号采集前端电路对射频信号进行变频处理，变频至固定频点307.2MHz；该通带信号通过通带500MHz带通滤波器进行抗混叠处理，馈入ADC进行量化；ADC采样频率为1.2288GHz。

#### 4.4.2 高速采样与数据传输

高速ADC实现了1.2288GHz的高速采样；使用了高速JESD204B链路与FPGA通信，单根Lane速率可达12.288Gbps，将500MHz带宽量化信号准确传输至FPGA。

#### 4.4.3 FPGA内部信号处理

FPGA内部采用Xilinx提供的JESD204B IP核与ADC进行通信，用户接口时钟为307.2Mhz，1个时钟具有4个采样点，并行数据传递至后端DSP单元进行进一步处理。

采集到的高速并行数据通过多项FIR数字滤波器进行滤波，实现较高矩形系数的滤波器，提高过渡带陡峭度，低通滤波后的数据传递至任意响应滤波器，进行宽带带内均衡，补偿系统的幅频响应，降低带内波动，为较高质量的功率测量提供硬件补偿。

#### 4.4.4 数据缓存与传输

FPGA接收外部节拍信号，在触发时刻将处理完毕的数据缓存至DDR4外部存储空间，缓存数据长度可调，时长参数软件可设，满足后续上位机对IQ数据的请求以及后续流控。FPGA可产生中断信号，在全局节拍信号的激励下定时进行网络数据传输。

#### 4.4.5 上位机与服务端数据流

上位机根据硬件中断信号请求IQ数据并通过PCIe缓存至上位机，然后通过网络传输，将连续IQ的数据传输至服务端；服务端响应IQ数据网络传输请求，并将数据缓存至资源池。服务端产生全局节拍信号，控制数据采集、传输的节奏。

---

## 五、本发明创造的效果和优点

本发明采用以上技术方案与现有技术相比，具有以下技术效果：

### 5.1 网络架构优势

采用网络架构，采集和测量分离。具体为数据集中缓存、数据采集节点分布式部署，同时保证采集节点设置的灵活性和中央调度的统一性。

### 5.2 中心服务器时序控制

采用中心服务器产生时序节拍的方法，统一调度采集节点的任务时序，充分利用网络带宽，减少网络传输冲突，提高了无线信号采集效率，适用于产线流水线测试。

### 5.3 系统架构合理性

系统架构较为合理，数据流清晰，采用多项技术，实时处理宽带信号，使用硬件均衡技术，补偿通带内频响，降低带内波动，提高功率及EVM测量精确度。

---

## 六、附图、表格及简单说明

### 图1：发明方案框图

![图1：发明方案概念框图](images/figure_1.png)

图1是发明方案框图，罗列了系统组成构建及逻辑关系，主体分为两部分，虚线圈住部分为分布式采集单元实现框图，另外一部分为基于网络的中心服务器，上述两者分别承担不同的工作任务，采集单元通过变频采样，实现无线信号的采集、存储及回传；中心服务器运行缓存池，并响应回传请求，同时发起节拍事件，引导采集单元按照特定的时序执行。

### 图2：FPGA控制逻辑框图

![图2：FPGA控制逻辑框图](images/figure_3.png)

图2是本发明控制逻辑FPGA实现框图，主要内容是：

1. 控制寄存器，软件可访问，配置当前工作参数和操作流程
2. 脚本存储器，分为正本和副本，可选择某一脚本执行
3. 射频等外设控制接口，按照脚本语义进行外设的配置和操作
4. 数据通道，根据外部触发信号指引，执行数据缓存或回传操作
5. 逻辑控制状态机，按照软件参数配合外部触发激励信号执行状态跳转，实现不同的时序流程
6. 外部触发激励信号接口，可以整形，计数，并产生特定事件

### 图3：操作流程图

![图3：操作流程图](images/figure_5.png)

图3是控制流程图：

1. **第一步**：系统上电并完成初始化（包括服务器和采集设备）
2. **第二步**：服务器发起第一个触发节拍
3. **第三步**：采集设备按照初始化参数响应触发节拍，开始执行当前激活的脚本，内部计数器开始计数
4. **第四步**：采集设备频点、参考电平等参数设置完毕，进入稳态，数据链路稳定
5. **第五步**：计数器在规定的计数值产生内部触发，开始数据采集并缓存
6. **第六步**：计数器在规定的计数值产生软件中断（保证第五步数据采集并缓存可靠执行），上位机响应中断信号，将缓存数据回传并通过网络发送至服务端

上述流程为服务器发起一次采集事件。循环执行，则可实现特定脚本条件下的无线信号自动采集。

### 图4：数据流程框图

![图4：FPGA数据流程图](images/figure_7.png)

图4是数据流程框图，首先ADC的量化数据通过JESD204B接口传送至FPGA，FPGA内部实现了采用多相技术的低通滤波器、均衡滤波器、功率补偿乘法器、DDC、采样率变换和PCIe通道。上位机通过PCIe通道传送数据并通过网络发送至服务器端。

---

## 七、具体实施方式

下面结合附图对本发明的技术方案做进一步的详细说明：

### 7.1 实施边界条件

首先根据操作环境，列出具体的实施边界条件和方法。

#### 表格1：边界条件列表

| 序号 | 边界条件描述 |
|------|--------------|
| 1 | 外部节拍信号（PP1S）是操作的基本时间单位 |
| 2 | 外部节拍信号由背板路由至FPGA，作为外部同步信号 |
| 3 | 节拍信号由服务器产生 |
| 4 | 只有当系统中所有板卡进入准备状态后，才可以发出 |
| 5 | 采集板卡响应外部节拍信号 |
| 6 | 采集板卡上电初始化后，进入READY状态，该状态可由服务器查询确认 |
| 7 | 在采集板卡为READY状态时，服务器可初始化采集板卡内的脚本，脚本分为正本和副本 |
| 8 | 在采集板卡为READY状态时，服务器可与采集板卡建立网络连接，并发出读请求 |
| 9 | 脚本的正本或副本选择由服务器指令确定 |
| 10 | 选定的脚本称为正本，其他称为副本 |
| 11 | 外部节拍信号上升沿有效 |
| 12 | 第一个节拍信号触发采集板卡状态跳转，由READY状态变为BUSY状态 |
| 13 | BUSY信号上升沿触发脚本执行，顺序执行N条，N由指令ID信息推算，脚本指针根据增量进行偏移（该增量为指令计数） |
| 14 | 一般情况下，采集板卡执行顺序为：1，配置外设，比如频率、衰减及增益等；2，由特定节拍计数值产生内部触发信号；3，内部触发信号触发IQ数据缓存至DDR；4，再次根据节拍计数值产生内部触发信号；5，该触发信号允许网络回传，网口上报 |

### 7.2 详细技术实现

#### 7.2.1 射频信号处理

无线信号采集前端电路对射频信号进行变频处理，变频至固定频点307.2MHz；该通带信号通过通带500MHz带通滤波器进行抗混叠处理，馈入ADC进行量化；ADC采样频率为1.2288GHz。

#### 7.2.2 高速采样与传输

高速ADC实现了1.2288GHz的高速采样；使用了高速JESD204B链路与FPGA通信，单根Lane速率可达12.288Gbps，将500MHz带宽量化信号准确传输至FPGA。

#### 7.2.3 FPGA信号处理

FPGA内部采用Xilinx提供的JESD204B IP核与ADC进行通信，用户接口时钟为307.2Mhz，1个时钟具有4个采样点，并行数据传递至后端DSP单元进行进一步处理。

采集到的高速并行数据通过多项FIR数字滤波器进行滤波，实现较高矩形系数的滤波器，提高过渡带陡峭度，低通滤波后的数据传递至任意响应滤波器，进行宽带带内均衡，补偿系统的幅频响应，降低带内波动，为较高质量的功率测量提供硬件补偿。

#### 7.2.4 数据缓存与传输

FPGA接收外部节拍信号，在触发时刻将处理完毕的数据缓存至DDR4外部存储空间，缓存数据长度可调，时长参数软件可设，满足后续上位机对IQ数据的请求以及后续流控。FPGA可产生中断信号，在全局节拍信号的激励下定时进行网络数据传输。

#### 7.2.5 上位机与服务端交互

上位机根据硬件中断信号请求IQ数据并通过PCIe缓存至上位机，然后通过网络传输，将连续IQ的数据传输至服务端；服务端响应IQ数据网络传输请求，并将数据缓存至资源池。服务端产生全局节拍信号，控制数据采集、传输的节奏。

结合上述流程阐述和图2、图3和图4所示框图，本发明阐述完毕。

---

## 八、附图说明

### 图1：发明方案概念框图
![图1](images/figure_1.png)

### 图2：FPGA控制逻辑框图
![图2](images/figure_3.png)

### 图3：操作流程图
![图3](images/figure_5.png)

### 图4：FPGA数据流程图
![图4](images/figure_7.png)
