# Patent Writing Skills

## 技能概述

本技能包含完整的专利交底书撰写能力，涵盖：
- 任意技术领域的专利交底书撰写
- 复杂技术方案的清晰表述与结构化描述
- 专利附图（Mermaid格式）的生成与中文化
- 技术创新点的提炼与规范化表达

## 技能详细说明

### 1. 专利交底书结构化撰写

**能力描述**：能够按照标准专利模板撰写完整的技术交底书，包含所有必要章节。

**包含内容**：
- 所属技术领域（400+字）
- 背景技术（2000+字，含现有技术分析、存在问题）
- 要解决的技术问题
- 技术方案（总体方案、软件/硬件实现、创新点、关键作用说明）
- 效果和优点
- 附图说明
- 具体实施方式（含参数表、详细步骤、实施例、接口实现等）
- 检索关键词及可替代表述

**适用场景**：
- 软件算法与人工智能相关专利申请
- 硬件系统与设备相关发明
- 通信与信号处理相关技术方案
- 图像处理与模式识别相关技术方案
- 其他技术领域的发明创造

### 2. 技术方案结构化描述能力

**能力说明**：
能够将复杂的技术方案按照专利撰写规范进行结构化描述，确保技术方案的完整性、可实施性和创新性的准确表达。

**总体技术方案描述**：
- 技术思路的整体阐述
- 核心技术架构的分层描述
- 各模块之间的协作关系
- 数据流向和处理流程

**软件/硬件实现方法**：
- 模块化设计思路
- 各模块功能和接口定义
- 关键算法或电路原理
- 参数配置和边界条件

**创新点提炼**：
- 与现有技术的区别点
- 解决技术问题的关键手段
- 技术效果的实现机制
- 可选实施例的扩展说明

**关键作用说明**：
- 各技术特征在整体方案中的作用
- 技术特征之间的协同关系
- 为什么采用该技术方案能够解决技术问题
- 技术方案带来的有益效果

### 3. 专利附图生成

**支持格式**：
- Mermaid流程图
- 架构图
- 对比示意图
- 原理说明图

**图表类型选择**：
根据技术方案的特点选择合适的附图类型：
1. **总体流程图** - 展示完整处理流程或工作过程
2. **系统架构图** - 展示系统组成、模块划分和数据流
3. **原理示意图** - 解释核心技术原理和创新点
4. **对比示意图** - 展示本发明与现有技术的区别和优势
5. **时序/状态图** - 展示时序关系或状态转换
6. **实施例图** - 展示具体实施方式或应用场景

**中文支持**：所有图表标签和说明均使用中文

**使用方法**：
- Typora直接渲染（推荐）
- Obsidian + Mermaid插件
- VS Code + Markdown Preview Mermaid Support插件
- 在线编辑器 https://mermaid.live/
- 导出为PNG/SVG用于专利申请

### 4. 技术文档撰写规范

**写作特点**：
- 结构清晰：层次分明，逻辑连贯
- 内容详实：技术参数、实施步骤、边界条件明确
- 语言规范：专业术语准确，符合专利撰写习惯
- 图文并茂：文字说明配合图表直观展示

**专利撰写要点**：
1. 所属技术领域要具体，不宜过于上位
2. 背景技术要指出现有技术的问题和缺点
3. 技术问题要正面表述发明目的
4. 技术方案要详细，可实施性强
5. 创新点要突出，明确区别于现有技术
6. 实施方式要具体，包含参数、步骤、实施例
7. 附图要清晰，黑白线条图，无底纹阴影

### 5. 技术方案文档化能力

**核心能力**：
- 从技术实现细节中提炼关键参数和配置
- 识别技术方案的边界条件和适用范围
- 将代码或电路图转化为结构化文字描述
- 设计合理的实施例来支持技术方案的宽泛性

**参数配置表设计**：
- 列出关键参数及其含义
- 说明参数的可选范围和典型值
- 解释参数选择对技术效果的影响
- 标注必要参数和可选参数

**实施步骤描述**：
- 按照逻辑顺序分解技术流程
- 每个步骤说明清楚输入、处理、输出
- 标注关键判断条件和分支
- 提供伪代码或算法描述作为辅助说明

**实施例设计**：
- 提供多个不同应用场景的实施例
- 说明各实施例之间的相同点和不同点
- 支持权利要求的宽泛解释
- 覆盖技术方案的核心变体

## 适用文件

1. **专利交底书模板**：`专利技术交底材料(模版).doc`
2. **参考案例**：任意同领域的已授权专利文档
3. **技术方案描述**：技术文档、设计文档、代码实现等
4. **附图文档**：生成的`patent_figures.md`等

## 输出示例

### 专利交底书文档

当用户需要撰写专利交底书时，生成完整文档：

```markdown
# 技能触发

用户："帮我写一个关于[技术方案描述]的专利交底书"

# 执行步骤

1. 分析技术方案，确认技术领域和核心创新点
2. 编写所属技术领域（400+字）
3. 编写背景技术（包含现有技术分析和问题）
4. 编写要解决的技术问题
5. 编写技术方案：
   - 总体技术方案
   - 软件/硬件实现方法（模块化）
   - 关键创新点
   - 各技术特征的作用说明
6. 编写效果和优点
7. 设计附图说明
8. 编写具体实施方式：
   - 边界条件与参数设置表
   - 详细实施步骤（含伪代码/电路描述）
   - 实施例
   - 接口/部件实现
9. 编写检索关键词
10. 使用Mermaid生成配套附图
11. 输出完整文档
```

### 专利附图生成

当用户需要专利附图时：

```markdown
# 技能触发

用户："为这个专利生成附图" 或 "制作技术示意图"

# 执行步骤

1. 理解技术方案，确定需要的附图类型和数量
2. 使用Mermaid语法创建图表：
   - 流程图：展示处理流程或工作过程
   - 架构图：展示系统组成
   - 示意图：对比不同方案
   - 原理图：解释核心原理
3. 确保所有标签使用中文
4. 生成markdown格式的图表文档
5. 同步生成技术示意图，并在专利交底书md文件中相应位置引用
6. 生成 Mermaid 格式的图表文件
7. 如用户已安装 mermaid-cli，可协助将图表转换为 PNG；否则仅生成 Markdown 格式图表，由用户自行转换
8. 在专利交底书md文件中相应位置引用

## 技术要点总结

1. **技术问题与技术方案的对应性**
   - 技术问题要来源于现有技术的实际缺陷
   - 技术方案要针对性解决技术问题
   - 避免技术问题与技术方案脱节

2. **技术方案的层次化表述**
   - 总体方案、模块方案、具体实现三层结构
   - 上层概括，下层细化
   - 每一层都要说明清楚技术手段和技术效果

3. **实施方式的完整性**
   - 参数表：列出所有关键参数
   - 步骤：详细的实施流程
   - 实施例：多个具体应用场景
   - 支持权利要求的宽泛性和具体性

## 相关技术领域

本技能可应用于以下技术领域的专利撰写：
- 软件与算法
- 通信与网络
- 人工智能与机器学习
- 图像处理与计算机视觉
- 硬件系统与电子电路
- 机械结构与设备
- 控制系统与自动化
- 数据处理与存储
- 网络安全与加密
- 其他技术领域
