---
name: patent-disclosure-writer
description: "撰写中文专利交底书。Use when: 用户需要撰写专利交底书、技术交底书、专利申请文档。"
metadata:
  {
    "openclaw":
      {
        "emoji": "📋",
        "requires": { "bins": ["pandoc", "mmdc"] },
      },
  }
---

# 专利交底书撰写助手

帮助用户撰写符合格式要求的中文专利交底书。

## 信息收集流程

专利交底书需要收集以下两类信息，这些信息可以通过和用户对话获取，如果用户提供了文档包含了部分或全部信息，就从文档中提取这些信息，并收集其他未提供的信息。 **缺少任何一项都不能开始撰写**：

### 第一类：基本信息（必需）

| 字段 | 说明 | 示例 |
|------|------|------|
| 专利名称 | 技术方案的名称，应体现技术特点 | "一种基于深度学习的图像识别方法" |
| 专利类型 | 发明 / 实用新型 / 外观设计 | 发明 |
| 发明人 | 实际做出创造性贡献的人 | 张三、李四 |
| 撰写人 | 撰写本文档的人 | 王五 |
| 联系方式 | 电话或邮箱 | 138xxxx1234 |

### 第二类：技术内容

| 字段 | 说明 | 是否必需 |
|------|------|------|
| 技术背景 | 介绍本发明所属的技术领域和技术背景 | 必需 |
| 发明目的 | 本发明要解决的技术问题 | 必需 |
| 技术方案 | 解决技术问题的具体方案（核心内容）| 必需 |
| 有益效果 | 与现有技术相比的优点 | 必需 |
| 具体实施方式 | 至少一个具体实施例，详细描述实现过程 | 非必需 |
| 附图说明 | 如有附图，说明各图的含义 | 非必需 |

## 对话策略

### 信息收集阶段

1. **初始触发**：用户提到"专利交底书"、"技术交底书"、"写专利"时触发本skill

2. **分批询问**：
   - 第一轮：询问第一类基本信息（专利名称、类型、发明人、撰写人、联系方式）
   - 第二轮：询问第二类技术内容（技术领域、背景技术、发明目的）
   - 第三轮：询问技术方案和具体实施方式（核心部分）

3. **一次最多问 2-3 个问题**，避免用户负担过重

4. **追问澄清**：
   - 如果用户描述模糊，追问具体细节
   - 技术方案尽量详细，能让本领域技术人员实现

### 信息确认阶段

收集完所有信息后，向用户复述确认：

```
好的，信息收集完毕，确认如下：

【基本信息】
- 专利名称：xxx
- 专利类型：xxx
- 发明人：xxx
- 撰写人：xxx
- 联系方式：xxx

【技术内容】
- 技术领域：xxx
- 背景技术：xxx
- 发明目的：xxx
- 技术方案：xxx
- 有益效果：xxx
- 具体实施方式：xxx

确认无误后，我将按照标准格式生成专利交底书。
```

### 环境和工具检查阶段

用户确认后，确认撰写专利所需的工具环境。本技能依赖以下工具（需用户自行安装）：

**必需：**
- `references/Patent_Writing.md` 和 `references/patent_example.md` 参考文件

**可选（用于生成 Word 和附图）：**
- pandoc - 用于将 Markdown 转换为 Word 文档
- mermaid-cli - 用于将 Mermaid 图表转换为 PNG 图片

如果上述工具未安装，向用户说明依赖关系，由用户自行决定是否安装。

### 建立工作目录阶段

在用户目录下建立文件夹，文件夹的名称为: '专利-[专利名称]-[日期]'，如该目录已经存在，则提示用户是继续在该目录下生成还是另外新建目录。

### 规划撰写步骤阶段

1. 参考 `references/Patent_Writing.md`  和 `references/patent_example.md`, 确定专利交底书的提纲，同时给出正式撰写专利交底书的大致执行时间。  
2. 待用户确认提纲符合要求后再正式撰写。如果用户提出修改建议，按照用户的要求修改交底书的提纲。

### 撰写阶段

按照用户确认的提纲，读取参考文件并生成文档：

1. 阅读 `references/Patent_Writing.md` 了解撰写指南和格式要求
2. 生成的专利交底书参考 `references/patent_example.md` 的示例结构
3. 按照用户提供的信息生成专利交底书文件

## 输出格式

生成的专利交底书的名称为：专利交底书-[专利名称]-[日期].md, 并保存在之前建立的目录下。

生成的图片保存在 images 子目录下，格式为png。 要求分辨率达到 1024 x 768 以上并保证其中的字迹清晰。

专利交底书生成后，转换为 word 格式，名称为：专利交底书-[专利名称]-[日期].doc， 之前的 markdown 文件保留不删除。

## 注意事项

- 技术方案部分要写得足够详细，这是专利的核心
- 使用规范的技术术语，避免口语化表达
- 具体实施方式要能让本领域技术人员根据描述实现该发明
- 生成的过程中尽量避免长时间无交互的情况，每完成一个步骤，就将完成的情况发送给用户

## 参考资料

- **撰写指导和格式要求**：阅读 `references/Patent_Writing.md`
- **示例文档**：阅读 `references/patent_example.md` 了解标准结构和写作风格

## 示例对话

**用户**："帮我写个专利交底书"

**助手**："好的，我来帮您撰写专利交底书。首先需要了解一些基本信息：

1. 专利名称是什么？
2. 是什么类型的专利（发明/实用新型/外观设计）？"

**用户**："一种智能水杯，实用新型"

**助手**："收到。请再提供以下信息：

3. 发明人是谁？
4. 撰写人是谁？
5. 联系方式（电话/邮箱）？"

...（继续收集技术内容）...

**助手**："好的，所有信息已收集完毕。我将参考格式要求和示例为您生成专利交底书。"

（读取参考文件后生成文档）
