---
name: patent-assistant
version: 1.1.0
description: 专利交底书撰写与专利检索助手。帮助研发人员将技术方案转化为结构化交底书，并进行专利检索分析。当用户要求写专利、写交底书、专利检索、查新时使用。
---

# 专利助手

帮助研发人员撰写专利技术交底书，并进行专利检索。

## 功能

### 1. 技术交底书生成

将口语化的技术描述转化为结构化的专利技术交底书。

**使用方式：**
```
帮我写一份专利交底书：[技术方案描述]
```

**输出结构：**
- 发明名称
- 技术领域
- 背景技术（现有技术及缺陷）
- 发明内容（技术问题、技术方案、有益效果）
- 具体实施方式
- 附图说明建议

### 2. 专利检索

基于技术方案进行专利检索，分析新颖性。

**使用方式：**
```
帮我检索相关专利：[技术关键词或交底书内容]
```

**输出内容：**
- 相关专利列表（专利号、标题、摘要）
- 技术相似度分析
- 新颖性初步判断

## 交底书生成流程

当用户提供技术方案时，按以下步骤处理：

### Step 1: 信息收集

如果用户提供的信息不完整，询问以下关键点：
- 要解决什么技术问题？
- 现有方案有什么缺陷？
- 你的方案核心是什么？
- 有哪些关键技术特征？
- 能达到什么效果？

### Step 2: 生成交底书

使用以下模板生成：

```markdown
# 专利技术交底书

## 一、发明名称
[简洁描述技术方案的名称，格式：一种XXX的方法/装置/系统]

## 二、技术领域
本发明涉及[大领域]技术领域，具体涉及[细分领域]。

## 三、背景技术
### 3.1 现有技术描述
[描述当前主流的技术方案]

### 3.2 现有技术缺陷
现有技术存在以下问题：
1. [问题1]
2. [问题2]
3. [问题3]

## 四、发明内容
### 4.1 要解决的技术问题
本发明要解决的技术问题是：[核心问题]

### 4.2 技术方案
为解决上述技术问题，本发明采用以下技术方案：
[详细描述技术方案，包含所有关键技术特征]

### 4.3 有益效果
采用本发明的技术方案，具有以下有益效果：
1. [效果1]
2. [效果2]
3. [效果3]

## 五、具体实施方式
### 5.1 实施例一
[详细描述一个具体实施例]

### 5.2 实施例二（可选）
[描述另一个实施例或变体]

## 六、附图说明
建议绘制以下附图：
- 图1：[附图内容建议]
- 图2：[附图内容建议]

## 七、关键词
[用于专利检索的关键词列表]
```

### Step 3: 优化建议

生成后提供：
- 权利要求书撰写建议
- 可能的扩展方向
- 需要补充的技术细节

## 专利检索流程

### Step 1: 提取检索关键词

从技术方案中提取：
- 核心技术术语
- 同义词/近义词
- IPC 分类号建议

### Step 2: 执行检索

使用 `scripts/patent_search.py` 进行多平台检索：

```bash
# 单平台检索（默认 Google Patents）
python scripts/patent_search.py "关键词1 关键词2" --limit 20

# 多平台并行检索（推荐）
python scripts/patent_search.py "关键词" -s all -p

# 指定平台检索
python scripts/patent_search.py "关键词" -s google,cnipa,innojoy

# 带相似度分析
python scripts/patent_search.py "关键词" -s all -p -a
```

**支持的检索平台：**
| 平台 | 参数 | 说明 |
|------|------|------|
| Google Patents | google | 全球专利，免费，数据最全 |
| Lens.org | lens | 专利+论文，免费开放 |
| 大为Innojoy | innojoy | 中国专利，免费基础版 |
| 百度学术 | baidu | 论文为主，部分专利 |
| Espacenet | espacenet | 欧洲专利局，全球数据 |
| 国知局CNIPA | cnipa | 中国官方，需登录账号 |
| 全部平台 | all | 同时检索所有平台 |

### Step 3: 分析结果

对检索结果进行：
- 技术相似度排序
- 关键特征对比
- 新颖性初步判断

## 注意事项

1. **交底书仅供参考**：生成的交底书需要发明人审核补充
2. **检索不能替代查新**：正式查新需要专业机构
3. **权利要求需专业撰写**：建议由专利代理人完成
4. **保密提醒**：提交前确认技术方案未公开

## 常用 IPC 分类

| 领域 | IPC 分类号 |
|------|-----------|
| 计算机软件 | G06F |
| 人工智能 | G06N |
| 图像处理 | G06T |
| 通信 | H04L, H04W |
| 数据库 | G06F 16/ |
| 物联网 | H04L 67/ |
| 区块链 | H04L 9/, G06Q |

## 示例

**用户输入：**
> 我做了一个用 AI 自动生成代码注释的工具，能识别代码逻辑自动写注释

**输出交底书：**
> （生成完整的交底书结构）

**检索结果：**
> （列出相关专利及分析）
