---
name: paste-rs
description: Paste text, Markdown, or HTML snippets to https://paste.rs and return a shareable URL. Use when the user asks to "paste"/"upload" text to paste.rs, share logs/config snippets safely as a link, or quickly publish command output without sending long messages.
---

# paste.rs

## Quick start (preferred)

Use the bundled script (it **saves a local `.md` file first**, then uploads):

```bash
# paste from stdin
some_command | python3 skills/paste-rs/scripts/paste_rs.py

# paste a file
python3 skills/paste-rs/scripts/paste_rs.py --file ./notes.md

# paste an inline snippet
python3 skills/paste-rs/scripts/paste_rs.py --text '<h1>Hello</h1>'

# choose where the .md file is saved (default: /tmp)
python3 skills/paste-rs/scripts/paste_rs.py --outdir ./tmp-pastes --text 'hello'
```

Output:
- **stdout**: URL `https://paste.rs/XXXX.md`
- **stderr**: path `saved: /tmp/paste-rs-YYYYMMDD-HHMMSS.md`

## Curl one-liners (fallback)

```bash
# stdin
some_command | curl -fsS https://paste.rs -d @-

# file
curl -fsS https://paste.rs -d @./file.txt
```

## Safety notes

- Treat the pasted content as **public**.
- Script `scripts/paste_rs.py` melakukan **redact otomatis by default** untuk pola rahasia umum (token/apiKey/botToken/password/Authorization).
- Kalau memang butuh raw (tidak disarankan), pakai `--no-redact`.

## Resources

- `scripts/paste_rs.py`: deterministic uploader (stdin / --text / --file)
- `references/paste-rs-api.md`: minimal API reference
