# Transport Guide — Paris

Paris has excellent public transport. The Metro covers the city; buses fill gaps; RER reaches suburbs and airports.

---

## System Overview

| Mode | Coverage | Best For |
|------|----------|----------|
| **Metro** | 16 lines, 300+ stations | Central Paris, most trips |
| **RER** | 5 lines, suburbs + airports | CDG, Versailles, La Défense |
| **Bus** | 300+ routes, surface travel | Scenic routes, night travel |
| **Tram** | Outer ring of Paris | T3 circles the periphery |
| **Vélib** | 20,000 bikes citywide | Short trips, good weather |

**Key insight:** Metro gets you almost anywhere in 30 min. Use it for everything central.

---

## Tickets & Passes

### Quick Decision

| Situation | Best Option |
|-----------|-------------|
| **1-2 days** | Carnet of 10 tickets (€17.35) |
| **3-5 days** | Paris Visite Pass (€29-62) |
| **1 week** | Navigo Découverte (€30.75 all zones) |
| **Living here** | Navigo monthly (€86.40 all zones) |
| **Occasional rider** | Single tickets via app (€2.15) |

### Ticket Types (2025)

| Ticket | Price | Valid For |
|--------|-------|-----------|
| **Single (t+)** | €2.15 | Metro, bus, RER Zone 1 |
| **Carnet (10 tickets)** | €17.35 | Same as single, 20% savings |
| **Navigo Easy (reloadable)** | €2 card + tickets | Contactless, phone app |
| **Navigo Découverte (week)** | €30.75 | Mon-Sun, all zones |
| **Paris Visite 1 day** | €14.45 | All zones, unlimited |
| **Paris Visite 5 days** | €62.30 | All zones, unlimited |

**Note:** Paper tickets being phased out. Use Navigo Easy card or phone app.

### Navigo Découverte

Best value for week stays (all zones = €30.75):
- Valid Monday 00:00 to Sunday 23:59
- Buy before Wednesday to get full value
- Requires passport photo (bring one or use photo booth at station)
- Purchase at any Metro station

---

## Metro

### Basics

- **Hours:** 5:30 AM - 12:40 AM (2:15 AM Fri-Sat)
- **Frequency:** Every 2-5 min peak, 5-10 min off-peak
- **Zones:** Metro is always Zone 1

### Useful Lines

| Line | Key Stops | Notes |
|------|-----------|-------|
| **1** | La Défense, Champs-Élysées, Louvre, Bastille | Automated, most useful |
| **4** | Gare du Nord, Les Halles, Saint-Germain | North-south spine |
| **6** | Eiffel Tower (Bir-Hakeim), elevated scenic views | Best for tourists |
| **9** | Trocadéro (Eiffel view) | Photo spot |
| **14** | Automated, fast, airport extension coming | Newest line |

### Metro Safety

| Issue | Where | Prevention |
|-------|-------|------------|
| Pickpocketing | Line 1, 4, 6; tourist stations | Bag in front, stay alert |
| Phone snatching | Door closing moment | Don't hold phone near door |
| Beggars/performers | Everywhere | Ignore, normal |

---

## RER (Suburban Trains)

### To Airports

| Airport | Line | Time | Cost |
|---------|------|------|------|
| **CDG** | RER B | 35-50 min | €11.80 |
| **Orly** | RER B + OrlyVal | 45 min | €14.50 |
| **Orly** | Tram T7 from Villejuif | 45 min | €2.15 |

**CDG Tips:**
- RER B every 10-15 min
- Buy ticket BEFORE going to platform
- Watch your bags — thieves target tourists with luggage

### To Key Destinations

| Destination | Line | From | Time |
|-------------|------|------|------|
| Versailles | RER C | Any central | 40 min |
| Disneyland | RER A | Nation | 45 min |
| La Défense | RER A | Châtelet | 15 min |

---

## Buses

| Route | Scenic | Connects |
|-------|--------|----------|
| **69** | ✅ Yes | Eiffel → Bastille (beautiful route) |
| **72** | ✅ Yes | Along Seine |
| **Noctilien** | Night | All night service (N01-N100+) |

**Tip:** Bus 69 is the budget sightseeing tour. Same price as metro, great views.

---

## Taxis & Uber

### Taxis

| Route | Fixed Price |
|-------|-------------|
| CDG → Right Bank | €56 |
| CDG → Left Bank | €65 |
| Orly → Right Bank | €44 |
| Orly → Left Bank | €39 |

**Rules:**
- Flat rate TO/FROM airports only (since 2016)
- Within Paris: metered
- Night surcharge after 7 PM
- Official taxis = roof light "TAXI Parisien"

### Uber & Apps

| App | Pros | Cons |
|-----|------|------|
| **Uber** | Easy, card payment | Slightly more than taxi |
| **Bolt** | Often cheaper | Smaller network |
| **FreeNow** | Official taxis | App quality varies |
| **G7** | Traditional taxi app | Cash or card |

**Uber typical:** €15-25 within central Paris. Surge pricing during rain.

---

## Vélib (Bike Share)

| Pass | Price | Notes |
|------|-------|-------|
| Single ride | €3 (30 min) | Additional €1/30min |
| Day pass | €5 | 30-min rides unlimited |
| Monthly | €3.10/month | First 30 min free per trip |

**E-bikes:** €0.10/min extra. Worth it for hills (Montmartre).

**Best areas:** Along Seine, Marais, Canal Saint-Martin. Avoid at night.

---

## Apps to Download

| App | Purpose |
|-----|---------|
| **Citymapper** | Best overall navigation |
| **RATP** | Official Paris transport |
| **Bonjour RATP** | Ticket purchase |
| **Vélib** | Bike rental |
| **Uber/Bolt** | Ride-hailing |

---

## Driving — Don't

| Issue | Details |
|-------|---------|
| Parking | Nearly impossible, €4-6/hour |
| Traffic | Constant gridlock |
| ZFE (Low emission zone) | Older cars banned from center |
| Fines | Bus lanes, pedestrian zones |
| One-way streets | Confusing, aggressive drivers |

**Only exception:** Day trips outside Paris (rent at edge of city).
