# Tech Industry — Paris

## Overview

Paris is Europe's #2 tech hub after London. Strong startup ecosystem, government support (French Tech), and major tech company presence. Salaries lower than London/US but quality of life compensates.

---

## Tech Hubs & Coworking

| Space | Type | Location | Notes |
|-------|------|----------|-------|
| **Station F** | World's largest startup campus | 13th | 1000+ startups, free events |
| **WeWork** | Coworking | Multiple | Corporate-friendly |
| **Morning** | Coworking | 10th, 11th | Startup culture |
| **La Felicità** | Food hall + workspace | 13th | Near Station F |
| **Anticafé** | Pay-per-time workspace | Multiple | Good for freelancers |

**Station F:** Free to visit, hosts events. Many incubators, VCs, startups.

---

## Major Tech Companies in Paris

| Company | Office Size | Focus |
|---------|-------------|-------|
| **Google** | 1000+ | AI lab, engineering |
| **Meta** | 500+ | AI research (FAIR) |
| **Microsoft** | 1500+ | Cloud, AI |
| **Amazon** | 2000+ | Engineering, AWS |
| **Apple** | 500+ | Retail, some engineering |
| **Datadog** | 500+ | Founded by French, major hub |
| **Criteo** | HQ | AdTech, French unicorn |
| **BlaBlaCar** | HQ | Carpooling, French unicorn |
| **Deezer** | HQ | Music streaming |
| **Doctolib** | HQ | Healthcare, fast-growing |
| **Contentsquare** | HQ | Analytics unicorn |
| **Mirakl** | HQ | Marketplace platform |

---

## Salary Ranges (2025)

| Role | Junior | Mid | Senior | Staff/Lead |
|------|--------|-----|--------|------------|
| **Software Engineer** | €40-50K | €50-70K | €70-90K | €90-120K |
| **Frontend** | €38-48K | €48-65K | €65-85K | €85-110K |
| **Backend** | €42-52K | €52-72K | €72-95K | €95-130K |
| **Data Engineer** | €45-55K | €55-75K | €75-100K | €100-140K |
| **DevOps/SRE** | €45-55K | €55-80K | €80-100K | €100-130K |
| **Product Manager** | €45-55K | €55-75K | €75-100K | €100-130K |
| **Engineering Manager** | - | €70-90K | €90-120K | €120-160K |

**Notes:**
- Equity rare outside startups
- 13th month bonus common
- Profit sharing (intéressement) adds 5-10%
- Compare: London = +30-50%, US = +100-150%

---

## Best Neighborhoods for Tech Workers

| Area | Why | Commute to Sentier |
|------|-----|-------------------|
| **2nd (Sentier)** | Tech hub itself | Walk |
| **10th** | Hip, cafes, affordable | 5-10 min |
| **11th** | Nightlife, restaurants | 10 min |
| **3rd (Marais)** | Central, nice | 10 min |
| **9th** | Professional, near offices | 5 min |

---

## French Tech Visa

Fast-track visa for tech workers, founders, investors.

| Type | Requirements | Duration |
|------|--------------|----------|
| **Talent Passport - Salaried** | €39K+ salary at innovative company | 4 years |
| **Talent Passport - Founder** | Founding innovative company | 4 years |
| **Tech Investor** | €300K+ investment | 4 years |

**Benefits:**
- Family included
- Path to permanent residence
- No labor market test

---

## Networking & Community

| Event/Community | Type | Frequency |
|-----------------|------|-----------|
| **Paris Tech Meetup** | General tech | Monthly |
| **French Tech All Stars** | Startup events | Quarterly |
| **La French Tech** | Government initiative | Ongoing |
| **React Paris** | Frontend | Monthly |
| **Paris.rb** | Ruby | Monthly |
| **Paris.py** | Python | Monthly |
| **Women Who Code Paris** | Diversity | Monthly |

---

## Remote Work Culture

| Aspect | Paris Reality |
|--------|---------------|
| **Hybrid** | Most companies: 2-3 days office |
| **Full remote** | Startups more flexible |
| **Coworking** | Many options, €200-400/month |
| **Café culture** | Acceptable for some work |

---

## Job Search

| Platform | Notes |
|----------|-------|
| **Welcome to the Jungle** | French tech favorite |
| **LinkedIn** | Standard |
| **Station F Job Board** | Startups |
| **French Tech Job Board** | Government-backed |
| **Angel.co** | Startup-focused |

**Tips:**
- French helps but English-only roles exist
- Startups more flexible on language
- Big tech = English usually fine
