# Startup Guide — Paris

## Overview

Paris is Europe's fastest-growing startup ecosystem. Government support (French Tech), top talent, and strong VC presence. More affordable than London/Bay Area with comparable quality of life.

---

## Why Paris for Startups

| Factor | Reality |
|--------|---------|
| **Talent** | Top engineering schools, diverse pool |
| **Funding** | €12B+ VC funding 2023 |
| **Government** | French Tech visa, tax incentives |
| **Cost** | 30-50% cheaper than London |
| **Quality of life** | Culture, food, lifestyle |
| **Market access** | EU base, 450M consumers |

---

## Station F

World's largest startup campus. Essential for any founder.

| Resource | Details |
|----------|---------|
| **Location** | 13th arrondissement |
| **Size** | 34,000 m², 1,000+ startups |
| **Programs** | Microsoft, Facebook, Meta accelerators |
| **Cost** | €195-900/month for desk |
| **Events** | Daily, often free |

**How to join:**
- Apply to incubator program (Meta, Microsoft, HEC, etc.)
- Or apply for Fighters Program (€195/month)

---

## Funding Landscape

### VC Firms (Active in Paris)

| Fund | Stage | Focus |
|------|-------|-------|
| **Partech** | Seed to Growth | General tech |
| **Eurazeo** | Growth | Consumer, B2B |
| **Balderton** | Series A-C | Pan-European |
| **Elaia** | Seed, Series A | Deep tech |
| **Kima Ventures** | Seed | Prolific, fast |
| **Ventech** | Series A-B | Enterprise |
| **Breega** | Seed to Series B | B2B, SaaS |
| **Daphni** | Seed, Series A | Impact, tech |

### Typical Funding Rounds

| Stage | Amount | What You Need |
|-------|--------|---------------|
| **Pre-seed** | €200K-500K | MVP, team |
| **Seed** | €500K-2M | Traction, early revenue |
| **Series A** | €5-15M | Product-market fit |
| **Series B** | €20-50M | Scaling |

---

## Government Support

### French Tech

| Program | Details |
|---------|---------|
| **French Tech Visa** | Fast-track for founders, employees |
| **French Tech 120** | Top 120 scale-ups, special support |
| **Bpifrance** | Government investment bank, loans, grants |
| **CIR/CII** | R&D tax credits (30% of R&D spending) |
| **JEI Status** | Tax exemptions for young innovative companies |

### JEI (Jeune Entreprise Innovante)

| Benefit | Details |
|---------|---------|
| **Payroll tax exemption** | Up to 8 years |
| **Corporate tax reduction** | First years |
| **Requirements** | <8 years old, <250 employees, 15%+ R&D |

---

## Incorporation

| Structure | Best For | Process Time |
|-----------|----------|--------------|
| **SAS** | Most startups | 1-2 weeks |
| **SASU** | Solo founders | 1-2 weeks |
| **SARL** | Small businesses | 1-2 weeks |

**Costs:** €500-2,000 (lawyer, notary fees)

**Platform:** Legalstart, Captain Contrat (online incorporation)

---

## Incubators & Accelerators

| Program | Focus | Duration |
|---------|-------|----------|
| **Station F Programs** | Various | 3-12 months |
| **50 Partners** | Late seed | 3 months |
| **The Family** | Consumer, B2B | 6 months |
| **Techstars Paris** | General | 3 months |
| **L'Accélérateur** | Scaling | 6 months |
| **Plug and Play** | Corporate innovation | Varies |

---

## Coworking Options

| Space | Price/Desk | Vibe |
|-------|------------|------|
| **Station F** | €195-900/mo | Startup central |
| **WeWork** | €400-800/mo | Corporate |
| **Morning** | €250-450/mo | Hip, tech |
| **Anticafé** | €5/hour | Freelance |
| **Kwerk** | €350-600/mo | Design-focused |

---

## Talent

### Where to Hire

| Source | Notes |
|--------|-------|
| **Welcome to the Jungle** | French tech platform |
| **Station F job board** | Startup-specific |
| **École 42** | Free coding school, great devs |
| **HEC, Sciences Po** | Business talent |
| **Polytechnique, Centrale** | Engineering talent |

### Salary Benchmarks (Startup)

| Role | Seed Stage | Series A+ |
|------|------------|-----------|
| Junior Dev | €35-45K | €45-55K |
| Senior Dev | €55-70K | €70-90K |
| Product Manager | €50-65K | €65-85K |
| Growth/Marketing | €40-55K | €55-75K |
| Sales | €40K + commission | €50K + commission |

**Equity:** Common in startups, typically BSPCE (French stock options)

---

## Networking

| Event | Frequency | Notes |
|-------|-----------|-------|
| **La French Tech events** | Monthly | Government-backed |
| **Station F events** | Daily | Free, open |
| **VivaTech** | Annual (June) | Major conference |
| **Startup Weekend** | Monthly | Hackathons |
| **Founders meetups** | Weekly | Various groups |

---

## Common Mistakes

| Mistake | Reality |
|---------|---------|
| Underestimating bureaucracy | Plan 2-3 weeks for admin |
| Ignoring French | Helps enormously with hiring, customers |
| Only targeting France | EU market is the opportunity |
| Not using JEI status | Significant savings |
| Skipping Station F | Best ecosystem access |
