# Safety Guide — Paris

## Overall Assessment

Paris is a safe major city. Violent crime against tourists is very rare. Main concerns are pickpocketing, phone snatching, and street scams. Exercise normal urban awareness.

**Comparison:** Slightly less safe than London for petty theft. Safer than Barcelona. Less safe than Tokyo or Amsterdam.

---

## Crime by Type

### Pickpocketing (Most Common)

| Hotspots | How It Happens | Prevention |
|----------|----------------|------------|
| Metro Line 1, 4, 6 | Crowded trains, distraction | Bag in front, zipped |
| Eiffel Tower area | Tourists distracted by photos | Cross-body bag |
| Louvre queues | Standing still, not alert | Valuables in front pockets |
| Sacré-Cœur steps | Scam distractions | Decline all approaches |
| Champs-Élysées | Shopping crowds | Stay aware |
| Gare du Nord | Luggage distraction | Never put bags down |

### Phone Snatching

| Method | Where | Prevention |
|--------|-------|------------|
| Door closing grab | Metro at stop | Don't use phone near doors |
| Moped snatch | Streets, crossings | Phone in pocket while walking |
| Table grab | Outdoor cafes | Never put phone on table |
| Distraction + grab | Tourist areas | Brief phone use, then away |

### Street Scams

| Scam | How It Works | Response |
|------|--------------|----------|
| **Gold ring** | "Found" ring offered for sale | Ignore, walk away |
| **Petition** | Sign = donation demand or distraction | Say "Non", keep moving |
| **Bracelet/string** | Tied on wrist, demands payment | Don't let them touch you |
| **Three-card monte** | Street gambling, rigged | Never play, crowds are shills |
| **Fake flower sellers** | Forces flower, demands payment | Firmly refuse |
| **Free gift** | CD, trinket → demands money | Don't accept anything |
| **"Do you speak English?"** | Leads to donation/scam | Brief "no", walk on |
| **Euronet ATMs** | 10-40% hidden exchange fees | Use bank ATMs only |

### Scam Hotspots

| Area | Scam Types | Advice |
|------|------------|--------|
| Sacré-Cœur steps | Bracelet, petition, three-card | Walk purposefully |
| Eiffel Tower base | Ring, trinket sellers | Ignore all vendors |
| Champs-Élysées | Clipboard petitions | Don't engage |
| Notre-Dame area | Petition, donation requests | Decline firmly |
| Gare du Nord | Fake helpers, taxi scams | Official channels only |

---

## Areas by Safety Level

| Safety | Areas |
|--------|-------|
| ⭐⭐⭐⭐⭐ Very Safe | 6th, 7th, 8th, 16th, Marais (3rd-4th) |
| ⭐⭐⭐⭐ Safe | 1st, 2nd, 5th, 9th, 11th, 12th, 15th |
| ⭐⭐⭐ Generally Safe | 10th (central), 14th, 17th, 13th, 20th (south) |
| ⭐⭐ Caution at Night | North 18th (Goutte d'Or), 19th (parts), La Chapelle |
| ⭐ Avoid | Porte de la Chapelle, Stalingrad area late night |

**Note:** Even "caution" areas are fine during daytime. Issues are late night, isolated streets.

---

## Night Safety

### What Changes After Dark

| Time | Considerations |
|------|----------------|
| 6-10 PM | Well-lit areas fine, normal crowds |
| 10 PM - midnight | Stick to busy streets, nightlife areas safe |
| Midnight - 5 AM | Use Uber/taxi, avoid isolated areas |
| Metro closes | Noctilien buses or ride-hailing |

### Areas to Avoid Late Night

- Gare du Nord exterior
- Barbès-Rochechouart area
- Porte de la Chapelle
- Parts of Stalingrad
- Isolated Metro station exits
- Bois de Boulogne (park)

---

## Women's Safety

**Overall:** Paris is safe for solo female travelers. Catcalling exists but usually ignorable.

| Consideration | Advice |
|---------------|--------|
| Solo dining | Completely normal, no stigma |
| Public transport | Safe even late, well-lit |
| Walking alone | Fine in busy areas, Uber for quiet routes |
| Catcalling | Exists in some areas, ignore |
| Bars/clubs | Don't leave drinks unattended |

**Resources:**
- Emergency: 112 (EU-wide) or 17 (police)
- Text 114 for silent emergency SMS

---

## Public Transport Safety

| Mode | Safety | Notes |
|------|--------|-------|
| Metro | Safe | Peak hours = pickpocket risk |
| RER | Safe | More spacious, less crowded |
| Bus | Very safe | Driver present |
| Uber/Taxi | Very safe | Licensed, tracked |
| Night Metro | Closes 12:40 AM | Use Noctilien buses after |

### Metro-Specific Tips

- **Stand away from doors** — snatching risk
- **Bag in front** — always visible
- **Don't show phone** — especially at stations
- **Use first or last cars** — tend to be less crowded

---

## Emergency Contacts

| Service | Number |
|---------|--------|
| **General Emergency (EU)** | 112 |
| **Police** | 17 |
| **Ambulance (SAMU)** | 15 |
| **Fire** | 18 |
| **Silent emergency (SMS)** | 114 |
| **Anti-terrorism hotline** | 0 800 201 517 |
| **Lost credit cards** | Bank specific |

**Pharmacies:** Green cross signs, some open 24h (Champs-Élysées)

---

## Terrorism Context

Since 2015 attacks, security is heightened:
- Armed soldiers patrol (Sentinelle)
- Bag checks at major sites
- Security barriers at events

**Practical impact:** Minimal. Security is visible but not intrusive. Paris remains very safe for visitors.
