# Resident Guide — Moving to Paris

## Before Moving

### Visa Requirements (Non-EU)

| Visa Type | Requirements | Duration |
|-----------|--------------|----------|
| **Talent Passport - Salaried** | €39K+ salary, innovative company | 4 years |
| **Talent Passport - Founder** | Creating company in France | 4 years |
| **Skilled Worker** | Job offer, employer sponsorship | 1-4 years |
| **Long-Stay Visitor** | Sufficient funds, no work | 1 year |
| **Student** | University acceptance | 1 year renewable |

**EU/EEA citizens:** No visa needed, just register after 3 months.

### Timeline for Moving

| Phase | Timeframe | Actions |
|-------|-----------|---------|
| **Job search** | 3-6 months before | Apply, negotiate |
| **Visa application** | 2-3 months before | Consulate in home country |
| **Pre-arrival** | 1 month before | Book temporary housing |
| **Arrival week** | Day 1-7 | OFII validation, bank, phone |
| **First month** | Week 1-4 | Permanent housing, healthcare |

---

## Finding Housing

### The Rental Process

**Typical timeline:** 2-4 weeks from search to move-in

| Step | What Happens |
|------|--------------|
| 1. Search | Seloger, PAP.fr, LeBonCoin |
| 2. Viewing | Often same-day decisions needed |
| 3. Dossier | Submit complete file (see below) |
| 4. Guarantor check | Garant required (or Visale) |
| 5. Contract signing | Bail d'habitation |
| 6. Move-in | Pay deposit + first month |

### Required Documents (Dossier)

| Document | Notes |
|----------|-------|
| **ID/Passport** | Copy |
| **Visa/Titre de séjour** | If applicable |
| **3 months payslips** | Or employment contract |
| **Tax return** | Avis d'imposition |
| **Bank statements** | 3 months |
| **Previous landlord reference** | Quittance de loyer |
| **Employment contract** | CDI preferred |

**Newcomer challenges:**
- No French credit history
- No French guarantor → use **Visale** (free government guarantee)
- No avis d'imposition → employer letter + home country tax docs

### Deposit & Fees

| Cost | Amount |
|------|--------|
| Security deposit | 1 month rent (unfurnished), 2 months (furnished) |
| Agency fee | 0-1 month rent |
| First month rent | Immediate |
| Moving costs | €200-500 |

---

## First Week Checklist

| Task | Where | Notes |
|------|-------|-------|
| **OFII validation** | Online + appointment | Required within 3 months |
| **Bank account** | BNP, Société Générale, Boursorama | Need address |
| **Phone SIM** | Free, Orange, SFR | €10-20/month |
| **Internet** | Orange, Free, SFR | €30-40/month |
| **Register healthcare** | Ameli.fr | After getting bank |
| **CAF application** | caf.fr | Housing aid |

---

## Banking

### Traditional Banks

| Bank | Pros | Cons |
|------|------|------|
| **BNP Paribas** | Large network | Fees, bureaucracy |
| **Société Générale** | International services | Same |
| **Crédit Agricole** | Regional, personal | Same |

### Online Banks (Easier)

| Bank | Pros | Cons |
|------|------|------|
| **Boursorama** | Free, easy opening | No cash deposit |
| **N26** | Instant, mobile | German bank |
| **Revolut** | Multi-currency | Not full French bank |
| **Hello Bank** | BNP-owned, free | Limited branches |

**Tip:** Open Boursorama online while waiting for traditional bank appointment.

---

## Healthcare (Sécurité Sociale)

### Registration

1. Get job (or student status)
2. Apply on ameli.fr
3. Receive carte vitale (health card)
4. Choose mutuelle (supplementary insurance)

### Costs After Registration

| Service | Your Cost | Notes |
|---------|-----------|-------|
| GP visit | €0-8 | 70% reimbursed |
| Specialist | €10-25 | After GP referral |
| Prescriptions | €0-30% | Most covered |
| Hospital | Mostly €0 | Emergencies free |

### Mutuelle (Supplementary)

| Level | Monthly Cost |
|-------|--------------|
| Basic | €30-50 |
| Standard | €50-80 |
| Premium | €80-150 |

**Employers must offer mutuelle** — often 50% employer-paid.

---

## French Bureaucracy Tips

| Reality | Strategy |
|---------|----------|
| **Everything requires paper** | Keep copies of everything |
| **Appointments weeks out** | Book early |
| **Phone support poor** | Go in person |
| **August = dead** | Nothing happens |
| **CDI is king** | Indefinite contract opens all doors |

### Key Acronyms

| Acronym | Meaning |
|---------|---------|
| **OFII** | Immigration office |
| **CAF** | Housing aid |
| **CPAM** | Health insurance |
| **URSSAF** | Social security |
| **CDI** | Permanent contract |
| **CDD** | Fixed-term contract |
| **APL** | Rent subsidy |

---

## Learning French

| Method | Cost | Notes |
|--------|------|-------|
| **Alliance Française** | €200-500/term | Quality, official |
| **Mairie courses** | Free-€50 | Local town halls |
| **Universities** | €200-400/term | DELF/DALF prep |
| **Apps (Duolingo, Babbel)** | Free-€100/year | Supplement only |
| **Language exchange** | Free | Meetup groups |

**Reality:** You can survive with English in Paris, but French makes everything easier — admin, housing, social life.

---

## Social Integration

| Activity | Where |
|----------|-------|
| **Meetup groups** | meetup.com |
| **Expat groups** | InterNations, Facebook |
| **Sports clubs** | Association sportive |
| **Language exchange** | Polyglot Club |
| **Volunteering** | France Bénévolat |

---

## Cost of Living Summary

| Category | Monthly (Single) |
|----------|------------------|
| Rent (1BR) | €1,200-1,800 |
| Utilities | €80-120 |
| Groceries | €250-350 |
| Transport | €86 (Navigo) |
| Health | €30-50 (mutuelle) |
| Phone/Internet | €50-70 |
| Entertainment | €150-300 |
| **TOTAL** | **€2,000-2,800** |
