# Food Overview — Paris

Paris invented modern dining. From croissants to Michelin stars, every meal matters here. The trick is avoiding tourist traps while finding real bistros, markets, and bakeries.

## What Paris Does Well

| Cuisine | Why | Best Areas |
|---------|-----|------------|
| **Bakeries (boulangeries)** | World's best bread, croissants | Every neighborhood |
| **Classic bistros** | Duck confit, steak-frites, coq au vin | 11th, 5th, Marais |
| **Wine bars** | Natural wine movement started here | 10th, 11th, Oberkampf |
| **Cheese shops** | 400+ varieties | Rue Mouffetard, Marais |
| **Markets** | Fresh produce, street food | Throughout city |
| **Fine dining** | Most Michelin stars globally | 1st, 7th, 8th |

**Key insight:** Breakfast is just coffee + croissant. Lunch is substantial. Dinner is late (8-10 PM).

---

## Restaurants by Budget

### Budget (Under €15/person)

| Restaurant | Type | Must-Order | Location |
|------------|------|------------|----------|
| **L'As du Fallafel** | Middle Eastern | Falafel special €8 | Marais (4th) |
| **Chez Janou** | Provençal | €18 lunch menu | Marais |
| **Breizh Café** | Crêperie | Complete galette €12-15 | Marais, Odéon |
| **Bouillon Chartier** | Classic French | 3-course €20 | 9th |
| **Pink Mamma** | Italian | Pizza/pasta €12-18 | 10th, 11th |
| **Au Petit Grec** | Greek | Gyros €7 | Latin Quarter |
| **Miznon** | Israeli | Pita €12 | Marais |

### Mid-Range (€25-50/person)

| Restaurant | Type | Must-Order | Location |
|------------|------|------------|----------|
| **Le Comptoir du Panthéon** | Bistro | Steak tartare | 5th |
| **Café de Flore** | Historic café | Croque monsieur | St-Germain |
| **Le Petit Cler** | Neighborhood bistro | Duck confit | 7th (Rue Cler) |
| **Frenchie** | Modern French | Tasting menu | 2nd (Sentier) |
| **Septime** | Contemporary | Prix fixe €45 | 11th |
| **Le Bouillon Pigalle** | Neo-bistro | Traditional dishes | 18th |
| **Clown Bar** | Wine bar + food | Natural wines | 11th |

### Splurge (€80+/person)

| Restaurant | Stars | Price | Notes |
|------------|-------|-------|-------|
| **L'Ambroisie** | ⭐⭐⭐ | €300+ | Place des Vosges, classic |
| **Le Cinq** | ⭐⭐⭐ | €250+ | Four Seasons, elegant |
| **Septime** | ⭐ | €130 | Book 3 weeks ahead |
| **Arpège** | ⭐⭐⭐ | €400+ | Vegetable-focused |
| **L'Astrance** | ⭐⭐ | €200+ | Tasting only |

**Booking tips:**
- Top spots: Book 2-4 weeks ahead via LaFourchette/TheFork
- Lunch = 30-50% cheaper than dinner
- Many closed Sunday/Monday

---

## Essential Paris Foods

| Food | Where | Notes |
|------|-------|-------|
| **Croissant** | Any boulangerie with queue | €1.20-1.80, eat same day |
| **Baguette tradition** | Same | Look for "tradition" label |
| **Croque monsieur** | Any café | Ham, cheese, béchamel |
| **Steak-frites** | Bistros | Medium rare = saignant |
| **Duck confit** | Southwest bistros | Crispy leg, potatoes |
| **Escargots** | Classic restaurants | Garlic butter |
| **Onion soup** | Bistros in winter | Gratinée, cheese top |
| **Crêpes/galettes** | Crêperies | Savory = galette (buckwheat) |
| **Macarons** | Pierre Hermé, Ladurée | €2-3 each |
| **Tarte Tatin** | Bistros | Upside-down apple tart |

---

## Quick Reference by Situation

| Situation | Go To |
|-----------|-------|
| Impressing someone | Septime, Frenchie, Le Comptoir |
| Cheap & delicious | L'As du Fallafel, Bouillon Chartier |
| Late night (after 10 PM) | Au Pied de Cochon (24h), Le Grand Colbert |
| Brunch | Café de Flore, Eggs&Co, Season |
| Business lunch | Le Voltaire, Le Grand Véfour |
| With kids | Pink Mamma, Bouillon Pigalle |
| Vegetarian | Le Potager du Marais, Wild & The Moon |
| Classic experience | Bouillon Chartier, Bofinger, La Coupole |

---

## Detailed Guides

| Topic | File |
|-------|------|
| French classics | `food-traditional.md` |
| Food markets | `food-markets.md` |
| Best areas | `food-areas.md` |
| Wine bars & cafes | `food-wine-cafes.md` |
| Dietary needs & tips | `food-practical.md` |
