# Cost of Living — Paris

## Overview

Paris is expensive but competitive with London. Housing is the main cost. Food can be cheap if you cook and use markets. Public transport is affordable.

**Monthly budget ranges:**
- **Student:** €1,000-1,500
- **Single professional:** €2,500-3,500
- **Couple:** €3,500-5,000
- **Family (2 kids):** €5,000-7,000+

---

## Housing Costs (2025)

### Rent by Arrondissement

| Type | Central (1-8) | Inner (9-12) | Outer (13-20) |
|------|---------------|--------------|---------------|
| Studio | €1,200-1,800 | €900-1,400 | €700-1,100 |
| 1BR | €1,800-2,800 | €1,400-2,000 | €1,100-1,600 |
| 2BR | €2,500-4,000 | €1,800-2,800 | €1,400-2,200 |
| 3BR | €3,500-6,000 | €2,500-4,000 | €2,000-3,000 |

**Key factors:**
- Furnished = +20-30%
- New/renovated = +10-20%
- With balcony = +5-10%
- August = more availability, some negotiate

### Additional Housing Costs

| Cost | Amount | Notes |
|------|--------|-------|
| Security deposit | 1-2 months rent | Returned at end |
| Agency fee | 1 month rent | If using agent |
| Utilities | €80-150/month | Electricity, gas, water |
| Internet | €30-40/month | Orange, Free, SFR |
| Home insurance | €15-30/month | Required |
| Building charges | Often included | Check lease |

---

## Food & Groceries

### Grocery Costs

| Item | Supermarket | Market | Notes |
|------|-------------|--------|-------|
| Baguette | €1.10 | €1.30 | Tradition = better |
| Croissant | €1.20 | €1.50 | Boulangerie best |
| Milk (1L) | €1.20 | N/A | |
| Eggs (12) | €3.50 | €4.00 | Free-range more |
| Chicken (kg) | €8.00 | €12.00 | Market = better quality |
| Cheese (200g) | €4.00 | €6.00 | Specialty fromagerie |
| Wine (bottle) | €5-15 | €8-20 | Supermarket = great value |
| Coffee (kg) | €15-25 | - | Roasters in 11th |

**Monthly grocery budgets:**
- Tight budget: €200-250
- Comfortable: €350-450
- Gourmet: €500+

### Supermarket Tiers

| Budget | Stores |
|--------|--------|
| Cheap | Lidl, Aldi, Leader Price |
| Mid-range | Carrefour, Monoprix, Franprix |
| Premium | Monoprix Gourmet, Lafayette Gourmet |
| Organic | Bio c' Bon, Naturalia |

### Eating Out

| Meal | Budget | Mid-range | Nice |
|------|--------|-----------|------|
| Coffee | €2.50 | €4.00 | €6.00 |
| Croissant | €1.50 | €2.00 | €2.50 |
| Lunch (plat) | €12 | €18 | €30 |
| Dinner (2 courses) | €20 | €40 | €80+ |
| Baguette sandwich | €5 | €8 | €12 |
| Wine (glass) | €5 | €8 | €15 |

---

## Transport Costs

| Pass | Price | Coverage |
|------|-------|----------|
| Single ticket | €2.15 | Zone 1 metro/bus |
| Carnet (10) | €17.35 | Cheaper per trip |
| Navigo Week | €30.75 | All zones Mon-Sun |
| Navigo Month | €86.40 | All zones |
| Navigo Annual | €950 | ~€79/month |
| Vélib Monthly | €3.10 | First 30 min free |

**Note:** Employers must reimburse 50% of Navigo pass.

---

## Utilities & Services

| Service | Monthly Cost |
|---------|--------------|
| Electricity | €40-80 |
| Gas | €20-50 |
| Water | €20-40 |
| Internet | €30-40 |
| Mobile | €10-25 |
| Netflix | €6-18 |
| Gym | €40-100 |

---

## Healthcare Costs

### With French Coverage (Sécurité Sociale)

| Service | Out of Pocket |
|---------|---------------|
| GP visit | €8 (after reimbursement) |
| Specialist | €10-25 |
| Prescriptions | €0-30% |
| Hospital | Mostly covered |

### Mutuelle (Supplementary Insurance)

| Coverage Level | Monthly Cost |
|----------------|--------------|
| Basic | €30-50 |
| Standard | €50-80 |
| Premium | €80-150 |

**Note:** Employers often provide mutuelle.

---

## Monthly Budget Examples

### Student (Tight)
| Category | €/month |
|----------|---------|
| Room/shared | €600 |
| Groceries | €200 |
| Transport (Navigo) | €86 |
| Phone | €15 |
| Entertainment | €100 |
| **Total** | **€1,000** |

### Young Professional (Comfortable)
| Category | €/month |
|----------|---------|
| 1BR apartment | €1,600 |
| Groceries | €350 |
| Eating out | €300 |
| Transport | €86 |
| Phone/Internet | €55 |
| Entertainment | €200 |
| Savings | €400 |
| **Total** | **€3,000** |

### Family (2 adults + 2 kids)
| Category | €/month |
|----------|---------|
| 3BR apartment | €2,800 |
| Groceries | €700 |
| Transport | €172 (2 Navigo) |
| Kids activities | €300 |
| School (public = free) | €0 |
| Utilities | €150 |
| Insurance | €100 |
| Entertainment | €300 |
| **Total** | **€4,500** |

---

## Tax Considerations

| Tax | Rate | Notes |
|-----|------|-------|
| Income tax | 0-45% | Progressive brackets |
| Social charges | ~20% | Includes healthcare |
| Taxe d'habitation | Abolished | For primary residence |
| VAT | 20% (5.5% food) | Included in prices |
