---
name: Paris
slug: paris
version: 1.0.0
description: Navigate Paris as visitor, resident, tech worker, student, or entrepreneur with arrondissements, transport, costs, safety, and local insights.
metadata: {"clawdbot":{"emoji":"🇫🇷","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Paris for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Arrondissements** | |
| Quick comparison | `arrondissements-index.md` |
| Central (1-4) | `arrondissements-central.md` |
| Left Bank (5-7) | `arrondissements-left-bank.md` |
| Right Bank (8-11) | `arrondissements-right-bank.md` |
| Outer (12-20) | `arrondissements-outer.md` |
| Choosing guide | `arrondissements-choosing.md` |
| **Food** | |
| Overview & restaurants | `food-overview.md` |
| French classics | `food-traditional.md` |
| Markets | `food-markets.md` |
| Best areas | `food-areas.md` |
| Wine bars & cafes | `food-wine-cafes.md` |
| Dietary & tips | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport | `transport.md` |
| Cost of living | `cost.md` |
| Safety | `safety.md` |
| Weather | `climate.md` |
| Local services | `local.md` |
| **Career** | |
| Tech industry | `tech.md` |
| Students | `student.md` |
| Startups | `startup.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. Safety is Important
Paris is safe overall. Main concerns:
- Pickpocketing (#1 risk, especially metros and tourist sites)
- Street scams (bracelet, petition, ring)
- Some areas at night (north 18th, 19th)
See `safety.md` for area-specific guidance.

### 3. Weather Surprises
| Myth | Reality |
|------|---------|
| "Always romantic" | Rains often, grey winters |
| "Hot summers" | Can be very hot (35°C+) in July-Aug |
| "Mild spring" | April can still be cold |

**Best weather:** May-June, September-October

### 4. Current Data
| Item | Range |
|------|-------|
| 1BR rent | €1,200-2,000 (central) |
| Senior SWE salary | €70K-120K total comp |
| Student budget | €1,000-1,500/month |
| Metro ticket | €2.15 (single), €16.90 (10-pack) |

### 5. Tourist Traps
- Skip: Euronet ATMs (40% fees), restaurants near Eiffel Tower
- Do: Free museums (1st Sunday), Marais, Latin Quarter side streets
- Free views: Sacré-Cœur steps, Galeries Lafayette rooftop, Parc de Belleville

### 6. Transit Over Walking
- Metro covers everything (16 lines)
- Navigo Découverte for week stays (€30.75/week)
- Vélib bikes great for spring/summer
- Never drive — impossible parking, ZTL zones

### 7. Arrondissement Matching
| Profile | Best Areas |
|---------|------------|
| Young professionals | 10th, 11th, Marais (3rd-4th) |
| Families | 15th, 16th, 12th |
| Budget-conscious | 18th (south), 19th, 20th |
| Tech workers | 2nd (Sentier), 10th, 11th |
| Students | 5th (Latin Quarter), 13th |

## Paris-Specific Traps

- **Euronet ATMs** — Private ATMs charge 10-40% fees. Use bank ATMs only.
- **Ring scam** — Someone finds "gold ring", offers to sell. It's worthless.
- **Petition scam** — Signing → distraction for pickpocket or "donation" demand.
- **Eiffel Tower restaurants** — €30+ for bad food. Walk to 7th arrondissement.
- **Montmartre portrait artists** — Aggressive, overpriced. Politely decline.
- **Lock bridges** — Locks removed, just a tourist thing now. Skip it.
- **August closures** — Many shops/restaurants close. Not best time.
