# 任务优先级规范

## 优先级级别

### P0 - 最高优先级（紧急）

**触发条件：**
- 系统关键错误需要立即修复
- 安全漏洞需要紧急处理
- 数据丢失风险需要立即操作
- 依赖系统崩溃

**典型任务：**
- 紧急系统备份
- 关键数据恢复
- 安全漏洞修复
- 系统崩溃恢复

**执行策略：**
- 立即执行
- 最高并发优先
- 资源优先分配
- 超时时间：10 秒

### P1 - 高优先级（重要）

**触发条件：**
- 重要业务功能需要完成
- 重要文件需要处理
- 定期任务
- 重要通知

**典型任务：**
- 重要文件备份
- 定期系统检查
- 重要数据迁移
- 重要通知发送

**执行策略：**
- 优先执行
- 高并发优先
- 资源合理分配
- 超时时间：30 秒

### P2 - 中优先级（普通）

**触发条件：**
- 常规任务
- 优化任务
- 收集任务
- 非紧急操作

**典型任务：**
- 常规文件整理
- 日志清理
- 定期备份
- 系统更新

**执行策略：**
- 按顺序执行
- 中等并发
- 资源正常分配
- 超时时间：60 秒

### P3 - 低优先级（可选）

**触发条件：**
- 可选操作
- 后台任务
- 清理任务
- 统计任务

**典型任务：**
- 临时文件清理
- 历史数据归档
- 日志归档
- 统计分析

**执行策略：**
- 后台执行
- 低并发
- 资源按需分配
- 超时时间：120 秒

## 优先级设置规则

### 自动识别优先级

系统根据任务类型自动设置优先级：

```python
{
  "系统关键任务": "P0",
  "安全相关任务": "P0",
  "数据恢复任务": "P0",
  "重要业务任务": "P1",
  "定期维护任务": "P1",
  "常规操作任务": "P2",
  "清理归档任务": "P3"
}
```

### 用户指定优先级

用户可以在命令中指定优先级：

```bash
# 高优先级任务
"P0: 删除紧急日志文件"

# 低优先级任务
"P3: 归档历史数据"
```

### 优先级提升

当任务之间存在依赖关系时，自动提升依赖任务的优先级：

```bash
# 如果任务2依赖任务1
"任务2"  # P2

# 系统自动提升为 P1
```

## 优先级冲突处理

### 策略1：高优先级优先

```json
{
  "P0": 4,
  "P1": 3,
  "P2": 2,
  "P3": 1
}
```

### 策略2：时间戳优先

```json
{
  "P0": 1,
  "P1": 2,
  "P2": 3,
  "P3": 4
}
```

### 策略3：混合策略

```json
{
  "优先级 + 时间戳": {
    "P0": 1,
    "P1": 2,
    "P2": 3,
    "P3": 4,
    "同优先级": 按时间戳
  }
}
```

## 优先级队列

### 队列结构

```json
{
  "P0": [
    { "task_id": "T1", "command": "紧急备份", "time": "22:30:00" },
    { "task_id": "T2", "command": "数据恢复", "time": "22:30:01" }
  ],
  "P1": [
    { "task_id": "T3", "command": "重要备份", "time": "22:30:02" },
    { "task_id": "T4", "command": "系统检查", "time": "22:30:05" }
  ],
  "P2": [
    { "task_id": "T5", "command": "文件整理", "time": "22:30:10" },
    { "task_id": "T6", "command": "日志清理", "time": "22:30:15" }
  ],
  "P3": [
    { "task_id": "T7", "command": "临时清理", "time": "22:30:20" }
  ]
}
```

## 优先级调整

### 动态调整

```json
{
  "触发条件": "系统资源紧张时",
  "调整策略": {
    "降低P1": "优先执行P0",
    "降低P2": "优先执行P1",
    "保持P0": "最高优先级不变"
  }
}
```

### 人工调整

用户可以通过命令调整优先级：

```bash
# 提升任务优先级
"P1: 创建文件"  # 修改为 P0

# 降低任务优先级
"P1: 创建文件"  # 修改为 P2
```
