---
name: parallel-task-executor
description: 多任务并行执行管理器。接收多条指令并同步执行，支持优先级调度、任务依赖、结果收集和进度跟踪。适用于需要并发处理多个独立任务的场景。
---

# 多任务并行执行管理器

## 核心能力

接收用户的多条指令，自动识别任务类型、优先级和依赖关系，并在并发执行池中同步处理。

## 任务队列管理

### 任务注册
当收到多条指令时，自动注册为独立任务：

```json
{
  "task_id": "task_123",
  "command": "下载文件",
  "priority": 1,
  "status": "pending",
  "created_at": "2026-02-05T22:30:00Z",
  "depends_on": []
}
```

### 优先级系统

**优先级级别：**
- `P0` - 最高优先级（紧急任务）
- `P1` - 高优先级（重要任务）
- `P2` - 中优先级（普通任务）
- `P3` - 低优先级（可选任务）

**调度策略：**
1. 高优先级任务优先执行
2. 同优先级任务按时间戳 FIFO
3. 低优先级任务在系统空闲时执行

## 并发执行池

### 执行模式

**同步执行模式：**
```json
{
  "mode": "parallel",
  "max_concurrent": 4,
  "tasks": [
    { "task_id": 1, "command": "任务1" },
    { "task_id": 2, "command": "任务2" },
    { "task_id": 3, "command": "任务3" }
  ]
}
```

**串行执行模式：**
```json
{
  "mode": "serial",
  "tasks": [
    { "task_id": 1, "command": "任务1" },
    { "task_id": 2, "command": "任务2" },
    { "task_id": 3, "command": "任务3" }
  ]
}
```

### 并发控制

- **最大并发数：** 默认 4
- **超时时间：** 默认 30 秒
- **重试次数：** 默认 3
- **资源限制：** CPU、内存、I/O

## 任务类型识别

### 自动识别的任务类型

1. **文件操作**
   - 创建/删除文件
   - 移动/重命名文件
   - 下载/上传文件

2. **浏览器操作**
   - 打开网页
   - 填写表单
   - 截图

3. **命令执行**
   - Shell 命令
   - 脚本执行
   - 应用程序启动

4. **数据处理**
   - 解析 JSON/XML
   - 文件转换
   - 数据计算

5. **网络请求**
   - HTTP 请求
   - API 调用
   - 数据库查询

## 任务调度流程

```
接收指令 → 任务注册 → 优先级排序 → 执行池分配 → 并发执行 → 结果收集 → 报告生成
```

### 详细流程

1. **接收指令**
   - 解析用户的多条消息
   - 提取任务命令
   - 识别任务类型

2. **任务注册**
   - 生成唯一任务 ID
   - 设置优先级
   - 检查依赖关系

3. **优先级排序**
   - 按 P0→P1→P2→P3 排序
   - 同优先级按时间排序

4. **执行池分配**
   - 最多 N 个并发任务
   - 检查系统资源
   - 分配到执行槽

5. **并发执行**
   - 执行任务
   - 实时进度更新
   - 错误处理

6. **结果收集**
   - 收集所有任务结果
   - 合并成功/失败状态
   - 生成报告

## 进度追踪

### 实时进度

```json
{
  "total_tasks": 5,
  "completed": 2,
  "running": 2,
  "pending": 1,
  "progress": "40%",
  "eta": "预计剩余 30 秒"
}
```

### 任务状态

- `pending` - 等待中
- `running` - 执行中
- `completed` - 已完成
- `failed` - 失败
- `cancelled` - 已取消

## 结果报告

### 执行报告

```json
{
  "execution_id": "exec_456",
  "total_tasks": 5,
  "completed": 4,
  "failed": 1,
  "success_rate": "80%",
  "duration": "45.2秒",
  "tasks": [
    {
      "task_id": 1,
      "command": "创建文件",
      "status": "completed",
      "result": "成功",
      "duration": "2.1秒"
    },
    {
      "task_id": 2,
      "command": "下载文件",
      "status": "completed",
      "result": "成功",
      "duration": "18.5秒"
    }
  ]
}
```

## 错误处理

### 错误恢复策略

1. **自动重试**
   - 失败任务自动重试
   - 最多重试 3 次
   - 指数退避策略

2. **错误隔离**
   - 单个任务失败不影响其他任务
   - 失败任务独立处理
   - 失败报告详细

3. **错误通知**
   - 实时错误状态
   - 失败原因分析
   - 建议解决方案

## 使用示例

### 示例1：多条独立任务

```bash
# 用户发送
"创建文件A，创建文件B，下载文件C"

# 系统自动处理为 3 个并发任务
# 结果：
# ✓ 任务1: 创建文件A - 成功
# ✓ 任务2: 创建文件B - 成功
# ✓ 任务3: 下载文件C - 成功
```

### 示例2：带优先级任务

```bash
# 用户发送
"高优先级：删除临时文件，中优先级：备份文件，低优先级：整理文档"

# 系统按优先级排序执行
# 结果：
# ✓ 高优先级：删除临时文件 - 成功
# ✓ 中优先级：备份文件 - 成功
# ✓ 低优先级：整理文档 - 成功
```

### 示例3：任务依赖

```bash
# 用户发送
"先创建目录，再创建文件"

# 系统自动识别依赖关系
# 结果：
# ✓ 任务1: 创建目录 - 成功
# ✓ 任务2: 创建文件 - 成功（依赖任务1完成）
```

## 配置参数

可在 `~/.openclaw/openclaw.json` 中配置：

```json
{
  "parallel-executor": {
    "max_concurrent_tasks": 4,
    "task_timeout_seconds": 30,
    "max_retries": 3,
    "default_priority": "P1",
    "enable_progress_tracking": true,
    "enable_error_recovery": true
  }
}
```

## 最佳实践

### 任务拆分原则
- 将复杂任务拆分为独立小任务
- 避免任务间强依赖
- 合理设置任务优先级

### 并发控制
- 高优先级任务可提高并发数
- 避免过度并发导致系统负载过高
- 监控系统资源使用

### 错误处理
- 允许部分失败
- 详细记录错误信息
- 提供恢复建议

## 资源

- [执行报告格式](references/reports.md)
- [任务优先级规范](references/priorities.md)
- [调度算法说明](references/scheduler.md)
