# Prompting patterns for Parallel Search/Extract

Use these patterns when generating `objective` and `search_queries`.

## Objective templates

### General research

```
Find trustworthy sources that answer: <question>.
Prefer primary/official sources. If possible, include publish dates.
```

### Freshness constrained

```
I need the latest info about: <topic>.
Prefer sources published after <YYYY-MM-DD>.
If there are breaking changes or recent releases, prioritise those.
```

### Domain-scoped

```
Answer: <question>.
Prefer information from: <domain list>.
If multiple docs disagree, report both and explain.
```

## search_queries patterns

- Include the core nouns + synonyms:
  - `auth`, `authentication`, `login` ...
- Include version numbers / dates:
  - `v2`, `2025`, `Jan 2026` ...
- Include exact error strings when debugging:
  - `"EADDRINUSE"`, `"TypeError: ..."`

Example (OpenAI API change):
- `OpenAI responses API migration guide`
- `Chat completions deprecation timeline`
- `OpenAI SDK v4 breaking changes`

## Workflow: fast research loop

1. Search with `max_results=5`.
2. Pick the 2–3 best URLs.
3. Extract those URLs.
4. Answer with citations (URL + date), and quote only what you need.

## Workflow: compare sources

- Use `source_policy.include_domains` to force two competing sources (e.g. `developer.mozilla.org` vs vendor docs).
- Use Extract on both.
- Summarise the differences and recommend the safer/most official guidance.
