# Parallel Search/Extract API notes

This is a compact field reference for the OpenClaw `parallel-ai-search` skill.

## Auth + headers

- Base URL: `https://api.parallel.ai`
- Auth header: `x-api-key: $PARALLEL_API_KEY`
- Beta header (current): `parallel-beta: search-extract-2025-10-10`

The Node scripts set the beta header automatically (override via `PARALLEL_BETA_HEADER`).

## Endpoints

### Search

`POST /v1beta/search`

Typical request shape:
```json
{
  "objective": "...",
  "search_queries": ["..."],
  "mode": "one-shot",
  "max_results": 10,
  "excerpts": {
    "max_chars_per_result": 10000,
    "max_chars_total": 50000
  },
  "source_policy": {
    "include_domains": ["example.com"],
    "exclude_domains": ["spam.com"],
    "after_date": "2024-01-01"
  },
  "fetch_policy": { "max_age_seconds": 3600 }
}
```

Typical response shape:
```json
{
  "search_id": "search_...",
  "results": [
    {
      "url": "https://...",
      "title": "...",
      "publish_date": "YYYY-MM-DD" | null,
      "excerpts": ["..."]
    }
  ],
  "warnings": [...],
  "usage": [...]
}
```

### Extract

`POST /v1beta/extract`

Limits:
- `urls`: max **10** per request (the script auto-batches if you pass more).

Typical request shape:
```json
{
  "urls": ["https://..."],
  "objective": "...",
  "search_queries": ["..."],
  "excerpts": true,
  "full_content": false,
  "fetch_policy": {
    "max_age_seconds": 86400,
    "timeout_seconds": 60,
    "disable_cache_fallback": false
  }
}
```

Typical response shape:
```json
{
  "extract_id": "extract_...",
  "results": [
    {
      "url": "https://...",
      "title": "...",
      "publish_date": "YYYY-MM-DD" | null,
      "excerpts": ["..."],
      "full_content": "..." 
    }
  ],
  "errors": [...],
  "warnings": [...],
  "usage": [...]
}
```

## Source policy

For domain/date filtering, use `source_policy`:
- `include_domains`: allowlist domains (max 10)
- `exclude_domains`: denylist domains (max 10)
- `after_date`: filter for freshness (`YYYY-MM-DD`)

Recommendation: use apex domains without scheme (`example.com`, not `https://www.example.com/...`). The scripts normalise common forms.

## Fetch policy (freshness)

- Search defaults to indexed/cached content; add `fetch_policy.max_age_seconds` to ask for fresher content.
- Extract is more crawl-like; you can use `fetch_policy` to control recrawl vs cached fallback.

If you have to run many calls in a loop, respect account rate limits.
