# OpenClaw configuration notes

## Enabling and providing the API key (host runs)

OpenClaw injects per-skill env vars at the start of an agent run, then restores the environment afterwards.

Add this to `~/.openclaw/openclaw.json`:

```json5
{
  skills: {
    entries: {
      "parallel-ai-search": {
        enabled: true,
        apiKey: "YOUR_PARALLEL_API_KEY"
      }
    }
  }
}
```

Notes:
- The key under `entries` defaults to the skill name. Because the name contains hyphens, keep it quoted.
- `apiKey` is a convenience field: this skill declares `primaryEnv: "PARALLEL_API_KEY"`, so OpenClaw will inject it as that env var.

## Sandboxed sessions

If the agent is sandboxed, skill processes run inside Docker and **do not inherit host env**.

You have two options:
- Set the env var in the sandbox config:

```json5
{
  agents: {
    defaults: {
      sandbox: {
        docker: {
          env: {
            PARALLEL_API_KEY: "YOUR_PARALLEL_API_KEY"
          }
        }
      }
    }
  }
}
```

- Or bake the env var into your sandbox image.

## Tooling

The scripts assume:
- `node` is on PATH
- Node is new enough to provide the global `fetch` API (Node 18+)
