---
name: paperpod
description: Isolated agent runtime for code execution, live preview URLs, browser automation, 50+ tools (ffmpeg, sqlite, pandoc, imagemagick), LLM inference, and persistent memory — all via CLI or HTTP, no SDK or API keys required.
metadata:
  author: PaperPod
  version: "2.0.3"
  homepage: https://paperpod.dev
---

# PaperPod

Isolated, agent-native sandboxes for code execution, live preview URLs, browser automation, 50+ tools (ffmpeg, sqlite, pandoc, imagemagick), LLM inference, and persistent memory — all via CLI or HTTP, no SDK or API keys required. Billed per second of compute usage and topup via stripe or x402.

## Quick Start

```bash
curl -X POST https://paperpod.dev/login -d '{"email":"you@email.com"}'  # Verify and get token
npm install -g @paperpod/cli
ppod login <token> && ppod help
```

## Authentication

**Step 1: Get a token**
```bash
curl -X POST https://paperpod.dev/login -d '{"email":"you@email.com"}'
# Check email → click magic link → copy token (pp_sess_...)
```

**Step 2: Use the token** (pick one method)

| Method | How | Best for |
|--------|-----|----------|
| **CLI login** | `ppod login pp_sess_...` | Everyday, Interactive use |
| **Env var** | `export PAPERPOD_TOKEN=pp_sess_...` | Scripts, CI/CD |
| **Per-request** | `-H "Authorization: Bearer pp_sess_..."` | HTTP one-shots |

Tokens expire in **15 days**. On `EXPIRED_TOKEN` error, re-authenticate via `POST /login`.

---

## CLI (Recommended)

The CLI is the easiest way to use PaperPod. It handles streaming, sessions, and reconnection automatically.

### CLI Commands

| Category | Command | Description |
|----------|---------|-------------|
| **Sandbox** | `ppod exec <cmd>` | Run shell command |
| | `ppod write <path> [file]` | Write file (stdin if no file) |
| | `ppod read <path>` | Read file |
| | `ppod ls <path>` | List directory |
| **Processes** | `ppod start <cmd>` | Start background process |
| | `ppod ps` | List processes |
| | `ppod kill <id>` | Stop process |
| **Ports** | `ppod expose <port>` | Get public URL (-q for URL only) |
| **Browser** | `ppod browser:screenshot <url>` | Capture webpage |
| | `ppod browser:pdf <url>` | Generate PDF |
| | `ppod browser:scrape <url> [sel]` | Scrape elements (default: body) |
| | `ppod browser:markdown <url>` | Extract markdown |
| | `ppod browser:content <url>` | Get rendered HTML |
| | `ppod browser:test <url> '<json>'` | Run Playwright tests |
| | `ppod browser:acquire` | Acquire reusable session |
| | `ppod browser:connect <id>` | Connect to existing session |
| | `ppod browser:sessions` | List active sessions |
| | `ppod browser:limits` | Check browser limits |
| **AI** | `ppod ai <prompt>` | Text generation |
| | `ppod ai:embed <text>` | Generate embeddings |
| | `ppod ai:image <prompt>` | Generate image |
| | `ppod ai:transcribe <audio>` | Transcribe audio |
| | `ppod ai:models` | List available AI models |
| **Code** | `ppod interpret <code>` | Rich output (charts) |
| **Memory** | `ppod mem:write <path>` | Persist data |
| | `ppod mem:read <path>` | Read persisted data |
| | `ppod mem:ls` | List memory files |
| | `ppod mem:rm <path>` | Delete from memory |
| | `ppod mem:usage` | Check quota |
| **Account** | `ppod balance` | Check credits |
| | `ppod status` | Connection info |
| | `ppod help` | Show all commands |
| | `ppod <cmd> --help` | Help for specific command |

**Update CLI:** `npm update -g @paperpod/cli`

### CLI Examples

```bash
# Execute code
ppod exec "python -c 'print(2+2)'"
ppod exec "npm init -y && npm install express"
# Start server + expose (--bind 0.0.0.0 required for public access)
ppod start "python -m http.server 8080 --bind 0.0.0.0"
ppod expose 8080  # → https://8080-{sandbox-id}-p8080_v1.paperpod.work (stable URL)
# Browser with tracing
ppod browser:screenshot https://example.com --trace debug.zip
# Persistent storage (survives sandbox reset)
echo '{"step":3}' | ppod mem:write state.json
# Built-in tools (50+ available: ffmpeg, sqlite3, pandoc, imagemagick, git, jq, ripgrep...)
ppod exec "ffmpeg -i input.mp4 -vf scale=640:480 output.mp4"  # Video processing
ppod exec "sqlite3 data.db 'SELECT * FROM users'"             # Database queries
ppod exec "convert image.png -resize 50% thumbnail.png"       # Image manipulation
```
---

## HTTP Endpoints

Use HTTP for one-shot tasks or when CLI isn't available. Run `curl https://paperpod.dev/docs` or visit https://paperpod.dev/docs for full API reference.

### Quick Reference

| Endpoint | Purpose |
|----------|---------|
| `POST /execute` | Run code (python, javascript, shell) |
| `POST /execute/stream` | Stream output (SSE) |
| `POST /files/write` | Write file |
| `POST /files/read` | Read file |
| `POST /files/list` | List directory |
| `POST /process/start` | Start background process |
| `POST /process/list` | List processes |
| `POST /expose` | Get preview URL for port |
| `POST /memory/write` | Persist data |
| `POST /memory/read` | Read persisted data |
| `POST /browser/screenshot` | Capture screenshot |
| `POST /browser/pdf` | Generate PDF |
| `POST /browser/markdown` | Extract markdown |
| `POST /ai/generate` | Text generation |
| `POST /ai/embed` | Embeddings |
| `POST /ai/image` | Image generation |
| `GET /ai/models` | List models |

### HTTP Example

```bash
# Execute shell command
curl -X POST https://paperpod.dev/execute \
  -H "Authorization: Bearer $PAPERPOD_TOKEN" \
  -d '{"code": "ls -la", "language": "shell"}'
```
---

## Capabilities

| Category | What you can do |
|----------|-----------------|
| **Code Execution** | Python, JavaScript, shell commands |
| **Processes** | Background servers, long-running jobs |
| **Preview URLs** | Expose ports → `https://8080-{sandbox-id}-p8080_v1.paperpod.work` |
| **Agent Memory** | 10MB persistent storage (R2) |
| **Browser** | Screenshots, PDFs, scraping (Playwright) |
| **AI Models** | Text, embeddings, images, transcription |
| **Files** | Read/write, git, bulk operations |

### Pre-installed Tools (50+)

| Category | Tools |
|----------|-------|
| **Runtimes** | python, node, npm, bun, pip |
| **Version Control** | git, gh (GitHub CLI) |
| **HTTP & Networking** | curl, httpie, jq, dig, ss |
| **Search & Text** | ripgrep (rg), find, sed, awk, tree |
| **Media & Docs** | ffmpeg, imagemagick, pandoc |
| **Build & Data** | make, sqlite3, tar, gzip, zip, unzip |

## Key Notes

- **Sandboxes are isolated** — each user gets their own container with a full Linux environment; you can only affect your own ephemeral sandbox
- **Sandbox is ephemeral** — use Agent Memory (`/memory/*`) for persistence
- **Working directory is `/workspace`** — relative paths like `file.txt` resolve to `/workspace/file.txt`
- **Servers must bind to `0.0.0.0`** for public access
- **Ports 3000-3010 are reserved** — use 8080, 5000, 4000, etc.
- **Browser sessions** — Each command creates an ephemeral session. Use `browser:acquire` for multi-command session reuse, `--trace` to capture Playwright traces

## Billing

**$0.0001/sec** compute + browser, **$0.02/1K neurons** AI. New accounts get **$5 free** (~14 hours), no credit card required.

## Discovery

- `ppod help` — CLI command reference
- `GET https://paperpod.dev/` — API schema (JSON)
- `GET https://paperpod.dev/docs` — Full documentation

---

## Advanced: WebSocket (not recommended for normal workflows). For programmatic integrations or custom apps, connect via WebSocket. `GET https://paperpod.dev/docs` to learn more. 

