---
name: paper-parse
description: 对用户提供的任何学术论文（PDF附件或URL）进行双模式深度研读。当用户请求分析、研读、解读或总结一篇学术论文时，使用此技能。一次性生成两份报告：Part A 面向研究者的深度专业解析，Part B 面向快速理解的核心逻辑与价值提炼。
---

# Paper Parse

对任何学术论文进行专业深度解析，一次性产出两种不同深度的报告。

## 核心原则

- **学术严谨性**: 对研究设计、数据结果、论证逻辑的转述必须绝对准确，符合该领域学术规范。
- **理论深度**: 清晰揭示论文的理论基础、核心假设，以及它对现有理论体系的补充、修正或颠覆。
- **完整复现**: 完整呈现从提出问题到得出结论的全过程，特别是方法论和关键数据，做到关键信息零遗漏。
- **超越翻译**: 产出物应比线性翻译稿更能清晰地揭示论文的内在逻辑和创新点。
- **双模输出**: 始终在一个最终交付文件中同时提供 Part A 和 Part B。

## 工作流程

论文研读分四步执行：

### Step 1: 通读论文全文

使用 `pdftotext` 命令或 `file` 工具的 `read` 动作提取论文全文。对于URL来源的论文，先尝试下载PDF再提取。必须覆盖从摘要到参考文献的所有内容。对于包含重要图表的论文，使用 `file` 工具的 `view` 动作查看关键图表页面，并将图表信息保存到文本文件中。

### Step 2: 综合分析

创建临时分析文件 `temp_analysis.md`，提取并组织以下要素：
- 研究问题、假设、方法论、数据来源
- 核心发现与关键数据
- 理论贡献与实践意义
- 论文的根本矛盾点、切入视角、方法创新

**此步骤不可跳过**，它是保证最终报告质量的思考过程。

### Step 3: 撰写双模报告

创建最终交付文件，文件名格式为 `[论文简称]_研读报告.md`。

**撰写 Part A 前**，先读取模板：`/home/ubuntu/skills/paper-parse/references/part-a-template.md`

**撰写 Part B 前**，先读取模板：`/home/ubuntu/skills/paper-parse/references/part-b-template.md`

### Step 4: 交付成果

使用 `message` 工具交付最终报告文件。消息文本中简要概括论文的核心创新、关键发现和理论价值，引导用户查看附件。

## 写作质量标准

- 使用完整段落而非大量列表，交替使用段落和表格组织信息
- 关键术语首次出现时提供中英文对照
- 引用论文中的具体数据和实验结果来支撑每一项论述
- Part A 追求专业性和完整性，Part B 追求洞察力和凝练度
- 最终文件中 Part A 和 Part B 之间用 `---` 分隔

## 最终交付文件结构

```markdown
# [论文标题] 双模式研读报告

---

## Part A: 深度专业学术速读报告

（遵循 part-a-template.md 结构生成的完整内容）

---

## Part B: 核心逻辑链与根本价值提炼

（遵循 part-b-template.md 结构生成的完整内容）
```
