---
name: paper-fetcher
description: Fetch academic papers from Sci-Hub given a DOI. Automatically downloads PDFs and saves them to research/papers/ with clean filenames. Use when the user provides a DOI or requests a paper from PubMed.
---

# Paper Fetcher

Automated academic paper retrieval from Sci-Hub.

## Usage

**Simple fetch:**
```
Get paper: 10.1038/nature12345
```

**Multiple papers:**
```
Fetch these papers:
- 10.1016/j.cell.2023.01.001
- 10.1038/s41586-2023-06789-0
- 10.1126/science.abc1234
```

**With context:**
```
Get the epitalon paper: 10.1007/s12603-011-0032-7
```

## What It Does

1. Takes DOI as input
2. Navigates to https://www.sci-hub.su/DOI
3. Downloads the PDF
4. Saves to `research/papers/` with clean filename
5. Returns confirmation with file path

## Output Location

```
workspace/
└── research/
    └── papers/
        ├── paper_10.1038_nature12345.pdf
        ├── paper_10.1016_j.cell.2023.01.001.pdf
        └── ...
```

## Filename Format

`paper_[DOI with slashes replaced].pdf`

Examples:
- DOI: `10.1038/nature12345` → `paper_10.1038_nature12345.pdf`
- DOI: `10.1016/j.cell.2023.01.001` → `paper_10.1016_j.cell.2023.01.001.pdf`

## Workflow

When user provides a DOI:

1. **Extract DOI** - Parse from message (with or without https://doi.org/ prefix)
2. **Navigate Sci-Hub** - Use browser to load https://www.sci-hub.su/DOI
3. **Wait for PDF** - Let page load and find download link
4. **Download** - Save PDF to research/papers/
5. **Confirm** - Report success with file path

## Error Handling

**If paper not found on Sci-Hub:**
- Report that Sci-Hub couldn't find it
- Suggest checking the DOI format
- User can try manual search

**If download fails:**
- Report the error
- Provide Sci-Hub URL for manual download

## Integration

**With Obsidian Sync:**
- Papers saved in research/papers/
- Can create notes linking to PDFs
- Sync metadata to Obsidian vault

**With Research Automation:**
- Fetch papers discovered in research runs
- Build reference library automatically
- Cross-reference with protocol notes

## Tips

**Finding DOIs:**
- PubMed: Listed in article details
- Paper itself: Usually on first page
- Google Scholar: In citation info

**Format flexibility:**
- With prefix: `https://doi.org/10.1038/nature12345` ✅
- Without prefix: `10.1038/nature12345` ✅
- Either format works

**Batch fetching:**
- Send multiple DOIs at once
- Processed sequentially
- All saved to research/papers/

---

**Status:** Active  
**Sci-Hub Domain:** https://www.sci-hub.su  
**Save Location:** research/papers/
