---
name: pancake-skills
description: Tương tác với Pancake Platform API để quản lý pages, conversations, messages, customers, statistics, tags, posts, users. Sử dụng khi cần (1) Quản lý pages và tạo access token, (2) Xử lý conversations và messages, (3) Quản lý thông tin customers, (4) Xem statistics và analytics, (5) Quản lý tags và posts, (6) Quản lý users/staff, (7) Upload media content, (8) Chat plugin operations.
---

# pancake-skills

## Mục tiêu

Skill này cung cấp khả năng tương tác với Pancake Platform API - nền tảng quản lý bán hàng đa kênh. Hỗ trợ đầy đủ các thao tác:

- **Pages**: Liệt kê pages, tạo page access token
- **Conversations**: Quản lý hội thoại, gán tags, assign staff, đánh dấu read/unread
- **Messages**: Lấy lịch sử tin nhắn, gửi tin nhắn (inbox, reply comment, private reply)
- **Customers**: Quản lý khách hàng, thêm/sửa/xóa notes
- **Statistics**: Thống kê ads, engagement, page, tags, users
- **Tags**: Liệt kê tags của page
- **Posts**: Liệt kê bài viết
- **Users**: Quản lý staff, cấu hình round robin
- **Upload**: Upload media content
- **Chat Plugin**: Gửi tin nhắn qua chat plugin

## Thiết lập môi trường (bắt buộc)

**User API** (endpoints `/api/v1/pages`):
- `USER_ACCESS_TOKEN`: Token cá nhân, lấy từ **Account → Personal Settings**. Có hiệu lực 90 ngày.

**Page API** (endpoints `/api/public_api/v1` và `/api/public_api/v2`):
- `PAGE_ACCESS_TOKEN`: Token của page, lấy từ **Settings → Tools**. Không hết hạn trừ khi xóa/renew.

**Tuỳ chọn**:
- `PANCAKE_BASE_URL`: Mặc định `https://pages.fm`
- `CONFIRM_WRITE`: Set `YES` để cho phép thao tác ghi (POST/PUT/DELETE)

## Cách gọi nhanh

Script gợi ý: `scripts/pancake.sh`

### Ví dụ GET

```bash
# Liệt kê pages (User API)
export USER_ACCESS_TOKEN="***"
bash scripts/pancake.sh pages-list

# Liệt kê conversations của page (Page API)
export PAGE_ACCESS_TOKEN="***"
bash scripts/pancake.sh conversations-list 123456789

# Lọc conversations theo tags và type
bash scripts/pancake.sh conversations-list 123456789 "?tags=1,2&type=INBOX"

# Lấy tin nhắn trong conversation
bash scripts/pancake.sh messages-list 123456789 conv_abc123

# Liệt kê tags
bash scripts/pancake.sh tags-list 123456789

# Liệt kê staff
bash scripts/pancake.sh users-list 123456789

# Thống kê page (SINCE/UNTIL là Unix timestamp)
bash scripts/pancake.sh stats-page 123456789 1704067200 1706745600
```

### Ví dụ WRITE

```bash
export PAGE_ACCESS_TOKEN="***"
export CONFIRM_WRITE=YES

# Gửi tin nhắn inbox
echo '{"action":"reply_inbox","message":"Xin chào!"}' | \
  bash scripts/pancake.sh messages-send 123456789 conv_abc123

# Gửi tin nhắn với attachment (dùng content_ids từ upload API)
echo '{"action":"reply_inbox","content_ids":["xxx"]}' | \
  bash scripts/pancake.sh messages-send 123456789 conv_abc123

# Reply comment
echo '{"action":"reply_comment","message_id":"comment123","message":"Cảm ơn bạn!"}' | \
  bash scripts/pancake.sh messages-send 123456789 conv_abc123

# Private reply từ comment
echo '{"action":"private_replies","post_id":"post123","message_id":"comment123","message":"Inbox nhé!"}' | \
  bash scripts/pancake.sh messages-send 123456789 conv_abc123

# Thêm tag vào conversation
echo '{"action":"add","tag_id":"123"}' | \
  bash scripts/pancake.sh conversations-tag 123456789 conv_abc123

# Gỡ tag khỏi conversation
echo '{"action":"remove","tag_id":"123"}' | \
  bash scripts/pancake.sh conversations-tag 123456789 conv_abc123

# Assign staff vào conversation
echo '{"assignee_ids":["user-uuid-1","user-uuid-2"]}' | \
  bash scripts/pancake.sh conversations-assign 123456789 conv_abc123

# Đánh dấu conversation đã đọc
bash scripts/pancake.sh conversations-read 123456789 conv_abc123

# Cập nhật thông tin khách hàng
echo '{"changes":{"name":"Nguyễn Văn A","gender":"male","birthday":"1990-01-15"}}' | \
  bash scripts/pancake.sh customers-update 123456789 customer_uuid

# Thêm ghi chú cho khách hàng
echo '{"message":"Khách hàng VIP, ưu tiên hỗ trợ"}' | \
  bash scripts/pancake.sh customers-add-note 123456789 customer_uuid

# Upload file
bash scripts/pancake.sh upload 123456789 /path/to/image.jpg

# Cập nhật round robin users
echo '{"inbox":["user-uuid-1"],"comment":["user-uuid-2"]}' | \
  bash scripts/pancake.sh users-round-robin 123456789
```

## Guardrails

- Không ghi dữ liệu khi chưa set `CONFIRM_WRITE=YES`
- Với thao tác ghi: luôn chạy 1 lệnh GET trước để xác nhận ID/shape dữ liệu
- Không lưu access token vào repo
- **QUAN TRỌNG**: Khi gửi message, `message` và `content_ids` là **MUTUALLY EXCLUSIVE** - không được gửi cả hai cùng lúc

## Endpoint thuộc skill này

### User API (`https://pages.fm/api/v1`)
- `GET /pages` - Liệt kê pages
- `POST /pages/{page_id}/generate_page_access_token` - Tạo page access token

### Page API v2 (`https://pages.fm/api/public_api/v2`)
- `GET /pages/{page_id}/conversations` - Liệt kê conversations

### Page API v1 (`https://pages.fm/api/public_api/v1`)

**Conversations:**
- `POST /pages/{page_id}/conversations/{conversation_id}/tags` - Thêm/xóa tag
- `POST /pages/{page_id}/conversations/{conversation_id}/assign` - Assign staff
- `POST /pages/{page_id}/conversations/{conversation_id}/read` - Đánh dấu đã đọc
- `POST /pages/{page_id}/conversations/{conversation_id}/unread` - Đánh dấu chưa đọc

**Messages:**
- `GET /pages/{page_id}/conversations/{conversation_id}/messages` - Lấy tin nhắn
- `POST /pages/{page_id}/conversations/{conversation_id}/messages` - Gửi tin nhắn

**Customers:**
- `GET /pages/{page_id}/page_customers` - Liệt kê khách hàng
- `PUT /pages/{page_id}/page_customers/{page_customer_id}` - Cập nhật khách hàng
- `POST /pages/{page_id}/page_customers/{page_customer_id}/notes` - Thêm ghi chú
- `PUT /pages/{page_id}/page_customers/{page_customer_id}/notes` - Sửa ghi chú
- `DELETE /pages/{page_id}/page_customers/{page_customer_id}/notes` - Xóa ghi chú

**Statistics:**
- `GET /pages/{page_id}/statistics/pages_campaigns` - Thống kê chiến dịch quảng cáo
- `GET /pages/{page_id}/statistics/ads` - Thống kê quảng cáo
- `GET /pages/{page_id}/statistics/customer_engagements` - Thống kê tương tác
- `GET /pages/{page_id}/statistics/pages` - Thống kê page
- `GET /pages/{page_id}/statistics/tags` - Thống kê tags
- `GET /pages/{page_id}/statistics/users` - Thống kê users

**Other:**
- `GET /pages/{page_id}/tags` - Liệt kê tags
- `GET /pages/{page_id}/posts` - Liệt kê bài viết
- `GET /pages/{page_id}/users` - Liệt kê users
- `POST /pages/{page_id}/round_robin_users` - Cập nhật round robin
- `GET /pages/{page_id}/sip_call_logs` - Lấy lịch sử cuộc gọi
- `GET /pages/{page_id}/export_data` - Export dữ liệu
- `POST /pages/{page_id}/upload_contents` - Upload media

### Chat Plugin (`https://pages.fm/api/v1`)
- `POST /pke_chat_plugin/messages` - Gửi tin nhắn qua chat plugin
- `GET /pke_chat_plugin/messages` - Lấy tin nhắn chat plugin

## Tham chiếu

- OpenAPI spec: `references/openapi-pancake.yaml`
- Xem chi tiết parameters và response schema trong file OpenAPI
