# pancake-skills

Claude Code skill for interacting with the Pancake Platform API - a multi-channel sales management platform.

## Installation

Copy the skill directory to your Claude skills folder:
```bash
cp -r pancake-skills ~/.claude/skills/
```

## Environment Variables

### Required

| Variable | Description | How to obtain |
|----------|-------------|---------------|
| `USER_ACCESS_TOKEN` | Personal access token (90-day validity) | Account → Personal Settings |
| `PAGE_ACCESS_TOKEN` | Page access token (no expiration) | Page Settings → Tools |

### Optional

| Variable | Default | Description |
|----------|---------|-------------|
| `PANCAKE_BASE_URL` | `https://pages.fm` | Override API base URL |
| `CONFIRM_WRITE` | - | Set to `YES` to allow write operations |

## Quick Start

### List your pages

```bash
export USER_ACCESS_TOKEN="your_token"
bash scripts/pancake.sh pages-list
```

### List conversations

```bash
export PAGE_ACCESS_TOKEN="your_page_token"
bash scripts/pancake.sh conversations-list 123456789
```

### Send a message

```bash
export PAGE_ACCESS_TOKEN="your_page_token"
export CONFIRM_WRITE=YES

echo '{"action":"reply_inbox","message":"Hello!"}' | \
  bash scripts/pancake.sh messages-send 123456789 conversation_id
```

## Available Commands

### Pages
| Command | Description |
|---------|-------------|
| `pages-list` | List all pages |
| `pages-generate-token PAGE_ID` | Generate page access token |

### Conversations
| Command | Description |
|---------|-------------|
| `conversations-list PAGE_ID [QUERY]` | List conversations |
| `conversations-tag PAGE_ID CONV_ID` | Add/remove tag (stdin: JSON) |
| `conversations-assign PAGE_ID CONV_ID` | Assign staff (stdin: JSON) |
| `conversations-read PAGE_ID CONV_ID` | Mark as read |
| `conversations-unread PAGE_ID CONV_ID` | Mark as unread |

### Messages
| Command | Description |
|---------|-------------|
| `messages-list PAGE_ID CONV_ID [COUNT]` | Get messages |
| `messages-send PAGE_ID CONV_ID` | Send message (stdin: JSON) |

### Customers
| Command | Description |
|---------|-------------|
| `customers-list PAGE_ID SINCE UNTIL PAGE [SIZE] [ORDER]` | List customers |
| `customers-update PAGE_ID CUST_ID` | Update customer (stdin: JSON) |
| `customers-add-note PAGE_ID CUST_ID` | Add note (stdin: JSON) |
| `customers-update-note PAGE_ID CUST_ID` | Update note (stdin: JSON) |
| `customers-delete-note PAGE_ID CUST_ID` | Delete note (stdin: JSON) |

### Statistics
| Command | Description |
|---------|-------------|
| `stats-campaigns PAGE_ID SINCE UNTIL` | Ads campaign stats |
| `stats-ads PAGE_ID SINCE UNTIL TYPE` | Ads stats (by_id/by_time) |
| `stats-engagement PAGE_ID DATE_RANGE [BY_HOUR]` | Engagement stats |
| `stats-page PAGE_ID SINCE UNTIL` | Page stats |
| `stats-tags PAGE_ID SINCE UNTIL` | Tag stats |
| `stats-users PAGE_ID DATE_RANGE` | User stats |
| `stats-new-customers PAGE_ID DATE_RANGE [GROUP]` | New customer stats |

### Tags, Posts, Users
| Command | Description |
|---------|-------------|
| `tags-list PAGE_ID` | List all tags |
| `posts-list PAGE_ID SINCE UNTIL PAGE SIZE [TYPE]` | List posts |
| `users-list PAGE_ID` | List staff |
| `users-round-robin PAGE_ID` | Update round robin (stdin: JSON) |

### Other
| Command | Description |
|---------|-------------|
| `call-logs PAGE_ID SIP_ID PAGE SIZE [SINCE] [UNTIL]` | Get call logs |
| `export-ads-conversations PAGE_ID SINCE UNTIL [OFFSET]` | Export ads conversations |
| `upload PAGE_ID FILE_PATH` | Upload media |
| `chat-plugin-send PAGE_ID` | Send chat plugin message (stdin: JSON) |
| `chat-plugin-messages PAGE_ID CONV_ID [OFFSET]` | Get chat plugin messages |

## Message Types

### Inbox Message
```json
{
  "action": "reply_inbox",
  "message": "Your text message"
}
```

### Inbox with Attachment
```json
{
  "action": "reply_inbox",
  "content_ids": ["content_id_from_upload"]
}
```

> **Important**: `message` and `content_ids` are mutually exclusive. Do not send both.

### Reply to Comment
```json
{
  "action": "reply_comment",
  "message_id": "comment_id",
  "message": "Your reply"
}
```

### Private Reply
```json
{
  "action": "private_replies",
  "post_id": "post_id",
  "message_id": "comment_id",
  "message": "Your private message"
}
```

## Safety Features

- **Write Protection**: All write operations require `CONFIRM_WRITE=YES`
- **Token Security**: Tokens are URL-encoded automatically
- **Validation**: Clear error messages for missing required parameters

## API Reference

Full OpenAPI specification is available at `references/openapi-pancake.yaml`.

## License

MIT

---

# Tiếng Việt

## Giới thiệu

Claude Code skill để tương tác với Pancake Platform API - nền tảng quản lý bán hàng đa kênh.

## Cài đặt

Copy thư mục skill vào folder skills của Claude:
```bash
cp -r pancake-skills ~/.claude/skills/
```

## Biến môi trường

### Bắt buộc

| Biến | Mô tả | Cách lấy |
|------|-------|----------|
| `USER_ACCESS_TOKEN` | Token cá nhân (hiệu lực 90 ngày) | Account → Personal Settings |
| `PAGE_ACCESS_TOKEN` | Token của page (không hết hạn) | Page Settings → Tools |

### Tuỳ chọn

| Biến | Mặc định | Mô tả |
|------|----------|-------|
| `PANCAKE_BASE_URL` | `https://pages.fm` | Ghi đè URL API |
| `CONFIRM_WRITE` | - | Đặt `YES` để cho phép thao tác ghi |

## Bắt đầu nhanh

### Liệt kê pages

```bash
export USER_ACCESS_TOKEN="token_của_bạn"
bash scripts/pancake.sh pages-list
```

### Liệt kê conversations

```bash
export PAGE_ACCESS_TOKEN="token_page_của_bạn"
bash scripts/pancake.sh conversations-list 123456789
```

### Gửi tin nhắn

```bash
export PAGE_ACCESS_TOKEN="token_page_của_bạn"
export CONFIRM_WRITE=YES

echo '{"action":"reply_inbox","message":"Xin chào!"}' | \
  bash scripts/pancake.sh messages-send 123456789 conversation_id
```

## Các lệnh có sẵn

### Pages
| Lệnh | Mô tả |
|------|-------|
| `pages-list` | Liệt kê tất cả pages |
| `pages-generate-token PAGE_ID` | Tạo page access token |

### Conversations
| Lệnh | Mô tả |
|------|-------|
| `conversations-list PAGE_ID [QUERY]` | Liệt kê conversations |
| `conversations-tag PAGE_ID CONV_ID` | Thêm/xóa tag (stdin: JSON) |
| `conversations-assign PAGE_ID CONV_ID` | Gán nhân viên (stdin: JSON) |
| `conversations-read PAGE_ID CONV_ID` | Đánh dấu đã đọc |
| `conversations-unread PAGE_ID CONV_ID` | Đánh dấu chưa đọc |

### Messages
| Lệnh | Mô tả |
|------|-------|
| `messages-list PAGE_ID CONV_ID [COUNT]` | Lấy tin nhắn |
| `messages-send PAGE_ID CONV_ID` | Gửi tin nhắn (stdin: JSON) |

### Customers
| Lệnh | Mô tả |
|------|-------|
| `customers-list PAGE_ID SINCE UNTIL PAGE [SIZE] [ORDER]` | Liệt kê khách hàng |
| `customers-update PAGE_ID CUST_ID` | Cập nhật khách hàng (stdin: JSON) |
| `customers-add-note PAGE_ID CUST_ID` | Thêm ghi chú (stdin: JSON) |
| `customers-update-note PAGE_ID CUST_ID` | Sửa ghi chú (stdin: JSON) |
| `customers-delete-note PAGE_ID CUST_ID` | Xóa ghi chú (stdin: JSON) |

### Statistics
| Lệnh | Mô tả |
|------|-------|
| `stats-campaigns PAGE_ID SINCE UNTIL` | Thống kê chiến dịch quảng cáo |
| `stats-ads PAGE_ID SINCE UNTIL TYPE` | Thống kê quảng cáo (by_id/by_time) |
| `stats-engagement PAGE_ID DATE_RANGE [BY_HOUR]` | Thống kê tương tác |
| `stats-page PAGE_ID SINCE UNTIL` | Thống kê page |
| `stats-tags PAGE_ID SINCE UNTIL` | Thống kê tags |
| `stats-users PAGE_ID DATE_RANGE` | Thống kê users |
| `stats-new-customers PAGE_ID DATE_RANGE [GROUP]` | Thống kê khách hàng mới |

### Tags, Posts, Users
| Lệnh | Mô tả |
|------|-------|
| `tags-list PAGE_ID` | Liệt kê tất cả tags |
| `posts-list PAGE_ID SINCE UNTIL PAGE SIZE [TYPE]` | Liệt kê bài viết |
| `users-list PAGE_ID` | Liệt kê nhân viên |
| `users-round-robin PAGE_ID` | Cập nhật round robin (stdin: JSON) |

### Khác
| Lệnh | Mô tả |
|------|-------|
| `call-logs PAGE_ID SIP_ID PAGE SIZE [SINCE] [UNTIL]` | Lấy lịch sử cuộc gọi |
| `export-ads-conversations PAGE_ID SINCE UNTIL [OFFSET]` | Export conversations từ ads |
| `upload PAGE_ID FILE_PATH` | Upload media |
| `chat-plugin-send PAGE_ID` | Gửi tin nhắn chat plugin (stdin: JSON) |
| `chat-plugin-messages PAGE_ID CONV_ID [OFFSET]` | Lấy tin nhắn chat plugin |

## Các loại tin nhắn

### Tin nhắn Inbox
```json
{
  "action": "reply_inbox",
  "message": "Nội dung tin nhắn"
}
```

### Inbox với Attachment
```json
{
  "action": "reply_inbox",
  "content_ids": ["content_id_từ_upload"]
}
```

> **Quan trọng**: `message` và `content_ids` là **MUTUALLY EXCLUSIVE** - không được gửi cả hai cùng lúc.

### Trả lời Comment
```json
{
  "action": "reply_comment",
  "message_id": "comment_id",
  "message": "Nội dung trả lời"
}
```

### Private Reply
```json
{
  "action": "private_replies",
  "post_id": "post_id",
  "message_id": "comment_id",
  "message": "Tin nhắn riêng tư"
}
```

## Tính năng an toàn

- **Bảo vệ ghi**: Tất cả thao tác ghi yêu cầu `CONFIRM_WRITE=YES`
- **Bảo mật token**: Token được URL-encode tự động
- **Xác thực**: Thông báo lỗi rõ ràng khi thiếu tham số bắt buộc

## Tham chiếu API

Xem đầy đủ OpenAPI specification tại `references/openapi-pancake.yaml`.
