# Pakat API Reference

Base URL: `https://new.pakat.net/api/`

## Authentication

All requests require `X-API-KEY` header. Store the key in env var `PAKAT_API_KEY`.

```bash
curl -H "X-API-KEY: $PAKAT_API_KEY" https://new.pakat.net/api/lists
```

## Endpoints

### Lists
| Method | Path | Description |
|--------|------|-------------|
| GET | /lists | List all lists |
| POST | /lists | Create list (multipart/form-data) |
| GET | /lists/{list_uid} | View list |
| PUT | /lists/{list_uid} | Update list (x-www-form-urlencoded) |
| DELETE | /lists/{list_uid} | Delete list |
| POST | /lists/{list_uid}/copy | Copy list |

**Create list required fields:** `general[name]`, `general[description]`, `defaults[from_name]`, `defaults[from_email]`, `defaults[reply_to]`

**Optional fields:** `defaults[subject]`, `notifications[subscribe]` (yes/no), `notifications[unsubscribe]` (yes/no), `notifications[subscribe_to]`, `notifications[unsubscribe_to]`, `company[name]`, `company[country]`, `company[address_1]`, `company[address_2]`, `company[zone_name]`, `company[city]`, `company[zip_code]`, `company[phone]`, `company[address_format]`

### List Subscribers
| Method | Path | Description |
|--------|------|-------------|
| GET | /lists/{list_uid}/subscribers | List subscribers (optional query: `status`) |
| POST | /lists/{list_uid}/subscribers | Create subscriber (multipart/form-data) |
| GET | /lists/{list_uid}/subscribers/{subscriber_uid} | View subscriber |
| PUT | /lists/{list_uid}/subscribers/{subscriber_uid} | Update subscriber (x-www-form-urlencoded) |
| DELETE | /lists/{list_uid}/subscribers/{subscriber_uid} | Delete subscriber |
| GET | /lists/{list_uid}/subscribers/search-by-email | Search by email (`EMAIL` query param) |
| GET | /lists/subscribers/search-by-email-in-all-lists | Search email across all lists (`EMAIL` query param) |
| GET | /lists/{list_uid}/subscribers/search-by-custom-fields | Search by custom fields |
| PUT | /lists/{list_uid}/subscribers/{subscriber_uid}/unsubscribe | Unsubscribe |
| PUT | /lists/subscribers/unsubscribe-by-email-from-all-lists | Unsubscribe by email from all lists (body: `EMAIL`) |

**Subscriber fields:** `EMAIL` (required), `FNAME`, `LNAME`, `details[status]` (unconfirmed/confirmed/blacklisted/unsubscribed/unapproved/disabled/moved), `details[source]` (web/api/import), `details[ip_address]`

**Status filter values:** unconfirmed, confirmed, blacklisted, unsubscribed, unapproved, disabled, moved

### List Fields
| Method | Path | Description |
|--------|------|-------------|
| GET | /lists/{list_uid}/fields | List fields |
| POST | /lists/{list_uid}/fields | Create field (multipart/form-data) |
| GET | /lists/{list_uid}/fields/{field_id} | View field |
| PUT | /lists/{list_uid}/fields/{field_id} | Update field (x-www-form-urlencoded) |
| DELETE | /lists/{list_uid}/fields/{field_id} | Delete field |
| GET | /lists/fields/types | Get field types |

**Field properties:** `type`, `label`, `tag`, `required` (yes/no), `visibility` (visible/hidden/none), `sort_order`, `help_text`, `default_value`, `description`, `options[N][name]`, `options[N][value]`

### List Segments
| Method | Path | Description |
|--------|------|-------------|
| GET | /lists/{list_uid}/segments | List segments |
| POST | /lists/{list_uid}/segments | Create segment (multipart/form-data) |
| GET | /lists/{list_uid}/segments/{segment_uid} | View segment |
| PUT | /lists/{list_uid}/segments/{segment_uid} | Update segment (x-www-form-urlencoded) |
| DELETE | /lists/{list_uid}/segments/{segment_uid} | Delete segment |
| GET | /lists/segments/condition-operators | Get condition operators |

**Segment properties:** `name`, `operator_match` (any/all), `conditions[N][field_id]`, `conditions[N][operator_id]`, `conditions[N][value]`, plus campaign conditions with `action` (open/click), `campaign_id`, `time_comparison_operator` (lte/lt/gte/gt/eq), `time_value`, `time_unit` (day/month/year)

### Campaigns
| Method | Path | Description |
|--------|------|-------------|
| GET | /campaigns | List campaigns |
| POST | /campaigns | Create campaign (multipart/form-data) |
| GET | /campaigns/{campaign_uid} | View campaign |
| PUT | /campaigns/{campaign_uid} | Update campaign (x-www-form-urlencoded) |
| DELETE | /campaigns/{campaign_uid} | Delete campaign |
| POST | /campaigns/{campaign_uid}/copy | Copy campaign |
| PUT | /campaigns/{campaign_uid}/pause-unpause | Toggle pause |
| PUT | /campaigns/{campaign_uid}/mark-sent | Mark as sent |
| GET | /campaigns/{campaign_uid}/stats | Get stats |

**Create campaign required fields:** `campaign[name]`, `campaign[from_name]`, `campaign[from_email]`, `campaign[subject]`, `campaign[reply_to]`, `campaign[send_at]` (format: `Y-m-d H:i:s`), `campaign[list_uid]`

**Optional fields:** `campaign[type]` (regular/autoresponder), `campaign[status]` (pending-sending/draft/paused), `campaign[segment_uid]`, `campaign[group_uid]`, `campaign[delivery_servers]` (comma-separated IDs)

**Template options (pick one):**
- `campaign[template][template_uid]` — use existing template
- `campaign[template][content]` — base64-encoded HTML content
- `campaign[template][archive]` — base64-encoded zip archive

**Other template options:** `campaign[template][inline_css]` (yes/no), `campaign[template][plain_text]`, `campaign[template][auto_plain_text]` (yes/no)

**Tracking options:** `campaign[options][url_tracking]` (yes/no), `campaign[options][tracking_domain_id]`, `campaign[options][plain_text_email]` (yes/no), `campaign[options][email_stats]`

**Autoresponder options:** `campaign[options][autoresponder_event]` (AFTER-SUBSCRIBE/AFTER-CAMPAIGN-OPEN), `campaign[options][autoresponder_time_unit]` (minute/hour/day/week/month/year), `campaign[options][autoresponder_time_value]`, `campaign[options][autoresponder_open_campaign_id]`

**Recurring:** `campaign[options][cronjob_enabled]` (0/1), `campaign[options][cronjob]` (cron expression)

### Campaign Analytics
| Method | Path | Description |
|--------|------|-------------|
| GET | /campaigns/{campaign_uid}/bounces | View bounces |
| POST | /campaigns/{campaign_uid}/bounces | Create bounce record |
| GET | /campaigns/{campaign_uid}/delivery-logs | View delivery logs |
| GET | /campaigns/email-message-id/{email_message_id} | View by email message ID |
| GET | /campaigns/{campaign_uid}/unsubscribes | View unsubscribes |

### Campaign Tracking
| Method | Path | Description |
|--------|------|-------------|
| GET | /campaigns/{campaign_uid}/track-url/{subscriber_uid}/{hash} | Track URL click |
| GET | /campaigns/{campaign_uid}/track-opening/{subscriber_uid} | Record opening |
| POST | /campaigns/{campaign_uid}/track-unsubscribe/{subscriber_uid} | Record unsubscribe |

### Templates
| Method | Path | Description |
|--------|------|-------------|
| GET | /templates | List templates |
| POST | /templates | Create template (multipart/form-data) |
| GET | /templates/{template_uid} | View template |
| PUT | /templates/{template_uid} | Update template (x-www-form-urlencoded) |
| DELETE | /templates/{template_uid} | Delete template |

**Template fields:** `template[name]` (required), `template[content]` (base64-encoded HTML), `template[archive]` (base64-encoded zip), `template[inline_css]` (yes/no)

### Transactional Emails
| Method | Path | Description |
|--------|------|-------------|
| GET | /transactional-emails | List transactional emails |
| POST | /transactional-emails | Send transactional email (multipart/form-data) |
| GET | /transactional-emails/{email_uid} | View transactional email |
| DELETE | /transactional-emails/{email_uid} | Delete transactional email |

**Required fields:** `email[to_name]`, `email[to_email]`, `email[from_name]`, `email[subject]`, `email[body]` (base64-encoded HTML), `email[send_at]` (UTC, format: `Y-m-d H:i:s`)

**Optional fields:** `email[from_email]` (must be on verified domain), `email[reply_to_name]`, `email[reply_to_email]`, `email[plain_text]`, `email[template_uid]` (overrides body if set), `email[params]` (for `{{ params.key }}` placeholders), `email[contact]` (for `{{ contact.key }}` placeholders)

**Attachments (up to 3):** `email[attachments][N][name]`, `email[attachments][N][type]` (MIME), `email[attachments][N][data]` (base64)

### Other Endpoints
| Method | Path | Description |
|--------|------|-------------|
| POST | /customers | Create customer account |
| GET | /delivery-servers | List delivery servers |
| GET | /delivery-servers/{server_id} | View delivery server |
| GET | /countries | List countries |
| GET | /countries/{country_id}/zones | Get country zones |
| GET | /sending-domains/{domain_name} | Verify sending domain |
| GET | /quota/index | Check account quota |

## Response Format

Success responses include `status: "success"` with data. Error responses return:
```json
{"status": "error", "error": "Error message"}
```

## Content Encoding

Fields that accept HTML content (`campaign[template][content]`, `email[body]`, `template[content]`) must be **base64-encoded** before sending.

## Pagination

List endpoints support `page` and `per_page` query parameters.
