---
name: pakat
description: Interact with Pakat email marketing API (new.pakat.net) - REQUIRES PAKAT_API_KEY environment variable. Use when the user wants to manage email lists, subscribers, campaigns, templates, transactional emails, segments, or check campaign stats and delivery logs via the Pakat platform. Triggers on mentions of Pakat, email campaigns, mailing lists, subscriber management, or transactional email sending through Pakat.
metadata:
  {
    "openclaw":
      {
        "requires": { "bins": ["curl"], "env": ["PAKAT_API_KEY"] },
        "credentials":
          {
            "primary": "PAKAT_API_KEY",
            "description": "API key from https://new.pakat.net/customer/api-keys/index",
          },
      },
  }
---

# Pakat Email Marketing

[Pakat](https://pakat.net) is a Persian/Farsi-friendly email marketing platform for creating and managing mailing lists, sending campaigns, transactional emails, and tracking delivery — all via a clean REST API.

**🔗 [Sign up for Pakat](https://profile.pakat.net/signup)** to get started.

## Setup

Require env var `PAKAT_API_KEY`. If not set, ask the user for their API key.

Get your API key from: **https://new.pakat.net/customer/api-keys/index**

```bash
export PAKAT_API_KEY="your-key-here"
```

## Making Requests

Base URL: `https://new.pakat.net/api`

```bash
# GET requests
curl -s -H "X-API-KEY: $PAKAT_API_KEY" "https://new.pakat.net/api/{endpoint}"

# POST requests (multipart/form-data)
curl -s -X POST -H "X-API-KEY: $PAKAT_API_KEY" \
  -F "field=value" \
  "https://new.pakat.net/api/{endpoint}"

# PUT requests (x-www-form-urlencoded)
curl -s -X PUT -H "X-API-KEY: $PAKAT_API_KEY" \
  -d "field=value" \
  "https://new.pakat.net/api/{endpoint}"

# DELETE requests
curl -s -X DELETE -H "X-API-KEY: $PAKAT_API_KEY" "https://new.pakat.net/api/{endpoint}"
```

## Common Workflows

### List all mailing lists
```bash
curl -s -H "X-API-KEY: $PAKAT_API_KEY" "https://new.pakat.net/api/lists"
```

### Add subscriber to a list
```bash
curl -s -X POST -H "X-API-KEY: $PAKAT_API_KEY" \
  -F "EMAIL=user@example.com" \
  -F "FNAME=John" \
  -F "LNAME=Doe" \
  "https://new.pakat.net/api/lists/{list_uid}/subscribers"
```

### Create and send a campaign
```bash
curl -s -X POST -H "X-API-KEY: $PAKAT_API_KEY" \
  -F "campaign[name]=My Campaign" \
  -F "campaign[from_name]=Sender Name" \
  -F "campaign[from_email]=sender@domain.com" \
  -F "campaign[subject]=Email Subject" \
  -F "campaign[reply_to]=reply@domain.com" \
  -F "campaign[send_at]=2025-01-15 10:00:00" \
  -F "campaign[list_uid]=LIST_UID_HERE" \
  -F "campaign[template][template_uid]=TEMPLATE_UID" \
  "https://new.pakat.net/api/campaigns"
```

### Send a transactional email
```bash
# Encode HTML content safely using a heredoc
BODY_B64=$(base64 -w0 <<'EOF'
<h1>Hello</h1><p>Your order is confirmed.</p>
EOF
)

curl -s -X POST -H "X-API-KEY: $PAKAT_API_KEY" \
  -F "email[to_name]=John Doe" \
  -F "email[to_email]=john@example.com" \
  -F "email[from_name]=My App" \
  -F "email[subject]=Order Confirmation" \
  -F "email[body]=$BODY_B64" \
  -F "email[send_at]=2025-01-15 10:00:00" \
  "https://new.pakat.net/api/transactional-emails"
```

### Check campaign stats
```bash
curl -s -H "X-API-KEY: $PAKAT_API_KEY" "https://new.pakat.net/api/campaigns/{campaign_uid}/stats"
```

## Key Notes

- **HTML content must be base64-encoded** (`campaign[template][content]`, `email[body]`, `template[content]`)
- **Safe encoding:** When encoding user-provided HTML content, use heredocs (`base64 <<'EOF'`) or write to a temporary file first to avoid shell injection vulnerabilities. Never use `echo` with unsanitized input.
- **Transactional email `send_at`** is UTC, format: `Y-m-d H:i:s`
- **Campaign `send_at`** uses the customer's configured timezone
- **Transactional templates:** Set `email[template_uid]` to use a template instead of `email[body]`. Use `email[params][key]` for `{{ params.key }}` placeholders
- **Subscriber statuses:** unconfirmed, confirmed, blacklisted, unsubscribed, unapproved, disabled, moved
- **Pagination:** Use `?page=N&per_page=N` query params on list endpoints
- **`from_email`** for transactional emails must be on a verified domain

## Full API Reference

For complete endpoint details, request/response schemas, and all available fields, read [references/api_reference.md](references/api_reference.md).

For the raw OpenAPI 3.0 spec, see [references/openapi.json](references/openapi.json).
