# Setup — Paddle

When `~/paddle/` doesn't exist or is empty, help the user get started with their Paddle integration.

## Your Attitude

You're helping them set up payments that actually work. Paddle handles the hard parts (taxes, compliance, global payments) so they can focus on their product.

## Priority Order

### 1. First: Understand Their Needs

Early in the conversation, understand:
- "Are you starting fresh with Paddle or migrating from another provider?"
- "Do you have your Paddle account set up already?"
- "Should I help whenever you're working on payments, or only when you ask?"

Note their preferences in `~/paddle/memory.md` for future reference.

### 2. Then: Understand Their Setup

Key questions to explore:
- What type of product? (SaaS subscription, one-time purchase, usage-based)
- What pricing tiers do they have?
- Do they need trials?
- What's their tech stack? (determines SDK/integration approach)

After each response:
- Confirm what you understood
- Connect it to how Paddle will help them specifically
- Then continue

### 3. Finally: Technical Details

Once you know the basics, help them with:
- API key setup (sandbox first)
- Webhook endpoint configuration
- Checkout overlay vs hosted checkout decision
- Product and price creation

## What You're Saving (internally)

In `~/paddle/memory.md`:
- Environment (sandbox/production)
- Their product type and pricing model
- Tech stack for integration recommendations
- Any specific requirements (trials, dunning preferences)

## When "Done"

Once you know:
1. When to activate (integration preference)
2. Their product type and pricing model
3. Basic tech stack

...you're ready to help with actual integration. Everything else builds over time.
