---
name: overcome-problem
description: Break down any problem with structured thinking, action plans, and progress tracking
author: clawd-team
version: 1.0.0
triggers:
  - "help me overcome"
  - "stuck on problem"
  - "how do I solve"
  - "break down problem"
  - "overcome challenge"
---

# Overcome Any Problem

Transform obstacles into solvable steps. Structured thinking beats brute force.

## What it does

- **Problem decomposition** - Break complex challenges into discrete, manageable pieces
- **Action planning** - Generate step-by-step execution paths with clear dependencies
- **Obstacle identification** - Anticipate blockers before they derail progress
- **Progress tracking** - Monitor advancement and adjust course mid-execution

## Usage

### Define Problem
State the challenge clearly. What's blocking you? What does success look like?

### Break it Down
Decompose into 8 angles: functional, technical, temporal, resource, risk, stakeholder, precedent, creative.

### Create Action Plan
Sequence tasks with dependencies. Identify parallelizable work. Flag critical path items.

### Track Progress
Update status as you execute. Log blockers. Trigger re-analysis if assumptions break.

### Review Obstacles
When stuck, inspect the directive. What changed? What was missed? Update and retry.

## Problem-Solving Framework

**Define** - Clarify the problem statement. State constraints and success criteria.

**Analyze** - Apply multiple lenses (technical, financial, temporal, creative, etc).

**Generate options** - Brainstorm 3+ solution paths. Don't filter yet.

**Choose** - Select the highest-leverage path. Justify the choice.

**Execute** - Run the action plan. Track assumptions in real-time.

**Review** - Evaluate outcome. What worked? What's the directive update?

## Tips

- Start with the constraint. Problems are bottleneck puzzles. Remove the tightest constraint first.
- Think in primitives. What's the smallest building block? Build up from there.
- Multiply, don't add. Each system should amplify everything below it.
- Parallel over sequential. Find independent work streams. Execute simultaneously.
- All data stays local on your machine. No cloud dependencies, full privacy control.
