# Outreach Tracking & Feedback

## Why Track

Most outreach fails. The difference between 2% and 10% response rate is systematic learning. Track everything, find patterns, iterate.

---

## What to Track

### Per Contact
- Name, email, company, role
- Channel used (email, LinkedIn, Twitter)
- Template/approach used
- Date sent
- Response status: no reply / interested / declined / converted
- Notes: objections, timing mentioned, referrals given

### Per Campaign
- Target audience definition
- Subject lines tested (with open rates if available)
- Templates used (with response rates)
- Best day/time patterns
- Conversion: contacted → responded → meeting → outcome

### Per Template
- Open rate (if trackable)
- Response rate
- Positive vs negative responses
- Objections received
- Iterations made

---

## Tracking Systems

**Minimum viable (no tools):**
```
| Contact | Company | Channel | Template | Date | Status | Notes |
|---------|---------|---------|----------|------|--------|-------|
```
Spreadsheet works. Update after every touch.

**With tools:**
- **Sales:** Apollo, Outreach.io, Salesloft, HubSpot sequences
- **PR:** Muck Rack, Prowly, Cision
- **Recruiting:** Gem, LinkedIn Recruiter, Lever, Greenhouse
- **Link building:** Pitchbox, BuzzStream, Respona

---

## Exclusivity Tracking (PR/Media)

**Critical for PR outreach.** If you offer an exclusive, you CANNOT pitch competitors until declined.

| Outlet | Exclusive Offered | Date | Status | Deadline |
|--------|-------------------|------|--------|----------|
| TechCrunch | Product launch | Feb 10 | Waiting | Feb 15 |
| Engadget | - | - | Blocked until TC responds | - |

**Rule:** Update status before any new pitch. Violating exclusivity = burned relationship.

---

## Pattern Recognition

After 20+ outreaches, analyze:

### What's working?
- Which subject lines get opens? (A/B test)
- Which opening lines get responses?
- What personalization hooks resonate?
- Which days/times perform best?
- Which channels convert for which personas?

### What's failing?
- Templates with <5% response → revise or drop
- Personas that never respond → wrong target or wrong approach?
- Objections that repeat → address proactively in pitch

### Signals to watch:
- "Wrong timing" → add to re-engage list with date
- "Not interested" → ask why (product fit? messaging? competition?)
- "Send more info" without questions → likely brush-off, lower priority
- Quick positive reply → what made this one work?

---

## Feedback Loop

After every campaign (or weekly for ongoing):

1. **What won?** Document winning templates, subject lines, timing
2. **What lost?** Note what flopped, hypothesize why
3. **What to test next?** New angles, channels, personalization hooks
4. **Update the Profile** in main SKILL.md with learnings

---

## Benchmarks

**Cold email:**
- Open rate: 40-60% is good
- Response rate: 5-15% is good
- Meeting conversion: 2-5% of total sent

**LinkedIn:**
- Connection accept: 20-40%
- InMail response: 10-25%

**PR/Media:**
- Response rate: 5-10% (journalists are flooded)
- Coverage rate: 1-3% of pitches

**Recruiting:**
- InMail response: 15-30% (varies by role/level)
- Screen conversion: 50%+ of responses

If below these benchmarks → revisit personalization, targeting, or value prop.

---

## Never Again List

Track contacts/outlets to avoid:

| Contact | Reason | Date Added |
|---------|--------|------------|
| [Example] | Rude response, reported as spam | 2024-01-15 |
| [Example] | Ghosted 5x, never responds | 2024-02-01 |

Check before outreach. Don't waste effort on dead ends.

---

## Re-engage List

Track "not now" responses for future:

| Contact | Original Response | Re-engage Date | Trigger |
|---------|-------------------|----------------|---------|
| [Example] | "Budgets reset Q3" | July 1 | New quarter |
| [Example] | "After our launch" | Check their news | Product launch |

Set reminders. "Not now" often becomes "yes" with good timing.
