# Outreach by Type

## Sales Outreach

**Goal:** Book meetings, qualify leads, move pipeline.

**Key principles:**
- Lead with business problem, not product features
- Qualify before heavy investment (BANT: Budget, Authority, Need, Timeline)
- Multi-thread: don't rely on single contact
- CRM hygiene: update after every touch

**Trigger events to watch:**
- Funding rounds (new budget)
- Leadership changes (new priorities)
- Job postings (signals initiative)
- Competitor mentions (pain points)
- Company news (expansion, launches)

**Cadence:**
- SDR: 8-12 touches over 3 weeks, multi-channel
- AE: 5-7 touches, more personalized
- Enterprise: slower, relationship-first

**Tools to know:** Apollo, Outreach.io, Salesloft, LinkedIn Sales Navigator, ZoomInfo

---

## PR/Media Outreach

**Goal:** Earned media coverage, journalist relationships.

**Key principles:**
- News hook is MANDATORY — why cover this TODAY?
- Offer exclusives strategically (one outlet at a time)
- No attachments — link to press kit
- Build relationships before you need coverage

**What journalists want:**
- Data, numbers, trends
- Access (exclusive interview, early product)
- Story angles that fit their beat
- Quick responses when they're on deadline

**Embargo management:**
- Get explicit agreement in writing
- Send reminders 48h and 24h before lift
- Have plan if someone breaks it
- Track who agreed, who didn't

**Influencer distinctions:**
| Tier | Followers | Approach |
|------|-----------|----------|
| Macro | 500K+ | Go through manager/agency |
| Mid | 50K-500K | Email or DM, expect paid |
| Micro | 10K-50K | DM works, more flexible |
| Nano | <10K | Product exchange often works |

**Never:** Ask for "exposure" without budget. They know their worth.

---

## SEO/Link Building Outreach

**Goal:** Earn backlinks, guest post placements, resource mentions.

**Key principles:**
- Quality over quantity — one DR70 link > ten DR20 links
- Personalization is the differentiator (editors see 50+ pitches/day)
- Follow up — most links come from touch 2 or 3
- Track everything: who, when, response, link placed

**Qualification checklist:**
- [ ] DA/DR above threshold (usually 30+)
- [ ] Real traffic (check SimilarWeb/Ahrefs)
- [ ] Not a PBN (check: too many outbound links, thin content, unrelated niches)
- [ ] Published guest posts before (check for "write for us" or author bios)

**Pitch types:**
1. **Guest post:** Topic ideas that fit their audience + your expertise
2. **Resource page:** Why your resource deserves inclusion (specific value)
3. **Broken link:** Found 404 on their page, suggest your replacement
4. **HARO/Connectively:** Expert quotes for journalist queries

**Guest post topic formula:**
[What their audience wants] + [What you can credibly write about] = pitch

---

## Recruiting/Talent Outreach

**Goal:** Get candidates interested, book screens.

**Key principles:**
- Senior candidates get 20+ InMails/day — stand out or get ignored
- Reference SPECIFIC work (projects, talks, repos, articles)
- Sell the opportunity, not the company (growth, impact, team)
- Seniority-appropriate tone:
  - IC: tech stack, growth, interesting problems
  - Manager: team size, scope, autonomy
  - Exec: equity, impact, vision

**Personalization research:**
- LinkedIn activity (posts, comments)
- GitHub/portfolio (recent projects)
- Talks/podcasts (specific points they made)
- Articles/blogs (reference specific insights)

**Follow-up cadence:**
- Touch 1: InMail or email
- Touch 2 (Day 5): Add value (company news, team article)
- Touch 3 (Day 10): Different channel
- Stop if no response after 3

**Red flags in your own outreach:**
- "Exciting opportunity" (meaningless)
- Wrong seniority/role match
- Copy-paste without name check
- "Fast-paced environment" (cliché)

---

## Investor/BD Outreach

**Goal:** Meetings with investors, partnership conversations.

**Key principles:**
- Warm intros >> cold outreach (find the path)
- Research thoroughly: thesis fit, portfolio, recent investments
- Timing matters: fund age, deployment pace, partner interests
- Follow up with value, not asks

**Warm intro path research:**
1. LinkedIn 2nd connections
2. Portfolio founder overlaps
3. Conference/event speaker lists
4. Twitter mutuals
5. Shared investors/advisors

**What investors want to see:**
- Traction (or clear path to it)
- Market size with bottoms-up math
- Team credibility for this problem
- Why now (timing, market shift)

**Cold outreach only when:**
- Strong signal (thesis fit, portfolio pattern)
- Compelling hook (notable traction, unique insight)
- Specific ask (intro to portfolio company, feedback on market)

**Partner outreach (BD):**
- Lead with mutual value (what do they get?)
- Have specifics ready (integration scope, timeline, resources)
- Enterprise: expect legal/security review
- Startups: move fast, be flexible

**Meeting prep:**
- Their investment thesis / strategic priorities
- Portfolio companies / existing partnerships
- Recent news / announcements
- Questions they'll likely ask

**Post-meeting:**
- Follow up same day with notes and next steps
- Send promised materials within 24h
- If timeline given, follow up on that date exactly
