---
name: Outreach
description: Plan, personalize, and track outreach campaigns for sales, PR, recruiting, partnerships, and link building with timing strategy and follow-up cadence.
---

## Situation Detection

| Context | Load |
|---------|------|
| Writing cold emails, follow-ups, subject lines | `templates.md` |
| Sales outreach (SDR, BDR, AE) | `by-type.md` → Sales section |
| PR/Media pitching, influencer outreach | `by-type.md` → PR section |
| Link building, guest posts, SEO outreach | `by-type.md` → SEO section |
| Recruiting, talent sourcing | `by-type.md` → Recruiting section |
| Investor, partnership, BD outreach | `by-type.md` → BD section |
| Tracking what works, analyzing patterns | `tracking.md` |

---

## Universal Rules

**The Formula:** Who (right person, verified contact) + Why Now (trigger event) + WIIFT (what's in it for them)

**Personalization:** Reference something SPECIFIC — not "loved your work" but "your piece on X changed how I think about Y." If you can't find a hook, you haven't researched enough.

**Timing:**
- Best: Tuesday-Thursday, 9-11am recipient's timezone
- Avoid: Monday 9am, Friday afternoon, holidays, major news days
- Check: Did they just post/publish something? Strike while relevant

**Follow-up cadence:**

| Touch | Timing | Purpose |
|-------|--------|---------|
| 1 | Day 0 | Value-first intro, specific ask |
| 2 | Day 3-5 | New angle or additional value |
| 3 | Day 7-10 | Different channel if possible |
| 4 | Day 14+ | Break-up email |

Stop after 3-4 touches. "Bumping this up" is spam.

---

## Quick Checks

**Before sending:**
- [ ] Verified email (not generic info@)
- [ ] Personalization hook is SPECIFIC
- [ ] Under 150 words for cold outreach
- [ ] No attachments (link to resources)
- [ ] Clear CTA (specific ask, not "let me know")
- [ ] Subject line under 50 characters

**Red flags to avoid:**
- "I came across your profile..." (generic)
- Pitching in first message (build curiosity first)
- "Per my last email..." (guilt-trip)
- Asking for "exposure" (have budget or don't ask)
- Simultaneous competitor pitches with exclusive angles

---

## Outreach Profile

*Build over time. Update after campaigns.*

### What Works
<!-- "Subject line: Question format +40% opens" "Tuesday 10am best time" -->

### What Fails
<!-- "Long emails ignored" "LinkedIn connect requests <10% accept" -->

### Templates That Convert
<!-- "Follow-up #2 formula: new value + specific ask" -->

### Channel Preferences by Persona
<!-- "Execs: email via EA" "Journalists: Twitter DM > email" -->

### Contacts to Avoid
<!-- "Reporter X: never responds" "VC Y: no cold outreach" -->

---

*Empty = nothing learned yet. Every campaign reveals patterns. Track and update.*
