---
name: outreach-and-prospecting
description: Run cold and warm outreach campaigns to find and engage potential customers or partners. Use when building a prospecting pipeline, writing cold emails or LinkedIn messages, identifying and qualifying leads, planning an outreach strategy, or scaling lead generation as a solopreneur. Covers lead identification, qualification frameworks, cold email writing, LinkedIn outreach, multi-touch sequences, and tracking. Trigger on "cold outreach", "prospecting", "find customers", "cold email", "LinkedIn outreach", "lead generation", "outreach strategy", "build a pipeline", "find clients".
---

# Outreach and Prospecting

## Overview
Outbound outreach is one of the most powerful but most abused channels. Done well, it surfaces high-value opportunities that inbound alone will never find. Done poorly, it damages your reputation. This playbook gives you a repeatable system: who to target, how to find them, what to say, and how to follow up — all tuned for a solopreneur doing this alongside everything else.

---

## Step 1: Define Your Ideal Customer Profile (ICP)

Before reaching out to anyone, know exactly who you're looking for. A vague ICP = wasted outreach on the wrong people.

**ICP template:**
```
COMPANY / PERSON PROFILE:
  Industry:           [specific — not "tech"]
  Company size:       [e.g., 10-50 employees] (if B2B)
  Job title / role:   [the person who feels the pain AND has budget authority]
  Location:           [if relevant]
  Revenue range:      [if B2B — indicates budget capacity]

PAIN SIGNALS (how to know they need you):
  - [Observable behavior that indicates they have the problem]
  - [Tool they currently use that you can improve upon]
  - [Content they publish or engage with that reveals the pain]
  - [Life event or business event that triggers the need]

DISQUALIFIERS (do not reach out if):
  - [Signal that means they're not a good fit — saves time]
  - [Signal that means they can't afford you]
  - [Signal that means they already have a perfect solution]
```

---

## Step 2: Find and Qualify Leads

**Lead sources (ranked by quality for solopreneurs):**

1. **Warm introductions** — Someone you know introduces you to someone who needs you. Highest conversion. Ask your network regularly: "Do you know anyone dealing with [specific problem]?"
2. **LinkedIn Sales Navigator or free search** — Filter by job title, industry, company size. Check their profile for pain signals.
3. **Job postings** — Companies hiring for roles related to your problem space often have the pain you solve. The job posting itself is your conversation starter.
4. **Content engagement** — People who comment on or share content about your problem. They're signaling the pain publicly.
5. **Tool review sites** — People leaving negative reviews on competitor tools are actively frustrated and open to alternatives.
6. **Reddit / forum posts** — People asking questions related to your problem. If the thread is old, they may have solved it — if recent, they haven't.
7. **Newly funded companies** — Crunchbase alerts for funding in your industry. Funded companies have budget and growth pressure.
8. **Newly registered domains / new companies** — Tools like Instantly or Apollo can surface these. New businesses need everything.

**Qualification checklist — only outreach leads that pass ALL of these:**
- [ ] They have the specific pain you solve (evidence, not assumption)
- [ ] They have budget (company size, funding, or individual income indicates ability to pay)
- [ ] They are reachable (you can find a way to contact them)
- [ ] They are the right person (decision-maker or influencer, not someone with no authority)

---

## Step 3: Write Cold Emails That Get Replies

Most cold emails fail because they're about the sender. Flip it: make every sentence about the recipient.

**The anatomy of a cold email that works:**

```
SUBJECT LINE: Specific, curious, not salesy. 
              Avoid: "Quick question", "Synergy opportunity", "Intro"
              Good: "[Specific observation about them]", "Saw your [thing] — thought of something"

LINE 1 (the hook): 
  Show you did research. Reference something specific about THEM.
  "I noticed you just hired 3 new sales reps at [Company]."
  "Your blog post on [topic] mentioned [specific challenge]."
  This proves you're not mass-blasting.

LINES 2-3 (the bridge):
  Connect their specific situation to a problem you solve.
  "That usually means [specific pain that comes with their situation]."
  One sentence. Don't over-explain.

LINE 4 (the value):
  State what you do in terms of THEIR outcome. Not your features.
  "I help [company type] [achieve specific result] in [timeframe]."
  One sentence.

LINE 5 (the ask):
  Make it tiny. Low commitment. Easy to say yes to.
  NOT: "Can we hop on a 30-min call this week?"
  YES: "Would it be worth a quick 10-min chat if this is relevant?"
  YES: "Want me to send over a quick example of how I did this for [similar company]?"

SIGN-OFF:
  First name only. No title. No company logo. Keep it human.
```

**Subject line formulas that work:**
- `[Specific observation about their business]`
- `[Their competitor] is doing [X] — are you?`
- `Question about [specific thing on their site/profile]`
- `[Mutual connection] suggested I reach out`

**Length rule:** Under 100 words in the body. If you can't make your case in 5 sentences, you haven't distilled it enough.

---

## Step 4: LinkedIn Outreach (Same Principles, Different Format)

LinkedIn messages get higher open rates than email but have stricter formatting constraints.

**Connection request message (if not already connected):**
- 1-2 sentences max. Specific. Not "I'd love to connect."
- "Saw your comment on [post] about [topic] — had a relevant thought. Mind connecting?"

**After connection is accepted — the message:**
- Same structure as cold email but even shorter (3-4 sentences max).
- Reference WHY you connected (the specific thing that triggered it).
- End with a low-commitment ask.

**LinkedIn outreach mistakes:**
- Sending a pitch immediately after connection. Wait. Send a value-first message first (share something useful, no ask).
- Writing long paragraphs. LinkedIn messages get skimmed. Short wins.
- Using templates so obviously that they feel automated. Personalization is the entire point.

---

## Step 5: Build a Multi-Touch Sequence

One message rarely converts. Build a sequence of 3-5 touchpoints across different channels over 2-3 weeks.

**Example sequence:**
```
Day 1:   LinkedIn connection request (with personalized note)
Day 3:   LinkedIn message (value-first, no ask)
Day 5:   Cold email (the main pitch — references the LinkedIn interaction)
Day 10:  LinkedIn comment on one of their posts (genuine, helpful comment)
Day 14:  Follow-up email ("Just wanted to bump this — still relevant?")
Day 21:  Final email ("Last note from me — if the timing isn't right, 
          totally understand. Happy to reconnect later.")
```

**Rules:**
- Never more than one touchpoint per channel per week.
- Each touchpoint adds something new — a different angle, a new piece of value, a different case study. Don't just repeat the same message.
- The final touchpoint gives them a clean exit. No guilt, no pressure. This protects your reputation.

---

## Step 6: Track and Manage Your Pipeline

Outreach without tracking is guesswork. Use a simple system (spreadsheet or CRM):

```
COLUMNS:
  Lead Name | Company | Source | Date First Contacted | 
  Last Touchpoint | Stage | Notes | Next Action | Next Action Date
  
STAGES:
  Identified → Contacted → Replied → In Conversation → Proposal Sent → 
  Closed Won → Closed Lost → Not Now (re-nurture later)
```

**Pipeline hygiene rules:**
- Review your pipeline weekly (10 min). Move leads between stages. Delete dead ones (no response after full sequence = done).
- "Not Now" is not "No forever." Flag these for re-contact in 3-6 months. Timing matters — a lead that said no in January might say yes in June.
- Track your conversion rates at each stage. If "Contacted → Replied" is very low, your messaging needs work. If "In Conversation → Proposal Sent" is low, your discovery process needs work.

---

## Step 7: Outreach Volume and Time Management

As a solopreneur, you can't prospect full-time. Time-box it.

**Recommended cadence:**
- **Daily (20 min):** Research and qualify 3-5 new leads. Add to pipeline.
- **Daily (15 min):** Send or follow up on 3-5 touchpoints.
- **Weekly (30 min):** Pipeline review. Update stages. Plan next week's outreach.

**Volume targets:**
- 3-5 new leads entering the pipeline per day
- 15-25 active leads in your pipeline at any time
- 1-3 discovery calls per week (depending on your capacity)

**If outreach is taking more than 45 min/day, you're spending too much time on research. Use better tools or tighter ICP criteria to reduce the search time.**

---

## Outreach Mistakes to Avoid
- Blasting the same template to 500 people. Personalization is not optional — it is the entire strategy.
- Giving up after one message. Most replies come on touchpoints 3-5, not 1.
- Pitching immediately. Lead with value or curiosity. Earn the right to pitch.
- Ignoring "not now" responses. These are warm leads for the future. nurture them.
- Not following up on replies fast enough. If someone replies, respond within the same day. Speed signals professionalism and interest.
