---
name: outlook
emoji: f4e7
description: Microsoft Outlook/Live.com email client via Microsoft Graph API. List, search, read, send, and reply to emails.
homepage: https://github.com/abhiramee08b021/outlook-cli
metadata:
  {
    "openclaw":
      {
        "emoji": "📧",
        "requires": { "bins": ["python3"], "python_packages": ["requests"] },
        "install":
          [
            {
              "id": "manual",
              "kind": "manual",
              "label": "Requires Azure AD app registration",
            },
          ],
      },
  }
---

# Outlook CLI

Command-line email client for Microsoft Outlook/Live/Hotmail using Microsoft Graph API.

## Setup

1. **Create Azure AD App:** https://portal.azure.com → App registrations
   - Name: `outlook-cli`
   - Account type: "Personal Microsoft accounts only"
   - Redirect URI: `http://localhost:8080/callback`

2. **Get credentials** from your app registration

3. **Configure:**
   ```bash
   outlook configure
   ```

4. **Authenticate:**
   ```bash
   outlook auth
   ```

## Commands

| Command | Description |
|---------|-------------|
| `outlook list [n]` | List recent emails |
| `outlook search "query" [n]` | Search emails |
| `outlook read <id>` | Read email by ID |
| `outlook send --to ...` | Send email |
| `outlook reply <id>` | Reply to email |
| `outlook status` | Check auth status |

## Examples

**List emails:**
```bash
outlook list 20
```

**Search:**
```bash
outlook search "from:linkedin.com"
outlook search "subject:invoice"
```

**Send:**
```bash
outlook send --to "user@example.com" --subject "Hello" --body "Message"
outlook send --to "a@x.com,b@x.com" --cc "boss@x.com" --subject "Update" --body-file ./msg.txt
```

**Reply:**
```bash
outlook reply EMAIL_ID --body "Thanks!"
outlook reply EMAIL_ID --all --body "Thanks everyone!"
```

## Search Operators

- `from:email@domain.com` - Sender
- `subject:keyword` - Subject line
- `body:keyword` - Email body
- `received:YYYY-MM-DD` - Date
- `hasattachment:yes` - Has attachments

## Files

- `SKILL.md` - This documentation
- `outlook` - Main CLI script
- `README.md` - Full documentation
