# Outlook CLI

A command-line tool for managing Microsoft Outlook/Live/Hotmail emails via Microsoft Graph API. Built as an OpenClaw skill.

## Features

- 📧 **List emails** - View recent emails in your inbox
- 🔍 **Search** - Full-text search across emails
- 📖 **Read** - View full email content
- ✉️ **Send** - Send new emails with CC/BCC support
- 💬 **Reply** - Reply to emails (with reply-all support)

## Installation

### Prerequisites

- Python 3.7+
- `requests` library (`pip install requests`)

### Setup

1. **Clone or download** this repository:
   ```bash
   git clone https://github.com/abhiramee08b021/outlook-cli.git
   cd outlook-cli
   ```

2. **Create Azure AD App Registration:**
   - Go to [Azure Portal](https://portal.azure.com) → App registrations → New registration
   - Name: `outlook-cli` (or anything)
   - Supported account types: "Personal Microsoft accounts only"
   - Redirect URI: Web → `http://localhost:8080/callback`
   - Click **Register**

3. **Get credentials:**
   - Copy **Application (client) ID** from Overview page
   - Go to **Certificates & secrets** → New client secret → Copy value

4. **Configure the tool:**
   ```bash
   ./outlook configure
   # Enter your Client ID and Client Secret when prompted
   ```

5. **Authenticate:**
   ```bash
   ./outlook auth
   ```
   - Opens browser for Microsoft login
   - Copy the callback URL and paste when prompted

## Usage

### List Emails

```bash
./outlook list          # List 10 most recent emails
./outlook list 20       # List 20 emails
```

### Search Emails

```bash
./outlook search "from:linkedin.com"
./outlook search "subject:invoice"
./outlook search "body:meeting" 30
```

**Search operators:**
- `from:email@domain.com` - Search by sender
- `to:email@domain.com` - Search by recipient
- `subject:keyword` - Search subject line
- `body:keyword` - Search email body
- `received:YYYY-MM-DD` - Search by date
- `hasattachment:yes` - Emails with attachments

### Read Email

```bash
./outlook read AQMkADAwATM3ZmY...
```

### Send Email

```bash
# Simple email
./outlook send --to "recipient@example.com" --subject "Hello" --body "Message"

# Multiple recipients
./outlook send --to "user1@example.com,user2@example.com" --subject "Hi" --body "Hello all"

# With CC/BCC
./outlook send --to "boss@company.com" --cc "team@company.com" --subject "Update" --body "Project status"

# Body from file
./outlook send --to "friend@example.com" --subject "Notes" --body-file ./notes.txt

# HTML email
./outlook send --to "user@example.com" --subject "Styled" --body "<h1>Hello</h1>" --html

# From stdin (pipe)
echo "Meeting notes" | ./outlook send --to "team@company.com" --subject "Notes" --body-file -
```

### Reply to Email

```bash
# Reply to sender only
./outlook reply EMAIL_ID --body "Thanks for the info!"

# Reply to all (includes CC)
./outlook reply EMAIL_ID --all --body "Thanks everyone!"

# Reply from file
./outlook reply EMAIL_ID --body-file ./response.txt
```

### Check Status

```bash
./outlook status
```

## Configuration

Configuration is stored in `~/.config/outlook-cli/`:
- `config.json` - Client ID and secret
- `tokens.json` - OAuth tokens (auto-generated)

## Security

- Tokens are stored with restricted permissions (600)
- Client secret is stored locally and never transmitted except to Microsoft
- Uses OAuth2 with refresh tokens for secure, long-term access

## Limitations

- Attachments: Can view received emails with attachments, but sending attachments is not yet supported
- Drafts: Direct send only, no draft saving

## License

MIT

## Contributing

Pull requests welcome! This is a community tool for Outlook email management.
