# Phase 3: Documentation

**Done when:** SKILL.md has YubiKey setup instructions, README.md mentions YubiKey support, and troubleshooting covers common YubiKey issues.

---

### Task 1: Add YubiKey Setup section to SKILL.md

**Files:**
- Modify: `/Volumes/T9/ryan-homedir/devel/otp-challenger/SKILL.md`

**Step 1: Add YubiKey Setup section after TOTP Setup (after line 108)**

Find the section "### 4. Test Your Setup" (around line 109). Insert the following BEFORE that section (after "Option C: In 1Password"):

```markdown
### YubiKey Setup (Alternative to TOTP)

If you have a YubiKey, you can use touch-to-verify instead of typing 6-digit codes.

#### 1. Get Yubico API Credentials

1. Go to **https://upgrade.yubico.com/getapikey/**
2. Enter your email address
3. Touch your YubiKey to generate an OTP in the form field
4. Submit — you'll receive a **Client ID** and **Secret Key**

**Troubleshooting "Invalid OTP" during registration:**

If Yubico's site rejects your OTP, your key may not be registered with Yubico's cloud:

1. Install **YubiKey Manager** from https://www.yubico.com/support/download/yubikey-manager/
2. Open it, go to **Applications → OTP → Configure Slot 1**
3. Select **Yubico OTP** and check **"Upload to Yubico"**
4. This re-registers your key with Yubico's servers
5. Try getting API credentials again

#### 2. Configure Credentials

**Option A: In your OpenClaw config**
```yaml
# ~/.openclaw/config.yaml
security:
  yubikey:
    clientId: "12345"
    secretKey: "your-base64-secret-key"
```

**Option B: In environment variables**
```bash
export YUBIKEY_CLIENT_ID="12345"
export YUBIKEY_SECRET_KEY="your-base64-secret-key"
```

#### 3. Test YubiKey Verification

```bash
# Touch your YubiKey when prompted
./verify.sh "testuser" "cccccccccccc..."  # paste YubiKey output
# Should show: ✅ YubiKey verified for testuser (valid for 24 hours)
```

#### Using Both TOTP and YubiKey

You can configure both methods. The script auto-detects which to use based on the code format:
- **6 digits** → TOTP validation
- **44 characters** → YubiKey validation

This lets you use TOTP on your phone and YubiKey at your desk.
```

**Step 2: Verify markdown renders correctly**

Visually check the file or use a markdown preview tool.

**Step 3: Commit**

```bash
git add SKILL.md
git commit -m "docs(SKILL): add YubiKey setup instructions"
```

---

### Task 2: Update Scripts section in SKILL.md

**Files:**
- Modify: `/Volumes/T9/ryan-homedir/devel/otp-challenger/SKILL.md`

**Step 1: Update the Scripts section (around line 183)**

Find the line:
```markdown
- **`verify.sh <user_id> <code>`** - Verify OTP code and update state
```

Replace with:
```markdown
- **`verify.sh <user_id> <code>`** - Verify OTP code (TOTP or YubiKey) and update state
```

**Step 2: Commit**

```bash
git add SKILL.md
git commit -m "docs(SKILL): update scripts section for YubiKey"
```

---

### Task 3: Update Configuration section in SKILL.md

**Files:**
- Modify: `/Volumes/T9/ryan-homedir/devel/otp-challenger/SKILL.md`

**Step 1: Add YubiKey config options (around line 195)**

Find the Configuration section that lists environment variables. After the existing options, add:

```markdown
**YubiKey Configuration:**
- **`YUBIKEY_CLIENT_ID`** - Yubico API client ID (required for YubiKey)
- **`YUBIKEY_SECRET_KEY`** - Yubico API secret key (required for YubiKey)
```

**Step 2: Commit**

```bash
git add SKILL.md
git commit -m "docs(SKILL): add YubiKey configuration options"
```

---

### Task 4: Add YubiKey troubleshooting to SKILL.md

**Files:**
- Modify: `/Volumes/T9/ryan-homedir/devel/otp-challenger/SKILL.md`

**Step 1: Add YubiKey troubleshooting section (around line 367, in Troubleshooting)**

Find the existing troubleshooting section. Add after the existing items:

```markdown
### YubiKey Issues

### "YUBIKEY_CLIENT_ID not set"
- Get API credentials from https://upgrade.yubico.com/getapikey/
- Set `YUBIKEY_CLIENT_ID` and `YUBIKEY_SECRET_KEY` in environment or config

### "Invalid OTP" when getting API key
- Your YubiKey may not be registered with Yubico's cloud
- Use YubiKey Manager to reconfigure Slot 1 with "Upload to Yubico" checked

### "YubiKey API signature mismatch"
- Check that `YUBIKEY_SECRET_KEY` is correct (should be base64)
- Try regenerating API credentials from Yubico

### "Failed to contact Yubico API"
- Check internet connectivity
- Yubico API requires HTTPS (port 443)
- Try: `curl -I https://api.yubico.com/wsapi/2.0/verify`

### "YubiKey OTP already used"
- Each YubiKey press generates a unique code
- Touch your YubiKey again to generate a fresh code
- Don't copy-paste old codes
```

**Step 2: Commit**

```bash
git add SKILL.md
git commit -m "docs(SKILL): add YubiKey troubleshooting section"
```

---

### Task 5: Update Technical Details in SKILL.md

**Files:**
- Modify: `/Volumes/T9/ryan-homedir/devel/otp-challenger/SKILL.md`

**Step 1: Add YubiKey technical details (around line 230, after TOTP Implementation)**

After the TOTP Implementation section, add:

```markdown
### YubiKey OTP Implementation

- **API**: Yubico Cloud (api.yubico.com)
- **Protocol**: HMAC-SHA1 signed requests
- **OTP Format**: 44-character ModHex (alphabet: cbdefghijklnrtuv)
- **Public ID**: First 12 characters identify the physical key
- **Replay Protection**: Handled by Yubico servers
- **Network**: Requires HTTPS to api.yubico.com
```

**Step 2: Commit**

```bash
git add SKILL.md
git commit -m "docs(SKILL): add YubiKey technical details"
```

---

### Task 6: Update README.md

**Files:**
- Modify: `/Volumes/T9/ryan-homedir/devel/otp-challenger/README.md`

**Step 1: Update the Example section (around line 26)**

Find the example section. Update the comment to mention both methods:

```markdown
## Example

```bash
#!/bin/bash
# In your deploy skill

source ../otp/verify.sh

# Works with both 6-digit TOTP codes and YubiKey OTP
if ! verify_otp "$USER" "$OTP_CODE"; then
  echo "🔒 Production deployment requires OTP verification"
  exit 1
fi

echo "✅ Identity verified. Deploying..."
kubectl apply -f production.yaml
```
```

**Step 2: Add YubiKey mention to Documentation section (around line 43)**

Update the Documentation section bullet list:

```markdown
## Documentation

See **[SKILL.md](./SKILL.md)** for complete documentation:
- Installation & setup
- TOTP and YubiKey configuration
- Usage examples
- Security considerations
- Configuration options
- Troubleshooting
```

**Step 3: Commit**

```bash
git add README.md
git commit -m "docs(README): mention YubiKey support"
```

---

### Task 7: Update metadata in SKILL.md frontmatter

**Files:**
- Modify: `/Volumes/T9/ryan-homedir/devel/otp-challenger/SKILL.md`

**Step 1: Update the description in frontmatter (line 3)**

Find the description line:
```yaml
description: Enable agents and skills to challenge users for fresh two-factor authentication proof before executing sensitive actions.
```

Update to:
```yaml
description: Enable agents and skills to challenge users for fresh two-factor authentication proof (TOTP or YubiKey) before executing sensitive actions.
```

**Step 2: Update version number (line 2)**

```yaml
version: 1.1.0
```

**Step 3: Commit**

```bash
git add SKILL.md
git commit -m "docs(SKILL): update version and description for YubiKey release"
```

---

### Phase 3 Verification

**Step 1: Review documentation changes**

```bash
cd /Volumes/T9/ryan-homedir/devel/otp-challenger
git diff HEAD~7 SKILL.md README.md | head -100
```

Verify:
- YubiKey setup section is present
- Configuration options are documented
- Troubleshooting covers YubiKey issues
- README mentions YubiKey support

**Step 2: Run full test suite one more time**

```bash
bats tests/verify.bats tests/check-status.bats
```

Expected: All tests pass

**Step 3: Create final commit summarizing the feature**

```bash
git add -A
git status
```

If there are any uncommitted changes, commit them:

```bash
git commit -m "feat: complete YubiKey OTP support implementation"
```

---

### Feature Complete Verification

Run a final end-to-end check:

```bash
# Verify TOTP still works
OTP_SECRET="JBSWY3DPEHPK3PXP" ./verify.sh testuser $(oathtool --totp -b JBSWY3DPEHPK3PXP)

# Verify YubiKey format detection works (will fail on credentials, not format)
./verify.sh testuser "cccccccccccccccccccccccccccccccccccccccccccc"
# Expected: "YUBIKEY_CLIENT_ID not set" error

# With real YubiKey credentials (if available):
# YUBIKEY_CLIENT_ID="xxx" YUBIKEY_SECRET_KEY="yyy" ./verify.sh testuser "<touch yubikey>"
```

The feature is complete when:
1. All BATS tests pass
2. TOTP verification works as before
3. YubiKey format is detected and routed correctly
4. Documentation describes both methods
