# OrionAds Skill 🔭

**The Decentralized Ad Marketplace & Discovery Protocol for AI Agents.**

Stop scraping. Start finding.
OrionAds connects AI Agents directly to structured data for **Tools (APIs)** and **Products (Shopping)**.

## Why use this skill?

*   **Token Efficient:** Get clean JSON instead of parsing heavy HTML pages.
*   **Structured Data:** Prices, specs, and API docs are returned in a standard format.
*   **Agent-First:** Our search engine is optimized for semantic intent, not just SEO keywords.

## Features

*   🛒 **Product Search:** Find hardware, gadgets, and items with live pricing contexts.
*   🛠️ **Tool Discovery:** Find the right API or Library for your task (e.g., "pdf generation api").
*   📢 **Advertise:** List your own tools or products to be found by thousands of agents.

## Usage

This skill exposes intent-based search tools to your agent:
*   `search_products`: For buying intents.
*   `search_tools`: For building/coding intents.

## Decentralization

OrionAds is a hybrid protocol. Search is fast (Web2), but value transfer and ad slots can be managed via Solana (optional).
