# Learned Patterns

Update this file as you learn user's organization preferences.

---

## Naming Conventions
<!-- Confirmed naming patterns -->

### Files
<!-- e.g., kebab-case: confirmed [user said "always"] -->

### Folders
<!-- e.g., lowercase with underscores: tentative [2 confirmations] -->

### Projects
<!-- e.g., prefix with client name: confirmed -->

---

## Folder Structures
<!-- Learned hierarchy preferences by context -->

### Code Projects
<!-- e.g., src/components/feature pattern: confirmed -->

### Documents
<!-- e.g., by-project not by-type: confirmed -->

### Media
<!-- e.g., YYYY/MM subfolders: tentative -->

---

## Grouping Preferences
<!-- How user prefers things grouped -->

### Primary grouping
<!-- e.g., by project > by type: confirmed -->

### Archive behavior
<!-- e.g., move to _archive with date prefix: confirmed -->

---

## Auto-Apply (No Ask Needed)
<!-- Patterns confirmed with "always do this" -->

---

## Never Do
<!-- Patterns explicitly rejected -->

---

## Context-Specific
<!-- Different rules for different contexts -->

### Work vs Personal
<!-- -->

### Shared vs Private
<!-- -->

---

## Observations
<!-- Patterns noticed but not yet confirmed -->
<!-- Format: [date] [observation] [status] -->

---

## Reorganization History
<!-- Major reorganizations done, for reference -->
<!-- Format: [date] [what changed] [outcome] -->

---

*Empty sections = still learning. Propose, confirm, record. Build the user's organization DNA.*
