---
name: Organize
description: Proactively organize while working. Learn user's structure preferences, think ahead for scale, optimize for future access.
---

## Core Principle

Organization isn't a separate task—it happens while you work. Every file created, every folder touched is an opportunity to improve structure.

Think ahead: how will this scale? How will it be accessed later? Organize for the future, not just today.

Check `principles.md` for organization fundamentals. Check `patterns.md` for learned preferences (update as you learn).

---

## Proactive Triggers

Organize when you notice:

| Trigger | Action |
|---------|--------|
| Creating new file | Propose location based on patterns.md |
| Multiple related files | Suggest grouping structure |
| Naming something | Apply naming conventions from patterns.md |
| Searching takes effort | Propose reorganization |
| Pattern emerging | Document in patterns.md, confirm with user |

---

## The Organization Loop

```
1. OBSERVE — Notice structure while working
2. PROPOSE — Suggest improvement before acting
3. CONFIRM — Get explicit OK (until pattern confirmed)
4. APPLY   — Organize, document what you did
5. LEARN   — Record preference in patterns.md
```

**Never reorganize without asking.** Until a pattern is confirmed, always propose first.

---

## Scale Thinking

Before placing anything, ask:

- **10x test:** If this grows 10x, does the structure hold?
- **Access pattern:** How will this be found later? By whom?
- **Related items:** What will live near this? Group accordingly.
- **Lifecycle:** Will this be archived? Deleted? Versioned?

---

## Proposal Format

```
📁 Organization suggestion

I'm about to [create/move/rename] [item].

Current: [where it would go by default]
Proposed: [where it should go based on patterns]

Reasoning: [why this structure scales better]

OK to organize this way? (Say "always for X" to skip future asks)
```

---

## Learning Preferences

Track confirmations:

| Pattern | Status |
|---------|--------|
| Seen once | Note, still ask |
| Confirmed 2x | Tentative, still ask |
| "Always do this" | Auto-apply, stop asking |
| "Never do this" | Avoid, record in patterns.md |

---

## Reorganization Proposals

When existing structure needs improvement:

```
📁 Reorganization proposal

Problem: [what's inefficient now]
Impact: [how it affects access/scale]

Proposed change:
- [specific moves/renames]

Effort: [minimal/moderate/significant]
Risk: [what could break]

Should I proceed?
```

---

## Anti-Patterns

| Don't | Do instead |
|-------|------------|
| Reorganize silently | Always propose first |
| Organize in bulk later | Organize while working |
| Structure for today only | Think 10x ahead |
| Assume preferences | Confirm, then record |
| Same structure for everything | Adapt to content type |
