---
version: 1
title: Human-Friendly Calendar
timezone: local
updatedAt: 2026-02-26T01:38:54.592Z
categories:
  - id: math
    label: Math
    color: "#2563eb"
    description: Math work
  - id: physics
    label: Physics
    color: "#7c3aed"
    description: Physics work
  - id: chem
    label: Chem
    color: "#16a34a"
    description: Chemistry work
  - id: english
    label: English
    color: "#f59e0b"
    description: English work
  - id: history
    label: History
    color: "#f97316"
    description: History work
  - id: multi
    label: Multi
    color: "#0ea5a4"
    description: Multivariable calc
  - id: b2a
    label: B2A
    color: "#9333ea"
    description: B2Alpha startup
  - id: life
    label: Life
    color: "#e11d48"
    description: Family, errands, admin, personal
---

# Calendar

This file is the single source of truth for the calendar app and CLI.
The authoritative event data lives in the `Event Records` section.

## Categories

| id | label | color | description |
| --- | --- | --- | --- |
| math | Math | #2563eb | Math work |
| physics | Physics | #7c3aed | Physics work |
| chem | Chem | #16a34a | Chemistry work |
| english | English | #f59e0b | English work |
| history | History | #f97316 | History work |
| multi | Multi | #0ea5a4 | Multivariable calc |
| b2a | B2A | #9333ea | B2Alpha startup |
| life | Life | #e11d48 | Family, errands, admin, personal |

## Event Checklist

- [ ] `evt_Rxo-fKEa` | 2000-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_qInyoKcn` | 2001-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_GfCWHXe9` | 2002-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_DtxKMOCt` | 2003-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_M5P18GSx` | 2004-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_wUSh-eqU` | 2005-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_QHOhhaj2` | 2006-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_MO5JlLts` | 2007-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_5CmHWkLR` | 2008-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_JdnC1dLI` | 2009-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_Kw_Y8J2y` | 2010-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_iWIWasJp` | 2011-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_MF-k8kVG` | 2012-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_skkC8Qm1` | 2013-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_YWTbdSRR` | 2014-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_1UY1fO87` | 2015-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_mP8otqLV` | 2016-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_3NXJHa-v` | 2017-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_lnSQn_y7` | 2018-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_egFvKfDQ` | 2019-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_qm_bXd9D` | 2020-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_fHxDDbNU` | 2021-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_YGG-QzHe` | 2022-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_i7ivk46V` | 2023-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_mgui4Jau` | 2024-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_hSKyvo9Z` | 2025-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_v1GClHgi` | 2026-02-16 07:45 -> 2026-02-16 16:00 | **Purdue's for Me - College of Engineering** (`life`)
- [ ] `evt_IcrkEyXB` | 2026-02-18 00:00 -> 2026-02-18 01:00 | **AP CHEM: Unit 7 Test** (`life`)
- [ ] `evt_zxid6zB-` | 2026-02-20 09:30 -> 2026-02-20 11:00 | **MATH QUIZ: 15.6-15.7 (Triple/Cylindrical)** (`life`)
- [ ] `evt_W1rkxhC1` | 2026-02-21 21:20 -> 2026-02-21 21:45 | **AP Chem Unit 7 Review** (`life`)
- [ ] `evt_u7S2rhly` | 2026-02-21 22:10 -> 2026-02-21 22:40 | **AP Gov Party Platforms** (`life`)
- [ ] `evt_E-VeMWOL` | 2026-02-22 01:00 -> 2026-02-22 07:15 | **Sleep** (`life`)
- [ ] `evt_cZbxPMTg` | 2026-02-22 07:15 -> 2026-02-22 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_maEGWnZ4` | 2026-02-22 07:25 -> 2026-02-22 07:35 | **Wake Up** (`life`)
- [ ] `evt_PeUeqmNP` | 2026-02-22 07:35 -> 2026-02-22 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_v40Xk1hm` | 2026-02-22 08:00 -> 2026-02-22 08:10 | **Wake Up** (`life`)
- [ ] `evt_DOpql9nH` | 2026-02-22 08:10 -> 2026-02-22 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_2MRR7a7C` | 2026-02-22 10:00 -> 2026-02-22 11:00 | **Test Event** (`life`)
- [ ] `evt_x16JWhZB` | 2026-02-22 13:30 -> 2026-02-22 15:30 | **AP Chem Unit 7 Review** (`life`)
- [ ] `evt_Dh4w8eco` | 2026-02-22 15:30 -> 2026-02-22 17:30 | **AP Physics (Torque/Rotational) - Concept Work** (`life`)
- [ ] `evt_SLRutOzI` | 2026-02-22 17:30 -> 2026-02-22 19:00 | **AP Chem Unit 7 Review** (`life`)
- [ ] `evt_Icd7jBEI` | 2026-02-22 19:00 -> 2026-02-22 20:00 | **AP Chem Unit 7 Practice Problems** (`life`)
- [ ] `evt_3ZuWYLoF` | 2026-02-22 20:00 -> 2026-02-22 20:45 | **Workout** (`life`)
- [ ] `evt_7505sH7R` | 2026-02-22 21:35 -> 2026-02-22 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_Vueyn4eh` | 2026-02-22 21:45 -> 2026-02-22 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_JxpfB-GR` | 2026-02-22 21:50 -> 2026-02-22 22:10 | **Shower** (`life`)
- [ ] `evt_u621tiSY` | 2026-02-22 22:30 -> 2026-02-22 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_rjxDo2j8` | 2026-02-22 22:35 -> 2026-02-22 22:55 | **Shower** (`life`)
- [ ] `evt_I2ChL5nD` | 2026-02-23 00:00 -> 2026-02-23 07:15 | **Sleep** (`life`)
- [ ] `evt__FiTIp3l` | 2026-02-23 07:15 -> 2026-02-23 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_S1u_DpyC` | 2026-02-23 08:30 -> 2026-02-23 08:40 | **Wake Up (Snow Day)** (`life`)
- [ ] `evt_NzLC0yo7` | 2026-02-23 08:40 -> 2026-02-23 08:45 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_QXzP-Sf-` | 2026-02-23 09:00 -> 2026-02-23 11:00 | **🧪 AP Chem: One Pager + Unit Lab (MISSED)** (`life`)
- [ ] `evt_LCWwlGHs` | 2026-02-23 11:00 -> 2026-02-23 13:00 | **🧪 AP Chem: Unit 7 Review** (`life`)
- [ ] `evt_bXh-9CNW` | 2026-02-23 13:00 -> 2026-02-23 13:30 | **Lunch** (`life`)
- [ ] `evt_6eu8fG-7` | 2026-02-23 13:30 -> 2026-02-23 14:30 | **⚡ AP Physics: Lab Writeup (Whirlygig)** (`life`)
- [ ] `evt_hnoQtWdw` | 2026-02-23 14:45 -> 2026-02-23 18:30 | **🧪 AP Chem: Unit 7 Deep Review** (`life`)
- [ ] `evt__Yv1cohP` | 2026-02-23 15:00 -> 2026-02-23 18:15 | **🏗️ B2A Work Session @ Library [SKIPPED → Chem]** (`life`)
- [ ] `evt_6HvgkiVO` | 2026-02-23 19:00 -> 2026-02-23 20:30 | **🎸 Guitar Concert** (`life`)
- [ ] `evt_R6wKCAdf` | 2026-02-23 20:45 -> 2026-02-23 21:30 | **Workout** (`life`)
- [ ] `evt_pf46pI9W` | 2026-02-23 21:30 -> 2026-02-23 22:30 | **🧪 AP Chem: Final Review Pass** (`life`)
- [ ] `evt_uekciqvB` | 2026-02-23 22:30 -> 2026-02-23 22:40 | **Evening Check-in** (`life`)
- [ ] `evt_2BtiMDGw` | 2026-02-23 22:30 -> 2026-02-23 22:35 | **Brush Teeth (PM) [DUP - IGNORE]** (`life`)
- [ ] `evt_53LUgn-v` | 2026-02-23 22:35 -> 2026-02-23 22:55 | **Shower** (`life`)
- [ ] `evt_APL7Yt3F` | 2026-02-23 22:40 -> 2026-02-23 22:45 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_Sf7iVABC` | 2026-02-23 22:45 -> 2026-02-23 23:05 | **Shower** (`life`)
- [ ] `evt_sGflJXY_` | 2026-02-24 00:00 -> 2026-02-24 07:15 | **Sleep** (`life`)
- [ ] `evt_Adm14fA6` | 2026-02-24 07:15 -> 2026-02-24 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_Z2faobJ-` | 2026-02-24 07:25 -> 2026-02-24 07:35 | **Wake Up** (`life`)
- [ ] `evt_s6usjtmX` | 2026-02-24 07:35 -> 2026-02-24 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_KwkDvsH2` | 2026-02-24 08:00 -> 2026-02-24 08:10 | **Wake Up** (`life`)
- [ ] `evt__nVcqLHd` | 2026-02-24 08:10 -> 2026-02-24 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_f4vEde8L` | 2026-02-24 17:15 -> 2026-02-24 18:45 | **AP Physics Quiz 2 Prep** (`life`)
- [ ] `evt_4nVdZGjE` | 2026-02-24 19:00 -> 2026-02-24 20:00 | **Multi: Triple Integrals** (`life`)
- [ ] `evt_duM5ffdG` | 2026-02-24 20:15 -> 2026-02-24 21:00 | **Workout** (`life`)
- [ ] `evt_W2wygxJG` | 2026-02-24 21:00 -> 2026-02-24 21:30 | **English: Truman Show Notes** (`life`)
- [ ] `evt_hq4dkRQl` | 2026-02-24 21:30 -> 2026-02-24 22:15 | **📐 Math HW: Redo Properly** (`life`)
- [ ] `evt_gxHE7YMk` | 2026-02-24 22:15 -> 2026-02-24 22:25 | **Evening Check-in** (`life`)
- [ ] `evt_684G8zGO` | 2026-02-24 22:25 -> 2026-02-24 22:30 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_cicGm6H5` | 2026-02-24 22:30 -> 2026-02-24 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_A2ecogk1` | 2026-02-24 22:30 -> 2026-02-24 22:50 | **Shower** (`life`)
- [ ] `evt_x9jYZvZR` | 2026-02-24 22:35 -> 2026-02-24 22:55 | **Shower** (`life`)
- [ ] `evt_HrXae22f` | 2026-02-25 00:00 -> 2026-02-25 07:15 | **Sleep** (`life`)
- [ ] `evt_dbJ6f01x` | 2026-02-25 (all day) | **⚡ Physics Quiz 2: Torque & Moment of Inertia** (`life`)
- [ ] `evt__3yJ5LdY` | 2026-02-25 07:15 -> 2026-02-25 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_76fehQxZ` | 2026-02-25 07:25 -> 2026-02-25 07:35 | **Wake Up** (`life`)
- [ ] `evt_1n_WZ_-A` | 2026-02-25 07:35 -> 2026-02-25 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_hjR-QiLC` | 2026-02-25 08:00 -> 2026-02-25 08:10 | **Wake Up** (`life`)
- [ ] `evt_PMA_yfVG` | 2026-02-25 08:10 -> 2026-02-25 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_vDmneprY` | 2026-02-25 17:15 -> 2026-02-25 18:10 | **Physics webassign + concept check** (`physics`)
- [ ] `evt_LoWzi3cZ` | 2026-02-25 17:15 -> 2026-02-25 18:30 | **AP Physics Whirligig + Practice** (`life`)
- [ ] `evt_Z_1VeBj-` | 2026-02-25 18:10 -> 2026-02-25 18:25 | **Pick up sister** (`life`)
- [ ] `evt_i944_v_C` | 2026-02-25 18:25 -> 2026-02-25 19:30 | **Physics webassign + concept check (finish)** (`physics`)
- [ ] `evt_UQxk4yBx` | 2026-02-25 18:45 -> 2026-02-25 20:00 | **Multi: Triple Integrals** (`life`)
- [ ] `evt_8nuraLrq` | 2026-02-25 19:45 -> 2026-02-25 20:45 | **Physics quiz prep (Torque & Rotational Inertia)** (`physics`)
- [ ] `evt__dhFen6H` | 2026-02-25 20:15 -> 2026-02-25 21:00 | **Workout** (`life`)
- [ ] `evt_pbXZAVx5` | 2026-02-25 20:45 -> 2026-02-25 22:00 | **Math QZ 15.2 practice** (`math`)
- [ ] `evt_TLTZHNCd` | 2026-02-25 21:00 -> 2026-02-25 21:30 | **English: Truman Show Prep** (`life`)
- [ ] `evt_HWW5T0Wm` | 2026-02-25 21:35 -> 2026-02-25 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_7M0frlg3` | 2026-02-25 21:45 -> 2026-02-25 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_jFk6jUGo` | 2026-02-25 21:50 -> 2026-02-25 22:10 | **Shower** (`life`)
- [ ] `evt_pN0rDFdG` | 2026-02-25 22:15 -> 2026-02-25 23:15 | **Chem missing work (during B2A call)** (`chem`)
- [ ] `evt_8OlCIe8P` | 2026-02-25 22:30 -> 2026-02-25 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_3z1Ypmn-` | 2026-02-25 22:35 -> 2026-02-25 22:55 | **Shower** (`life`)
- [ ] `evt_aRj3m08n` | 2026-02-25 23:15 -> 2026-02-26 00:15 | **Multi practice** (`multi`)
- [ ] `evt_SDKaSnxc` | 2026-02-26 00:00 -> 2026-02-26 07:15 | **Sleep** (`life`)
- [ ] `evt__4Y-AgFx` | 2026-02-26 07:15 -> 2026-02-26 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_BbdIBBog` | 2026-02-26 07:25 -> 2026-02-26 07:35 | **Wake Up** (`life`)
- [ ] `evt_Q7kFkECr` | 2026-02-26 07:35 -> 2026-02-26 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_D-BPsi5s` | 2026-02-26 08:00 -> 2026-02-26 08:10 | **Wake Up** (`life`)
- [ ] `evt_6Fjhm5f0` | 2026-02-26 08:10 -> 2026-02-26 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_seed001` | 2026-02-26 09:00 -> 2026-02-26 10:00 | **Weekly planning** (`projects`)
- [ ] `evt_seed002` | 2026-02-26 14:00 -> 2026-02-26 15:00 | **Math study block** (`math`)
- [ ] `evt_GUUq2mxe` | 2026-02-26 18:45 -> 2026-02-26 20:00 | **AP Chem Unit 8 Notes** (`life`)
- [ ] `evt_EBYuqHiP` | 2026-02-26 20:15 -> 2026-02-26 21:00 | **Workout** (`life`)
- [ ] `evt_GIrBExc2` | 2026-02-26 21:00 -> 2026-02-26 21:30 | **Project/Startup** (`life`)
- [ ] `evt_Qqu7VSNB` | 2026-02-26 21:35 -> 2026-02-26 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_F9P3feQw` | 2026-02-26 21:45 -> 2026-02-26 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_aYANx5Qa` | 2026-02-26 21:50 -> 2026-02-26 22:10 | **Shower** (`life`)
- [ ] `evt_JeNJG-Km` | 2026-02-26 22:30 -> 2026-02-26 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_om-OTklC` | 2026-02-26 22:35 -> 2026-02-26 22:55 | **Shower** (`life`)
- [ ] `evt_wOvI-ygU` | 2026-02-27 00:00 -> 2026-02-27 07:15 | **Sleep** (`life`)
- [ ] `evt_DYCOm_eo` | 2026-02-27 (all day) | **🧪 AP CHEM UNIT 7 TEST** (`life`)
- [ ] `evt_B1m7-J82` | 2026-02-27 07:15 -> 2026-02-27 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_qau6uwZb` | 2026-02-27 07:25 -> 2026-02-27 07:35 | **Wake Up** (`life`)
- [ ] `evt_0-X8Po4U` | 2026-02-27 07:35 -> 2026-02-27 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_3WYD7C88` | 2026-02-27 08:00 -> 2026-02-27 08:10 | **Wake Up** (`life`)
- [ ] `evt_sLgsgs89` | 2026-02-27 08:10 -> 2026-02-27 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_YhXYTdkB` | 2026-02-27 17:15 -> 2026-02-27 18:30 | **Multi: Triple Integrals** (`life`)
- [ ] `evt_uiOP_gxc` | 2026-02-27 18:45 -> 2026-02-27 20:00 | **English: Truman Show Seminar Prep** (`life`)
- [ ] `evt_keHWgl_4` | 2026-02-27 20:15 -> 2026-02-27 21:00 | **Workout** (`life`)
- [ ] `evt_wXt7DgU2` | 2026-02-27 21:00 -> 2026-02-27 21:30 | **Project/Startup** (`life`)
- [ ] `evt_MZDIfcHt` | 2026-02-27 21:35 -> 2026-02-27 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_JMdue046` | 2026-02-27 21:45 -> 2026-02-27 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_LLmtm6UM` | 2026-02-27 21:50 -> 2026-02-27 22:10 | **Shower** (`life`)
- [ ] `evt_a0d-ItYo` | 2026-02-27 22:30 -> 2026-02-27 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_VEDdjsju` | 2026-02-27 22:35 -> 2026-02-27 22:55 | **Shower** (`life`)
- [ ] `evt_Mnsn700q` | 2026-02-28 00:00 -> 2026-02-28 07:15 | **Sleep** (`life`)
- [ ] `evt_FnzCVPuV` | 2026-02-28 07:15 -> 2026-02-28 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_1_kl_OKw` | 2026-02-28 07:25 -> 2026-02-28 07:35 | **Wake Up** (`life`)
- [ ] `evt_R6673MRh` | 2026-02-28 07:35 -> 2026-02-28 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_W6i1heHj` | 2026-02-28 08:00 -> 2026-02-28 08:10 | **Wake Up** (`life`)
- [ ] `evt_q1Za806G` | 2026-02-28 08:10 -> 2026-02-28 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_ne9uLHNP` | 2026-02-28 10:00 -> 2026-02-28 12:00 | **Multi: 15.8/15.9 Practice** (`life`)
- [ ] `evt_AwX0AyIv` | 2026-02-28 13:00 -> 2026-02-28 15:00 | **AP Chem Unit 8 Notes** (`life`)
- [ ] `evt_yB6auwe5` | 2026-02-28 15:30 -> 2026-02-28 16:15 | **Workout** (`life`)
- [ ] `evt_oSALYEif` | 2026-02-28 16:30 -> 2026-02-28 18:00 | **AP Physics: Rotation + Newton 2** (`life`)
- [ ] `evt_ZYWtVKSB` | 2026-02-28 19:00 -> 2026-02-28 20:00 | **Project/Startup** (`life`)
- [ ] `evt_cxCNCZxj` | 2026-02-28 21:35 -> 2026-02-28 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_G-hNQ2kL` | 2026-02-28 21:45 -> 2026-02-28 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_jIaTfly6` | 2026-02-28 21:50 -> 2026-02-28 22:10 | **Shower** (`life`)
- [ ] `evt_lxgnyRDf` | 2026-02-28 22:30 -> 2026-02-28 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_V-cGVcmK` | 2026-02-28 22:35 -> 2026-02-28 22:55 | **Shower** (`life`)
- [ ] `evt_e4rfYAt7` | 2026-03-01 00:00 -> 2026-03-01 07:15 | **Sleep** (`life`)
- [ ] `evt_ANUijxOc` | 2026-03-01 07:15 -> 2026-03-01 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_SvkwoDPl` | 2026-03-01 07:25 -> 2026-03-01 07:35 | **Wake Up** (`life`)
- [ ] `evt_fQiHvSgk` | 2026-03-01 07:35 -> 2026-03-01 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_3aTHYEsx` | 2026-03-01 08:00 -> 2026-03-01 08:10 | **Wake Up** (`life`)
- [ ] `evt_-rUdkbjN` | 2026-03-01 08:10 -> 2026-03-01 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_q9NFDWL0` | 2026-03-01 10:00 -> 2026-03-01 12:00 | **English: Truman Show Seminar Deep Prep** (`life`)
- [ ] `evt_ZCnPVFCC` | 2026-03-01 13:00 -> 2026-03-01 15:00 | **AP Physics WA17 + Concept Check** (`life`)
- [ ] `evt_Q487nZSA` | 2026-03-01 15:30 -> 2026-03-01 16:15 | **Workout** (`life`)
- [ ] `evt_iFf7FUgp` | 2026-03-01 16:30 -> 2026-03-01 18:00 | **AP Chem Unit 8 Notes** (`life`)
- [ ] `evt_JX9t6oN5` | 2026-03-01 19:00 -> 2026-03-01 20:00 | **AP Gov Review** (`life`)
- [ ] `evt_jUS5xpU8` | 2026-03-01 21:35 -> 2026-03-01 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_shBlfWgE` | 2026-03-01 21:45 -> 2026-03-01 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_a3PxIwOY` | 2026-03-01 21:50 -> 2026-03-01 22:10 | **Shower** (`life`)
- [ ] `evt_ZDAcUIYt` | 2026-03-01 22:30 -> 2026-03-01 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_4RkmGxPC` | 2026-03-01 22:35 -> 2026-03-01 22:55 | **Shower** (`life`)
- [ ] `evt_2h968dGW` | 2026-03-02 00:00 -> 2026-03-02 07:15 | **Sleep** (`life`)
- [ ] `evt_Jmm2jPqO` | 2026-03-02 07:15 -> 2026-03-02 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_ZB4fy12r` | 2026-03-02 07:25 -> 2026-03-02 07:35 | **Wake Up** (`life`)
- [ ] `evt_zuNMDQDT` | 2026-03-02 07:35 -> 2026-03-02 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_ix-hw1NC` | 2026-03-02 08:00 -> 2026-03-02 08:10 | **Wake Up** (`life`)
- [ ] `evt_5mm5tqkD` | 2026-03-02 08:10 -> 2026-03-02 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_25ojFu4G` | 2026-03-02 17:15 -> 2026-03-02 18:30 | **English: Seminar Final Prep** (`life`)
- [ ] `evt_LOIK2Ie9` | 2026-03-02 18:45 -> 2026-03-02 20:00 | **AP Physics Quiz 3 Prep** (`life`)
- [ ] `evt_TYB-T1Q1` | 2026-03-02 20:15 -> 2026-03-02 21:00 | **Workout** (`life`)
- [ ] `evt_9mkRzgHO` | 2026-03-02 21:00 -> 2026-03-02 21:30 | **Multi: Practice** (`life`)
- [ ] `evt_S37ckxBb` | 2026-03-02 21:35 -> 2026-03-02 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_hjPAhUss` | 2026-03-02 21:45 -> 2026-03-02 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_3hadHnUx` | 2026-03-02 21:50 -> 2026-03-02 22:10 | **Shower** (`life`)
- [ ] `evt_7QSWVd3w` | 2026-03-02 22:30 -> 2026-03-02 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_a7jbQ8tG` | 2026-03-02 22:35 -> 2026-03-02 22:55 | **Shower** (`life`)
- [ ] `evt_1diRq4vw` | 2026-03-03 00:00 -> 2026-03-03 07:15 | **Sleep** (`life`)
- [ ] `evt_96d9Rkwh` | 2026-03-03 (all day) | **⚡ Physics Quiz 3: Rotation & Newton's 2nd Law** (`life`)
- [ ] `evt_FacFALX7` | 2026-03-03 07:15 -> 2026-03-03 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_BVDTrLL2` | 2026-03-03 07:25 -> 2026-03-03 07:35 | **Wake Up** (`life`)
- [ ] `evt_SImvphu5` | 2026-03-03 07:35 -> 2026-03-03 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_qEgN-X86` | 2026-03-03 08:00 -> 2026-03-03 08:10 | **Wake Up** (`life`)
- [ ] `evt_EnOXZSLI` | 2026-03-03 08:10 -> 2026-03-03 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_nsVOKR_o` | 2026-03-03 17:15 -> 2026-03-03 18:30 | **Multi: Practice** (`life`)
- [ ] `evt_bB7eAVoC` | 2026-03-03 18:45 -> 2026-03-03 20:00 | **AP Chem Unit 8 Notes** (`life`)
- [ ] `evt_dgyM9xAj` | 2026-03-03 20:15 -> 2026-03-03 21:00 | **Workout** (`life`)
- [ ] `evt_jlpYNhNs` | 2026-03-03 21:00 -> 2026-03-03 21:30 | **Project/Startup** (`life`)
- [ ] `evt_HuX-Uy3_` | 2026-03-03 21:35 -> 2026-03-03 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_M7HUqTVN` | 2026-03-03 21:45 -> 2026-03-03 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_3lpEQqO3` | 2026-03-03 21:50 -> 2026-03-03 22:10 | **Shower** (`life`)
- [ ] `evt_sQbG_9Nn` | 2026-03-03 22:30 -> 2026-03-03 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_rr0ZACTK` | 2026-03-03 22:35 -> 2026-03-03 22:55 | **Shower** (`life`)
- [ ] `evt_xN0gV0OT` | 2026-03-04 00:00 -> 2026-03-04 07:15 | **Sleep** (`life`)
- [ ] `evt_X4Gf_DgV` | 2026-03-04 (all day) | **📐 Multi: Choice Board DUE** (`life`)
- [ ] `evt_jILc-XUJ` | 2026-03-04 07:15 -> 2026-03-04 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_XvB7Aov0` | 2026-03-04 07:25 -> 2026-03-04 07:35 | **Wake Up** (`life`)
- [ ] `evt_bRvYc6xP` | 2026-03-04 07:35 -> 2026-03-04 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_vvL8EF9I` | 2026-03-04 08:00 -> 2026-03-04 08:10 | **Wake Up** (`life`)
- [ ] `evt_EgZmFFmK` | 2026-03-04 08:10 -> 2026-03-04 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_59ohJR4c` | 2026-03-04 17:15 -> 2026-03-04 18:30 | **Multi: Practice** (`life`)
- [ ] `evt_CE9IpVwm` | 2026-03-04 18:45 -> 2026-03-04 20:00 | **AP Physics: Rotation Review** (`life`)
- [ ] `evt_MEDpr16l` | 2026-03-04 20:15 -> 2026-03-04 21:00 | **Workout** (`life`)
- [ ] `evt_ypZs1MUS` | 2026-03-04 21:00 -> 2026-03-04 21:30 | **Admin/Planning** (`life`)
- [ ] `evt_YIxmFHL4` | 2026-03-04 21:35 -> 2026-03-04 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_rk4EMkSk` | 2026-03-04 21:45 -> 2026-03-04 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_OG0AUeK8` | 2026-03-04 21:50 -> 2026-03-04 22:10 | **Shower** (`life`)
- [ ] `evt_hr7qx-e1` | 2026-03-04 22:30 -> 2026-03-04 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_0AHfrFOg` | 2026-03-04 22:35 -> 2026-03-04 22:55 | **Shower** (`life`)
- [ ] `evt_EzSUYbPl` | 2026-03-05 00:00 -> 2026-03-05 07:15 | **Sleep** (`life`)
- [ ] `evt_Kdz-HV4e` | 2026-03-05 07:15 -> 2026-03-05 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_Zett3qXT` | 2026-03-05 07:25 -> 2026-03-05 07:35 | **Wake Up** (`life`)
- [ ] `evt_CPHNK5JU` | 2026-03-05 07:35 -> 2026-03-05 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_V3rHyrUa` | 2026-03-05 08:00 -> 2026-03-05 08:10 | **Wake Up** (`life`)
- [ ] `evt_gVHE8ACW` | 2026-03-05 08:10 -> 2026-03-05 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_yNNxqg_o` | 2026-03-05 17:15 -> 2026-03-05 18:30 | **AP Chem Unit 8 Notes** (`life`)
- [ ] `evt_6gq_kpOW` | 2026-03-05 18:45 -> 2026-03-05 20:00 | **AP Gov Review** (`life`)
- [ ] `evt_As_WCG3F` | 2026-03-05 20:15 -> 2026-03-05 21:00 | **Workout** (`life`)
- [ ] `evt_J5kamlpF` | 2026-03-05 21:00 -> 2026-03-05 21:30 | **Project/Startup** (`life`)
- [ ] `evt_0f6ZT6FM` | 2026-03-05 21:35 -> 2026-03-05 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_GpeWnBoo` | 2026-03-05 21:45 -> 2026-03-05 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_EZ-A9DKO` | 2026-03-05 21:50 -> 2026-03-05 22:10 | **Shower** (`life`)
- [ ] `evt_SfEDgsml` | 2026-03-05 22:30 -> 2026-03-05 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_QUf-RKMF` | 2026-03-05 22:35 -> 2026-03-05 22:55 | **Shower** (`life`)
- [ ] `evt_fYyfKNod` | 2026-03-06 00:00 -> 2026-03-06 07:15 | **Sleep** (`life`)
- [ ] `evt_7rBNatlM` | 2026-03-06 07:15 -> 2026-03-06 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_zyG8DG5D` | 2026-03-06 07:25 -> 2026-03-06 07:35 | **Wake Up** (`life`)
- [ ] `evt_9nGbRxbJ` | 2026-03-06 07:35 -> 2026-03-06 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_fV5TH056` | 2026-03-06 08:00 -> 2026-03-06 08:10 | **Wake Up** (`life`)
- [ ] `evt_uOWNP-C_` | 2026-03-06 08:10 -> 2026-03-06 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_0-A29RfD` | 2026-03-06 17:15 -> 2026-03-06 18:30 | **AP Physics: Practice Set** (`life`)
- [ ] `evt_habraWb0` | 2026-03-06 18:45 -> 2026-03-06 20:00 | **English/Guitar Prep** (`life`)
- [ ] `evt_Wd_FY6sz` | 2026-03-06 20:15 -> 2026-03-06 21:00 | **Workout** (`life`)
- [ ] `evt_V2Gys6So` | 2026-03-06 21:00 -> 2026-03-06 21:30 | **Rest/Reset** (`life`)
- [ ] `evt_QcZLMs7P` | 2026-03-06 21:35 -> 2026-03-06 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_q8kuipRo` | 2026-03-06 21:45 -> 2026-03-06 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_YsoXuuS5` | 2026-03-06 21:50 -> 2026-03-06 22:10 | **Shower** (`life`)
- [ ] `evt_iW2y7H0i` | 2026-03-06 22:30 -> 2026-03-06 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_W4hmCKpy` | 2026-03-06 22:35 -> 2026-03-06 22:55 | **Shower** (`life`)
- [ ] `evt_8s6se_CB` | 2026-03-07 00:00 -> 2026-03-07 07:15 | **Sleep** (`life`)
- [ ] `evt_hQqr8-kP` | 2026-03-07 07:15 -> 2026-03-07 07:25 | **Morning Check-in** (`life`)
- [ ] `evt_K1ecYyRG` | 2026-03-07 07:25 -> 2026-03-07 07:35 | **Wake Up** (`life`)
- [ ] `evt_rrXQOGoV` | 2026-03-07 07:35 -> 2026-03-07 07:40 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_j5HSJc6R` | 2026-03-07 08:00 -> 2026-03-07 08:10 | **Wake Up** (`life`)
- [ ] `evt_Vhunoydb` | 2026-03-07 08:10 -> 2026-03-07 08:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_tM33vD-c` | 2026-03-07 10:00 -> 2026-03-07 12:00 | **Multi: Practice** (`life`)
- [ ] `evt_1_ViZa7B` | 2026-03-07 13:00 -> 2026-03-07 15:00 | **RSEF Prep** (`life`)
- [ ] `evt_qGdkxyVs` | 2026-03-07 15:30 -> 2026-03-07 16:15 | **Workout** (`life`)
- [ ] `evt_Zdm4LubZ` | 2026-03-07 16:30 -> 2026-03-07 18:00 | **Guitar Prep** (`life`)
- [ ] `evt_tmh67udB` | 2026-03-07 19:00 -> 2026-03-07 20:00 | **Project/Startup** (`life`)
- [ ] `evt_oYl6FLXW` | 2026-03-07 21:35 -> 2026-03-07 21:45 | **Evening Check-in** (`life`)
- [ ] `evt_TktQEnWH` | 2026-03-07 21:45 -> 2026-03-07 21:50 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_nls05wza` | 2026-03-07 21:50 -> 2026-03-07 22:10 | **Shower** (`life`)
- [ ] `evt_2zYsh0r_` | 2026-03-07 22:30 -> 2026-03-07 22:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_e0TBQYsv` | 2026-03-07 22:35 -> 2026-03-07 22:55 | **Shower** (`life`)
- [ ] `evt_1wsC9ceJ` | 2026-03-08 09:00 -> 2026-03-08 09:10 | **Wake Up** (`life`)
- [ ] `evt_gjYHwRiC` | 2026-03-08 09:10 -> 2026-03-08 09:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_u1B1upZk` | 2026-03-08 23:30 -> 2026-03-08 23:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_DcQG4VAk` | 2026-03-08 23:35 -> 2026-03-08 23:55 | **Shower** (`life`)
- [ ] `evt_xAn8voyu` | 2026-03-09 09:00 -> 2026-03-09 09:10 | **Wake Up** (`life`)
- [ ] `evt_1lrOh5oC` | 2026-03-09 09:10 -> 2026-03-09 09:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_lpi_PHQF` | 2026-03-09 23:30 -> 2026-03-09 23:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_Wb_h_1Lw` | 2026-03-09 23:35 -> 2026-03-09 23:55 | **Shower** (`life`)
- [ ] `evt_epEl9a9x` | 2026-03-10 (all day) | **📐 Multi TEST: Unit 15b** (`life`)
- [ ] `evt_MhxJBWJt` | 2026-03-10 09:00 -> 2026-03-10 09:10 | **Wake Up** (`life`)
- [ ] `evt_cLbGgZ7Q` | 2026-03-10 09:10 -> 2026-03-10 09:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_MMDlxpzd` | 2026-03-10 23:30 -> 2026-03-10 23:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_-2aNaJr9` | 2026-03-10 23:35 -> 2026-03-10 23:55 | **Shower** (`life`)
- [ ] `evt_3hQgPI8u` | 2026-03-11 09:00 -> 2026-03-11 09:10 | **Wake Up** (`life`)
- [ ] `evt_pMVdxXtH` | 2026-03-11 09:10 -> 2026-03-11 09:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_ab9u0nMw` | 2026-03-11 23:30 -> 2026-03-11 23:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_nfiLx6Zg` | 2026-03-11 23:35 -> 2026-03-11 23:55 | **Shower** (`life`)
- [ ] `evt_xSzR3K0y` | 2026-03-12 09:00 -> 2026-03-12 09:10 | **Wake Up** (`life`)
- [ ] `evt_TTx3xoe-` | 2026-03-12 09:10 -> 2026-03-12 09:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_I8k9R8lJ` | 2026-03-12 23:30 -> 2026-03-12 23:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_WIyD0zyv` | 2026-03-12 23:35 -> 2026-03-12 23:55 | **Shower** (`life`)
- [ ] `evt_e5syc80l` | 2026-03-13 09:00 -> 2026-03-13 09:10 | **Wake Up** (`life`)
- [ ] `evt_OcRy7SqD` | 2026-03-13 09:10 -> 2026-03-13 09:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_fQkx6QuM` | 2026-03-13 23:30 -> 2026-03-13 23:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_Yzi6NnI-` | 2026-03-13 23:35 -> 2026-03-13 23:55 | **Shower** (`life`)
- [ ] `evt_g4NaCdg_` | 2026-03-14 09:00 -> 2026-03-14 09:10 | **Wake Up** (`life`)
- [ ] `evt_8hZ4M6SH` | 2026-03-14 09:10 -> 2026-03-14 09:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_p4eQR8C0` | 2026-03-14 23:30 -> 2026-03-14 23:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_chClbllr` | 2026-03-14 23:35 -> 2026-03-14 23:55 | **Shower** (`life`)
- [ ] `evt_26Z1bpD9` | 2026-03-15 09:00 -> 2026-03-15 09:10 | **Wake Up** (`life`)
- [ ] `evt_w9I2n3Em` | 2026-03-15 09:10 -> 2026-03-15 09:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_MuWNVnFy` | 2026-03-15 23:30 -> 2026-03-15 23:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_mcLLk_Yf` | 2026-03-15 23:35 -> 2026-03-15 23:55 | **Shower** (`life`)
- [ ] `evt_JpR7KGkv` | 2026-03-16 09:00 -> 2026-03-16 09:10 | **Wake Up** (`life`)
- [ ] `evt_A9P-y8ks` | 2026-03-16 09:10 -> 2026-03-16 09:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_oNQ1DL9F` | 2026-03-16 23:30 -> 2026-03-16 23:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_92cWe8s-` | 2026-03-16 23:35 -> 2026-03-16 23:55 | **Shower** (`life`)
- [ ] `evt_emkE-Tn_` | 2026-03-17 (all day) | **⚡ Physics Unit 5 TEST: Rotational Dynamics & Energy** (`life`)
- [ ] `evt_YLjGuII_` | 2026-03-17 09:00 -> 2026-03-17 09:10 | **Wake Up** (`life`)
- [ ] `evt_PR_1o8t-` | 2026-03-17 09:10 -> 2026-03-17 09:15 | **Brush Teeth (AM)** (`life`)
- [ ] `evt_ao1Q623V` | 2026-03-17 23:30 -> 2026-03-17 23:35 | **Brush Teeth (PM)** (`life`)
- [ ] `evt_WKhZCE2C` | 2026-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_JF9yobsJ` | 2027-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_dEbcNfwq` | 2028-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_1NCSTrjn` | 2029-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_4a6iti8M` | 2030-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_0XlQFCFq` | 2031-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_I-YQ4_Kc` | 2032-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_b_hj08W_` | 2033-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_-xybAb58` | 2034-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_Sk8Owmr-` | 2035-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_PcUlXG5e` | 2036-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_-Vbpch-5` | 2037-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_JO80v0tu` | 2038-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_DyB97eAT` | 2039-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_xqiLDBe1` | 2040-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_Mf3UX97l` | 2041-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_yq7jh6IF` | 2042-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_AoiWqi_O` | 2043-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_jqaObjns` | 2044-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_mSfajeXR` | 2045-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_AJloG-cm` | 2046-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_wC4WitUB` | 2047-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_1Rg-Fjhm` | 2048-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_5DI0b-kq` | 2049-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_cAmx4KVj` | 2050-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_KNKmrJeH` | 2051-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_X792V53T` | 2052-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_RvqFgvjE` | 2053-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_pr8y3RbN` | 2054-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_hD5oXGtw` | 2055-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_vYxwV_6z` | 2056-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_DLFzygXo` | 2057-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_66xYGC7h` | 2058-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_iC7UYU_l` | 2059-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_EfyaYitS` | 2060-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_QT3uH6T1` | 2061-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_iLvPWd0-` | 2062-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_AU2ZogTr` | 2063-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_irba550U` | 2064-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_Y_ba9jil` | 2065-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_hdkN0sWV` | 2066-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_Ya7PnOHp` | 2067-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_RJEVwfyS` | 2068-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_CQ9qmnkO` | 2069-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_yVchHCxJ` | 2070-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_wPECshK2` | 2071-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_DuhIE_zM` | 2072-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_YyelP-Wk` | 2073-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_6YaegfSF` | 2074-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_2hPjN05T` | 2075-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_bCPY3mPs` | 2076-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_T94Do-Rd` | 2077-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_w3R46S2M` | 2078-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_uIv86aFP` | 2079-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_6XXBLzo0` | 2080-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt__MKyCZHB` | 2081-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_CP8JFByj` | 2082-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_cqktYTjO` | 2083-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_2TLXwLSR` | 2084-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_oMzkEYnx` | 2085-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_Tr0wf3-t` | 2086-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_6RqkshtO` | 2087-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_voaIUz6D` | 2088-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_-C_8GpgD` | 2089-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_4oFpghg-` | 2090-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_GlRXRSp1` | 2091-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_zzm2x_ae` | 2092-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_1idPCFQB` | 2093-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_gNpgiS6R` | 2094-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_e3Ik87AI` | 2095-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_zEBsi4YK` | 2096-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_frMxityD` | 2097-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_5DimjUzG` | 2098-11-29 (all day) | **Happy birthday!** (`life`)
- [ ] `evt_RsgGrvNF` | 2099-11-29 (all day) | **Happy birthday!** (`life`)

## Event Records

### evt_Rxo-fKEa - Happy birthday!

```event
id: evt_Rxo-fKEa
externalId: gcal_9hf8792t3es62712nd27edp7js_20001129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2000-11-29T00:00:00.000Z
end: 2000-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20001129
```

### evt_qInyoKcn - Happy birthday!

```event
id: evt_qInyoKcn
externalId: gcal_9hf8792t3es62712nd27edp7js_20011129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2001-11-29T00:00:00.000Z
end: 2001-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20011129
```

### evt_GfCWHXe9 - Happy birthday!

```event
id: evt_GfCWHXe9
externalId: gcal_9hf8792t3es62712nd27edp7js_20021129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2002-11-29T00:00:00.000Z
end: 2002-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20021129
```

### evt_DtxKMOCt - Happy birthday!

```event
id: evt_DtxKMOCt
externalId: gcal_9hf8792t3es62712nd27edp7js_20031129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2003-11-29T00:00:00.000Z
end: 2003-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20031129
```

### evt_M5P18GSx - Happy birthday!

```event
id: evt_M5P18GSx
externalId: gcal_9hf8792t3es62712nd27edp7js_20041129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2004-11-29T00:00:00.000Z
end: 2004-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20041129
```

### evt_wUSh-eqU - Happy birthday!

```event
id: evt_wUSh-eqU
externalId: gcal_9hf8792t3es62712nd27edp7js_20051129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2005-11-29T00:00:00.000Z
end: 2005-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20051129
```

### evt_QHOhhaj2 - Happy birthday!

```event
id: evt_QHOhhaj2
externalId: gcal_9hf8792t3es62712nd27edp7js_20061129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2006-11-29T00:00:00.000Z
end: 2006-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20061129
```

### evt_MO5JlLts - Happy birthday!

```event
id: evt_MO5JlLts
externalId: gcal_9hf8792t3es62712nd27edp7js_20071129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2007-11-29T00:00:00.000Z
end: 2007-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20071129
```

### evt_5CmHWkLR - Happy birthday!

```event
id: evt_5CmHWkLR
externalId: gcal_9hf8792t3es62712nd27edp7js_20081129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2008-11-29T00:00:00.000Z
end: 2008-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20081129
```

### evt_JdnC1dLI - Happy birthday!

```event
id: evt_JdnC1dLI
externalId: gcal_9hf8792t3es62712nd27edp7js_20091129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2009-11-29T00:00:00.000Z
end: 2009-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20091129
```

### evt_Kw_Y8J2y - Happy birthday!

```event
id: evt_Kw_Y8J2y
externalId: gcal_9hf8792t3es62712nd27edp7js_20101129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2010-11-29T00:00:00.000Z
end: 2010-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20101129
```

### evt_iWIWasJp - Happy birthday!

```event
id: evt_iWIWasJp
externalId: gcal_9hf8792t3es62712nd27edp7js_20111129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2011-11-29T00:00:00.000Z
end: 2011-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20111129
```

### evt_MF-k8kVG - Happy birthday!

```event
id: evt_MF-k8kVG
externalId: gcal_9hf8792t3es62712nd27edp7js_20121129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2012-11-29T00:00:00.000Z
end: 2012-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20121129
```

### evt_skkC8Qm1 - Happy birthday!

```event
id: evt_skkC8Qm1
externalId: gcal_9hf8792t3es62712nd27edp7js_20131129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2013-11-29T00:00:00.000Z
end: 2013-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20131129
```

### evt_YWTbdSRR - Happy birthday!

```event
id: evt_YWTbdSRR
externalId: gcal_9hf8792t3es62712nd27edp7js_20141129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2014-11-29T00:00:00.000Z
end: 2014-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20141129
```

### evt_1UY1fO87 - Happy birthday!

```event
id: evt_1UY1fO87
externalId: gcal_9hf8792t3es62712nd27edp7js_20151129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2015-11-29T00:00:00.000Z
end: 2015-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20151129
```

### evt_mP8otqLV - Happy birthday!

```event
id: evt_mP8otqLV
externalId: gcal_9hf8792t3es62712nd27edp7js_20161129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2016-11-29T00:00:00.000Z
end: 2016-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20161129
```

### evt_3NXJHa-v - Happy birthday!

```event
id: evt_3NXJHa-v
externalId: gcal_9hf8792t3es62712nd27edp7js_20171129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2017-11-29T00:00:00.000Z
end: 2017-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20171129
```

### evt_lnSQn_y7 - Happy birthday!

```event
id: evt_lnSQn_y7
externalId: gcal_9hf8792t3es62712nd27edp7js_20181129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2018-11-29T00:00:00.000Z
end: 2018-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20181129
```

### evt_egFvKfDQ - Happy birthday!

```event
id: evt_egFvKfDQ
externalId: gcal_9hf8792t3es62712nd27edp7js_20191129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2019-11-29T00:00:00.000Z
end: 2019-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20191129
```

### evt_qm_bXd9D - Happy birthday!

```event
id: evt_qm_bXd9D
externalId: gcal_9hf8792t3es62712nd27edp7js_20201129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2020-11-29T00:00:00.000Z
end: 2020-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20201129
```

### evt_fHxDDbNU - Happy birthday!

```event
id: evt_fHxDDbNU
externalId: gcal_9hf8792t3es62712nd27edp7js_20211129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2021-11-29T00:00:00.000Z
end: 2021-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20211129
```

### evt_YGG-QzHe - Happy birthday!

```event
id: evt_YGG-QzHe
externalId: gcal_9hf8792t3es62712nd27edp7js_20221129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2022-11-29T00:00:00.000Z
end: 2022-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20221129
```

### evt_i7ivk46V - Happy birthday!

```event
id: evt_i7ivk46V
externalId: gcal_9hf8792t3es62712nd27edp7js_20231129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2023-11-29T00:00:00.000Z
end: 2023-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20231129
```

### evt_mgui4Jau - Happy birthday!

```event
id: evt_mgui4Jau
externalId: gcal_9hf8792t3es62712nd27edp7js_20241129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2024-11-29T00:00:00.000Z
end: 2024-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20241129
```

### evt_hSKyvo9Z - Happy birthday!

```event
id: evt_hSKyvo9Z
externalId: gcal_9hf8792t3es62712nd27edp7js_20251129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2025-11-29T00:00:00.000Z
end: 2025-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20251129
```

### evt_v1GClHgi - Purdue's for Me - College of Engineering

```event
id: evt_v1GClHgi
externalId: gcal_mkk4v5162s3k6tn4trvnrh402k
updatedAt: 2026-01-16T14:02:00.318Z
title: Purdue's for Me - College of Engineering
start: 2026-02-16T07:45:00-05:00
end: 2026-02-16T16:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: mkk4v5162s3k6tn4trvnrh402k
location: Stewart Center, West Foyer, 128 Memorial Mall, West Lafayette, IN,
  47907-2034, United States
notes: >-
  Edit Registration:
  https://apply.purdue.edu/register/?k=5f3c87ef-e2d1-4953-93eb-cd3951deb408

   Purdue's for Me is designed specifically for admitted students. You'll get to experience campus and all the amazing opportunities available to students. During this program, you will enjoy quality time with students, faculty, and staff in the academic program to which you are admitted. In addition, you'll learn more about your major, financial aid, housing, student life, and have the chance to get any questions answered that you may have about Purdue.
```

### evt_IcrkEyXB - AP CHEM: Unit 7 Test

```event
id: evt_IcrkEyXB
externalId: gcal_46jrd925842rrnnk16tprt56sc
updatedAt: 2026-02-02T21:01:45.730Z
title: "AP CHEM: Unit 7 Test"
start: 2026-02-18T00:00:00-05:00
end: 2026-02-18T01:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 46jrd925842rrnnk16tprt56sc
```

### evt_zxid6zB- - MATH QUIZ: 15.6-15.7 (Triple/Cylindrical)

```event
id: evt_zxid6zB-
externalId: gcal_pe3sqt9g31pvsjf2c38h00i6l0
updatedAt: 2026-02-03T19:44:34.868Z
title: "MATH QUIZ: 15.6-15.7 (Triple/Cylindrical)"
start: 2026-02-20T09:30:00-05:00
end: 2026-02-20T11:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: pe3sqt9g31pvsjf2c38h00i6l0
```

### evt_W1rkxhC1 - AP Chem Unit 7 Review

```event
id: evt_W1rkxhC1
externalId: gcal_7k8dbg1ncsqobg6ipu04r5glak
updatedAt: 2026-02-22T02:14:11.071Z
title: AP Chem Unit 7 Review
start: 2026-02-21T21:20:00-05:00
end: 2026-02-21T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 7k8dbg1ncsqobg6ipu04r5glak
```

### evt_u7S2rhly - AP Gov Party Platforms

```event
id: evt_u7S2rhly
externalId: gcal_1fr4vo5635kr1it152av09v424
updatedAt: 2026-02-22T02:14:12.012Z
title: AP Gov Party Platforms
start: 2026-02-21T22:10:00-05:00
end: 2026-02-21T22:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 1fr4vo5635kr1it152av09v424
```

### evt_E-VeMWOL - Sleep

```event
id: evt_E-VeMWOL
externalId: gcal_i3k7bop8opggmiehpnbfsof2bc
updatedAt: 2026-02-22T05:10:39.265Z
title: Sleep
start: 2026-02-22T01:00:00-05:00
end: 2026-02-22T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: i3k7bop8opggmiehpnbfsof2bc
```

### evt_cZbxPMTg - Morning Check-in

```event
id: evt_cZbxPMTg
externalId: gcal_bh4359a2pm0rv1lnlbis1khmlg
updatedAt: 2026-02-22T02:02:55.794Z
title: Morning Check-in
start: 2026-02-22T07:15:00-05:00
end: 2026-02-22T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: bh4359a2pm0rv1lnlbis1khmlg
```

### evt_maEGWnZ4 - Wake Up

```event
id: evt_maEGWnZ4
externalId: gcal_djqjdo5p7lh95r5q3hgppcvsnc
updatedAt: 2026-02-22T02:03:19.685Z
title: Wake Up
start: 2026-02-22T07:25:00-05:00
end: 2026-02-22T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: djqjdo5p7lh95r5q3hgppcvsnc
```

### evt_PeUeqmNP - Brush Teeth (AM)

```event
id: evt_PeUeqmNP
externalId: gcal_7llnd2s8uhav9q311dadreb90g
updatedAt: 2026-02-22T02:03:20.908Z
title: Brush Teeth (AM)
start: 2026-02-22T07:35:00-05:00
end: 2026-02-22T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 7llnd2s8uhav9q311dadreb90g
```

### evt_v40Xk1hm - Wake Up

```event
id: evt_v40Xk1hm
externalId: gcal_v94kfhj57od4ejjstkt8nj8ujo
updatedAt: 2026-02-22T01:59:53.763Z
title: Wake Up
start: 2026-02-22T08:00:00-05:00
end: 2026-02-22T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: v94kfhj57od4ejjstkt8nj8ujo
```

### evt_DOpql9nH - Brush Teeth (AM)

```event
id: evt_DOpql9nH
externalId: gcal_skg0u6rei7jfjtf4o4l3vr3c3o
updatedAt: 2026-02-22T01:59:54.931Z
title: Brush Teeth (AM)
start: 2026-02-22T08:10:00-05:00
end: 2026-02-22T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: skg0u6rei7jfjtf4o4l3vr3c3o
```

### evt_2MRR7a7C - Test Event

```event
id: evt_2MRR7a7C
externalId: ext_6B7DyafYxARR
updatedAt: 2026-02-26T01:38:54.592Z
title: Test Event
start: 2026-02-22T10:00:00Z
end: 2026-02-22T11:00:00Z
allDay: false
category: life
completed: false
```

### evt_x16JWhZB - AP Chem Unit 7 Review

```event
id: evt_x16JWhZB
externalId: gcal_slielhj7s59ovuf69ir9ptui8g
updatedAt: 2026-02-22T17:12:05.120Z
title: AP Chem Unit 7 Review
start: 2026-02-22T13:30:00-05:00
end: 2026-02-22T15:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: slielhj7s59ovuf69ir9ptui8g
```

### evt_Dh4w8eco - AP Physics (Torque/Rotational) - Concept Work

```event
id: evt_Dh4w8eco
externalId: gcal_96644lh441kc0b90vii88c0f3c
updatedAt: 2026-02-22T17:12:02.659Z
title: AP Physics (Torque/Rotational) - Concept Work
start: 2026-02-22T15:30:00-05:00
end: 2026-02-22T17:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 96644lh441kc0b90vii88c0f3c
```

### evt_SLRutOzI - AP Chem Unit 7 Review

```event
id: evt_SLRutOzI
externalId: gcal_9m7957dseqqeuejh7pui305v5k
updatedAt: 2026-02-22T22:32:05.226Z
title: AP Chem Unit 7 Review
start: 2026-02-22T17:30:00-05:00
end: 2026-02-22T19:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9m7957dseqqeuejh7pui305v5k
```

### evt_Icd7jBEI - AP Chem Unit 7 Practice Problems

```event
id: evt_Icd7jBEI
externalId: gcal_6ct12bpmkdvi5oku68qmto97ak
updatedAt: 2026-02-22T22:32:09.368Z
title: AP Chem Unit 7 Practice Problems
start: 2026-02-22T19:00:00-05:00
end: 2026-02-22T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 6ct12bpmkdvi5oku68qmto97ak
```

### evt_3ZuWYLoF - Workout

```event
id: evt_3ZuWYLoF
externalId: gcal_vkjmvocmfkaq17tas88pfrvegc
updatedAt: 2026-02-22T17:11:58.623Z
title: Workout
start: 2026-02-22T20:00:00-05:00
end: 2026-02-22T20:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: vkjmvocmfkaq17tas88pfrvegc
```

### evt_7505sH7R - Evening Check-in

```event
id: evt_7505sH7R
externalId: gcal_kirhttpn0555hpee8d17ufmvog
updatedAt: 2026-02-22T01:16:17.469Z
title: Evening Check-in
start: 2026-02-22T21:35:00-05:00
end: 2026-02-22T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: kirhttpn0555hpee8d17ufmvog
```

### evt_Vueyn4eh - Brush Teeth (PM)

```event
id: evt_Vueyn4eh
externalId: gcal_n01m0op167tredgrr2kqs5evqo
updatedAt: 2026-02-22T02:03:22.036Z
title: Brush Teeth (PM)
start: 2026-02-22T21:45:00-05:00
end: 2026-02-22T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: n01m0op167tredgrr2kqs5evqo
```

### evt_JxpfB-GR - Shower

```event
id: evt_JxpfB-GR
externalId: gcal_2hrbkp2k6l1bdcam0akfnkspd4
updatedAt: 2026-02-22T02:03:23.070Z
title: Shower
start: 2026-02-22T21:50:00-05:00
end: 2026-02-22T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 2hrbkp2k6l1bdcam0akfnkspd4
```

### evt_u621tiSY - Brush Teeth (PM)

```event
id: evt_u621tiSY
externalId: gcal_rb79d49rphrolk5bf1n0cqiab0
updatedAt: 2026-02-22T01:59:56.151Z
title: Brush Teeth (PM)
start: 2026-02-22T22:30:00-05:00
end: 2026-02-22T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: rb79d49rphrolk5bf1n0cqiab0
```

### evt_rjxDo2j8 - Shower

```event
id: evt_rjxDo2j8
externalId: gcal_0488t5fg3uo5a8u0f90iq1b2h4
updatedAt: 2026-02-22T01:59:57.311Z
title: Shower
start: 2026-02-22T22:35:00-05:00
end: 2026-02-22T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 0488t5fg3uo5a8u0f90iq1b2h4
```

### evt_I2ChL5nD - Sleep

```event
id: evt_I2ChL5nD
externalId: gcal_s0sulff4f8ejd6gggrgmifj53c
updatedAt: 2026-02-22T02:03:24.107Z
title: Sleep
start: 2026-02-23T00:00:00-05:00
end: 2026-02-23T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: s0sulff4f8ejd6gggrgmifj53c
```

### evt__FiTIp3l - Morning Check-in

```event
id: evt__FiTIp3l
externalId: gcal_7l51tt5g1gvhu06ksfoa325ke0
updatedAt: 2026-02-22T02:02:56.707Z
title: Morning Check-in
start: 2026-02-23T07:15:00-05:00
end: 2026-02-23T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 7l51tt5g1gvhu06ksfoa325ke0
```

### evt_S1u_DpyC - Wake Up (Snow Day)

```event
id: evt_S1u_DpyC
externalId: gcal_i78rbpv8c40qni60o6e6ld5k10
updatedAt: 2026-02-23T03:07:25.457Z
title: Wake Up (Snow Day)
start: 2026-02-23T08:30:00-05:00
end: 2026-02-23T08:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: i78rbpv8c40qni60o6e6ld5k10
```

### evt_NzLC0yo7 - Brush Teeth (AM)

```event
id: evt_NzLC0yo7
externalId: gcal_cbc9m8fqm0ksmr84co40i8kgt0
updatedAt: 2026-02-23T03:07:26.464Z
title: Brush Teeth (AM)
start: 2026-02-23T08:40:00-05:00
end: 2026-02-23T08:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: cbc9m8fqm0ksmr84co40i8kgt0
```

### evt_QXzP-Sf- - 🧪 AP Chem: One Pager + Unit Lab (MISSED)

```event
id: evt_QXzP-Sf-
externalId: gcal_hfk0p5m2395daq5c9gm5m94g64
updatedAt: 2026-02-23T17:17:20.416Z
title: "🧪 AP Chem: One Pager + Unit Lab (MISSED)"
start: 2026-02-23T09:00:00-05:00
end: 2026-02-23T11:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: hfk0p5m2395daq5c9gm5m94g64
```

### evt_LCWwlGHs - 🧪 AP Chem: Unit 7 Review

```event
id: evt_LCWwlGHs
externalId: gcal_b567hrv8ulfq55ukp34b4i3hfk
updatedAt: 2026-02-23T03:08:27.108Z
title: "🧪 AP Chem: Unit 7 Review"
start: 2026-02-23T11:00:00-05:00
end: 2026-02-23T13:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: b567hrv8ulfq55ukp34b4i3hfk
```

### evt_bXh-9CNW - Lunch

```event
id: evt_bXh-9CNW
externalId: gcal_9rlihfkhq0jdhiit46a3e6vf8s
updatedAt: 2026-02-23T03:08:27.861Z
title: Lunch
start: 2026-02-23T13:00:00-05:00
end: 2026-02-23T13:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9rlihfkhq0jdhiit46a3e6vf8s
```

### evt_6eu8fG-7 - ⚡ AP Physics: Lab Writeup (Whirlygig)

```event
id: evt_6eu8fG-7
externalId: gcal_j43k2rbe2hh32kmnmfkhd894b4
updatedAt: 2026-02-23T03:08:28.547Z
title: "⚡ AP Physics: Lab Writeup (Whirlygig)"
start: 2026-02-23T13:30:00-05:00
end: 2026-02-23T14:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: j43k2rbe2hh32kmnmfkhd894b4
```

### evt_hnoQtWdw - 🧪 AP Chem: Unit 7 Deep Review

```event
id: evt_hnoQtWdw
externalId: gcal_ik1ubmtumn51opc9h558175ht8
updatedAt: 2026-02-23T17:19:19.786Z
title: "🧪 AP Chem: Unit 7 Deep Review"
start: 2026-02-23T14:45:00-05:00
end: 2026-02-23T18:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: ik1ubmtumn51opc9h558175ht8
```

### evt__Yv1cohP - 🏗️ B2A Work Session @ Library [SKIPPED → Chem]

```event
id: evt__Yv1cohP
externalId: gcal_58h7i2jan9e2ian2n3r74633mc
updatedAt: 2026-02-23T17:19:19.059Z
title: 🏗️ B2A Work Session @ Library [SKIPPED → Chem]
start: 2026-02-23T15:00:00-05:00
end: 2026-02-23T18:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 58h7i2jan9e2ian2n3r74633mc
```

### evt_6HvgkiVO - 🎸 Guitar Concert

```event
id: evt_6HvgkiVO
externalId: gcal_bpgiafhj29ie8aobreag199c8k
updatedAt: 2026-02-23T17:17:17.437Z
title: 🎸 Guitar Concert
start: 2026-02-23T19:00:00-05:00
end: 2026-02-23T20:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: bpgiafhj29ie8aobreag199c8k
```

### evt_R6wKCAdf - Workout

```event
id: evt_R6wKCAdf
externalId: gcal_9g0ti472t3jlkm17fm4u3f80tg
updatedAt: 2026-02-23T17:17:18.448Z
title: Workout
start: 2026-02-23T20:45:00-05:00
end: 2026-02-23T21:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9g0ti472t3jlkm17fm4u3f80tg
```

### evt_pf46pI9W - 🧪 AP Chem: Final Review Pass

```event
id: evt_pf46pI9W
externalId: gcal_incppaut215io3riu0v0vhdh4o
updatedAt: 2026-02-23T17:17:19.559Z
title: "🧪 AP Chem: Final Review Pass"
start: 2026-02-23T21:30:00-05:00
end: 2026-02-23T22:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: incppaut215io3riu0v0vhdh4o
```

### evt_uekciqvB - Evening Check-in

```event
id: evt_uekciqvB
externalId: gcal_p8iuor858ans338uvq1uelt930
updatedAt: 2026-02-23T17:17:21.570Z
title: Evening Check-in
start: 2026-02-23T22:30:00-05:00
end: 2026-02-23T22:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: p8iuor858ans338uvq1uelt930
```

### evt_2BtiMDGw - Brush Teeth (PM) [DUP - IGNORE]

```event
id: evt_2BtiMDGw
externalId: gcal_htebhemk0fodvkioun675eela4
updatedAt: 2026-02-23T17:17:29.351Z
title: Brush Teeth (PM) [DUP - IGNORE]
start: 2026-02-23T22:30:00-05:00
end: 2026-02-23T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: htebhemk0fodvkioun675eela4
```

### evt_53LUgn-v - Shower

```event
id: evt_53LUgn-v
externalId: gcal_9887u5c18kjjjov9rfl3vm285g
updatedAt: 2026-02-22T02:00:02.173Z
title: Shower
start: 2026-02-23T22:35:00-05:00
end: 2026-02-23T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9887u5c18kjjjov9rfl3vm285g
```

### evt_APL7Yt3F - Brush Teeth (PM)

```event
id: evt_APL7Yt3F
externalId: gcal_dcrjd6u7mk7fno9sfd9a1v8ncc
updatedAt: 2026-02-23T17:17:22.635Z
title: Brush Teeth (PM)
start: 2026-02-23T22:40:00-05:00
end: 2026-02-23T22:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: dcrjd6u7mk7fno9sfd9a1v8ncc
```

### evt_Sf7iVABC - Shower

```event
id: evt_Sf7iVABC
externalId: gcal_bdjpkv0je7faqpanl4j8qmq598
updatedAt: 2026-02-23T17:17:23.762Z
title: Shower
start: 2026-02-23T22:45:00-05:00
end: 2026-02-23T23:05:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: bdjpkv0je7faqpanl4j8qmq598
```

### evt_sGflJXY_ - Sleep

```event
id: evt_sGflJXY_
externalId: gcal_hmgl654jolimpgon0so5d8iiss
updatedAt: 2026-02-22T02:03:29.709Z
title: Sleep
start: 2026-02-24T00:00:00-05:00
end: 2026-02-24T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: hmgl654jolimpgon0so5d8iiss
```

### evt_Adm14fA6 - Morning Check-in

```event
id: evt_Adm14fA6
externalId: gcal_3hbrrtkamrmjtvdl3g8ir8op90
updatedAt: 2026-02-22T02:02:57.924Z
title: Morning Check-in
start: 2026-02-24T07:15:00-05:00
end: 2026-02-24T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 3hbrrtkamrmjtvdl3g8ir8op90
```

### evt_Z2faobJ- - Wake Up

```event
id: evt_Z2faobJ-
externalId: gcal_fhad3cdkn0uh7rmt809lp5jlu0
updatedAt: 2026-02-22T02:03:30.999Z
title: Wake Up
start: 2026-02-24T07:25:00-05:00
end: 2026-02-24T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: fhad3cdkn0uh7rmt809lp5jlu0
```

### evt_s6usjtmX - Brush Teeth (AM)

```event
id: evt_s6usjtmX
externalId: gcal_dtiog17nnjbtjivnnh2enhlk1c
updatedAt: 2026-02-22T02:03:32.090Z
title: Brush Teeth (AM)
start: 2026-02-24T07:35:00-05:00
end: 2026-02-24T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: dtiog17nnjbtjivnnh2enhlk1c
```

### evt_KwkDvsH2 - Wake Up

```event
id: evt_KwkDvsH2
externalId: gcal_emhubmq2sd4ba2fsbqto6en81c
updatedAt: 2026-02-22T02:00:03.720Z
title: Wake Up
start: 2026-02-24T08:00:00-05:00
end: 2026-02-24T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: emhubmq2sd4ba2fsbqto6en81c
```

### evt__nVcqLHd - Brush Teeth (AM)

```event
id: evt__nVcqLHd
externalId: gcal_ni02577ee7pjscn5kqfrq3ptr0
updatedAt: 2026-02-22T02:00:04.819Z
title: Brush Teeth (AM)
start: 2026-02-24T08:10:00-05:00
end: 2026-02-24T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: ni02577ee7pjscn5kqfrq3ptr0
```

### evt_f4vEde8L - AP Physics Quiz 2 Prep

```event
id: evt_f4vEde8L
externalId: gcal_ftejj4tuug22mqlo5f4b1n2kt0
updatedAt: 2026-02-22T00:33:13.220Z
title: AP Physics Quiz 2 Prep
start: 2026-02-24T17:15:00-05:00
end: 2026-02-24T18:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: ftejj4tuug22mqlo5f4b1n2kt0
```

### evt_4nVdZGjE - Multi: Triple Integrals

```event
id: evt_4nVdZGjE
externalId: gcal_nomaskcibq9q0cqb1v7qka1jfk
updatedAt: 2026-02-22T00:33:14.012Z
title: "Multi: Triple Integrals"
start: 2026-02-24T19:00:00-05:00
end: 2026-02-24T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: nomaskcibq9q0cqb1v7qka1jfk
```

### evt_duM5ffdG - Workout

```event
id: evt_duM5ffdG
externalId: gcal_1taagteb0kkmrovolj5bc79kgg
updatedAt: 2026-02-22T00:33:14.763Z
title: Workout
start: 2026-02-24T20:15:00-05:00
end: 2026-02-24T21:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 1taagteb0kkmrovolj5bc79kgg
```

### evt_W2wygxJG - English: Truman Show Notes

```event
id: evt_W2wygxJG
externalId: gcal_pbjftm2vfh41628l1j61m9d5lc
updatedAt: 2026-02-22T00:33:15.531Z
title: "English: Truman Show Notes"
start: 2026-02-24T21:00:00-05:00
end: 2026-02-24T21:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: pbjftm2vfh41628l1j61m9d5lc
```

### evt_hq4dkRQl - 📐 Math HW: Redo Properly

```event
id: evt_hq4dkRQl
externalId: gcal_4t4hkd1a5kln8t5if8u7v0ttns
updatedAt: 2026-02-24T06:29:16.657Z
title: "📐 Math HW: Redo Properly"
start: 2026-02-24T21:30:00-05:00
end: 2026-02-24T22:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 4t4hkd1a5kln8t5if8u7v0ttns
```

### evt_gxHE7YMk - Evening Check-in

```event
id: evt_gxHE7YMk
externalId: gcal_16dcbrjocnk4egs1coun818rus
updatedAt: 2026-02-24T06:29:22.382Z
title: Evening Check-in
start: 2026-02-24T22:15:00-05:00
end: 2026-02-24T22:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 16dcbrjocnk4egs1coun818rus
```

### evt_684G8zGO - Brush Teeth (PM)

```event
id: evt_684G8zGO
externalId: gcal_e31sa91c1gfc71thsrhf1mc67o
updatedAt: 2026-02-24T06:29:23.331Z
title: Brush Teeth (PM)
start: 2026-02-24T22:25:00-05:00
end: 2026-02-24T22:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: e31sa91c1gfc71thsrhf1mc67o
```

### evt_cicGm6H5 - Brush Teeth (PM)

```event
id: evt_cicGm6H5
externalId: gcal_vk11ebmo6chklq8m3ugg3ut5co
updatedAt: 2026-02-22T02:00:06.045Z
title: Brush Teeth (PM)
start: 2026-02-24T22:30:00-05:00
end: 2026-02-24T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: vk11ebmo6chklq8m3ugg3ut5co
```

### evt_A2ecogk1 - Shower

```event
id: evt_A2ecogk1
externalId: gcal_o100vv7gi9lpakkh22ssr0nm14
updatedAt: 2026-02-24T06:29:24.284Z
title: Shower
start: 2026-02-24T22:30:00-05:00
end: 2026-02-24T22:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: o100vv7gi9lpakkh22ssr0nm14
```

### evt_x9jYZvZR - Shower

```event
id: evt_x9jYZvZR
externalId: gcal_p03t30rohjo1lqvd4tmf59hbp8
updatedAt: 2026-02-22T02:00:07.257Z
title: Shower
start: 2026-02-24T22:35:00-05:00
end: 2026-02-24T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: p03t30rohjo1lqvd4tmf59hbp8
```

### evt_HrXae22f - Sleep

```event
id: evt_HrXae22f
externalId: gcal_bqfn96n8p8sv5i3gm8nng1aeqc
updatedAt: 2026-02-22T02:03:35.346Z
title: Sleep
start: 2026-02-25T00:00:00-05:00
end: 2026-02-25T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: bqfn96n8p8sv5i3gm8nng1aeqc
```

### evt_dbJ6f01x - ⚡ Physics Quiz 2: Torque & Moment of Inertia

```event
id: evt_dbJ6f01x
externalId: gcal_erspk8061jmsfe488uden62p74
updatedAt: 2026-02-22T22:38:00.614Z
title: "⚡ Physics Quiz 2: Torque & Moment of Inertia"
start: 2026-02-25T00:00:00.000Z
end: 2026-02-25T01:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: erspk8061jmsfe488uden62p74
```

### evt__3yJ5LdY - Morning Check-in

```event
id: evt__3yJ5LdY
externalId: gcal_l0lfujig5h60sa09dcnu8gvivc
updatedAt: 2026-02-22T02:02:58.659Z
title: Morning Check-in
start: 2026-02-25T07:15:00-05:00
end: 2026-02-25T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: l0lfujig5h60sa09dcnu8gvivc
```

### evt_76fehQxZ - Wake Up

```event
id: evt_76fehQxZ
externalId: gcal_modjdpe1l0urrj6c56pqe1q0e4
updatedAt: 2026-02-22T02:03:36.415Z
title: Wake Up
start: 2026-02-25T07:25:00-05:00
end: 2026-02-25T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: modjdpe1l0urrj6c56pqe1q0e4
```

### evt_1n_WZ_-A - Brush Teeth (AM)

```event
id: evt_1n_WZ_-A
externalId: gcal_bpajie59k689d0o785bsggi8kc
updatedAt: 2026-02-22T02:03:37.442Z
title: Brush Teeth (AM)
start: 2026-02-25T07:35:00-05:00
end: 2026-02-25T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: bpajie59k689d0o785bsggi8kc
```

### evt_hjR-QiLC - Wake Up

```event
id: evt_hjR-QiLC
externalId: gcal_hp08oe5v1d2da7ps0nj1eobeeg
updatedAt: 2026-02-22T02:00:08.824Z
title: Wake Up
start: 2026-02-25T08:00:00-05:00
end: 2026-02-25T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: hp08oe5v1d2da7ps0nj1eobeeg
```

### evt_PMA_yfVG - Brush Teeth (AM)

```event
id: evt_PMA_yfVG
externalId: gcal_ob9992j4b2vneslg8old0eusl4
updatedAt: 2026-02-22T02:00:10.001Z
title: Brush Teeth (AM)
start: 2026-02-25T08:10:00-05:00
end: 2026-02-25T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: ob9992j4b2vneslg8old0eusl4
```

### evt_vDmneprY - Physics webassign + concept check

```event
id: evt_vDmneprY
externalId: md_evt_vDmneprY
updatedAt: 2026-02-26T01:29:14.789Z
title: Physics webassign + concept check
start: 2026-02-25T17:15:00-05:00
end: 2026-02-25T18:10:00-05:00
allDay: false
category: physics
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 26lhq70ge2m2nlm5jtre85l554
```

### evt_LoWzi3cZ - AP Physics Whirligig + Practice

```event
id: evt_LoWzi3cZ
externalId: gcal_lnaujcir1ud3ato4ds4c1ulpio
updatedAt: 2026-02-22T00:33:16.208Z
title: AP Physics Whirligig + Practice
start: 2026-02-25T17:15:00-05:00
end: 2026-02-25T18:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: lnaujcir1ud3ato4ds4c1ulpio
```

### evt_Z_1VeBj- - Pick up sister

```event
id: evt_Z_1VeBj-
externalId: md_evt_Z_1VeBj-
updatedAt: 2026-02-26T01:29:15.171Z
title: Pick up sister
start: 2026-02-25T18:10:00-05:00
end: 2026-02-25T18:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: jkcvs0su4rr5hnc8h2bbt6vvo0
```

### evt_i944_v_C - Physics webassign + concept check (finish)

```event
id: evt_i944_v_C
externalId: md_evt_i944_v_C
updatedAt: 2026-02-26T01:29:15.584Z
title: Physics webassign + concept check (finish)
start: 2026-02-25T18:25:00-05:00
end: 2026-02-25T19:30:00-05:00
allDay: false
category: physics
completed: false
googleEventIds:
  niravsurabhi@gmail.com: k24q4cgpfi7ftf7lnhfmfdiurg
```

### evt_UQxk4yBx - Multi: Triple Integrals

```event
id: evt_UQxk4yBx
externalId: gcal_3tl3nkqpafei5e10jv9nrcs9mk
updatedAt: 2026-02-22T00:33:16.938Z
title: "Multi: Triple Integrals"
start: 2026-02-25T18:45:00-05:00
end: 2026-02-25T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 3tl3nkqpafei5e10jv9nrcs9mk
```

### evt_8nuraLrq - Physics quiz prep (Torque & Rotational Inertia)

```event
id: evt_8nuraLrq
externalId: md_evt_8nuraLrq
updatedAt: 2026-02-26T01:29:16.039Z
title: Physics quiz prep (Torque & Rotational Inertia)
start: 2026-02-25T19:45:00-05:00
end: 2026-02-25T20:45:00-05:00
allDay: false
category: physics
completed: false
googleEventIds:
  niravsurabhi@gmail.com: tpd108ht5u9k25b5a71ofttr14
```

### evt__dhFen6H - Workout

```event
id: evt__dhFen6H
externalId: gcal_6baap102vddpl2ua9ol04lbvlk
updatedAt: 2026-02-22T00:33:17.671Z
title: Workout
start: 2026-02-25T20:15:00-05:00
end: 2026-02-25T21:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 6baap102vddpl2ua9ol04lbvlk
```

### evt_pbXZAVx5 - Math QZ 15.2 practice

```event
id: evt_pbXZAVx5
externalId: md_evt_pbXZAVx5
updatedAt: 2026-02-26T01:29:16.439Z
title: Math QZ 15.2 practice
start: 2026-02-25T20:45:00-05:00
end: 2026-02-25T22:00:00-05:00
allDay: false
category: math
completed: false
googleEventIds:
  niravsurabhi@gmail.com: oo4k2huif6oh9jqu9jmfnsmd2g
```

### evt_TLTZHNCd - English: Truman Show Prep

```event
id: evt_TLTZHNCd
externalId: gcal_r4ui1onou3bd0sbgh0ndnnduqg
updatedAt: 2026-02-22T00:33:18.346Z
title: "English: Truman Show Prep"
start: 2026-02-25T21:00:00-05:00
end: 2026-02-25T21:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: r4ui1onou3bd0sbgh0ndnnduqg
```

### evt_HWW5T0Wm - Evening Check-in

```event
id: evt_HWW5T0Wm
externalId: gcal_89ga59jdp3nucfnq7bphv5djj8
updatedAt: 2026-02-22T01:16:20.148Z
title: Evening Check-in
start: 2026-02-25T21:35:00-05:00
end: 2026-02-25T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 89ga59jdp3nucfnq7bphv5djj8
```

### evt_7M0frlg3 - Brush Teeth (PM)

```event
id: evt_7M0frlg3
externalId: gcal_2tr2c77umsldd5qbs6l9fv6lnc
updatedAt: 2026-02-22T02:03:38.721Z
title: Brush Teeth (PM)
start: 2026-02-25T21:45:00-05:00
end: 2026-02-25T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 2tr2c77umsldd5qbs6l9fv6lnc
```

### evt_jFk6jUGo - Shower

```event
id: evt_jFk6jUGo
externalId: gcal_n5jsrev7pgpf5pkkucitou82ro
updatedAt: 2026-02-22T02:03:39.789Z
title: Shower
start: 2026-02-25T21:50:00-05:00
end: 2026-02-25T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: n5jsrev7pgpf5pkkucitou82ro
```

### evt_pN0rDFdG - Chem missing work (during B2A call)

```event
id: evt_pN0rDFdG
externalId: md_evt_pN0rDFdG
updatedAt: 2026-02-26T01:29:16.809Z
title: Chem missing work (during B2A call)
start: 2026-02-25T22:15:00-05:00
end: 2026-02-25T23:15:00-05:00
allDay: false
category: chem
completed: false
googleEventIds:
  niravsurabhi@gmail.com: ebvv25e0c9ekdbvdrlsm3ao60k
```

### evt_8OlCIe8P - Brush Teeth (PM)

```event
id: evt_8OlCIe8P
externalId: gcal_1dl4vl14j37ra39gg7149cuolo
updatedAt: 2026-02-22T02:00:11.122Z
title: Brush Teeth (PM)
start: 2026-02-25T22:30:00-05:00
end: 2026-02-25T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 1dl4vl14j37ra39gg7149cuolo
```

### evt_3z1Ypmn- - Shower

```event
id: evt_3z1Ypmn-
externalId: gcal_fc5g97k4ta8jof8p1re9t02fbs
updatedAt: 2026-02-22T02:00:12.323Z
title: Shower
start: 2026-02-25T22:35:00-05:00
end: 2026-02-25T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: fc5g97k4ta8jof8p1re9t02fbs
```

### evt_aRj3m08n - Multi practice

```event
id: evt_aRj3m08n
externalId: md_evt_aRj3m08n
updatedAt: 2026-02-26T01:29:17.271Z
title: Multi practice
start: 2026-02-25T23:15:00-05:00
end: 2026-02-26T00:15:00-05:00
allDay: false
category: multi
completed: false
googleEventIds:
  niravsurabhi@gmail.com: csb78nvkklhq1quobn6o9k0tq0
```

### evt_SDKaSnxc - Sleep

```event
id: evt_SDKaSnxc
externalId: gcal_o5tc6u04lp89aq1a7skt515ld0
updatedAt: 2026-02-22T02:03:40.918Z
title: Sleep
start: 2026-02-26T00:00:00-05:00
end: 2026-02-26T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: o5tc6u04lp89aq1a7skt515ld0
```

### evt__4Y-AgFx - Morning Check-in

```event
id: evt__4Y-AgFx
externalId: gcal_4jqmkse197dklsp6u9o9323irk
updatedAt: 2026-02-22T02:02:59.449Z
title: Morning Check-in
start: 2026-02-26T07:15:00-05:00
end: 2026-02-26T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 4jqmkse197dklsp6u9o9323irk
```

### evt_BbdIBBog - Wake Up

```event
id: evt_BbdIBBog
externalId: gcal_g0oof1a0rvon95u4mugg0fn7rs
updatedAt: 2026-02-22T02:03:42.119Z
title: Wake Up
start: 2026-02-26T07:25:00-05:00
end: 2026-02-26T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: g0oof1a0rvon95u4mugg0fn7rs
```

### evt_Q7kFkECr - Brush Teeth (AM)

```event
id: evt_Q7kFkECr
externalId: gcal_krpp7g6q4dieusq3mar19so4s0
updatedAt: 2026-02-22T02:03:43.277Z
title: Brush Teeth (AM)
start: 2026-02-26T07:35:00-05:00
end: 2026-02-26T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: krpp7g6q4dieusq3mar19so4s0
```

### evt_D-BPsi5s - Wake Up

```event
id: evt_D-BPsi5s
externalId: gcal_peth89esggcfhq131frtgsrkkk
updatedAt: 2026-02-22T02:00:14.088Z
title: Wake Up
start: 2026-02-26T08:00:00-05:00
end: 2026-02-26T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: peth89esggcfhq131frtgsrkkk
```

### evt_6Fjhm5f0 - Brush Teeth (AM)

```event
id: evt_6Fjhm5f0
externalId: gcal_l2n15rrk5aqgj8gt09u1vvrf0c
updatedAt: 2026-02-22T02:00:15.269Z
title: Brush Teeth (AM)
start: 2026-02-26T08:10:00-05:00
end: 2026-02-26T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: l2n15rrk5aqgj8gt09u1vvrf0c
```

### evt_seed001 - Weekly planning

```event
id: evt_seed001
externalId: md_evt_seed001
updatedAt: 2026-02-26T01:29:17.622Z
title: Weekly planning
start: 2026-02-26T09:00:00.000Z
end: 2026-02-26T10:00:00.000Z
allDay: false
category: projects
completed: false
googleEventIds:
  niravsurabhi@gmail.com: q25cjoc2i5opq6uegq2tc4sij0
location: Home office
notes: Review priorities and blockers for the week
```

### evt_seed002 - Math study block

```event
id: evt_seed002
externalId: md_evt_seed002
updatedAt: 2026-02-26T01:29:18.008Z
title: Math study block
start: 2026-02-26T14:00:00.000Z
end: 2026-02-26T15:00:00.000Z
allDay: false
category: math
completed: false
googleEventIds:
  niravsurabhi@gmail.com: fu1hf5dsukrctp6rspfej6ul7g
location: Campus library
notes: Finish chapter exercises
```

### evt_GUUq2mxe - AP Chem Unit 8 Notes

```event
id: evt_GUUq2mxe
externalId: gcal_l9r3vjh476e5apieq414kpn1c0
updatedAt: 2026-02-22T00:33:19.611Z
title: AP Chem Unit 8 Notes
start: 2026-02-26T18:45:00-05:00
end: 2026-02-26T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: l9r3vjh476e5apieq414kpn1c0
```

### evt_EBYuqHiP - Workout

```event
id: evt_EBYuqHiP
externalId: gcal_n4tuqq8fhndkn4aqe0sudvvg18
updatedAt: 2026-02-22T00:33:20.282Z
title: Workout
start: 2026-02-26T20:15:00-05:00
end: 2026-02-26T21:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: n4tuqq8fhndkn4aqe0sudvvg18
```

### evt_GIrBExc2 - Project/Startup

```event
id: evt_GIrBExc2
externalId: gcal_5sen1b46fdtr0p0oc3ouubgjb4
updatedAt: 2026-02-22T00:33:20.962Z
title: Project/Startup
start: 2026-02-26T21:00:00-05:00
end: 2026-02-26T21:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 5sen1b46fdtr0p0oc3ouubgjb4
```

### evt_Qqu7VSNB - Evening Check-in

```event
id: evt_Qqu7VSNB
externalId: gcal_nn25u98vri56js51ainh3t54ok
updatedAt: 2026-02-22T01:16:21.073Z
title: Evening Check-in
start: 2026-02-26T21:35:00-05:00
end: 2026-02-26T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: nn25u98vri56js51ainh3t54ok
```

### evt_F9P3feQw - Brush Teeth (PM)

```event
id: evt_F9P3feQw
externalId: gcal_qgurukmh8gikbo5lagevpf7mtg
updatedAt: 2026-02-22T02:03:44.321Z
title: Brush Teeth (PM)
start: 2026-02-26T21:45:00-05:00
end: 2026-02-26T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: qgurukmh8gikbo5lagevpf7mtg
```

### evt_aYANx5Qa - Shower

```event
id: evt_aYANx5Qa
externalId: gcal_ravq150hbr21d16fv5plrhohuc
updatedAt: 2026-02-22T02:03:45.329Z
title: Shower
start: 2026-02-26T21:50:00-05:00
end: 2026-02-26T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: ravq150hbr21d16fv5plrhohuc
```

### evt_JeNJG-Km - Brush Teeth (PM)

```event
id: evt_JeNJG-Km
externalId: gcal_hogcgurbu0v9tac3knejhbgdjk
updatedAt: 2026-02-22T02:00:16.483Z
title: Brush Teeth (PM)
start: 2026-02-26T22:30:00-05:00
end: 2026-02-26T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: hogcgurbu0v9tac3knejhbgdjk
```

### evt_om-OTklC - Shower

```event
id: evt_om-OTklC
externalId: gcal_juv3d02021hrvcp2kvbqvqpmnc
updatedAt: 2026-02-22T02:00:17.754Z
title: Shower
start: 2026-02-26T22:35:00-05:00
end: 2026-02-26T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: juv3d02021hrvcp2kvbqvqpmnc
```

### evt_wOvI-ygU - Sleep

```event
id: evt_wOvI-ygU
externalId: gcal_t0ke41uifrvnjmvte75813ea1g
updatedAt: 2026-02-22T02:03:46.529Z
title: Sleep
start: 2026-02-27T00:00:00-05:00
end: 2026-02-27T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: t0ke41uifrvnjmvte75813ea1g
```

### evt_DYCOm_eo - 🧪 AP CHEM UNIT 7 TEST

```event
id: evt_DYCOm_eo
externalId: gcal_oon6uu83lhi43in3p1c1mh387c
updatedAt: 2026-02-24T21:49:26.009Z
title: 🧪 AP CHEM UNIT 7 TEST
start: 2026-02-27T00:00:00.000Z
end: 2026-02-27T01:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: oon6uu83lhi43in3p1c1mh387c
```

### evt_B1m7-J82 - Morning Check-in

```event
id: evt_B1m7-J82
externalId: gcal_64fbdac70f07cq84ubf3tb43k4
updatedAt: 2026-02-22T02:03:00.292Z
title: Morning Check-in
start: 2026-02-27T07:15:00-05:00
end: 2026-02-27T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 64fbdac70f07cq84ubf3tb43k4
```

### evt_qau6uwZb - Wake Up

```event
id: evt_qau6uwZb
externalId: gcal_e7s0babu04imhsm7mlgbsg68bk
updatedAt: 2026-02-22T02:03:47.643Z
title: Wake Up
start: 2026-02-27T07:25:00-05:00
end: 2026-02-27T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: e7s0babu04imhsm7mlgbsg68bk
```

### evt_0-X8Po4U - Brush Teeth (AM)

```event
id: evt_0-X8Po4U
externalId: gcal_28226vh3r2ftbmolvhndgo7jmc
updatedAt: 2026-02-22T02:03:48.748Z
title: Brush Teeth (AM)
start: 2026-02-27T07:35:00-05:00
end: 2026-02-27T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 28226vh3r2ftbmolvhndgo7jmc
```

### evt_3WYD7C88 - Wake Up

```event
id: evt_3WYD7C88
externalId: gcal_mvrnld0mr4fojjpim2mf461uq0
updatedAt: 2026-02-22T02:00:19.319Z
title: Wake Up
start: 2026-02-27T08:00:00-05:00
end: 2026-02-27T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: mvrnld0mr4fojjpim2mf461uq0
```

### evt_sLgsgs89 - Brush Teeth (AM)

```event
id: evt_sLgsgs89
externalId: gcal_7chbteafpqnpe8s1tfk03rob64
updatedAt: 2026-02-22T02:00:20.479Z
title: Brush Teeth (AM)
start: 2026-02-27T08:10:00-05:00
end: 2026-02-27T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 7chbteafpqnpe8s1tfk03rob64
```

### evt_YhXYTdkB - Multi: Triple Integrals

```event
id: evt_YhXYTdkB
externalId: gcal_o1c81302443j30o2vv84k0idao
updatedAt: 2026-02-22T00:33:21.652Z
title: "Multi: Triple Integrals"
start: 2026-02-27T17:15:00-05:00
end: 2026-02-27T18:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: o1c81302443j30o2vv84k0idao
```

### evt_uiOP_gxc - English: Truman Show Seminar Prep

```event
id: evt_uiOP_gxc
externalId: gcal_m3qemnl53cbsebbeuommvhedcc
updatedAt: 2026-02-22T00:33:22.414Z
title: "English: Truman Show Seminar Prep"
start: 2026-02-27T18:45:00-05:00
end: 2026-02-27T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: m3qemnl53cbsebbeuommvhedcc
```

### evt_keHWgl_4 - Workout

```event
id: evt_keHWgl_4
externalId: gcal_kjl64h521lhcgpit7f2jhj5rlc
updatedAt: 2026-02-22T00:33:23.127Z
title: Workout
start: 2026-02-27T20:15:00-05:00
end: 2026-02-27T21:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: kjl64h521lhcgpit7f2jhj5rlc
```

### evt_wXt7DgU2 - Project/Startup

```event
id: evt_wXt7DgU2
externalId: gcal_e3k31n9uu4vgruvkf8d5f1apto
updatedAt: 2026-02-22T00:33:23.823Z
title: Project/Startup
start: 2026-02-27T21:00:00-05:00
end: 2026-02-27T21:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: e3k31n9uu4vgruvkf8d5f1apto
```

### evt_MZDIfcHt - Evening Check-in

```event
id: evt_MZDIfcHt
externalId: gcal_0hf9ipnci0redl52ia0p70iomc
updatedAt: 2026-02-22T01:16:21.924Z
title: Evening Check-in
start: 2026-02-27T21:35:00-05:00
end: 2026-02-27T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 0hf9ipnci0redl52ia0p70iomc
```

### evt_JMdue046 - Brush Teeth (PM)

```event
id: evt_JMdue046
externalId: gcal_usnvor6t7fp4ahdv7gu0gtohn0
updatedAt: 2026-02-22T02:03:49.944Z
title: Brush Teeth (PM)
start: 2026-02-27T21:45:00-05:00
end: 2026-02-27T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: usnvor6t7fp4ahdv7gu0gtohn0
```

### evt_LLmtm6UM - Shower

```event
id: evt_LLmtm6UM
externalId: gcal_nuhts18vrta8pu6qh6rfdm9krc
updatedAt: 2026-02-22T02:03:51.089Z
title: Shower
start: 2026-02-27T21:50:00-05:00
end: 2026-02-27T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: nuhts18vrta8pu6qh6rfdm9krc
```

### evt_a0d-ItYo - Brush Teeth (PM)

```event
id: evt_a0d-ItYo
externalId: gcal_shpulkm61u0m979mthuf3ge724
updatedAt: 2026-02-22T02:00:21.573Z
title: Brush Teeth (PM)
start: 2026-02-27T22:30:00-05:00
end: 2026-02-27T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: shpulkm61u0m979mthuf3ge724
```

### evt_VEDdjsju - Shower

```event
id: evt_VEDdjsju
externalId: gcal_vlnccpmpp1tq7f0fdnbdh0hves
updatedAt: 2026-02-22T02:00:22.782Z
title: Shower
start: 2026-02-27T22:35:00-05:00
end: 2026-02-27T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: vlnccpmpp1tq7f0fdnbdh0hves
```

### evt_Mnsn700q - Sleep

```event
id: evt_Mnsn700q
externalId: gcal_cu8rkc45pk80eaes1nfq263g3s
updatedAt: 2026-02-22T02:03:52.033Z
title: Sleep
start: 2026-02-28T00:00:00-05:00
end: 2026-02-28T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: cu8rkc45pk80eaes1nfq263g3s
```

### evt_FnzCVPuV - Morning Check-in

```event
id: evt_FnzCVPuV
externalId: gcal_vtd3jnuvjelvq1ik7vamqma4pc
updatedAt: 2026-02-22T02:03:01.112Z
title: Morning Check-in
start: 2026-02-28T07:15:00-05:00
end: 2026-02-28T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: vtd3jnuvjelvq1ik7vamqma4pc
```

### evt_1_kl_OKw - Wake Up

```event
id: evt_1_kl_OKw
externalId: gcal_ree23sta8vurjcgrf0gm9i6ag0
updatedAt: 2026-02-22T02:03:53.082Z
title: Wake Up
start: 2026-02-28T07:25:00-05:00
end: 2026-02-28T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: ree23sta8vurjcgrf0gm9i6ag0
```

### evt_R6673MRh - Brush Teeth (AM)

```event
id: evt_R6673MRh
externalId: gcal_rj1nrljf4tv4tmno691qv4ujl8
updatedAt: 2026-02-22T02:03:54.174Z
title: Brush Teeth (AM)
start: 2026-02-28T07:35:00-05:00
end: 2026-02-28T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: rj1nrljf4tv4tmno691qv4ujl8
```

### evt_W6i1heHj - Wake Up

```event
id: evt_W6i1heHj
externalId: gcal_7v5utppbuf33trcarkpf2iekjc
updatedAt: 2026-02-22T02:00:24.361Z
title: Wake Up
start: 2026-02-28T08:00:00-05:00
end: 2026-02-28T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 7v5utppbuf33trcarkpf2iekjc
```

### evt_q1Za806G - Brush Teeth (AM)

```event
id: evt_q1Za806G
externalId: gcal_fe2riatqm42pn0u233irfjav1s
updatedAt: 2026-02-22T02:00:25.522Z
title: Brush Teeth (AM)
start: 2026-02-28T08:10:00-05:00
end: 2026-02-28T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: fe2riatqm42pn0u233irfjav1s
```

### evt_ne9uLHNP - Multi: 15.8/15.9 Practice

```event
id: evt_ne9uLHNP
externalId: gcal_6e8f5aoo0rld22f0kf16a8ml1s
updatedAt: 2026-02-22T00:33:24.534Z
title: "Multi: 15.8/15.9 Practice"
start: 2026-02-28T10:00:00-05:00
end: 2026-02-28T12:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 6e8f5aoo0rld22f0kf16a8ml1s
```

### evt_AwX0AyIv - AP Chem Unit 8 Notes

```event
id: evt_AwX0AyIv
externalId: gcal_m1gnv4lq5kcp0vas6sojt0kmgs
updatedAt: 2026-02-22T00:33:25.251Z
title: AP Chem Unit 8 Notes
start: 2026-02-28T13:00:00-05:00
end: 2026-02-28T15:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: m1gnv4lq5kcp0vas6sojt0kmgs
```

### evt_yB6auwe5 - Workout

```event
id: evt_yB6auwe5
externalId: gcal_r0n802bbefuumjjql1mhtrsejk
updatedAt: 2026-02-22T00:33:25.992Z
title: Workout
start: 2026-02-28T15:30:00-05:00
end: 2026-02-28T16:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: r0n802bbefuumjjql1mhtrsejk
```

### evt_oSALYEif - AP Physics: Rotation + Newton 2

```event
id: evt_oSALYEif
externalId: gcal_avj6uuuktjecmk7ekds55ereag
updatedAt: 2026-02-22T00:33:26.636Z
title: "AP Physics: Rotation + Newton 2"
start: 2026-02-28T16:30:00-05:00
end: 2026-02-28T18:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: avj6uuuktjecmk7ekds55ereag
```

### evt_ZYWtVKSB - Project/Startup

```event
id: evt_ZYWtVKSB
externalId: gcal_97gojr0s2bbi77n23l5kb0c6jo
updatedAt: 2026-02-22T00:33:27.215Z
title: Project/Startup
start: 2026-02-28T19:00:00-05:00
end: 2026-02-28T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 97gojr0s2bbi77n23l5kb0c6jo
```

### evt_cxCNCZxj - Evening Check-in

```event
id: evt_cxCNCZxj
externalId: gcal_9cegca1qq2o4csk62dnjs2ppv8
updatedAt: 2026-02-22T01:16:22.831Z
title: Evening Check-in
start: 2026-02-28T21:35:00-05:00
end: 2026-02-28T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9cegca1qq2o4csk62dnjs2ppv8
```

### evt_G-hNQ2kL - Brush Teeth (PM)

```event
id: evt_G-hNQ2kL
externalId: gcal_pvov84o45usde593eb7pg478os
updatedAt: 2026-02-22T02:03:55.219Z
title: Brush Teeth (PM)
start: 2026-02-28T21:45:00-05:00
end: 2026-02-28T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: pvov84o45usde593eb7pg478os
```

### evt_jIaTfly6 - Shower

```event
id: evt_jIaTfly6
externalId: gcal_4p8qbus7efgggrblh1vlsevs84
updatedAt: 2026-02-22T02:03:56.255Z
title: Shower
start: 2026-02-28T21:50:00-05:00
end: 2026-02-28T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 4p8qbus7efgggrblh1vlsevs84
```

### evt_lxgnyRDf - Brush Teeth (PM)

```event
id: evt_lxgnyRDf
externalId: gcal_uuh8ughr0fejdl9ioc0c4jihm4
updatedAt: 2026-02-22T02:00:26.684Z
title: Brush Teeth (PM)
start: 2026-02-28T22:30:00-05:00
end: 2026-02-28T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: uuh8ughr0fejdl9ioc0c4jihm4
```

### evt_V-cGVcmK - Shower

```event
id: evt_V-cGVcmK
externalId: gcal_fd8vmjigjkbra1oucm3a5drges
updatedAt: 2026-02-22T02:00:27.830Z
title: Shower
start: 2026-02-28T22:35:00-05:00
end: 2026-02-28T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: fd8vmjigjkbra1oucm3a5drges
```

### evt_e4rfYAt7 - Sleep

```event
id: evt_e4rfYAt7
externalId: gcal_3o56ovoq9f3r3ggn7567i2agkc
updatedAt: 2026-02-22T02:03:57.389Z
title: Sleep
start: 2026-03-01T00:00:00-05:00
end: 2026-03-01T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 3o56ovoq9f3r3ggn7567i2agkc
```

### evt_ANUijxOc - Morning Check-in

```event
id: evt_ANUijxOc
externalId: gcal_29vf6r9j62hfsccrq758hgqpmg
updatedAt: 2026-02-22T02:03:01.938Z
title: Morning Check-in
start: 2026-03-01T07:15:00-05:00
end: 2026-03-01T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 29vf6r9j62hfsccrq758hgqpmg
```

### evt_SvkwoDPl - Wake Up

```event
id: evt_SvkwoDPl
externalId: gcal_u89r01ifcda7eako9gosdvhgdo
updatedAt: 2026-02-22T02:03:58.510Z
title: Wake Up
start: 2026-03-01T07:25:00-05:00
end: 2026-03-01T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: u89r01ifcda7eako9gosdvhgdo
```

### evt_fQiHvSgk - Brush Teeth (AM)

```event
id: evt_fQiHvSgk
externalId: gcal_k4jg47ido8hvej51kdb8lajbc8
updatedAt: 2026-02-22T02:03:59.662Z
title: Brush Teeth (AM)
start: 2026-03-01T07:35:00-05:00
end: 2026-03-01T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: k4jg47ido8hvej51kdb8lajbc8
```

### evt_3aTHYEsx - Wake Up

```event
id: evt_3aTHYEsx
externalId: gcal_hs1pppl5be7ulqb808adnsappk
updatedAt: 2026-02-22T02:00:29.452Z
title: Wake Up
start: 2026-03-01T08:00:00-05:00
end: 2026-03-01T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: hs1pppl5be7ulqb808adnsappk
```

### evt_-rUdkbjN - Brush Teeth (AM)

```event
id: evt_-rUdkbjN
externalId: gcal_v78e0tu3i0nj44bmee3d3i5gsc
updatedAt: 2026-02-22T02:00:30.757Z
title: Brush Teeth (AM)
start: 2026-03-01T08:10:00-05:00
end: 2026-03-01T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: v78e0tu3i0nj44bmee3d3i5gsc
```

### evt_q9NFDWL0 - English: Truman Show Seminar Deep Prep

```event
id: evt_q9NFDWL0
externalId: gcal_hg30t3u5l5npk9urtmdv5lccpc
updatedAt: 2026-02-22T00:33:27.931Z
title: "English: Truman Show Seminar Deep Prep"
start: 2026-03-01T10:00:00-05:00
end: 2026-03-01T12:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: hg30t3u5l5npk9urtmdv5lccpc
```

### evt_ZCnPVFCC - AP Physics WA17 + Concept Check

```event
id: evt_ZCnPVFCC
externalId: gcal_b2232qqpg07jlpdaqtoou2quoo
updatedAt: 2026-02-22T00:33:28.612Z
title: AP Physics WA17 + Concept Check
start: 2026-03-01T13:00:00-05:00
end: 2026-03-01T15:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: b2232qqpg07jlpdaqtoou2quoo
```

### evt_Q487nZSA - Workout

```event
id: evt_Q487nZSA
externalId: gcal_m6lk2rqem0rkn20bun4dgpp8s0
updatedAt: 2026-02-22T00:33:29.276Z
title: Workout
start: 2026-03-01T15:30:00-05:00
end: 2026-03-01T16:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: m6lk2rqem0rkn20bun4dgpp8s0
```

### evt_iFf7FUgp - AP Chem Unit 8 Notes

```event
id: evt_iFf7FUgp
externalId: gcal_pkv30pnoktk1el29neipkdosds
updatedAt: 2026-02-22T00:33:29.858Z
title: AP Chem Unit 8 Notes
start: 2026-03-01T16:30:00-05:00
end: 2026-03-01T18:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: pkv30pnoktk1el29neipkdosds
```

### evt_JX9t6oN5 - AP Gov Review

```event
id: evt_JX9t6oN5
externalId: gcal_seirdopmu83qslg5t5p17ui7vo
updatedAt: 2026-02-22T00:33:30.564Z
title: AP Gov Review
start: 2026-03-01T19:00:00-05:00
end: 2026-03-01T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: seirdopmu83qslg5t5p17ui7vo
```

### evt_jUS5xpU8 - Evening Check-in

```event
id: evt_jUS5xpU8
externalId: gcal_kviuct3ifsgsdle5fvtnpu2j18
updatedAt: 2026-02-22T01:16:23.718Z
title: Evening Check-in
start: 2026-03-01T21:35:00-05:00
end: 2026-03-01T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: kviuct3ifsgsdle5fvtnpu2j18
```

### evt_shBlfWgE - Brush Teeth (PM)

```event
id: evt_shBlfWgE
externalId: gcal_3kmnft1mhoi6jrcbk01vha91a4
updatedAt: 2026-02-22T02:04:00.830Z
title: Brush Teeth (PM)
start: 2026-03-01T21:45:00-05:00
end: 2026-03-01T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 3kmnft1mhoi6jrcbk01vha91a4
```

### evt_a3PxIwOY - Shower

```event
id: evt_a3PxIwOY
externalId: gcal_jk7fgbub2latrls2t62ghh5ed8
updatedAt: 2026-02-22T02:04:02.008Z
title: Shower
start: 2026-03-01T21:50:00-05:00
end: 2026-03-01T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: jk7fgbub2latrls2t62ghh5ed8
```

### evt_ZDAcUIYt - Brush Teeth (PM)

```event
id: evt_ZDAcUIYt
externalId: gcal_jbv12l3gch56506h9p5h6bneg4
updatedAt: 2026-02-22T02:00:32.111Z
title: Brush Teeth (PM)
start: 2026-03-01T22:30:00-05:00
end: 2026-03-01T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: jbv12l3gch56506h9p5h6bneg4
```

### evt_4RkmGxPC - Shower

```event
id: evt_4RkmGxPC
externalId: gcal_kovfv7e2q0broembj5apaqp4bo
updatedAt: 2026-02-22T02:00:33.248Z
title: Shower
start: 2026-03-01T22:35:00-05:00
end: 2026-03-01T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: kovfv7e2q0broembj5apaqp4bo
```

### evt_2h968dGW - Sleep

```event
id: evt_2h968dGW
externalId: gcal_dqni57p9b9lkp61gu7gr9efih0
updatedAt: 2026-02-22T02:04:03.209Z
title: Sleep
start: 2026-03-02T00:00:00-05:00
end: 2026-03-02T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: dqni57p9b9lkp61gu7gr9efih0
```

### evt_Jmm2jPqO - Morning Check-in

```event
id: evt_Jmm2jPqO
externalId: gcal_atkjopoapk2tdnkmf94hvrkoo8
updatedAt: 2026-02-22T02:03:02.791Z
title: Morning Check-in
start: 2026-03-02T07:15:00-05:00
end: 2026-03-02T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: atkjopoapk2tdnkmf94hvrkoo8
```

### evt_ZB4fy12r - Wake Up

```event
id: evt_ZB4fy12r
externalId: gcal_g8kal8djn88tr6i3k769p8c7sg
updatedAt: 2026-02-22T02:04:04.292Z
title: Wake Up
start: 2026-03-02T07:25:00-05:00
end: 2026-03-02T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: g8kal8djn88tr6i3k769p8c7sg
```

### evt_zuNMDQDT - Brush Teeth (AM)

```event
id: evt_zuNMDQDT
externalId: gcal_gbgrgm6d76gs0oo8jbilo5m6a0
updatedAt: 2026-02-22T02:04:05.311Z
title: Brush Teeth (AM)
start: 2026-03-02T07:35:00-05:00
end: 2026-03-02T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: gbgrgm6d76gs0oo8jbilo5m6a0
```

### evt_ix-hw1NC - Wake Up

```event
id: evt_ix-hw1NC
externalId: gcal_6bhf2814tl7oedu66qv4nmuatk
updatedAt: 2026-02-22T02:00:34.917Z
title: Wake Up
start: 2026-03-02T08:00:00-05:00
end: 2026-03-02T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 6bhf2814tl7oedu66qv4nmuatk
```

### evt_5mm5tqkD - Brush Teeth (AM)

```event
id: evt_5mm5tqkD
externalId: gcal_3o8mmh35r9f6dvrnm58qftaf1k
updatedAt: 2026-02-22T02:00:36.112Z
title: Brush Teeth (AM)
start: 2026-03-02T08:10:00-05:00
end: 2026-03-02T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 3o8mmh35r9f6dvrnm58qftaf1k
```

### evt_25ojFu4G - English: Seminar Final Prep

```event
id: evt_25ojFu4G
externalId: gcal_kpbn6otf6bme4tikcfvof42tas
updatedAt: 2026-02-22T00:33:31.112Z
title: "English: Seminar Final Prep"
start: 2026-03-02T17:15:00-05:00
end: 2026-03-02T18:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: kpbn6otf6bme4tikcfvof42tas
```

### evt_LOIK2Ie9 - AP Physics Quiz 3 Prep

```event
id: evt_LOIK2Ie9
externalId: gcal_c5qnon8hcqh37li8dmvqafr74o
updatedAt: 2026-02-22T00:33:31.723Z
title: AP Physics Quiz 3 Prep
start: 2026-03-02T18:45:00-05:00
end: 2026-03-02T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: c5qnon8hcqh37li8dmvqafr74o
```

### evt_TYB-T1Q1 - Workout

```event
id: evt_TYB-T1Q1
externalId: gcal_oiujukafg2m8a2qnvjh9uej4ac
updatedAt: 2026-02-22T00:33:32.546Z
title: Workout
start: 2026-03-02T20:15:00-05:00
end: 2026-03-02T21:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: oiujukafg2m8a2qnvjh9uej4ac
```

### evt_9mkRzgHO - Multi: Practice

```event
id: evt_9mkRzgHO
externalId: gcal_t0dcq90mf50rcjdtmvep3q47e4
updatedAt: 2026-02-22T00:33:33.189Z
title: "Multi: Practice"
start: 2026-03-02T21:00:00-05:00
end: 2026-03-02T21:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: t0dcq90mf50rcjdtmvep3q47e4
```

### evt_S37ckxBb - Evening Check-in

```event
id: evt_S37ckxBb
externalId: gcal_t9n9i6fcos6neo6gnbb73i9l6k
updatedAt: 2026-02-22T01:16:24.552Z
title: Evening Check-in
start: 2026-03-02T21:35:00-05:00
end: 2026-03-02T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: t9n9i6fcos6neo6gnbb73i9l6k
```

### evt_hjPAhUss - Brush Teeth (PM)

```event
id: evt_hjPAhUss
externalId: gcal_n5ir4i1hs8qt97mhg04i0mfrjk
updatedAt: 2026-02-22T02:04:06.395Z
title: Brush Teeth (PM)
start: 2026-03-02T21:45:00-05:00
end: 2026-03-02T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: n5ir4i1hs8qt97mhg04i0mfrjk
```

### evt_3hadHnUx - Shower

```event
id: evt_3hadHnUx
externalId: gcal_13rgli52fgi2c5ao5jde47dkns
updatedAt: 2026-02-22T02:04:07.429Z
title: Shower
start: 2026-03-02T21:50:00-05:00
end: 2026-03-02T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 13rgli52fgi2c5ao5jde47dkns
```

### evt_7QSWVd3w - Brush Teeth (PM)

```event
id: evt_7QSWVd3w
externalId: gcal_1pefci8te7v344empnhgh1epck
updatedAt: 2026-02-22T02:00:37.193Z
title: Brush Teeth (PM)
start: 2026-03-02T22:30:00-05:00
end: 2026-03-02T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 1pefci8te7v344empnhgh1epck
```

### evt_a7jbQ8tG - Shower

```event
id: evt_a7jbQ8tG
externalId: gcal_tq3gfaqfpljlios61ohjkmoo70
updatedAt: 2026-02-22T02:00:38.322Z
title: Shower
start: 2026-03-02T22:35:00-05:00
end: 2026-03-02T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: tq3gfaqfpljlios61ohjkmoo70
```

### evt_1diRq4vw - Sleep

```event
id: evt_1diRq4vw
externalId: gcal_f73lq3efhricpdo0fbd8mha6a4
updatedAt: 2026-02-22T02:04:08.404Z
title: Sleep
start: 2026-03-03T00:00:00-05:00
end: 2026-03-03T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: f73lq3efhricpdo0fbd8mha6a4
```

### evt_96d9Rkwh - ⚡ Physics Quiz 3: Rotation & Newton's 2nd Law

```event
id: evt_96d9Rkwh
externalId: gcal_2kc386ta1vhdt9pgt5fukocq1o
updatedAt: 2026-02-22T22:38:01.354Z
title: "⚡ Physics Quiz 3: Rotation & Newton's 2nd Law"
start: 2026-03-03T00:00:00.000Z
end: 2026-03-03T01:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 2kc386ta1vhdt9pgt5fukocq1o
```

### evt_FacFALX7 - Morning Check-in

```event
id: evt_FacFALX7
externalId: gcal_ef6rhkmoalpcd2kt5vihs1fldg
updatedAt: 2026-02-22T02:03:03.679Z
title: Morning Check-in
start: 2026-03-03T07:15:00-05:00
end: 2026-03-03T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: ef6rhkmoalpcd2kt5vihs1fldg
```

### evt_BVDTrLL2 - Wake Up

```event
id: evt_BVDTrLL2
externalId: gcal_platjpimit5f1vuj30ek8ef9kc
updatedAt: 2026-02-22T02:04:09.583Z
title: Wake Up
start: 2026-03-03T07:25:00-05:00
end: 2026-03-03T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: platjpimit5f1vuj30ek8ef9kc
```

### evt_SImvphu5 - Brush Teeth (AM)

```event
id: evt_SImvphu5
externalId: gcal_4k30n20qonvkn628ihsvp57tvo
updatedAt: 2026-02-22T02:04:10.773Z
title: Brush Teeth (AM)
start: 2026-03-03T07:35:00-05:00
end: 2026-03-03T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 4k30n20qonvkn628ihsvp57tvo
```

### evt_qEgN-X86 - Wake Up

```event
id: evt_qEgN-X86
externalId: gcal_kq08qk0ukj22t8khkqck5dji2g
updatedAt: 2026-02-22T02:00:39.880Z
title: Wake Up
start: 2026-03-03T08:00:00-05:00
end: 2026-03-03T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: kq08qk0ukj22t8khkqck5dji2g
```

### evt_EnOXZSLI - Brush Teeth (AM)

```event
id: evt_EnOXZSLI
externalId: gcal_12fvlb7n34tccbunsh51fdotj8
updatedAt: 2026-02-22T02:00:41.030Z
title: Brush Teeth (AM)
start: 2026-03-03T08:10:00-05:00
end: 2026-03-03T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 12fvlb7n34tccbunsh51fdotj8
```

### evt_nsVOKR_o - Multi: Practice

```event
id: evt_nsVOKR_o
externalId: gcal_jqvnidde2n7ovpkfrrq1jnmvdc
updatedAt: 2026-02-22T00:33:33.931Z
title: "Multi: Practice"
start: 2026-03-03T17:15:00-05:00
end: 2026-03-03T18:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: jqvnidde2n7ovpkfrrq1jnmvdc
```

### evt_bB7eAVoC - AP Chem Unit 8 Notes

```event
id: evt_bB7eAVoC
externalId: gcal_junug19gobmdd4ppi3jurnkkbo
updatedAt: 2026-02-22T00:33:34.558Z
title: AP Chem Unit 8 Notes
start: 2026-03-03T18:45:00-05:00
end: 2026-03-03T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: junug19gobmdd4ppi3jurnkkbo
```

### evt_dgyM9xAj - Workout

```event
id: evt_dgyM9xAj
externalId: gcal_3b0uhvenp26nciqlod63iat65o
updatedAt: 2026-02-22T00:33:35.402Z
title: Workout
start: 2026-03-03T20:15:00-05:00
end: 2026-03-03T21:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 3b0uhvenp26nciqlod63iat65o
```

### evt_jlpYNhNs - Project/Startup

```event
id: evt_jlpYNhNs
externalId: gcal_s8meqarclbn1ujv0tf5bon9es0
updatedAt: 2026-02-22T00:33:36.084Z
title: Project/Startup
start: 2026-03-03T21:00:00-05:00
end: 2026-03-03T21:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: s8meqarclbn1ujv0tf5bon9es0
```

### evt_HuX-Uy3_ - Evening Check-in

```event
id: evt_HuX-Uy3_
externalId: gcal_sqrt15i4qu8gse1n72b5lvrajg
updatedAt: 2026-02-22T01:16:25.489Z
title: Evening Check-in
start: 2026-03-03T21:35:00-05:00
end: 2026-03-03T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: sqrt15i4qu8gse1n72b5lvrajg
```

### evt_M7HUqTVN - Brush Teeth (PM)

```event
id: evt_M7HUqTVN
externalId: gcal_bl5ilk30b59cje8n8gc06l3ujk
updatedAt: 2026-02-22T02:04:11.961Z
title: Brush Teeth (PM)
start: 2026-03-03T21:45:00-05:00
end: 2026-03-03T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: bl5ilk30b59cje8n8gc06l3ujk
```

### evt_3lpEQqO3 - Shower

```event
id: evt_3lpEQqO3
externalId: gcal_scih80ok4c2vn1qhcgh11e71e0
updatedAt: 2026-02-22T02:04:13.157Z
title: Shower
start: 2026-03-03T21:50:00-05:00
end: 2026-03-03T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: scih80ok4c2vn1qhcgh11e71e0
```

### evt_sQbG_9Nn - Brush Teeth (PM)

```event
id: evt_sQbG_9Nn
externalId: gcal_m1heroi75bid5ck3mbn8384chg
updatedAt: 2026-02-22T02:00:42.076Z
title: Brush Teeth (PM)
start: 2026-03-03T22:30:00-05:00
end: 2026-03-03T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: m1heroi75bid5ck3mbn8384chg
```

### evt_rr0ZACTK - Shower

```event
id: evt_rr0ZACTK
externalId: gcal_f7fn542se4r5m7me86q2dkrm70
updatedAt: 2026-02-22T02:00:43.297Z
title: Shower
start: 2026-03-03T22:35:00-05:00
end: 2026-03-03T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: f7fn542se4r5m7me86q2dkrm70
```

### evt_xN0gV0OT - Sleep

```event
id: evt_xN0gV0OT
externalId: gcal_qli59dor0tdflb19fav63k1b5k
updatedAt: 2026-02-22T02:04:14.303Z
title: Sleep
start: 2026-03-04T00:00:00-05:00
end: 2026-03-04T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: qli59dor0tdflb19fav63k1b5k
```

### evt_X4Gf_DgV - 📐 Multi: Choice Board DUE

```event
id: evt_X4Gf_DgV
externalId: gcal_41sa3baig292mhd377n1rn60n0
updatedAt: 2026-02-22T22:37:38.282Z
title: "📐 Multi: Choice Board DUE"
start: 2026-03-04T00:00:00.000Z
end: 2026-03-04T01:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 41sa3baig292mhd377n1rn60n0
```

### evt_jILc-XUJ - Morning Check-in

```event
id: evt_jILc-XUJ
externalId: gcal_1vergf81nief21720e72gbt0pg
updatedAt: 2026-02-22T02:03:04.640Z
title: Morning Check-in
start: 2026-03-04T07:15:00-05:00
end: 2026-03-04T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 1vergf81nief21720e72gbt0pg
```

### evt_XvB7Aov0 - Wake Up

```event
id: evt_XvB7Aov0
externalId: gcal_hlq1vorb0eouj9fcs55je9g7ok
updatedAt: 2026-02-22T02:04:15.406Z
title: Wake Up
start: 2026-03-04T07:25:00-05:00
end: 2026-03-04T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: hlq1vorb0eouj9fcs55je9g7ok
```

### evt_bRvYc6xP - Brush Teeth (AM)

```event
id: evt_bRvYc6xP
externalId: gcal_7kqv8rpjeh3esk0o7v9bjm1g3k
updatedAt: 2026-02-22T02:04:16.369Z
title: Brush Teeth (AM)
start: 2026-03-04T07:35:00-05:00
end: 2026-03-04T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 7kqv8rpjeh3esk0o7v9bjm1g3k
```

### evt_vvL8EF9I - Wake Up

```event
id: evt_vvL8EF9I
externalId: gcal_tm38mln53ou7t8jlcg80ch4bd8
updatedAt: 2026-02-22T02:00:44.893Z
title: Wake Up
start: 2026-03-04T08:00:00-05:00
end: 2026-03-04T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: tm38mln53ou7t8jlcg80ch4bd8
```

### evt_EgZmFFmK - Brush Teeth (AM)

```event
id: evt_EgZmFFmK
externalId: gcal_s46kkc4eutsgkohrdl0dkikhus
updatedAt: 2026-02-22T02:00:46.003Z
title: Brush Teeth (AM)
start: 2026-03-04T08:10:00-05:00
end: 2026-03-04T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: s46kkc4eutsgkohrdl0dkikhus
```

### evt_59ohJR4c - Multi: Practice

```event
id: evt_59ohJR4c
externalId: gcal_t4dgd9g7sjtb6c74ql5rt51sbk
updatedAt: 2026-02-22T00:33:36.798Z
title: "Multi: Practice"
start: 2026-03-04T17:15:00-05:00
end: 2026-03-04T18:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: t4dgd9g7sjtb6c74ql5rt51sbk
```

### evt_CE9IpVwm - AP Physics: Rotation Review

```event
id: evt_CE9IpVwm
externalId: gcal_mcuv8r3i96umpdh5dcfrcjrcg0
updatedAt: 2026-02-22T00:33:37.543Z
title: "AP Physics: Rotation Review"
start: 2026-03-04T18:45:00-05:00
end: 2026-03-04T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: mcuv8r3i96umpdh5dcfrcjrcg0
```

### evt_MEDpr16l - Workout

```event
id: evt_MEDpr16l
externalId: gcal_0b2t6n81tl82t4o6nfpnp0tsgc
updatedAt: 2026-02-22T00:33:38.189Z
title: Workout
start: 2026-03-04T20:15:00-05:00
end: 2026-03-04T21:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 0b2t6n81tl82t4o6nfpnp0tsgc
```

### evt_ypZs1MUS - Admin/Planning

```event
id: evt_ypZs1MUS
externalId: gcal_d0g2g6n0c4l1e3nkach01dgfbc
updatedAt: 2026-02-22T00:33:38.897Z
title: Admin/Planning
start: 2026-03-04T21:00:00-05:00
end: 2026-03-04T21:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: d0g2g6n0c4l1e3nkach01dgfbc
```

### evt_YIxmFHL4 - Evening Check-in

```event
id: evt_YIxmFHL4
externalId: gcal_70414odrlk63q78qriaaei62dg
updatedAt: 2026-02-22T01:16:26.311Z
title: Evening Check-in
start: 2026-03-04T21:35:00-05:00
end: 2026-03-04T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 70414odrlk63q78qriaaei62dg
```

### evt_rk4EMkSk - Brush Teeth (PM)

```event
id: evt_rk4EMkSk
externalId: gcal_vp3eggg2pl61ksfq8ambpluu0k
updatedAt: 2026-02-22T02:04:17.564Z
title: Brush Teeth (PM)
start: 2026-03-04T21:45:00-05:00
end: 2026-03-04T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: vp3eggg2pl61ksfq8ambpluu0k
```

### evt_OG0AUeK8 - Shower

```event
id: evt_OG0AUeK8
externalId: gcal_r2k8esrv0mg72auf6jquo15em4
updatedAt: 2026-02-22T02:04:18.630Z
title: Shower
start: 2026-03-04T21:50:00-05:00
end: 2026-03-04T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: r2k8esrv0mg72auf6jquo15em4
```

### evt_hr7qx-e1 - Brush Teeth (PM)

```event
id: evt_hr7qx-e1
externalId: gcal_6dgud3rdsjg1uotcgj65djp794
updatedAt: 2026-02-22T02:00:47.084Z
title: Brush Teeth (PM)
start: 2026-03-04T22:30:00-05:00
end: 2026-03-04T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 6dgud3rdsjg1uotcgj65djp794
```

### evt_0AHfrFOg - Shower

```event
id: evt_0AHfrFOg
externalId: gcal_np5om8ddlbdilu5kpakc6211gg
updatedAt: 2026-02-22T02:00:48.218Z
title: Shower
start: 2026-03-04T22:35:00-05:00
end: 2026-03-04T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: np5om8ddlbdilu5kpakc6211gg
```

### evt_EzSUYbPl - Sleep

```event
id: evt_EzSUYbPl
externalId: gcal_vbaso2o6r782v4k9kmpjf6645s
updatedAt: 2026-02-22T02:04:19.745Z
title: Sleep
start: 2026-03-05T00:00:00-05:00
end: 2026-03-05T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: vbaso2o6r782v4k9kmpjf6645s
```

### evt_Kdz-HV4e - Morning Check-in

```event
id: evt_Kdz-HV4e
externalId: gcal_7dkg3ltt0tc28k86g70lm45i3g
updatedAt: 2026-02-22T02:03:05.496Z
title: Morning Check-in
start: 2026-03-05T07:15:00-05:00
end: 2026-03-05T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 7dkg3ltt0tc28k86g70lm45i3g
```

### evt_Zett3qXT - Wake Up

```event
id: evt_Zett3qXT
externalId: gcal_r0hqmgmmq1l2ma7hg3bkud2a0o
updatedAt: 2026-02-22T02:04:20.838Z
title: Wake Up
start: 2026-03-05T07:25:00-05:00
end: 2026-03-05T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: r0hqmgmmq1l2ma7hg3bkud2a0o
```

### evt_CPHNK5JU - Brush Teeth (AM)

```event
id: evt_CPHNK5JU
externalId: gcal_0l1n1i1c3pejomiap92fjbfln8
updatedAt: 2026-02-22T02:04:21.980Z
title: Brush Teeth (AM)
start: 2026-03-05T07:35:00-05:00
end: 2026-03-05T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 0l1n1i1c3pejomiap92fjbfln8
```

### evt_V3rHyrUa - Wake Up

```event
id: evt_V3rHyrUa
externalId: gcal_980jgbf4gt6ui154nlma1hrtek
updatedAt: 2026-02-22T02:00:49.726Z
title: Wake Up
start: 2026-03-05T08:00:00-05:00
end: 2026-03-05T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 980jgbf4gt6ui154nlma1hrtek
```

### evt_gVHE8ACW - Brush Teeth (AM)

```event
id: evt_gVHE8ACW
externalId: gcal_9nb80omoj97u9j9bjj40lj4im4
updatedAt: 2026-02-22T02:00:50.826Z
title: Brush Teeth (AM)
start: 2026-03-05T08:10:00-05:00
end: 2026-03-05T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9nb80omoj97u9j9bjj40lj4im4
```

### evt_yNNxqg_o - AP Chem Unit 8 Notes

```event
id: evt_yNNxqg_o
externalId: gcal_npdthqq5e3844gd1bicqg3ac8o
updatedAt: 2026-02-22T00:33:39.488Z
title: AP Chem Unit 8 Notes
start: 2026-03-05T17:15:00-05:00
end: 2026-03-05T18:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: npdthqq5e3844gd1bicqg3ac8o
```

### evt_6gq_kpOW - AP Gov Review

```event
id: evt_6gq_kpOW
externalId: gcal_mt4upi8oga9p216ckb13rnl7ss
updatedAt: 2026-02-22T00:33:40.187Z
title: AP Gov Review
start: 2026-03-05T18:45:00-05:00
end: 2026-03-05T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: mt4upi8oga9p216ckb13rnl7ss
```

### evt_As_WCG3F - Workout

```event
id: evt_As_WCG3F
externalId: gcal_smmd37bpbvuj0lp2m554rtppas
updatedAt: 2026-02-22T00:33:40.844Z
title: Workout
start: 2026-03-05T20:15:00-05:00
end: 2026-03-05T21:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: smmd37bpbvuj0lp2m554rtppas
```

### evt_J5kamlpF - Project/Startup

```event
id: evt_J5kamlpF
externalId: gcal_v7icvkee7rm1lj5kb003b7ohn4
updatedAt: 2026-02-22T00:33:41.467Z
title: Project/Startup
start: 2026-03-05T21:00:00-05:00
end: 2026-03-05T21:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: v7icvkee7rm1lj5kb003b7ohn4
```

### evt_0f6ZT6FM - Evening Check-in

```event
id: evt_0f6ZT6FM
externalId: gcal_nave2938r721a6cia7sch60aus
updatedAt: 2026-02-22T01:16:27.209Z
title: Evening Check-in
start: 2026-03-05T21:35:00-05:00
end: 2026-03-05T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: nave2938r721a6cia7sch60aus
```

### evt_GpeWnBoo - Brush Teeth (PM)

```event
id: evt_GpeWnBoo
externalId: gcal_c8euqt0c1bt7m548i208ajq23k
updatedAt: 2026-02-22T02:04:23.094Z
title: Brush Teeth (PM)
start: 2026-03-05T21:45:00-05:00
end: 2026-03-05T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: c8euqt0c1bt7m548i208ajq23k
```

### evt_EZ-A9DKO - Shower

```event
id: evt_EZ-A9DKO
externalId: gcal_5nr3sog2q0tome3bmr536n2qek
updatedAt: 2026-02-22T02:04:24.213Z
title: Shower
start: 2026-03-05T21:50:00-05:00
end: 2026-03-05T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 5nr3sog2q0tome3bmr536n2qek
```

### evt_SfEDgsml - Brush Teeth (PM)

```event
id: evt_SfEDgsml
externalId: gcal_q3nbdq3qpaactdetfut4o80emo
updatedAt: 2026-02-22T02:00:51.896Z
title: Brush Teeth (PM)
start: 2026-03-05T22:30:00-05:00
end: 2026-03-05T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: q3nbdq3qpaactdetfut4o80emo
```

### evt_QUf-RKMF - Shower

```event
id: evt_QUf-RKMF
externalId: gcal_dj3ue83q03525ign4md8bv4l44
updatedAt: 2026-02-22T02:00:53.092Z
title: Shower
start: 2026-03-05T22:35:00-05:00
end: 2026-03-05T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: dj3ue83q03525ign4md8bv4l44
```

### evt_fYyfKNod - Sleep

```event
id: evt_fYyfKNod
externalId: gcal_41agbp26hbescqltqksm2b52rc
updatedAt: 2026-02-22T02:04:25.305Z
title: Sleep
start: 2026-03-06T00:00:00-05:00
end: 2026-03-06T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 41agbp26hbescqltqksm2b52rc
```

### evt_7rBNatlM - Morning Check-in

```event
id: evt_7rBNatlM
externalId: gcal_9mhrfip3tk084jnrcnfelucs80
updatedAt: 2026-02-22T02:03:06.465Z
title: Morning Check-in
start: 2026-03-06T07:15:00-05:00
end: 2026-03-06T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9mhrfip3tk084jnrcnfelucs80
```

### evt_zyG8DG5D - Wake Up

```event
id: evt_zyG8DG5D
externalId: gcal_okt6lvd1r6ob9b2fijss46utag
updatedAt: 2026-02-22T02:04:26.428Z
title: Wake Up
start: 2026-03-06T07:25:00-05:00
end: 2026-03-06T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: okt6lvd1r6ob9b2fijss46utag
```

### evt_9nGbRxbJ - Brush Teeth (AM)

```event
id: evt_9nGbRxbJ
externalId: gcal_b4j3ju1rb8e7hg2afc7f0d08hg
updatedAt: 2026-02-22T02:04:27.565Z
title: Brush Teeth (AM)
start: 2026-03-06T07:35:00-05:00
end: 2026-03-06T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: b4j3ju1rb8e7hg2afc7f0d08hg
```

### evt_fV5TH056 - Wake Up

```event
id: evt_fV5TH056
externalId: gcal_4ukd7uqqc5ko6kckp2pmls7kio
updatedAt: 2026-02-22T02:00:54.554Z
title: Wake Up
start: 2026-03-06T08:00:00-05:00
end: 2026-03-06T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 4ukd7uqqc5ko6kckp2pmls7kio
```

### evt_uOWNP-C_ - Brush Teeth (AM)

```event
id: evt_uOWNP-C_
externalId: gcal_84q3m09u6c5n4hjt7a2otc12j8
updatedAt: 2026-02-22T02:00:55.766Z
title: Brush Teeth (AM)
start: 2026-03-06T08:10:00-05:00
end: 2026-03-06T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 84q3m09u6c5n4hjt7a2otc12j8
```

### evt_0-A29RfD - AP Physics: Practice Set

```event
id: evt_0-A29RfD
externalId: gcal_h7q9434jmf004at051egtprc2o
updatedAt: 2026-02-22T00:33:42.087Z
title: "AP Physics: Practice Set"
start: 2026-03-06T17:15:00-05:00
end: 2026-03-06T18:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: h7q9434jmf004at051egtprc2o
```

### evt_habraWb0 - English/Guitar Prep

```event
id: evt_habraWb0
externalId: gcal_2uel0hh0tsn1f1qttj6tumfk1g
updatedAt: 2026-02-22T00:33:42.700Z
title: English/Guitar Prep
start: 2026-03-06T18:45:00-05:00
end: 2026-03-06T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 2uel0hh0tsn1f1qttj6tumfk1g
```

### evt_Wd_FY6sz - Workout

```event
id: evt_Wd_FY6sz
externalId: gcal_pmrr5a6fatv9btkus3koaqlh1k
updatedAt: 2026-02-22T00:33:43.479Z
title: Workout
start: 2026-03-06T20:15:00-05:00
end: 2026-03-06T21:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: pmrr5a6fatv9btkus3koaqlh1k
```

### evt_V2Gys6So - Rest/Reset

```event
id: evt_V2Gys6So
externalId: gcal_29emno9ipuhl54chjqr7354nv4
updatedAt: 2026-02-22T00:33:44.120Z
title: Rest/Reset
start: 2026-03-06T21:00:00-05:00
end: 2026-03-06T21:30:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 29emno9ipuhl54chjqr7354nv4
```

### evt_QcZLMs7P - Evening Check-in

```event
id: evt_QcZLMs7P
externalId: gcal_k6qv5b3p2ac632l50dgialb0ms
updatedAt: 2026-02-22T01:16:28.090Z
title: Evening Check-in
start: 2026-03-06T21:35:00-05:00
end: 2026-03-06T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: k6qv5b3p2ac632l50dgialb0ms
```

### evt_q8kuipRo - Brush Teeth (PM)

```event
id: evt_q8kuipRo
externalId: gcal_74camm3gtq4n1rr4vbn0kpptk4
updatedAt: 2026-02-22T02:04:28.642Z
title: Brush Teeth (PM)
start: 2026-03-06T21:45:00-05:00
end: 2026-03-06T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 74camm3gtq4n1rr4vbn0kpptk4
```

### evt_YsoXuuS5 - Shower

```event
id: evt_YsoXuuS5
externalId: gcal_dhgb1ou4aif6dchnnfag6k4fs0
updatedAt: 2026-02-22T02:04:29.789Z
title: Shower
start: 2026-03-06T21:50:00-05:00
end: 2026-03-06T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: dhgb1ou4aif6dchnnfag6k4fs0
```

### evt_iW2y7H0i - Brush Teeth (PM)

```event
id: evt_iW2y7H0i
externalId: gcal_qlittu9q42ef28brqcgv35v0ns
updatedAt: 2026-02-22T02:00:56.891Z
title: Brush Teeth (PM)
start: 2026-03-06T22:30:00-05:00
end: 2026-03-06T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: qlittu9q42ef28brqcgv35v0ns
```

### evt_W4hmCKpy - Shower

```event
id: evt_W4hmCKpy
externalId: gcal_m11c2hmepbrptie6l7v363u98o
updatedAt: 2026-02-22T02:00:57.994Z
title: Shower
start: 2026-03-06T22:35:00-05:00
end: 2026-03-06T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: m11c2hmepbrptie6l7v363u98o
```

### evt_8s6se_CB - Sleep

```event
id: evt_8s6se_CB
externalId: gcal_bcnc58rp5v1hqoh8eh20lcfk54
updatedAt: 2026-02-22T02:04:30.767Z
title: Sleep
start: 2026-03-07T00:00:00-05:00
end: 2026-03-07T07:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: bcnc58rp5v1hqoh8eh20lcfk54
```

### evt_hQqr8-kP - Morning Check-in

```event
id: evt_hQqr8-kP
externalId: gcal_vki39hmhafmuv48cpt9866qftg
updatedAt: 2026-02-22T02:03:07.184Z
title: Morning Check-in
start: 2026-03-07T07:15:00-05:00
end: 2026-03-07T07:25:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: vki39hmhafmuv48cpt9866qftg
```

### evt_K1ecYyRG - Wake Up

```event
id: evt_K1ecYyRG
externalId: gcal_1r6jq51uphgcbjfj9maecgbqnc
updatedAt: 2026-02-22T02:04:31.897Z
title: Wake Up
start: 2026-03-07T07:25:00-05:00
end: 2026-03-07T07:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 1r6jq51uphgcbjfj9maecgbqnc
```

### evt_rrXQOGoV - Brush Teeth (AM)

```event
id: evt_rrXQOGoV
externalId: gcal_onp1ki4pd28u1garunq5iu0eqs
updatedAt: 2026-02-22T02:04:33.157Z
title: Brush Teeth (AM)
start: 2026-03-07T07:35:00-05:00
end: 2026-03-07T07:40:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: onp1ki4pd28u1garunq5iu0eqs
```

### evt_j5HSJc6R - Wake Up

```event
id: evt_j5HSJc6R
externalId: gcal_vu3ef309iijs0gqmgigh55ao0o
updatedAt: 2026-02-22T02:00:59.608Z
title: Wake Up
start: 2026-03-07T08:00:00-05:00
end: 2026-03-07T08:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: vu3ef309iijs0gqmgigh55ao0o
```

### evt_Vhunoydb - Brush Teeth (AM)

```event
id: evt_Vhunoydb
externalId: gcal_3akj2ap1vp62n87mfr1djfaq7s
updatedAt: 2026-02-22T02:01:00.780Z
title: Brush Teeth (AM)
start: 2026-03-07T08:10:00-05:00
end: 2026-03-07T08:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 3akj2ap1vp62n87mfr1djfaq7s
```

### evt_tM33vD-c - Multi: Practice

```event
id: evt_tM33vD-c
externalId: gcal_gm4pvkrebjcdn1ehchqopctr5c
updatedAt: 2026-02-22T00:33:44.829Z
title: "Multi: Practice"
start: 2026-03-07T10:00:00-05:00
end: 2026-03-07T12:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: gm4pvkrebjcdn1ehchqopctr5c
```

### evt_1_ViZa7B - RSEF Prep

```event
id: evt_1_ViZa7B
externalId: gcal_s797p1q46abtifavpb3hgl34p8
updatedAt: 2026-02-22T00:33:45.542Z
title: RSEF Prep
start: 2026-03-07T13:00:00-05:00
end: 2026-03-07T15:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: s797p1q46abtifavpb3hgl34p8
```

### evt_qGdkxyVs - Workout

```event
id: evt_qGdkxyVs
externalId: gcal_a7tvpj7pgm62is6fosj6m3vkkk
updatedAt: 2026-02-22T00:33:46.321Z
title: Workout
start: 2026-03-07T15:30:00-05:00
end: 2026-03-07T16:15:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: a7tvpj7pgm62is6fosj6m3vkkk
```

### evt_Zdm4LubZ - Guitar Prep

```event
id: evt_Zdm4LubZ
externalId: gcal_9iefcncq8dt7i1lds80n1imtsk
updatedAt: 2026-02-22T00:33:47.660Z
title: Guitar Prep
start: 2026-03-07T16:30:00-05:00
end: 2026-03-07T18:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9iefcncq8dt7i1lds80n1imtsk
```

### evt_tmh67udB - Project/Startup

```event
id: evt_tmh67udB
externalId: gcal_4639bjviv5qmi33doqg27pnb5o
updatedAt: 2026-02-22T00:33:48.336Z
title: Project/Startup
start: 2026-03-07T19:00:00-05:00
end: 2026-03-07T20:00:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 4639bjviv5qmi33doqg27pnb5o
```

### evt_oYl6FLXW - Evening Check-in

```event
id: evt_oYl6FLXW
externalId: gcal_5qva7r59lblc3iklkkhc90h0q0
updatedAt: 2026-02-22T01:16:28.922Z
title: Evening Check-in
start: 2026-03-07T21:35:00-05:00
end: 2026-03-07T21:45:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 5qva7r59lblc3iklkkhc90h0q0
```

### evt_TktQEnWH - Brush Teeth (PM)

```event
id: evt_TktQEnWH
externalId: gcal_hpmvkk0bj4i4skmo04cij0q3m0
updatedAt: 2026-02-22T02:04:34.781Z
title: Brush Teeth (PM)
start: 2026-03-07T21:45:00-05:00
end: 2026-03-07T21:50:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: hpmvkk0bj4i4skmo04cij0q3m0
```

### evt_nls05wza - Shower

```event
id: evt_nls05wza
externalId: gcal_vf6eeoetv084runsbvdqcaetmk
updatedAt: 2026-02-22T02:04:35.787Z
title: Shower
start: 2026-03-07T21:50:00-05:00
end: 2026-03-07T22:10:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: vf6eeoetv084runsbvdqcaetmk
```

### evt_2zYsh0r_ - Brush Teeth (PM)

```event
id: evt_2zYsh0r_
externalId: gcal_8ro2l47asc71k2ef2jbcu21qek
updatedAt: 2026-02-22T02:01:01.849Z
title: Brush Teeth (PM)
start: 2026-03-07T22:30:00-05:00
end: 2026-03-07T22:35:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 8ro2l47asc71k2ef2jbcu21qek
```

### evt_e0TBQYsv - Shower

```event
id: evt_e0TBQYsv
externalId: gcal_ukl4khi1tj141nima21rg00uvk
updatedAt: 2026-02-22T02:01:03.044Z
title: Shower
start: 2026-03-07T22:35:00-05:00
end: 2026-03-07T22:55:00-05:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: ukl4khi1tj141nima21rg00uvk
```

### evt_1wsC9ceJ - Wake Up

```event
id: evt_1wsC9ceJ
externalId: gcal_7if7bjt120m7cmac7ef2ag9gis
updatedAt: 2026-02-22T02:01:04.676Z
title: Wake Up
start: 2026-03-08T09:00:00-04:00
end: 2026-03-08T09:10:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 7if7bjt120m7cmac7ef2ag9gis
```

### evt_gjYHwRiC - Brush Teeth (AM)

```event
id: evt_gjYHwRiC
externalId: gcal_gjm9ubch8fcs3rljifimueoub4
updatedAt: 2026-02-22T02:01:05.766Z
title: Brush Teeth (AM)
start: 2026-03-08T09:10:00-04:00
end: 2026-03-08T09:15:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: gjm9ubch8fcs3rljifimueoub4
```

### evt_u1B1upZk - Brush Teeth (PM)

```event
id: evt_u1B1upZk
externalId: gcal_g7ok5b60mrj4e8ub2j9i87oqr0
updatedAt: 2026-02-22T02:01:06.943Z
title: Brush Teeth (PM)
start: 2026-03-08T23:30:00-04:00
end: 2026-03-08T23:35:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: g7ok5b60mrj4e8ub2j9i87oqr0
```

### evt_DcQG4VAk - Shower

```event
id: evt_DcQG4VAk
externalId: gcal_2er368rqevp5ed7t0t7credmgs
updatedAt: 2026-02-22T02:01:08.134Z
title: Shower
start: 2026-03-08T23:35:00-04:00
end: 2026-03-08T23:55:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 2er368rqevp5ed7t0t7credmgs
```

### evt_xAn8voyu - Wake Up

```event
id: evt_xAn8voyu
externalId: gcal_0p18undh6a7dsrra2rpq1sr5rg
updatedAt: 2026-02-22T02:01:09.649Z
title: Wake Up
start: 2026-03-09T09:00:00-04:00
end: 2026-03-09T09:10:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 0p18undh6a7dsrra2rpq1sr5rg
```

### evt_1lrOh5oC - Brush Teeth (AM)

```event
id: evt_1lrOh5oC
externalId: gcal_4ukh7afu7o55e7np078t0dq5cc
updatedAt: 2026-02-22T02:01:10.717Z
title: Brush Teeth (AM)
start: 2026-03-09T09:10:00-04:00
end: 2026-03-09T09:15:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 4ukh7afu7o55e7np078t0dq5cc
```

### evt_lpi_PHQF - Brush Teeth (PM)

```event
id: evt_lpi_PHQF
externalId: gcal_l2ff6mhpn2mg69sj363q53i570
updatedAt: 2026-02-22T02:01:11.834Z
title: Brush Teeth (PM)
start: 2026-03-09T23:30:00-04:00
end: 2026-03-09T23:35:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: l2ff6mhpn2mg69sj363q53i570
```

### evt_Wb_h_1Lw - Shower

```event
id: evt_Wb_h_1Lw
externalId: gcal_ki17mpfqp1pt32mj09920n78kc
updatedAt: 2026-02-22T02:01:12.973Z
title: Shower
start: 2026-03-09T23:35:00-04:00
end: 2026-03-09T23:55:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: ki17mpfqp1pt32mj09920n78kc
```

### evt_epEl9a9x - 📐 Multi TEST: Unit 15b

```event
id: evt_epEl9a9x
externalId: gcal_f21o44ul61vaemu5th1obhlq04
updatedAt: 2026-02-22T22:37:38.866Z
title: "📐 Multi TEST: Unit 15b"
start: 2026-03-10T00:00:00.000Z
end: 2026-03-10T01:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: f21o44ul61vaemu5th1obhlq04
```

### evt_MhxJBWJt - Wake Up

```event
id: evt_MhxJBWJt
externalId: gcal_73f1ji79m9cqe633cr43j5pp5g
updatedAt: 2026-02-22T02:01:14.623Z
title: Wake Up
start: 2026-03-10T09:00:00-04:00
end: 2026-03-10T09:10:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 73f1ji79m9cqe633cr43j5pp5g
```

### evt_cLbGgZ7Q - Brush Teeth (AM)

```event
id: evt_cLbGgZ7Q
externalId: gcal_2ddbag1pt2o8tttaikgqikjm84
updatedAt: 2026-02-22T02:01:16.400Z
title: Brush Teeth (AM)
start: 2026-03-10T09:10:00-04:00
end: 2026-03-10T09:15:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 2ddbag1pt2o8tttaikgqikjm84
```

### evt_MMDlxpzd - Brush Teeth (PM)

```event
id: evt_MMDlxpzd
externalId: gcal_l99ir8h3l4mf0bdghnca7mod54
updatedAt: 2026-02-22T02:01:17.493Z
title: Brush Teeth (PM)
start: 2026-03-10T23:30:00-04:00
end: 2026-03-10T23:35:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: l99ir8h3l4mf0bdghnca7mod54
```

### evt_-2aNaJr9 - Shower

```event
id: evt_-2aNaJr9
externalId: gcal_n81dfsrlo2756827iv4jbq5o70
updatedAt: 2026-02-22T02:01:18.503Z
title: Shower
start: 2026-03-10T23:35:00-04:00
end: 2026-03-10T23:55:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: n81dfsrlo2756827iv4jbq5o70
```

### evt_3hQgPI8u - Wake Up

```event
id: evt_3hQgPI8u
externalId: gcal_0ik0a4j7m7vt3n13p1vv0082a8
updatedAt: 2026-02-22T02:01:20.028Z
title: Wake Up
start: 2026-03-11T09:00:00-04:00
end: 2026-03-11T09:10:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 0ik0a4j7m7vt3n13p1vv0082a8
```

### evt_pMVdxXtH - Brush Teeth (AM)

```event
id: evt_pMVdxXtH
externalId: gcal_h6mcoq5psolb2sri4caopejtmg
updatedAt: 2026-02-22T02:01:21.176Z
title: Brush Teeth (AM)
start: 2026-03-11T09:10:00-04:00
end: 2026-03-11T09:15:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: h6mcoq5psolb2sri4caopejtmg
```

### evt_ab9u0nMw - Brush Teeth (PM)

```event
id: evt_ab9u0nMw
externalId: gcal_0h5jm93ss63j7srphq91lbn65g
updatedAt: 2026-02-22T02:01:22.217Z
title: Brush Teeth (PM)
start: 2026-03-11T23:30:00-04:00
end: 2026-03-11T23:35:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 0h5jm93ss63j7srphq91lbn65g
```

### evt_nfiLx6Zg - Shower

```event
id: evt_nfiLx6Zg
externalId: gcal_eebueshmljmdc8p5h7a9ni78u8
updatedAt: 2026-02-22T02:01:23.292Z
title: Shower
start: 2026-03-11T23:35:00-04:00
end: 2026-03-11T23:55:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: eebueshmljmdc8p5h7a9ni78u8
```

### evt_xSzR3K0y - Wake Up

```event
id: evt_xSzR3K0y
externalId: gcal_pq6iabpnd5njb4la1fm8r5do10
updatedAt: 2026-02-22T02:01:24.798Z
title: Wake Up
start: 2026-03-12T09:00:00-04:00
end: 2026-03-12T09:10:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: pq6iabpnd5njb4la1fm8r5do10
```

### evt_TTx3xoe- - Brush Teeth (AM)

```event
id: evt_TTx3xoe-
externalId: gcal_gmiqq98p5i5aekt6bnvvv6sunk
updatedAt: 2026-02-22T02:01:25.764Z
title: Brush Teeth (AM)
start: 2026-03-12T09:10:00-04:00
end: 2026-03-12T09:15:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: gmiqq98p5i5aekt6bnvvv6sunk
```

### evt_I8k9R8lJ - Brush Teeth (PM)

```event
id: evt_I8k9R8lJ
externalId: gcal_c5h28d5t0nq9mtvm6hnguj9uuo
updatedAt: 2026-02-22T02:01:26.849Z
title: Brush Teeth (PM)
start: 2026-03-12T23:30:00-04:00
end: 2026-03-12T23:35:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: c5h28d5t0nq9mtvm6hnguj9uuo
```

### evt_WIyD0zyv - Shower

```event
id: evt_WIyD0zyv
externalId: gcal_d8r59gltoo4t5rhtiol4gap1qc
updatedAt: 2026-02-22T02:01:27.960Z
title: Shower
start: 2026-03-12T23:35:00-04:00
end: 2026-03-12T23:55:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: d8r59gltoo4t5rhtiol4gap1qc
```

### evt_e5syc80l - Wake Up

```event
id: evt_e5syc80l
externalId: gcal_9dpt7obok18nd7u9vgge31eabg
updatedAt: 2026-02-22T02:01:29.476Z
title: Wake Up
start: 2026-03-13T09:00:00-04:00
end: 2026-03-13T09:10:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9dpt7obok18nd7u9vgge31eabg
```

### evt_OcRy7SqD - Brush Teeth (AM)

```event
id: evt_OcRy7SqD
externalId: gcal_kevlls3f8augci780pv1c7t7m8
updatedAt: 2026-02-22T02:01:30.609Z
title: Brush Teeth (AM)
start: 2026-03-13T09:10:00-04:00
end: 2026-03-13T09:15:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: kevlls3f8augci780pv1c7t7m8
```

### evt_fQkx6QuM - Brush Teeth (PM)

```event
id: evt_fQkx6QuM
externalId: gcal_7q9hp6es9srnjs0hnald9agk1o
updatedAt: 2026-02-22T02:01:31.698Z
title: Brush Teeth (PM)
start: 2026-03-13T23:30:00-04:00
end: 2026-03-13T23:35:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 7q9hp6es9srnjs0hnald9agk1o
```

### evt_Yzi6NnI- - Shower

```event
id: evt_Yzi6NnI-
externalId: gcal_ju555ekeunh5d80fhv58uug0s8
updatedAt: 2026-02-22T02:01:32.655Z
title: Shower
start: 2026-03-13T23:35:00-04:00
end: 2026-03-13T23:55:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: ju555ekeunh5d80fhv58uug0s8
```

### evt_g4NaCdg_ - Wake Up

```event
id: evt_g4NaCdg_
externalId: gcal_oa4g44qd7u0t9qciqkmancufg4
updatedAt: 2026-02-22T02:01:34.234Z
title: Wake Up
start: 2026-03-14T09:00:00-04:00
end: 2026-03-14T09:10:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: oa4g44qd7u0t9qciqkmancufg4
```

### evt_8hZ4M6SH - Brush Teeth (AM)

```event
id: evt_8hZ4M6SH
externalId: gcal_orv4bpsba4hdmujk55sq6tdiqs
updatedAt: 2026-02-22T02:01:35.256Z
title: Brush Teeth (AM)
start: 2026-03-14T09:10:00-04:00
end: 2026-03-14T09:15:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: orv4bpsba4hdmujk55sq6tdiqs
```

### evt_p4eQR8C0 - Brush Teeth (PM)

```event
id: evt_p4eQR8C0
externalId: gcal_0cd8u0fofhsjob8vla2vnabf2c
updatedAt: 2026-02-22T02:01:36.563Z
title: Brush Teeth (PM)
start: 2026-03-14T23:30:00-04:00
end: 2026-03-14T23:35:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 0cd8u0fofhsjob8vla2vnabf2c
```

### evt_chClbllr - Shower

```event
id: evt_chClbllr
externalId: gcal_l3ehl8ogru4p8t8kvmnecr4r84
updatedAt: 2026-02-22T02:01:37.705Z
title: Shower
start: 2026-03-14T23:35:00-04:00
end: 2026-03-14T23:55:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: l3ehl8ogru4p8t8kvmnecr4r84
```

### evt_26Z1bpD9 - Wake Up

```event
id: evt_26Z1bpD9
externalId: gcal_5cmdmokfkfomqbcj38c0hdupbc
updatedAt: 2026-02-22T02:01:39.415Z
title: Wake Up
start: 2026-03-15T09:00:00-04:00
end: 2026-03-15T09:10:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 5cmdmokfkfomqbcj38c0hdupbc
```

### evt_w9I2n3Em - Brush Teeth (AM)

```event
id: evt_w9I2n3Em
externalId: gcal_kr04qu5smvl53r93kcg4hhaue4
updatedAt: 2026-02-22T02:01:40.646Z
title: Brush Teeth (AM)
start: 2026-03-15T09:10:00-04:00
end: 2026-03-15T09:15:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: kr04qu5smvl53r93kcg4hhaue4
```

### evt_MuWNVnFy - Brush Teeth (PM)

```event
id: evt_MuWNVnFy
externalId: gcal_gcsjt5q3b41u8mrejfjdp791rc
updatedAt: 2026-02-22T02:01:41.746Z
title: Brush Teeth (PM)
start: 2026-03-15T23:30:00-04:00
end: 2026-03-15T23:35:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: gcsjt5q3b41u8mrejfjdp791rc
```

### evt_mcLLk_Yf - Shower

```event
id: evt_mcLLk_Yf
externalId: gcal_rpfb7vb473kctdkn8d5m9bjggk
updatedAt: 2026-02-22T02:01:42.882Z
title: Shower
start: 2026-03-15T23:35:00-04:00
end: 2026-03-15T23:55:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: rpfb7vb473kctdkn8d5m9bjggk
```

### evt_JpR7KGkv - Wake Up

```event
id: evt_JpR7KGkv
externalId: gcal_se5pasjigemmemq1ct5j24glnk
updatedAt: 2026-02-22T02:01:44.382Z
title: Wake Up
start: 2026-03-16T09:00:00-04:00
end: 2026-03-16T09:10:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: se5pasjigemmemq1ct5j24glnk
```

### evt_A9P-y8ks - Brush Teeth (AM)

```event
id: evt_A9P-y8ks
externalId: gcal_bpb15cboangvv8fmi86e684794
updatedAt: 2026-02-22T02:01:45.639Z
title: Brush Teeth (AM)
start: 2026-03-16T09:10:00-04:00
end: 2026-03-16T09:15:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: bpb15cboangvv8fmi86e684794
```

### evt_oNQ1DL9F - Brush Teeth (PM)

```event
id: evt_oNQ1DL9F
externalId: gcal_453qvtkdlrp20i7r4ktihv9j3k
updatedAt: 2026-02-22T02:01:46.714Z
title: Brush Teeth (PM)
start: 2026-03-16T23:30:00-04:00
end: 2026-03-16T23:35:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 453qvtkdlrp20i7r4ktihv9j3k
```

### evt_92cWe8s- - Shower

```event
id: evt_92cWe8s-
externalId: gcal_efp5pavhekv9e42t72e71sjenk
updatedAt: 2026-02-22T02:01:47.849Z
title: Shower
start: 2026-03-16T23:35:00-04:00
end: 2026-03-16T23:55:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: efp5pavhekv9e42t72e71sjenk
```

### evt_emkE-Tn_ - ⚡ Physics Unit 5 TEST: Rotational Dynamics & Energy

```event
id: evt_emkE-Tn_
externalId: gcal_g8ms6sl66f1nub5fn3ugie05s8
updatedAt: 2026-02-22T22:38:02.055Z
title: "⚡ Physics Unit 5 TEST: Rotational Dynamics & Energy"
start: 2026-03-17T00:00:00.000Z
end: 2026-03-17T01:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: g8ms6sl66f1nub5fn3ugie05s8
```

### evt_YLjGuII_ - Wake Up

```event
id: evt_YLjGuII_
externalId: gcal_tirav8hkfg9hlc2lbre3nevqg4
updatedAt: 2026-02-22T02:01:49.590Z
title: Wake Up
start: 2026-03-17T09:00:00-04:00
end: 2026-03-17T09:10:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: tirav8hkfg9hlc2lbre3nevqg4
```

### evt_PR_1o8t- - Brush Teeth (AM)

```event
id: evt_PR_1o8t-
externalId: gcal_em0ip01cdr5i49jrp71pp2ue48
updatedAt: 2026-02-22T02:01:50.713Z
title: Brush Teeth (AM)
start: 2026-03-17T09:10:00-04:00
end: 2026-03-17T09:15:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: em0ip01cdr5i49jrp71pp2ue48
```

### evt_ao1Q623V - Brush Teeth (PM)

```event
id: evt_ao1Q623V
externalId: gcal_8o51lch34qt5oq0em5i2a5f5f8
updatedAt: 2026-02-22T02:01:51.859Z
title: Brush Teeth (PM)
start: 2026-03-17T23:30:00-04:00
end: 2026-03-17T23:35:00-04:00
allDay: false
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 8o51lch34qt5oq0em5i2a5f5f8
```

### evt_WKhZCE2C - Happy birthday!

```event
id: evt_WKhZCE2C
externalId: gcal_9hf8792t3es62712nd27edp7js_20261129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2026-11-29T00:00:00.000Z
end: 2026-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20261129
```

### evt_JF9yobsJ - Happy birthday!

```event
id: evt_JF9yobsJ
externalId: gcal_9hf8792t3es62712nd27edp7js_20271129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2027-11-29T00:00:00.000Z
end: 2027-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20271129
```

### evt_dEbcNfwq - Happy birthday!

```event
id: evt_dEbcNfwq
externalId: gcal_9hf8792t3es62712nd27edp7js_20281129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2028-11-29T00:00:00.000Z
end: 2028-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20281129
```

### evt_1NCSTrjn - Happy birthday!

```event
id: evt_1NCSTrjn
externalId: gcal_9hf8792t3es62712nd27edp7js_20291129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2029-11-29T00:00:00.000Z
end: 2029-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20291129
```

### evt_4a6iti8M - Happy birthday!

```event
id: evt_4a6iti8M
externalId: gcal_9hf8792t3es62712nd27edp7js_20301129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2030-11-29T00:00:00.000Z
end: 2030-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20301129
```

### evt_0XlQFCFq - Happy birthday!

```event
id: evt_0XlQFCFq
externalId: gcal_9hf8792t3es62712nd27edp7js_20311129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2031-11-29T00:00:00.000Z
end: 2031-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20311129
```

### evt_I-YQ4_Kc - Happy birthday!

```event
id: evt_I-YQ4_Kc
externalId: gcal_9hf8792t3es62712nd27edp7js_20321129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2032-11-29T00:00:00.000Z
end: 2032-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20321129
```

### evt_b_hj08W_ - Happy birthday!

```event
id: evt_b_hj08W_
externalId: gcal_9hf8792t3es62712nd27edp7js_20331129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2033-11-29T00:00:00.000Z
end: 2033-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20331129
```

### evt_-xybAb58 - Happy birthday!

```event
id: evt_-xybAb58
externalId: gcal_9hf8792t3es62712nd27edp7js_20341129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2034-11-29T00:00:00.000Z
end: 2034-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20341129
```

### evt_Sk8Owmr- - Happy birthday!

```event
id: evt_Sk8Owmr-
externalId: gcal_9hf8792t3es62712nd27edp7js_20351129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2035-11-29T00:00:00.000Z
end: 2035-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20351129
```

### evt_PcUlXG5e - Happy birthday!

```event
id: evt_PcUlXG5e
externalId: gcal_9hf8792t3es62712nd27edp7js_20361129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2036-11-29T00:00:00.000Z
end: 2036-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20361129
```

### evt_-Vbpch-5 - Happy birthday!

```event
id: evt_-Vbpch-5
externalId: gcal_9hf8792t3es62712nd27edp7js_20371129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2037-11-29T00:00:00.000Z
end: 2037-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20371129
```

### evt_JO80v0tu - Happy birthday!

```event
id: evt_JO80v0tu
externalId: gcal_9hf8792t3es62712nd27edp7js_20381129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2038-11-29T00:00:00.000Z
end: 2038-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20381129
```

### evt_DyB97eAT - Happy birthday!

```event
id: evt_DyB97eAT
externalId: gcal_9hf8792t3es62712nd27edp7js_20391129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2039-11-29T00:00:00.000Z
end: 2039-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20391129
```

### evt_xqiLDBe1 - Happy birthday!

```event
id: evt_xqiLDBe1
externalId: gcal_9hf8792t3es62712nd27edp7js_20401129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2040-11-29T00:00:00.000Z
end: 2040-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20401129
```

### evt_Mf3UX97l - Happy birthday!

```event
id: evt_Mf3UX97l
externalId: gcal_9hf8792t3es62712nd27edp7js_20411129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2041-11-29T00:00:00.000Z
end: 2041-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20411129
```

### evt_yq7jh6IF - Happy birthday!

```event
id: evt_yq7jh6IF
externalId: gcal_9hf8792t3es62712nd27edp7js_20421129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2042-11-29T00:00:00.000Z
end: 2042-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20421129
```

### evt_AoiWqi_O - Happy birthday!

```event
id: evt_AoiWqi_O
externalId: gcal_9hf8792t3es62712nd27edp7js_20431129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2043-11-29T00:00:00.000Z
end: 2043-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20431129
```

### evt_jqaObjns - Happy birthday!

```event
id: evt_jqaObjns
externalId: gcal_9hf8792t3es62712nd27edp7js_20441129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2044-11-29T00:00:00.000Z
end: 2044-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20441129
```

### evt_mSfajeXR - Happy birthday!

```event
id: evt_mSfajeXR
externalId: gcal_9hf8792t3es62712nd27edp7js_20451129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2045-11-29T00:00:00.000Z
end: 2045-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20451129
```

### evt_AJloG-cm - Happy birthday!

```event
id: evt_AJloG-cm
externalId: gcal_9hf8792t3es62712nd27edp7js_20461129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2046-11-29T00:00:00.000Z
end: 2046-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20461129
```

### evt_wC4WitUB - Happy birthday!

```event
id: evt_wC4WitUB
externalId: gcal_9hf8792t3es62712nd27edp7js_20471129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2047-11-29T00:00:00.000Z
end: 2047-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20471129
```

### evt_1Rg-Fjhm - Happy birthday!

```event
id: evt_1Rg-Fjhm
externalId: gcal_9hf8792t3es62712nd27edp7js_20481129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2048-11-29T00:00:00.000Z
end: 2048-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20481129
```

### evt_5DI0b-kq - Happy birthday!

```event
id: evt_5DI0b-kq
externalId: gcal_9hf8792t3es62712nd27edp7js_20491129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2049-11-29T00:00:00.000Z
end: 2049-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20491129
```

### evt_cAmx4KVj - Happy birthday!

```event
id: evt_cAmx4KVj
externalId: gcal_9hf8792t3es62712nd27edp7js_20501129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2050-11-29T00:00:00.000Z
end: 2050-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20501129
```

### evt_KNKmrJeH - Happy birthday!

```event
id: evt_KNKmrJeH
externalId: gcal_9hf8792t3es62712nd27edp7js_20511129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2051-11-29T00:00:00.000Z
end: 2051-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20511129
```

### evt_X792V53T - Happy birthday!

```event
id: evt_X792V53T
externalId: gcal_9hf8792t3es62712nd27edp7js_20521129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2052-11-29T00:00:00.000Z
end: 2052-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20521129
```

### evt_RvqFgvjE - Happy birthday!

```event
id: evt_RvqFgvjE
externalId: gcal_9hf8792t3es62712nd27edp7js_20531129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2053-11-29T00:00:00.000Z
end: 2053-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20531129
```

### evt_pr8y3RbN - Happy birthday!

```event
id: evt_pr8y3RbN
externalId: gcal_9hf8792t3es62712nd27edp7js_20541129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2054-11-29T00:00:00.000Z
end: 2054-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20541129
```

### evt_hD5oXGtw - Happy birthday!

```event
id: evt_hD5oXGtw
externalId: gcal_9hf8792t3es62712nd27edp7js_20551129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2055-11-29T00:00:00.000Z
end: 2055-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20551129
```

### evt_vYxwV_6z - Happy birthday!

```event
id: evt_vYxwV_6z
externalId: gcal_9hf8792t3es62712nd27edp7js_20561129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2056-11-29T00:00:00.000Z
end: 2056-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20561129
```

### evt_DLFzygXo - Happy birthday!

```event
id: evt_DLFzygXo
externalId: gcal_9hf8792t3es62712nd27edp7js_20571129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2057-11-29T00:00:00.000Z
end: 2057-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20571129
```

### evt_66xYGC7h - Happy birthday!

```event
id: evt_66xYGC7h
externalId: gcal_9hf8792t3es62712nd27edp7js_20581129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2058-11-29T00:00:00.000Z
end: 2058-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20581129
```

### evt_iC7UYU_l - Happy birthday!

```event
id: evt_iC7UYU_l
externalId: gcal_9hf8792t3es62712nd27edp7js_20591129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2059-11-29T00:00:00.000Z
end: 2059-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20591129
```

### evt_EfyaYitS - Happy birthday!

```event
id: evt_EfyaYitS
externalId: gcal_9hf8792t3es62712nd27edp7js_20601129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2060-11-29T00:00:00.000Z
end: 2060-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20601129
```

### evt_QT3uH6T1 - Happy birthday!

```event
id: evt_QT3uH6T1
externalId: gcal_9hf8792t3es62712nd27edp7js_20611129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2061-11-29T00:00:00.000Z
end: 2061-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20611129
```

### evt_iLvPWd0- - Happy birthday!

```event
id: evt_iLvPWd0-
externalId: gcal_9hf8792t3es62712nd27edp7js_20621129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2062-11-29T00:00:00.000Z
end: 2062-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20621129
```

### evt_AU2ZogTr - Happy birthday!

```event
id: evt_AU2ZogTr
externalId: gcal_9hf8792t3es62712nd27edp7js_20631129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2063-11-29T00:00:00.000Z
end: 2063-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20631129
```

### evt_irba550U - Happy birthday!

```event
id: evt_irba550U
externalId: gcal_9hf8792t3es62712nd27edp7js_20641129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2064-11-29T00:00:00.000Z
end: 2064-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20641129
```

### evt_Y_ba9jil - Happy birthday!

```event
id: evt_Y_ba9jil
externalId: gcal_9hf8792t3es62712nd27edp7js_20651129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2065-11-29T00:00:00.000Z
end: 2065-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20651129
```

### evt_hdkN0sWV - Happy birthday!

```event
id: evt_hdkN0sWV
externalId: gcal_9hf8792t3es62712nd27edp7js_20661129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2066-11-29T00:00:00.000Z
end: 2066-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20661129
```

### evt_Ya7PnOHp - Happy birthday!

```event
id: evt_Ya7PnOHp
externalId: gcal_9hf8792t3es62712nd27edp7js_20671129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2067-11-29T00:00:00.000Z
end: 2067-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20671129
```

### evt_RJEVwfyS - Happy birthday!

```event
id: evt_RJEVwfyS
externalId: gcal_9hf8792t3es62712nd27edp7js_20681129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2068-11-29T00:00:00.000Z
end: 2068-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20681129
```

### evt_CQ9qmnkO - Happy birthday!

```event
id: evt_CQ9qmnkO
externalId: gcal_9hf8792t3es62712nd27edp7js_20691129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2069-11-29T00:00:00.000Z
end: 2069-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20691129
```

### evt_yVchHCxJ - Happy birthday!

```event
id: evt_yVchHCxJ
externalId: gcal_9hf8792t3es62712nd27edp7js_20701129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2070-11-29T00:00:00.000Z
end: 2070-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20701129
```

### evt_wPECshK2 - Happy birthday!

```event
id: evt_wPECshK2
externalId: gcal_9hf8792t3es62712nd27edp7js_20711129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2071-11-29T00:00:00.000Z
end: 2071-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20711129
```

### evt_DuhIE_zM - Happy birthday!

```event
id: evt_DuhIE_zM
externalId: gcal_9hf8792t3es62712nd27edp7js_20721129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2072-11-29T00:00:00.000Z
end: 2072-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20721129
```

### evt_YyelP-Wk - Happy birthday!

```event
id: evt_YyelP-Wk
externalId: gcal_9hf8792t3es62712nd27edp7js_20731129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2073-11-29T00:00:00.000Z
end: 2073-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20731129
```

### evt_6YaegfSF - Happy birthday!

```event
id: evt_6YaegfSF
externalId: gcal_9hf8792t3es62712nd27edp7js_20741129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2074-11-29T00:00:00.000Z
end: 2074-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20741129
```

### evt_2hPjN05T - Happy birthday!

```event
id: evt_2hPjN05T
externalId: gcal_9hf8792t3es62712nd27edp7js_20751129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2075-11-29T00:00:00.000Z
end: 2075-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20751129
```

### evt_bCPY3mPs - Happy birthday!

```event
id: evt_bCPY3mPs
externalId: gcal_9hf8792t3es62712nd27edp7js_20761129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2076-11-29T00:00:00.000Z
end: 2076-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20761129
```

### evt_T94Do-Rd - Happy birthday!

```event
id: evt_T94Do-Rd
externalId: gcal_9hf8792t3es62712nd27edp7js_20771129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2077-11-29T00:00:00.000Z
end: 2077-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20771129
```

### evt_w3R46S2M - Happy birthday!

```event
id: evt_w3R46S2M
externalId: gcal_9hf8792t3es62712nd27edp7js_20781129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2078-11-29T00:00:00.000Z
end: 2078-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20781129
```

### evt_uIv86aFP - Happy birthday!

```event
id: evt_uIv86aFP
externalId: gcal_9hf8792t3es62712nd27edp7js_20791129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2079-11-29T00:00:00.000Z
end: 2079-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20791129
```

### evt_6XXBLzo0 - Happy birthday!

```event
id: evt_6XXBLzo0
externalId: gcal_9hf8792t3es62712nd27edp7js_20801129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2080-11-29T00:00:00.000Z
end: 2080-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20801129
```

### evt__MKyCZHB - Happy birthday!

```event
id: evt__MKyCZHB
externalId: gcal_9hf8792t3es62712nd27edp7js_20811129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2081-11-29T00:00:00.000Z
end: 2081-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20811129
```

### evt_CP8JFByj - Happy birthday!

```event
id: evt_CP8JFByj
externalId: gcal_9hf8792t3es62712nd27edp7js_20821129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2082-11-29T00:00:00.000Z
end: 2082-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20821129
```

### evt_cqktYTjO - Happy birthday!

```event
id: evt_cqktYTjO
externalId: gcal_9hf8792t3es62712nd27edp7js_20831129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2083-11-29T00:00:00.000Z
end: 2083-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20831129
```

### evt_2TLXwLSR - Happy birthday!

```event
id: evt_2TLXwLSR
externalId: gcal_9hf8792t3es62712nd27edp7js_20841129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2084-11-29T00:00:00.000Z
end: 2084-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20841129
```

### evt_oMzkEYnx - Happy birthday!

```event
id: evt_oMzkEYnx
externalId: gcal_9hf8792t3es62712nd27edp7js_20851129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2085-11-29T00:00:00.000Z
end: 2085-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20851129
```

### evt_Tr0wf3-t - Happy birthday!

```event
id: evt_Tr0wf3-t
externalId: gcal_9hf8792t3es62712nd27edp7js_20861129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2086-11-29T00:00:00.000Z
end: 2086-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20861129
```

### evt_6RqkshtO - Happy birthday!

```event
id: evt_6RqkshtO
externalId: gcal_9hf8792t3es62712nd27edp7js_20871129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2087-11-29T00:00:00.000Z
end: 2087-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20871129
```

### evt_voaIUz6D - Happy birthday!

```event
id: evt_voaIUz6D
externalId: gcal_9hf8792t3es62712nd27edp7js_20881129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2088-11-29T00:00:00.000Z
end: 2088-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20881129
```

### evt_-C_8GpgD - Happy birthday!

```event
id: evt_-C_8GpgD
externalId: gcal_9hf8792t3es62712nd27edp7js_20891129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2089-11-29T00:00:00.000Z
end: 2089-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20891129
```

### evt_4oFpghg- - Happy birthday!

```event
id: evt_4oFpghg-
externalId: gcal_9hf8792t3es62712nd27edp7js_20901129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2090-11-29T00:00:00.000Z
end: 2090-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20901129
```

### evt_GlRXRSp1 - Happy birthday!

```event
id: evt_GlRXRSp1
externalId: gcal_9hf8792t3es62712nd27edp7js_20911129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2091-11-29T00:00:00.000Z
end: 2091-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20911129
```

### evt_zzm2x_ae - Happy birthday!

```event
id: evt_zzm2x_ae
externalId: gcal_9hf8792t3es62712nd27edp7js_20921129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2092-11-29T00:00:00.000Z
end: 2092-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20921129
```

### evt_1idPCFQB - Happy birthday!

```event
id: evt_1idPCFQB
externalId: gcal_9hf8792t3es62712nd27edp7js_20931129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2093-11-29T00:00:00.000Z
end: 2093-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20931129
```

### evt_gNpgiS6R - Happy birthday!

```event
id: evt_gNpgiS6R
externalId: gcal_9hf8792t3es62712nd27edp7js_20941129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2094-11-29T00:00:00.000Z
end: 2094-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20941129
```

### evt_e3Ik87AI - Happy birthday!

```event
id: evt_e3Ik87AI
externalId: gcal_9hf8792t3es62712nd27edp7js_20951129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2095-11-29T00:00:00.000Z
end: 2095-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20951129
```

### evt_zEBsi4YK - Happy birthday!

```event
id: evt_zEBsi4YK
externalId: gcal_9hf8792t3es62712nd27edp7js_20961129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2096-11-29T00:00:00.000Z
end: 2096-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20961129
```

### evt_frMxityD - Happy birthday!

```event
id: evt_frMxityD
externalId: gcal_9hf8792t3es62712nd27edp7js_20971129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2097-11-29T00:00:00.000Z
end: 2097-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20971129
```

### evt_5DimjUzG - Happy birthday!

```event
id: evt_5DimjUzG
externalId: gcal_9hf8792t3es62712nd27edp7js_20981129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2098-11-29T00:00:00.000Z
end: 2098-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20981129
```

### evt_RsgGrvNF - Happy birthday!

```event
id: evt_RsgGrvNF
externalId: gcal_9hf8792t3es62712nd27edp7js_20991129
updatedAt: 2025-11-19T07:54:35.259Z
title: Happy birthday!
start: 2099-11-29T00:00:00.000Z
end: 2099-11-30T00:00:00.000Z
allDay: true
category: life
completed: false
googleEventIds:
  niravsurabhi@gmail.com: 9hf8792t3es62712nd27edp7js_20991129
```
