# Greeks 完全指南

## 📊 Greeks 概览

Greeks 是衡量期权价格对各种因素敏感度的指标。

| Greek | 衡量什么 | 单位 | 方向 |
|-------|---------|------|------|
| **Delta** (Δ) | 标的价格变动 | $/$ | Call正，Put负 |
| **Gamma** (Γ) | Delta的变化率 | Δ/$ | 都为正 |
| **Theta** (Θ) | 时间衰减 | $/天 | 通常为负 |
| **Vega** (ν) | IV变动 | $/1%IV | 都为正 |
| **Rho** (ρ) | 利率变动 | $/1%利率 | Call正，Put负 |

## 🔺 Delta (Δ) - 方向风险

### 定义
标的价格变动$1，期权价格变动多少。

### 范围
- **Call**: 0 到 +1
- **Put**: -1 到 0

### 解读
| Delta | 含义 |
|-------|------|
| 0.50 | ATM，标的涨$1，期权涨$0.50 |
| 0.80 | 深度ITM，类似持有股票 |
| 0.20 | 深度OTM，投机性强 |
| -0.50 | ATM Put |

### 作为概率近似
Delta 约等于期权到期ITM的概率：
- Delta = 0.30 ≈ 30%概率ITM

### 对冲
- Delta Neutral: 总Delta = 0
- 例: 持有100股 (Delta=100) + 买2个Delta=-50的Put = 0

## 📈 Gamma (Γ) - Delta的加速度

### 定义
标的价格变动$1，Delta变化多少。

### 特点
- ATM期权Gamma最大
- 临近到期时Gamma急剧增加
- 买方Gamma为正（好事）
- 卖方Gamma为负（坏事）

### Gamma风险
临近到期的ATM期权，小幅价格变动可能导致大幅盈亏变化。

```
Gamma高 = 高风险/高收益
临近到期ATM = "Gamma炸弹"
```

## ⏰ Theta (Θ) - 时间价值衰减

### 定义
每过一天，期权损失多少价值（其他条件不变）。

### 特点
- 通常为负数
- ATM期权Theta最大
- 临近到期时Theta加速
- 卖方收Theta（正收益）
- 买方付Theta（负收益）

### Theta衰减曲线
```
DTE 90 ────────┐
DTE 60 ─────┐  │ 
DTE 30 ──┐  │  │   缓慢衰减
DTE 14 ─┐│  │  │
DTE 7  ┐││  │  │   加速衰减
DTE 1  │││  │  │   急剧衰减
       ▼▼▼  ▼  ▼
       0 ←───────── 时间价值
```

### 策略影响
- **买方**: 选DTE 30-60天，避免Theta加速
- **卖方**: 选DTE 30-45天，收益与风险平衡

## 📊 Vega (ν) - 波动率敏感度

### 定义
IV变动1%，期权价格变动多少。

### 特点
- 所有期权Vega都为正
- ATM期权Vega最大
- 长期期权Vega更大
- 买方受益于IV上升
- 卖方受益于IV下降

### IV Crush
财报等事件后，IV大幅下降：
- 即使方向对了，买方也可能亏损
- 这就是为什么财报前买Straddle常常不赚钱

### 策略应用
| IV环境 | 买方 | 卖方 |
|--------|------|------|
| 低IV (Rank<30) | 有利 ✅ | 不利 ❌ |
| 高IV (Rank>70) | 不利 ❌ | 有利 ✅ |

## 💰 Rho (ρ) - 利率敏感度

### 定义
利率变动1%，期权价格变动多少。

### 特点
- Call Rho 为正（利率涨，Call涨）
- Put Rho 为负（利率涨，Put跌）
- 长期期权影响更大
- 通常影响较小，可忽略

### 何时关注
- 长期LEAPS期权
- 利率快速变动时期

## 🧮 Greeks 组合分析

### 策略希腊值

| 策略 | Delta | Gamma | Theta | Vega |
|------|-------|-------|-------|------|
| Long Call | + | + | - | + |
| Short Call | - | - | + | - |
| Long Put | - | + | - | + |
| Short Put | + | - | + | - |
| Bull Call Spread | + | ~0 | ~0 | ~0 |
| Iron Condor | ~0 | - | + | - |
| Long Straddle | 0 | ++ | -- | ++ |

### 例: Iron Condor Greeks
```
Delta ≈ 0      (中性)
Gamma < 0      (不希望大波动)
Theta > 0      (每天收钱)
Vega < 0       (希望IV下降)
```

## 📐 Black-Scholes 公式

期权定价的基础公式：

### Call 价格
```
C = S × N(d1) - K × e^(-rT) × N(d2)
```

### Put 价格
```
P = K × e^(-rT) × N(-d2) - S × N(-d1)
```

### 其中
```
d1 = [ln(S/K) + (r + σ²/2)T] / (σ√T)
d2 = d1 - σ√T
```

### 变量说明
- S: 标的价格
- K: 行权价
- T: 距到期时间（年）
- r: 无风险利率
- σ: 波动率
- N(): 标准正态分布累积函数

## 🎯 实战应用

### 1. Delta 对冲
```python
# 持有1000股，想对冲
# 找Delta = -0.50的Put
# 需要: 1000 / 50 = 20张Put
```

### 2. Theta收租
```python
# Iron Condor Theta = +$10/天
# 30天后如果不动 = $300收益
```

### 3. Vega交易
```python
# 低IV时买入Straddle
# IV从20%涨到30%
# Vega = $2.00/1%IV
# 收益 = 10% × $2.00 = $20/张
```

## ⚠️ 常见错误

1. **忽略Theta**: 买入后持有太久
2. **忽略Gamma**: 卖临近到期的ATM期权
3. **忽略Vega**: 高IV时买入期权
4. **过度对冲**: 频繁调整导致成本过高

## 📚 学习资源

- Natenberg《期权波动率与定价》
- Hull《期权、期货及其他衍生品》
- Tastytrade Greeks系列视频

---

**记住**: Greeks是工具，不是目的。关键是理解风险，做出明智决策。
