# Context Optimizer & Task Processing Skills Package

## Overview
This package contains two powerful OpenClaw skills for automated context management:

1. **Context Optimizer** - Automatically optimizes conversation context to prevent "prompt too large" errors
2. **Task Processor** - Handles large tasks by automatically splitting them into smaller subtasks

## Files Included
- `skills/context-optimizer/` - Main skill directory with all implementation files
- `commands/optimize-context.js` - Command handler for context optimization
- `commands/optimize-context.json` - Command configuration for context optimization
- `commands/process-task.js` - Command handler for processing large tasks
- `commands/process-task.json` - Command configuration for task processing
- `systems/context-monitor.js` - Background context monitoring system
- `systems/context-monitor-config.json` - Configuration for context monitoring
- `task_processing_config.json` - Global task processing configuration

## Installation Instructions

1. Extract this package to your OpenClaw workspace:
   ```bash
   cd ~/.openclaw/workspace
   tar -xzf /path/to/context-optimizer-skill.tar.gz
   ```

2. Install dependencies (if any are needed):
   ```bash
   cd ~/.openclaw/workspace/skills/context-optimizer
   npm install
   ```

3. The skills should now be available in your OpenClaw system with:
   - `/optimize-context` command for manual context optimization
   - `/process-task` command for handling large tasks with automatic splitting

## Features

### Context Optimizer
- Automatically monitors conversation length
- Triggers optimization when message count exceeds thresholds
- Extracts key points and facts while clearing old context
- Prevents "prompt too large" errors

### Task Processor
- Detects large tasks that exceed token limits
- Automatically splits large tasks into smaller subtasks
- Processes subtasks sequentially while maintaining context
- Integrates with context optimization to prevent overflow

### Automatic Monitoring
- Continuous background monitoring of context length
- Configurable thresholds for automatic optimization
- Seamless integration with normal conversation flow

## Configuration
- Adjust settings in `task_processing_config.json`
- Modify thresholds for message counts and token limits
- Configure timing for automatic optimization triggers

The skills are ready to use immediately after installation!