# Opportunity Scoring Guide

Score each opportunity 1-5 on four criteria. Total max = 20.

## Demand (How many people want this?)

| Score | Signal | Example |
|-------|--------|---------|
| 5 | 50+ people asking, trending topic | "Everyone needs X but nothing exists" |
| 4 | 20-50 mentions, regular complaints | "Searched everywhere for X, can't find" |
| 3 | 10-20 mentions, occasional requests | "Would be nice to have X" |
| 2 | 3-10 mentions, niche problem | "I personally wish X existed" |
| 1 | 1-2 mentions, hypothetical need | No evidence of real demand |

**Strong signals:** "I wish...", "Does anyone know a tool for...", "I'd pay for...", "Why doesn't X exist?"
**Weak signals:** "It would be cool if...", "Someone should build...", generic complaints

## Competition (How crowded is the space?)

| Score | Signal | Example |
|-------|--------|---------|
| 5 | No existing solutions | Completely new concept |
| 4 | 1-2 solutions, all flawed/abandoned | Old tools, bad UX, missing features |
| 3 | 3-5 competitors, room for differentiation | Market exists but has gaps |
| 2 | 10+ competitors, some strong players | Established market, hard to stand out |
| 1 | Dominated by big players | Google, Microsoft, etc. own this |

**Check:** Search ClawHub, Product Hunt, GitHub, App Store for existing solutions.
**Key insight:** Abandoned/unmaintained competitors = opportunity, not competition.

## Feasibility (How fast can you build an MVP?)

| Score | Signal | Example |
|-------|--------|---------|
| 5 | 1-2 days, existing APIs/libraries | Wrap an API, simple automation |
| 4 | 3-5 days, some custom logic | Integration + light business logic |
| 3 | 1-2 weeks, moderate complexity | Custom backend, multiple integrations |
| 2 | 2-4 weeks, significant dev work | ML model, complex infrastructure |
| 1 | Months+, deep technical challenges | Novel research, regulatory hurdles |

**For AI agent skills specifically:** Most agent skills are Feasibility 4-5 since they're primarily SKILL.md + scripts.

## Monetization (Will people pay?)

| Score | Signal | Example |
|-------|--------|---------|
| 5 | Saves money/time, B2B, clear ROI | "$500/mo tool replaces $5K employee" |
| 4 | Strong value prop, willing to pay $20-100 | Premium productivity, professional tools |
| 3 | Freemium possible, some willingness | Nice-to-have features worth $5-20 |
| 2 | Users expect free, hard to charge | Utility tools, open-source alternatives |
| 1 | No monetization path | Fun projects, internal tools |

**Best monetization signals:**
- People already paying for inferior alternatives
- B2B use case (businesses pay more than consumers)
- Time/money savings are quantifiable
- "I'd pay for this" in actual user comments

## Decision Matrix

| Total | Action | Reasoning |
|-------|--------|-----------|
| 16-20 | 🔥 BUILD NOW | High demand + low competition + feasible + monetizable |
| 12-15 | 👍 Pursue | Good opportunity, validate before heavy investment |
| 8-11 | 🤔 Monitor | Keep watching, might improve or combine with another |
| 4-7 | ❌ Skip | Not worth the effort right now |
