# 风险评估标准

## 一、风险分级定义

### 🔴 高风险（严重影响交付）

**特征**：
- 可能导致项目失败
- 可能造成重大经济损失
- 可能严重延期（>2 周）
- 客户配合度低或决策链复杂

**典型场景**：
- 工期紧张且不可调整
- 核心功能依赖未验证的第三方
- 预算低于成本
- 需求模糊且客户不愿确认
- 付款条件苛刻（如验收后全款）

**应对策略**：
- 重新评估是否承接
- 要求调整工期或预算
- 签订详细合同明确边界
- 分阶段交付降低风险

---

### 🟡 中风险（影响执行效率）

**特征**：
- 需要额外资源投入
- 可能小幅延期（<2 周）
- 技术难度较高但有方案
- 客户配合度一般

**典型场景**：
- 涉及多个第三方系统集成
- 性能要求较高
- 需要客户配合提供数据/接口
- 需求有部分不确定

**应对策略**：
- 预留缓冲时间
- 提前识别依赖项
- 与客户明确配合事项
- 定期同步进度

---

### 🟢 低风险（可接受）

**特征**：
- 常规项目，可预测
- 技术成熟，有类似案例
- 客户配合度高
- 预算合理

**典型场景**：
- 老客户二次合作
- 标准化产品/方案
- 工期充裕
- 需求清晰

**应对策略**：
- 按正常流程执行
- 保持常规沟通频率

---

## 二、风险评估维度

### 1. 交付风险

| 评估项 | 高风险信号 | 中风险信号 | 低风险信号 |
|--------|------------|------------|------------|
| 工期 | <2 周或指定硬 deadline | 2-4 周 | >4 周 |
| 技术难度 | 无成熟方案 | 有方案但需验证 | 成熟方案 |
| 人员匹配 | 无合适人员 | 需外部支持 | 团队熟悉 |
| 需求清晰度 | 模糊且不愿确认 | 部分清晰 | 清晰明确 |

### 2. 商务风险

| 评估项 | 高风险信号 | 中风险信号 | 低风险信号 |
|--------|------------|------------|------------|
| 预算 | 低于成本 | 利润<20% | 利润>30% |
| 付款 | 验收后全款 | 3-6-1 | 5-4-1 或更好 |
| 合同条款 | 苛刻/无限责任 | 部分苛刻 | 标准条款 |
| 竞品对比 | 多家低价竞争 | 2-3 家竞争 | 独家/优势明显 |

### 3. 技术风险

| 评估项 | 高风险信号 | 中风险信号 | 低风险信号 |
|--------|------------|------------|------------|
| 第三方依赖 | 无 API 文档 | 有文档但需对接 | 成熟 SDK |
| 性能要求 | 高并发无方案 | 有一定要求 | 常规要求 |
| 数据安全 | 敏感数据无保护 | 需要加密 | 公开数据 |
| 技术栈 | 指定不熟悉技术 | 需学习 | 团队熟悉 |

### 4. 客户风险

| 评估项 | 高风险信号 | 中风险信号 | 低风险信号 |
|--------|------------|------------|------------|
| 客户类型 | 新客户无背书 | 老客户新对接人 | 老客户熟悉对接人 |
| 决策链 | 多层级不明确 | 有决策人但慢 | 决策人明确高效 |
| 配合度 | 不愿提供资源 | 配合一般 | 积极配合 |
| 需求稳定性 | 频繁变更 | 部分变更 | 稳定 |

---

## 三、风险评分参考

**快速评分法**（每项 1-5 分，5 分最高风险）：

```
交付风险：___ 分
商务风险：___ 分
技术风险：___ 分
客户风险：___ 分

总分：___ 分

- 16-20 分：🔴 高风险（不建议承接）
- 11-15 分：🟡 中风险（谨慎评估）
- 4-10 分：🟢 低风险（建议承接）
```

---

## 四、常见风险应对话术

### 工期紧张
> "这个工期比较紧张，为了保证质量，建议分期上线，核心功能优先。"

### 预算不足
> "根据需求评估，这个预算可能难以覆盖成本，建议调整功能范围或增加预算。"

### 需求模糊
> "为了避免后期返工，建议先花 1-2 周做需求梳理，确认后再报价。"

### 第三方依赖
> "第三方接口的稳定性会影响项目进度，建议在合同中明确免责条款。"

### 付款条件
> "我们标准的付款方式是 5-4-1，预付款可以启动项目，保障双方权益。"
