# 常见问题清单

## 一、客户背景类

### 新客户
- 之前有没有类似项目经验？
- 怎么了解到我们的？（渠道/推荐）
- 公司规模？团队结构？
- 这个项目是谁发起的？（业务部门/技术部门/老板）
- 决策流程是怎样的？需要几轮审批？

### 老客户
- 上次合作是什么时候？什么项目？
- 合作体验怎么样？有没有遗留问题？
- 这次对接人和上次是同一个吗？
- 预算审批流程和上次一样吗？

---

## 二、项目要求类

### 时间要求
- 什么时候上线？（具体日期）
- 这个时间是硬性要求还是期望？
- 如果延期会有什么后果？
- 是否需要分期上线？
- 有没有关键节点？（如活动、发布会）

### 功能范围
- 核心功能是哪几个？
- 哪些功能可以二期做？
- 有没有不做的需求？
- 功能优先级排序？

### 多端支持
- 需要哪些端？（Web/小程序/APP）
- 优先级？（哪个先做）
- 是否需要数据打通？
- 有没有设计稿/原型？

---

## 三、技术风险类

### 第三方集成
- 需要对接哪些系统？
- 有 API 文档吗？
- 需要谁配合？（客户/第三方）
- 接口是现成的还是需要开发？
- 有没有对接经验或案例？

### 数据来源
- 数据从哪里来？
- 客户提供还是我们采集？
- 数据量大概多少？
- 数据更新频率？
- 有没有数据清洗需求？

### 性能要求
- 预计用户规模？
- 并发量预期？
- 响应时间要求？
- 是否需要 CDN/负载均衡？

### 技术栈
- 有没有指定技术栈？
- 部署环境？（公有云/私有云/本地）
- 有没有安全合规要求？
- 需要源码交付吗？

---

## 四、商务风险类

### 预算
- 预算范围是多少？
- 预算包含哪些？（开发/设计/运维）
- 预算审批通过了吗？
- 有没有追加预算的可能？

### 付款方式
- 付款节点？（预付款/进度款/尾款）
- 验收标准是什么？
- 发票类型？（普票/专票）
- 账期多久？

### 合同
- 用什么合同模板？（客户/我方）
- 有没有特殊条款？
- 保密协议签了吗？
- 知识产权归属？

### 竞品
- 还有谁在跟进？
- 客户最看重什么？（价格/技术/服务）
- 我们的优势是什么？
- 有没有底价？

---

## 五、售后运维类

### 运维期
- 运维期多久？（3 个月/6 个月/1 年）
- 运维范围？（bug 修复/功能迭代）
- 响应时间要求？
- 是否需要驻场？

### SLA 要求
- 系统可用性要求？（99%/99.9%）
- 故障响应时间？
- 数据备份要求？
- 安全巡检要求？

### 培训
- 需要培训吗？
- 培训对象？（管理员/最终用户）
- 培训方式？（线上/线下）
- 需要操作手册吗？

---

## 六、快速判断清单

### 🚩 红色预警（建议谨慎）
- [ ] 工期<2 周
- [ ] 预算低于市场均价 30%
- [ ] 验收后全款
- [ ] 需求完全模糊
- [ ] 指定不熟悉技术栈
- [ ] 无 API 文档的第三方对接
- [ ] 决策链>3 层
- [ ] 竞品>3 家且拼价格

### ✅ 绿色信号（建议承接）
- [ ] 老客户二次合作
- [ ] 预算合理（利润>30%）
- [ ] 预付款>50%
- [ ] 需求清晰有文档
- [ ] 技术成熟有案例
- [ ] 决策人明确
- [ ] 工期充裕
- [ ] 独家/优势明显

---

## 七、沟通技巧

### 问预算
> "类似项目我们做过，价格区间在 X 万到 Y 万，您这边预算大概什么范围？"

### 问工期
> "这个功能开发周期大概 X 周，您期望什么时候上线？我们看看怎么排期。"

### 问决策
> "这个项目除了您之外，还需要谁参与决策？我们好准备相关材料。"

### 问竞品
> "您这边应该也对比了几家吧？您最看重哪方面？我们好针对性准备。"
