---
name: opportunity-assessment
description: 商机判断与风险评估技能。接收新项目信息，主动询问关键问题（客户背景、时间要求、第三方集成等），输出风险分级评估、待确认事项清单、商机建议。适用于销售前期、项目立项、商机评审场景。
---

# 商机判断技能

## 核心目标

快速识别商机质量，评估风险等级，明确待确认事项，辅助决策是否承接项目。

---

## 工作流程

### 第一步：接收项目信息

用户可能提供：
- **文本描述**：项目概况、客户需求
- **文档/截图**：需求文档、聊天截图、会议纪要

### 第二步：主动询问（必须）

收到项目信息后，**必须主动询问以下关键问题**（根据项目情况选择）：

#### 客户背景
1. **是不是老客户？** 之前合作过哪些项目？
2. **客户行业属性？** 政府/企业/教育/医疗等
3. **预算范围有预期吗？** 大概什么量级？
4. **决策链是怎样的？** 谁是最终决策人？

#### 项目要求
5. **项目时间要求？** 什么时候上线？有硬性 deadline 吗？
6. **项目规模预期？** 小型/中型/大型？
7. **是否需要多端支持？** Web/小程序/APP/鸿蒙？

#### 技术风险
8. **涉及第三方系统吗？** 有哪些？API 文档有吗？
9. **有技术栈要求吗？** 指定技术或平台？
10. **数据从哪里来？** 客户提供还是我们采集？
11. **有没有高并发预期？** 预计用户规模？

#### 商务风险
12. **付款方式？** 预付款比例？验收标准？
13. **有没有竞品对比？** 还有谁在跟进？
14. **客户期望的合作模式？** 外包/联合开发/技术入股？

#### 其他
15. **有没有参考产品？** 类似的项目案例？
16. **售后要求？** 运维期多久？SLA 要求？

### 第三步：风险评估（按级别输出）

**风险分级标准**：

| 级别 | 标识 | 说明 |
|------|------|------|
| 🔴 高风险 | 严重影响交付 | 可能导致项目失败、延期、亏损 |
| 🟡 中风险 | 影响执行效率 | 需要额外资源或时间投入 |
| 🟢 低风险 | 轻微影响 | 可接受，常规处理即可 |

**风险评估维度**：

1. **交付风险** - 工期、技术难度、人员匹配
2. **商务风险** - 预算、付款、合同条款
3. **技术风险** - 第三方依赖、性能要求、数据安全
4. **客户风险** - 决策链、配合度、需求稳定性

### 第四步：输出待确认事项

列出**需要客户协助确认**的事项，按优先级排序：

| 优先级 | 待确认事项 | 影响 | 建议沟通方式 |
|--------|------------|------|--------------|
| P0 | ... | ... | ... |
| P1 | ... | ... | ... |

### 第五步：商机建议

基于以上分析，给出**承接建议**：

- ✅ **建议承接** - 风险可控，利润合理，客户优质
- ⚠️ **谨慎评估** - 存在一定风险，需进一步确认
- ❌ **不建议承接** - 风险过高，投入产出比低

---

## 输出格式

**重要：飞书消息不支持 markdown 表格，全部使用纯文本格式！**

### 1. 项目概况（简要）

```
项目名称：XXX
客户类型：新客户/老客户
预算范围：XXX
预期上线：XXX
```

### 2. 风险分级清单

```
🔴 高风险事项
- [风险描述] 影响：[说明] 建议：[应对措施]

🟡 中风险事项
- [风险描述] 影响：[说明] 建议：[应对措施]

🟢 低风险事项
- [风险描述] 影响：[说明] 建议：[应对措施]
```

### 3. 待确认事项（需要客户协助）

**注意：不要用 markdown 表格，用纯文本列表格式**

```
P0 紧急（影响报价/立项）
- [事项 1]
- [事项 2]

P1 重要（影响执行）
- [事项 1]
- [事项 2]

P2 一般（可后续确认）
- [事项 1]
- [事项 2]
```

### 4. 商机建议

```
综合评估：✅建议承接 / ⚠️谨慎评估 / ❌不建议承接

理由：
- 优势：...
- 劣势：...
- 关键决策点：...
```

---

## 注意事项

1. **必须主动询问** - 不要直接给评估，先问清楚背景
2. **风险透明** - 不确定的地方要明确标注
3. **分级清晰** - 高/中/低风险用 emoji 标识，一目了然
4. **可执行** - 每条风险都要有应对建议
5. **待确认事项** - 明确哪些需要客户协助，优先级排序

---

## 相关资源

- 风险评估标准：`references/风险评估标准.md`
- 常见问题清单：`references/常见问题清单.md`
