# AI Vocabulary Database

Complete database of 500+ AI-telltale words and phrases across 3 severity tiers.

---

## How to Use This Database

**Tier 1 (Dead Giveaways):** BAN COMPLETELY. These words scream "AI wrote this."

**Tier 2 (Suspicious):** Use sparingly. One or two instances per 1000 words maximum. Multiple occurrences = red flag.

**Tier 3 (Context-Dependent):** Watch density. Acceptable in technical writing, suspicious in casual content. Flag if 5+ instances per 500 words.

---

## TIER 1: Dead Giveaways (NEVER USE)

### Single Words

**A-D:**
- bustling
- catalyst
- cornerstone
- crucial
- comprehensive

**D-G:**
- delve / delving
- embark
- empower
- enduring
- groundbreaking (figurative)

**H-M:**
- harness
- indelible
- invaluable
- leverage
- meticulous
- multifaceted
- myriad

**N-R:**
- nestled
- paramount
- pivotal
- realm
- reimagine
- robust

**S-Z:**
- seamless
- synergy
- tapestry (abstract/figurative)
- testament
- transformative
- vibrant

### Tier 1 Phrases

- "delve into"
- "embark on a journey"
- "harness the power of"
- "in the realm of"
- "serves as a testament to"
- "stands as a testament to"
- "marking a pivotal moment"
- "plays a crucial role"
- "the evolving landscape of"
- "the intricate tapestry of"
- "in today's digital age"
- "in today's fast-paced world"
- "in today's rapidly changing"
- "without further ado"
- "it is worth noting"
- "it's important to note"

### Why Tier 1 Terms Are Banned

These words rarely appear in human writing but are extremely common in LLM output. They're "educated" vocabulary that sounds smart but feels artificial. Humans prefer simpler alternatives:

- "crucial" → "important", "key", "essential"
- "leverage" → "use"
- "delve into" → "explore", "examine", "look at"
- "robust" → "strong", "reliable", "solid"
- "seamless" → "smooth", "easy"

**Rule:** If you catch yourself about to use a Tier 1 word, pause and find a simpler alternative.

---

## TIER 2: Suspicious (Use Sparingly)

### Single Words

**A-F:**
- additionally
- align / alignment
- bolster
- catalyze
- cultivate
- disrupt / disruptive
- elevate
- encompass
- facilitate

**F-N:**
- foster / fostering
- garner
- holistic
- illuminate
- innovative / innovation (overused)
- intricate / intricacies
- juxtapose / juxtaposition
- nuanced

**O-Z:**
- optimize / optimization
- paradigm
- proactive
- profound
- quintessential
- scalable / scalability
- streamline
- synergize
- ubiquitous
- underscore (verb)
- utilize

### Tier 2 Phrases

- "align with"
- "bolster efforts"
- "catalyze change"
- "cultivate relationships"
- "elevate the conversation"
- "facilitate collaboration"
- "foster innovation"
- "garner attention"
- "illuminate the path"
- "paradigm shift"
- "proactive approach"
- "quintessential example"
- "streamline processes"
- "underscore the importance"

### Why Tier 2 Terms Are Suspicious

These words are legitimate but overused by AI. A human might use "facilitate" occasionally, but AI uses it constantly. The problem is density, not the words themselves.

**Acceptable use:**
- Technical documentation
- Academic writing
- One instance per 1000+ words

**Suspicious use:**
- Multiple instances per paragraph
- In casual/conversational writing
- When simpler words would work

**Better alternatives:**
- "additionally" → "also", "too", "and"
- "facilitate" → "help", "enable", "make easier"
- "utilize" → "use"
- "paradigm" → "model", "framework", "approach"

---

## TIER 3: Context-Dependent (Watch Density)

### Single Words - Abstract/Metaphorical Use

**Business/Tech Jargon:**
- actionable
- bandwidth (metaphorical: "I don't have the bandwidth")
- capacity (figurative)
- ecosystem
- framework
- friction
- granular
- journey (metaphorical)
- landscape (abstract: "the political landscape")
- leverage (noun)
- mindset
- narrative
- pain point
- roadmap
- scalable
- space (abstract: "in the AI space")
- stakeholder
- strategy / strategic
- sustainable / sustainability
- touchpoint
- value-add
- visibility

**Quality/Process Words:**
- authenticity / authentic
- compelling
- comprehensive
- dynamic
- effective / effectiveness
- efficient / efficiency
- engaging
- impactful
- innovative
- meaningful
- powerful
- relevant
- significant
- thoughtful
- valuable

**Change/Action Words:**
- accelerate
- amplify
- champion
- drive (verb: "drive results")
- enhance
- expand
- implement
- integrate
- navigate
- pioneer
- revolutionize
- shape
- spearhead
- transform
- unlock

### Tier 3 Phrases

**Business/Marketing:**
- "best practices"
- "cutting-edge"
- "game-changer" / "game-changing"
- "industry leader"
- "low-hanging fruit"
- "move the needle"
- "next-generation"
- "state-of-the-art"
- "synergies between"
- "take it to the next level"
- "value proposition"
- "win-win"

**Transition/Structure:**
- "at the end of the day"
- "diving deeper"
- "first and foremost"
- "in conclusion"
- "it goes without saying"
- "last but not least"
- "moreover"
- "moving forward"
- "on the other hand"
- "that being said"
- "the bottom line"
- "to summarize"
- "when all is said and done"

**Emphasis/Qualification:**
- "arguably"
- "essentially"
- "fundamentally"
- "incredibly"
- "literally" (misused)
- "particularly"
- "relatively"
- "significantly"
- "substantially"
- "truly"
- "undoubtedly"
- "virtually"

### Why Tier 3 Terms Need Context Checking

These words are legitimate in the right context but become AI tells when:

1. **Density is too high** → 5+ instances per 500 words
2. **Context is too casual** → Using "leverage" in a social media post
3. **They cluster together** → "Our innovative framework leverages cutting-edge solutions to drive meaningful impact"

**Acceptable contexts:**
- Business proposals and strategy documents
- Technical documentation
- Professional reports
- Industry-specific writing

**Suspicious contexts:**
- Blog posts and articles
- Social media content
- Casual emails
- Personal writing

**Red flag combinations:**
- "innovative solution" + "cutting-edge approach" + "game-changing impact"
- "leverage our framework" + "drive meaningful results" + "unlock new opportunities"
- "dynamic ecosystem" + "strategic roadmap" + "scalable solutions"

---

## AI PHRASE PATTERNS

Beyond individual words, watch for these multi-word patterns:

### Significance Inflation Phrases
- "marks a significant milestone"
- "represents a major shift"
- "stands as a testament to"
- "serves as a reminder"
- "underscores the importance of"
- "highlights the critical role of"
- "reflects broader trends"
- "symbolizes the ongoing"
- "contributes to the growing"
- "shapes the future of"
- "sets the stage for"
- "paves the way for"

### Vague Authority Phrases
- "experts believe"
- "studies show"
- "research indicates"
- "industry reports suggest"
- "observers have noted"
- "analysts predict"
- "sources confirm"
- "it is widely believed"
- "it is generally accepted"
- "conventional wisdom holds"

### Formulaic Transition Phrases
- "In today's [adjective] world"
- "In an era of [noun]"
- "In the age of [noun]"
- "As we navigate [noun]"
- "As we move forward"
- "Looking ahead"
- "Moving forward"
- "Going forward"
- "At the end of the day"
- "When all is said and done"

### Promotional Modifier Phrases
- "boasts a [noun]"
- "nestled in the heart of"
- "renowned for its"
- "breathtaking views of"
- "stunning array of"
- "vibrant community"
- "rich history"
- "unique blend of"
- "perfect combination of"
- "ideal destination for"

---

## STATISTICAL PATTERNS

### High-Frequency Co-Occurrence Sets

These word groups often appear together in AI text:

**Set 1: Business Transformation**
- innovative + dynamic + transformative
- leverage + optimize + streamline
- paradigm + framework + ecosystem

**Set 2: Quality Emphasis**
- comprehensive + robust + seamless
- cutting-edge + state-of-the-art + groundbreaking
- holistic + nuanced + multifaceted

**Set 3: Action & Impact**
- drive + catalyze + accelerate
- empower + enable + facilitate
- foster + cultivate + champion

**Set 4: Significance**
- crucial + pivotal + paramount
- vital + critical + essential
- key + significant + important

**Detection rule:** If 3+ words from the same set appear in one paragraph, flag as AI-likely.

---

## REPLACEMENT STRATEGIES

### Simplification Strategy

Replace complex AI vocabulary with simple alternatives:

| AI Word | Simple Alternative |
|---------|-------------------|
| utilize | use |
| facilitate | help, enable |
| leverage | use |
| optimize | improve |
| implement | do, start, set up |
| additionally | also, too |
| moreover | also, besides |
| endeavor (verb) | try |
| ascertain | find out, check |
| regarding | about |
| concerning | about |
| in order to | to |
| due to the fact that | because |

### Specificity Strategy

Replace vague AI terms with concrete alternatives:

| Vague AI Term | Concrete Alternative |
|---------------|---------------------|
| innovative solution | [describe what it actually does] |
| cutting-edge technology | [name the technology] |
| robust framework | [explain the specific features] |
| seamless experience | [describe how it works] |
| game-changing impact | [quantify the impact] |

### Casualization Strategy

Replace formal AI vocabulary with conversational alternatives:

| Formal AI | Casual Human |
|-----------|--------------|
| endeavor to | try to |
| ascertain | find out |
| commence | start |
| terminate | end, stop |
| subsequent to | after |
| prior to | before |
| in the vicinity of | near |

---

## DETECTION SCORING

### Vocabulary Density Score

Calculate AI likelihood based on word density:

**Tier 1 words:**
- 0 instances = 0 points
- 1-2 instances per 1000 words = 20 points
- 3-5 instances per 1000 words = 50 points
- 6+ instances per 1000 words = 100 points

**Tier 2 words:**
- 0-2 instances per 1000 words = 0 points
- 3-5 instances = 15 points
- 6-10 instances = 35 points
- 11+ instances = 70 points

**Tier 3 phrases:**
- 0-3 instances per 1000 words = 0 points
- 4-7 instances = 10 points
- 8-12 instances = 25 points
- 13+ instances = 50 points

**Total Score Interpretation:**
- 0-20 points: Likely human
- 21-50 points: Possibly AI or heavily edited
- 51-100 points: Likely AI
- 100+ points: Almost certainly AI

---

## CONTEXT-APPROPRIATE VOCABULARY

### When AI Words Are Acceptable

**Technical Documentation:**
- "utilize" is fine in API docs
- "implement" is standard in dev guides
- "framework" is appropriate technical term

**Academic Writing:**
- "paradigm" has specific meaning
- "facilitate" is standard academic language
- "methodology" is appropriate

**Business Strategy:**
- "leverage" (financial context)
- "stakeholder" (project management)
- "roadmap" (product planning)

**The key:** Even in these contexts, watch density. One "facilitate" per page is fine. Five per paragraph screams AI.

---

## QUICK SCAN CHECKLIST

Use this for rapid vocabulary detection:

**Tier 1 scan (30 seconds):**
- [ ] Search for: delve, tapestry, vibrant, seamless, robust
- [ ] Search for: crucial, leverage, testament, pivotal, nestled
- [ ] Search for: realm, embark, catalyst, paramount, myriad

**Tier 2 scan (1 minute):**
- [ ] Count instances of: additionally, moreover, facilitate, utilize
- [ ] Count instances of: paradigm, holistic, quintessential
- [ ] Flag if total > 5 per 1000 words

**Tier 3 scan (2 minutes):**
- [ ] Check business jargon density (ecosystem, framework, leverage, etc.)
- [ ] Check transition phrase frequency
- [ ] Flag if patterns feel repetitive

**Total scan time: ~3 minutes for comprehensive vocabulary check**
