# The 24 AI Writing Patterns

Comprehensive guide to detecting and removing AI writing patterns. Based on Wikipedia's "Signs of AI writing" page and Copyleaks research.

---

## CONTENT PATTERNS

### Pattern 1: Undue Emphasis on Significance, Legacy, and Broader Trends

**What it is:** LLM writing puffs up importance by adding statements about how arbitrary aspects represent or contribute to a broader topic.

**Words to watch:**
- stands/serves as
- is a testament/reminder
- a vital/significant/crucial/pivotal/key role/moment
- underscores/highlights its importance/significance
- reflects broader
- symbolizing its ongoing/enduring/lasting
- contributing to the
- setting the stage for
- marking/shaping the
- represents/marks a shift
- key turning point
- evolving landscape
- focal point
- indelible mark
- deeply rooted

**Before:**
The Statistical Institute of Catalonia was officially established in 1989, marking a pivotal moment in the evolution of regional statistics in Spain. This initiative was part of a broader movement across Spain to decentralize administrative functions and enhance regional governance.

**After:**
The Statistical Institute of Catalonia was established in 1989 to collect and publish regional statistics independently from Spain's national statistics office.

**Why it works:** Removes inflated significance, states facts directly, drops vague "broader movement" claims.

---

### Pattern 2: Undue Emphasis on Notability and Media Coverage

**What it is:** LLMs hit readers over the head with claims of notability, often listing sources without context.

**Words to watch:**
- independent coverage
- local/regional/national media outlets
- written by a leading expert
- active social media presence
- featured in [list of outlets]

**Before:**
Her views have been cited in The New York Times, BBC, Financial Times, and The Hindu. She maintains an active social media presence with over 500,000 followers.

**After:**
In a 2024 New York Times interview, she argued that AI regulation should focus on outcomes rather than methods.

**Why it works:** Cites specific coverage with actual content instead of name-dropping outlets. Removes social media follower count (irrelevant metric).

---

### Pattern 3: Superficial Analyses with -ing Endings

**What it is:** AI chatbots tack present participle ("-ing") phrases onto sentences to add fake depth.

**Words to watch:**
- highlighting/underscoring/emphasizing...
- ensuring...
- reflecting/symbolizing...
- contributing to...
- cultivating/fostering...
- encompassing...
- showcasing...

**Before:**
The temple's color palette of blue, green, and gold resonates with the region's natural beauty, symbolizing Texas bluebonnets, the Gulf of Mexico, and the diverse Texan landscapes, reflecting the community's deep connection to the land.

**After:**
The temple uses blue, green, and gold colors. The architect said these were chosen to reference local bluebonnets and the Gulf coast.

**Why it works:** Removes stacked -ing phrases, attributes claim to specific source, cuts vague "deep connection" language.

---

### Pattern 4: Promotional and Advertisement-like Language

**What it is:** LLMs have serious problems keeping a neutral tone, especially for "cultural heritage" topics.

**Words to watch:**
- boasts a
- vibrant
- rich (figurative)
- profound
- enhancing its
- showcasing
- exemplifies
- commitment to
- natural beauty
- nestled
- in the heart of
- groundbreaking (figurative)
- renowned
- breathtaking
- must-visit
- stunning

**Before:**
Nestled within the breathtaking region of Gonder in Ethiopia, Alamata Raya Kobo stands as a vibrant town with a rich cultural heritage and stunning natural beauty.

**After:**
Alamata Raya Kobo is a town in the Gonder region of Ethiopia, known for its weekly market and 18th-century church.

**Why it works:** Removes promotional adjectives (breathtaking, vibrant, stunning), replaces with specific notable features.

---

### Pattern 5: Vague Attributions and Weasel Words

**What it is:** AI chatbots attribute opinions to vague authorities without specific sources.

**Words to watch:**
- Industry reports
- Observers have cited
- Experts argue
- Some critics argue
- several sources/publications (when few cited)
- Studies show
- Research indicates
- It is widely believed

**Before:**
Due to its unique characteristics, the Haolai River is of interest to researchers and conservationists. Experts believe it plays a crucial role in the regional ecosystem.

**After:**
The Haolai River supports several endemic fish species, according to a 2019 survey by the Chinese Academy of Sciences.

**Why it works:** Names specific source, cites specific finding, removes vague "experts believe" claim.

---

### Pattern 6: Outline-like "Challenges and Future Prospects" Sections

**What it is:** Many LLM-generated articles include formulaic "Challenges" sections.

**Words to watch:**
- Despite its... faces several challenges...
- Despite these challenges
- Challenges and Legacy
- Future Outlook
- Looking ahead
- Moving forward

**Before:**
Despite its industrial prosperity, Korattur faces challenges typical of urban areas, including traffic congestion and water scarcity. Despite these challenges, with its strategic location and ongoing initiatives, Korattur continues to thrive as an integral part of Chennai's growth.

**After:**
Traffic congestion increased after 2015 when three new IT parks opened. The municipal corporation began a stormwater drainage project in 2022 to address recurring floods.

**Why it works:** Replaces formulaic structure with specific facts, dates, and causes. Removes "thriving" boilerplate.

---

## LANGUAGE AND GRAMMAR PATTERNS

### Pattern 7: Overused "AI Vocabulary" Words

**What it is:** These words appear far more frequently in post-2023 text. They often co-occur.

**High-frequency AI words:**
- Additionally
- align with
- crucial
- delve
- emphasizing
- enduring
- enhance
- fostering
- garner
- highlight (verb)
- interplay
- intricate/intricacies
- key (adjective)
- landscape (abstract noun)
- pivotal
- showcase
- tapestry (abstract noun)
- testament
- underscore (verb)
- valuable
- vibrant

**Before:**
Additionally, a distinctive feature of Somali cuisine is the incorporation of camel meat. An enduring testament to Italian colonial influence is the widespread adoption of pasta in the local culinary landscape, showcasing how these dishes have integrated into the traditional diet.

**After:**
Somali cuisine also includes camel meat, which is considered a delicacy. Pasta dishes, introduced during Italian colonization, remain common, especially in the south.

**Why it works:** Replaces "Additionally" with "also", removes "enduring testament", "landscape", "showcasing", uses simple "is" and "includes".

---

### Pattern 8: Avoidance of "is"/"are" (Copula Avoidance)

**What it is:** LLMs substitute elaborate constructions for simple copulas.

**Words to watch:**
- serves as/stands as/marks/represents [a]
- boasts/features/offers [a]

**Before:**
Gallery 825 serves as LAAA's exhibition space for contemporary art. The gallery features four separate spaces and boasts over 3,000 square feet.

**After:**
Gallery 825 is LAAA's exhibition space for contemporary art. The gallery has four rooms totaling 3,000 square feet.

**Why it works:** Uses simple "is" and "has" instead of elaborate "serves as", "features", "boasts".

---

### Pattern 9: Negative Parallelisms

**What it is:** Constructions like "Not only...but..." or "It's not just about..., it's..." are overused.

**Phrases to watch:**
- It's not just X, it's Y
- Not only X, but Y
- It's not about X, it's about Y
- Not merely X, but Y

**Before:**
It's not just about the beat riding under the vocals; it's part of the aggression and atmosphere. It's not merely a song, it's a statement.

**After:**
The heavy beat adds to the aggressive tone.

**Why it works:** Direct statement instead of rhetorical contrast. Cuts unnecessary emphasis.

---

### Pattern 10: Rule of Three Overuse

**What it is:** LLMs force ideas into groups of three to appear comprehensive.

**Before:**
The event features keynote sessions, panel discussions, and networking opportunities. Attendees can expect innovation, inspiration, and industry insights.

**After:**
The event includes talks and panels. There's also time for informal networking between sessions.

**Why it works:** Natural grouping (talks + panels), doesn't force third item. Second sentence varied structure.

---

### Pattern 11: Elegant Variation (Synonym Cycling)

**What it is:** AI has repetition-penalty code causing excessive synonym substitution.

**Before:**
The protagonist faces many challenges. The main character must overcome obstacles. The central figure eventually triumphs. The hero returns home.

**After:**
The protagonist faces many challenges but eventually triumphs and returns home.

**Why it works:** Uses one consistent term instead of cycling through synonyms unnecessarily.

---

### Pattern 12: False Ranges

**What it is:** LLMs use "from X to Y" constructions where X and Y aren't on a meaningful scale.

**Before:**
Our journey through the universe has taken us from the singularity of the Big Bang to the grand cosmic web, from the birth and death of stars to the enigmatic dance of dark matter.

**After:**
The book covers the Big Bang, star formation, and current theories about dark matter.

**Why it works:** Lists topics directly instead of forcing them into false "from X to Y" ranges.

---

## STYLE PATTERNS

### Pattern 13: Em Dash Overuse

**What it is:** LLMs use em dashes (—) more than humans, mimicking "punchy" sales writing.

**Before:**
The term is primarily promoted by Dutch institutions—not by the people themselves. You don't say "Netherlands, Europe" as an address—yet this mislabeling continues—even in official documents.

**After:**
The term is primarily promoted by Dutch institutions, not by the people themselves. You don't say "Netherlands, Europe" as an address, yet this mislabeling continues in official documents.

**Why it works:** Uses commas and periods instead of em dashes. Maintains flow without over-punctuation.

---

### Pattern 14: Overuse of Boldface

**What it is:** AI chatbots emphasize phrases in boldface mechanically.

**Before:**
It blends **OKRs** (Objectives and Key Results), **KPIs** (Key Performance Indicators), and visual strategy tools such as the **Business Model Canvas (BMC)** and **Balanced Scorecard (BSC)**.

**After:**
It blends OKRs, KPIs, and visual strategy tools like the Business Model Canvas and Balanced Scorecard.

**Why it works:** Removes unnecessary bold emphasis, lets content speak for itself.

---

### Pattern 15: Inline-Header Vertical Lists

**What it is:** AI outputs lists where items start with bolded headers followed by colons.

**Before:**
- **User Experience:** The user experience has been significantly improved with a new interface.
- **Performance:** Performance has been enhanced through optimized algorithms.
- **Security:** Security has been strengthened with end-to-end encryption.

**After:**
The update improves the interface, speeds up load times through optimized algorithms, and adds end-to-end encryption.

**Why it works:** Converts mechanical list to natural prose. Removes redundant header words.

---

### Pattern 16: Title Case in Headings

**What it is:** AI chatbots capitalize all main words in headings.

**Before:**
## Strategic Negotiations And Global Partnerships

**After:**
## Strategic negotiations and global partnerships

**Why it works:** Uses sentence case (only first word capitalized), which is more common in modern writing.

---

### Pattern 17: Emojis

**What it is:** AI chatbots often decorate headings or bullet points with emojis.

**Before:**
🚀 Launch Phase: The product launches in Q3
💡 Key Insight: Users prefer simplicity
✅ Next Steps: Schedule follow-up meeting

**After:**
The product launches in Q3. User research showed a preference for simplicity. Next step: schedule a follow-up meeting.

**Why it works:** Removes decorative emojis, converts to natural prose.

---

### Pattern 18: Curly Quotation Marks

**What it is:** ChatGPT uses curly quotes ("...") instead of straight quotes ("...").

**Before:**
He said "the project is on track" but others disagreed.

**After:**
He said "the project is on track" but others disagreed.

**Why it works:** Uses straight quotes (standard in most writing).

---

## COMMUNICATION PATTERNS

### Pattern 19: Collaborative Communication Artifacts

**What it is:** Text meant as chatbot correspondence gets pasted as content.

**Words to watch:**
- I hope this helps
- Of course!
- Certainly!
- You're absolutely right!
- Would you like...
- let me know
- here is a...

**Before:**
Here is an overview of the French Revolution. I hope this helps! Let me know if you'd like me to expand on any section.

**After:**
The French Revolution began in 1789 when financial crisis and food shortages led to widespread unrest.

**Why it works:** Removes chatbot framing, presents content directly.

---

### Pattern 20: Knowledge-Cutoff Disclaimers

**What it is:** AI disclaimers about incomplete information get left in text.

**Words to watch:**
- as of [date]
- Up to my last training update
- While specific details are limited/scarce...
- based on available information...

**Before:**
While specific details about the company's founding are not extensively documented in readily available sources, it appears to have been established sometime in the 1990s.

**After:**
The company was founded in 1994, according to its registration documents.

**Why it works:** Removes uncertainty disclaimer, provides specific fact with source.

---

### Pattern 21: Sycophantic/Servile Tone

**What it is:** Overly positive, people-pleasing language.

**Before:**
Great question! You're absolutely right that this is a complex topic. That's an excellent point about the economic factors.

**After:**
The economic factors you mentioned are relevant here.

**Why it works:** Removes praise filler, acknowledges point directly.

---

## FILLER AND HEDGING

### Pattern 22: Filler Phrases

**Common fillers and fixes:**

| Before | After |
|--------|-------|
| In order to achieve this goal | To achieve this |
| Due to the fact that it was raining | Because it was raining |
| At this point in time | Now |
| In the event that you need help | If you need help |
| The system has the ability to process | The system can process |
| It is important to note that the data shows | The data shows |
| For the purpose of | To |
| In spite of the fact that | Although |
| With regard to | About |
| In light of the fact that | Since |

**Why it works:** Removes bloat, makes writing more direct and efficient.

---

### Pattern 23: Excessive Hedging

**What it is:** Over-qualifying statements with multiple hedges.

**Before:**
It could potentially possibly be argued that the policy might have some effect on outcomes.

**After:**
The policy may affect outcomes.

**Why it works:** One hedge ("may") is enough. Removes redundant qualifiers.

---

### Pattern 24: Generic Positive Conclusions

**What it is:** Vague upbeat endings that say nothing specific.

**Before:**
The future looks bright for the company. Exciting times lie ahead as they continue their journey toward excellence. This represents a major step in the right direction.

**After:**
The company plans to open two more locations next year.

**Why it works:** Specific future action instead of vague optimism.

---

## Quick Detection Checklist

Use this checklist for rapid pattern scanning:

- [ ] Scan first paragraph for "serves as a testament", "marking a pivotal moment"
- [ ] Check for media outlet name-drops without specific claims
- [ ] Look for -ing phrase chains (showcasing, reflecting, highlighting)
- [ ] Flag promotional adjectives (nestled, breathtaking, vibrant, renowned)
- [ ] Check attributions—are they specific or vague?
- [ ] Look for "Despite challenges... continues to thrive" structure
- [ ] Count AI vocabulary words (crucial, delve, landscape, showcase, etc.)
- [ ] Check if "is"/"are"/"has" could replace "serves as"/"boasts"/"features"
- [ ] Look for "It's not just X, it's Y" patterns
- [ ] Check for groups of three items
- [ ] Look for synonym cycling (protagonist/character/hero)
- [ ] Check for "from X to Y" false ranges
- [ ] Count em dashes (—)
- [ ] Check for mechanical bold emphasis
- [ ] Look for inline-header lists (- **Topic:** Description)
- [ ] Check heading capitalization (Title Case vs sentence case)
- [ ] Look for decorative emojis
- [ ] Check quotation mark style (curly vs straight)
- [ ] Look for "I hope this helps!" and "Let me know if..."
- [ ] Check for "as of [date]" disclaimers
- [ ] Look for "Great question!" and excessive praise
- [ ] Check for "in order to", "due to the fact that", etc.
- [ ] Look for stacked hedges (could possibly potentially might)
- [ ] Check last paragraph for "future looks bright" or similar

**If 5+ patterns detected:** Text is very likely AI-generated
**If 10+ patterns detected:** Text is almost certainly AI-generated
