# Listing Optimization - OpenTable

## Conversion Foundations

A listing should reduce uncertainty fast:
- what the venue is
- what experience to expect
- when to book
- why this reservation is worth taking now

If a guest must guess, conversion drops.

## Profile Quality Checklist

| Element | Minimum Bar | Upgrade Move |
|--------|--------------|--------------|
| Title and positioning | Clear concept and cuisine in plain language | Add unique hook without jargon |
| Photos | Current and representative | Sequence by decision flow: space, dishes, social proof |
| Menu signals | Accurate and up to date | Highlight signature items and constraints |
| Policies | Visible before booking | Rewrite in neutral, guest-first language |
| Special events | Correct dates and seat times | Add concise value framing and clear inclusions |

## Messaging Patterns

- Replace vague claims with observable details.
- Keep policy text firm but non-punitive.
- Align tone with service level and audience.
- Avoid long blocks of text where bullets communicate faster.

## Experiment Ideas

- A/B test hero photo sequence by daypart demand.
- Test policy copy that clarifies cancellation expectations.
- Test event title framing with concrete value language.
- Measure booking conversion impact before scaling edits.

## Signals to Watch

- Booking conversion by traffic source
- Lead time shifts after listing updates
- Drop-off near confirmation step
- Increase in support questions tied to unclear listing copy
