# Troubleshooting Guide

Common issues and solutions when using the OpenGraph.io API.

## Common Issues

### No OpenGraph Tags Found

**Symptom:** Response shows `"openGraph": {"error": "No OpenGraph Tags Found"}`

**Causes & Solutions:**

1. **The site genuinely has no OG tags**
   - Check `hybridGraph` — it contains inferred data from HTML
   - Use `/extract` endpoint to get specific elements

2. **JavaScript-rendered content**
   - Add `full_render=true` to render JavaScript first
   ```bash
   ?full_render=true
   ```

3. **Content behind authentication**
   - OpenGraph.io cannot access authenticated content
   - Only public pages are supported

---

### Empty or Minimal Data

**Symptom:** Response has title but missing description, image, etc.

**Solutions:**

1. **Try full rendering:**
   ```bash
   ?full_render=true
   ```

2. **Try with proxy:**
   ```bash
   ?use_proxy=true
   ```

3. **Check `htmlInferred`** — it may have data that `openGraph` doesn't

4. **The page may genuinely lack metadata** — not all sites implement OG tags

---

### Site Unreachable (Error 104)

**Symptom:** Error code 104, site unreachable

**Causes & Solutions:**

1. **Site is blocking datacenter IPs**
   ```bash
   ?use_proxy=true
   ```

2. **Geo-restricted content**
   ```bash
   ?use_proxy=true
   ```

3. **Site is actually down**
   - Verify the URL works in your browser
   - Check if the site is online

4. **SSL/TLS issues**
   - Some sites have certificate problems
   - Try with `auto_proxy=true` for automatic retry

---

### Timeout (Error 105)

**Symptom:** Request times out

**Causes & Solutions:**

1. **Slow site + full_render**
   - Full rendering takes longer
   - The site may be genuinely slow

2. **Heavy JavaScript**
   - Some SPAs take a long time to fully render
   - Consider if you really need `full_render`

3. **Large page**
   - Very large pages take longer to process

---

### Rate Limit Exceeded (Error 102)

**Symptom:** Error code 102, rate limit exceeded

**Solutions:**

1. **Check your usage:**
   - Visit [dashboard.opengraph.io](https://dashboard.opengraph.io)
   - Review current usage vs. limits

2. **Enable caching:**
   ```bash
   ?cache_ok=true  # (default)
   ```

3. **Upgrade your plan:**
   - Free tier: 100 requests/month
   - Paid plans have higher limits

4. **Check response headers:**
   ```
   X-RateLimit-Remaining: 5
   X-RateLimit-Reset: 1706547200
   ```

---

### Invalid URL (Error 103)

**Symptom:** Error code 103, invalid URL

**Solutions:**

1. **URL encode properly:**
   ```bash
   # Bash with jq
   encoded=$(echo -n 'https://example.com/path?query=value' | jq -sRr @uri)
   
   # JavaScript
   const encoded = encodeURIComponent(url);
   ```

2. **Check URL format:**
   - Must include protocol (`https://` or `http://`)
   - Must be a valid URL format

3. **No fragments:**
   - URL fragments (`#section`) may cause issues
   - Strip them if not needed

---

### Wrong Language Content

**Symptom:** Getting content in unexpected language

**Solutions:**

1. **Set Accept-Language header:**
   ```bash
   ?accept_lang=en-US,en;q=0.9
   ```

2. **For specific regions:**
   ```bash
   ?accept_lang=de-DE,de;q=0.9  # German
   ?accept_lang=ja-JP,ja;q=0.9  # Japanese
   ```

---

### Cached Content is Stale

**Symptom:** Getting old data when page has been updated

**Solutions:**

1. **Disable cache:**
   ```bash
   ?cache_ok=false
   ```

2. **Set shorter cache age:**
   ```bash
   ?max_cache_age=3600000  # 1 hour in ms
   ```

---

## Image Generation Issues

### Diagram Syntax Errors

**Symptom:** "Invalid diagram syntax" error

**Solutions:**

1. **Validate syntax first:**
   - Test Mermaid at [mermaid.live](https://mermaid.live)
   - Test D2 at [d2lang.com/playground](https://d2lang.com/playground)

2. **Use `diagramCode` not `prompt`:**
   ```json
   {
     "diagramCode": "flowchart LR\n  A-->B-->C",
     "diagramFormat": "mermaid"
   }
   ```

3. **Don't mix syntax with description:**
   ```json
   // ❌ WRONG
   {"prompt": "graph LR A-->B make it beautiful"}
   
   // ✅ CORRECT  
   {
     "diagramCode": "graph LR\n  A-->B",
     "diagramFormat": "mermaid",
     "stylePreferences": "beautiful, modern"
   }
   ```

---

### Image Quality Issues

**Symptom:** Generated image looks wrong or low quality

**Solutions:**

1. **Increase quality:**
   ```json
   {"quality": "high"}
   ```

2. **Use appropriate `kind`:**
   - `icon` for logos
   - `diagram` for technical diagrams
   - `social-card` for OG images
   - `illustration` for general images

3. **For diagrams, use `outputStyle: "standard"`:**
   ```json
   {
     "outputStyle": "standard"  // Premium may alter layout
   }
   ```

---

### Wrong Aspect Ratio

**Symptom:** Image dimensions aren't what you expected

**Solutions:**

1. **Specify aspect ratio explicitly:**
   ```json
   {
     "aspectRatio": "og-image"  // 1200x630
   }
   ```

2. **Check available presets:**
   - `square` — 1024×1024
   - `og-image` — 1200×630
   - `twitter-card` — 1200×600
   - `wide` — 1920×1080

---

## Debugging Tips

### Check the Full Response

Always examine the complete response:
- `hybridGraph` — best combined data
- `openGraph` — raw OG tags
- `htmlInferred` — data inferred from HTML
- `requestInfo` — request metadata

### Use `requestInfo` for Diagnostics

```json
{
  "requestInfo": {
    "responseCode": 200,      // HTTP status from target
    "full_render": false,     // Was rendering used?
    "use_proxy": false,       // Was proxy used?
    "cache_ok": true,         // Was cache allowed?
    "redirects": 2            // Number of redirects
  }
}
```

### Test Incrementally

1. Start with basic request
2. Add `full_render=true` if needed
3. Add `use_proxy=true` if still failing
4. Try `auto_proxy=true` for automatic escalation

### Compare with Browser

1. Open URL in browser
2. View page source (Ctrl+U)
3. Search for `og:` tags
4. Compare with API response

---

## Getting Help

### Support Channels

- **Documentation:** [docs.opengraph.io](https://docs.opengraph.io)
- **Dashboard:** [dashboard.opengraph.io](https://dashboard.opengraph.io)
- **Email:** support@opengraph.io

### Information to Include

When reporting issues, include:
1. The URL you're trying to fetch
2. Full API request (with app_id redacted)
3. Full response body
4. What you expected vs. what you got
