# Platform Support

OpenGraph.io extracts rich metadata from a wide variety of platforms. This reference shows what data is available from popular sites.

## Video Platforms

### YouTube

Full metadata extraction including engagement metrics.

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | "Video Title (4K Remaster)" |
| `description` | Full video description |
| `image` / `imageSecureUrl` | Thumbnail (maxresdefault) |
| `imageWidth` / `imageHeight` | 1280 × 720 |
| `video` | Embed URL (`youtube.com/embed/ID`) |
| `site_name` | Channel name |
| `profileUsername` | Channel name |
| `articleLikes` | Like count |
| `articleComments` | Comment count |
| `articleViews` | View count |

**Example Request:**
```bash
curl -s "https://opengraph.io/api/1.1/site/$(echo -n 'https://www.youtube.com/watch?v=dQw4w9WgXcQ' | jq -sRr @uri)?app_id=${OPENGRAPH_APP_ID}"
```

**Example Response (hybridGraph):**
```json
{
  "title": "Rick Astley - Never Gonna Give You Up (Official Video)",
  "description": "The official video for 'Never Gonna Give You Up'...",
  "type": "photo",
  "imageSecureUrl": "https://i.ytimg.com/vi/dQw4w9WgXcQ/maxresdefault.jpg",
  "imageWidth": 1280,
  "imageHeight": 720,
  "video": "https://www.youtube.com/embed/dQw4w9WgXcQ",
  "site_name": "Rick Astley",
  "profileUsername": "Rick Astley",
  "articleLikes": "18769272",
  "articleComments": "2416252",
  "articleViews": "1738229652"
}
```

---

### Vimeo

Full OG tag support with video embed.

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Video title |
| `description` | Video description |
| `image` | Thumbnail URL |
| `video` / `videoSecureUrl` | Embed URL |
| `videoWidth` / `videoHeight` | Video dimensions |
| `site_name` | "Vimeo" |

**Example Response (hybridGraph):**
```json
{
  "title": "The New Vimeo Player",
  "description": "It may look (mostly) the same...",
  "type": "video.other",
  "image": "https://i.vimeocdn.com/video/452001751.jpg",
  "video": "https://player.vimeo.com/video/76979871",
  "videoWidth": "1280",
  "videoHeight": "720",
  "site_name": "Vimeo"
}
```

---

### TikTok

> ⚠️ **Requires `full_render=true`** — TikTok is JavaScript-heavy.

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Video caption |
| `description` | Full caption with hashtags |
| `image` | Video thumbnail |
| `site_name` | "TikTok" |

**Example Request:**
```bash
curl -s "https://opengraph.io/api/1.1/site/$(echo -n 'https://www.tiktok.com/@user/video/123' | jq -sRr @uri)?app_id=${OPENGRAPH_APP_ID}&full_render=true"
```

---

## Social Platforms

### Twitter / X

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Tweet author and preview |
| `description` | Tweet text |
| `image` | Profile picture or media |
| `site_name` | "X (formerly Twitter)" |

> 💡 For best results on Twitter/X, use `full_render=true`.

---

### LinkedIn

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Post title or profile name |
| `description` | Post content preview |
| `image` | Profile or post image |
| `site_name` | "LinkedIn" |

---

### Facebook

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Page or post title |
| `description` | Page description |
| `image` | Cover or post image |
| `site_name` | "Facebook" |

---

## E-commerce Platforms

### Amazon

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Product name |
| `description` | Product description |
| `image` | Product image |
| `site_name` | "Amazon.com" |

> 💡 Use `use_proxy=true` for better results with Amazon.

---

### Shopify Stores

Most Shopify stores have excellent OG tag support.

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Product name |
| `description` | Product description |
| `image` | Product image |
| `type` | "product" |
| `site_name` | Store name |

---

## News & Publishing

### Medium

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Article title |
| `description` | Article subtitle/preview |
| `image` | Article hero image |
| `type` | "article" |
| `site_name` | "Medium" |

---

### Substack

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Post title |
| `description` | Post preview |
| `image` | Post image |
| `type` | "article" |
| `site_name` | Newsletter name |

---

### News Sites (NYT, BBC, etc.)

Most major news sites have full OG tag support.

**Common Fields:**
| Field | Description |
|-------|-------------|
| `title` | Headline |
| `description` | Article lede |
| `image` | Article image |
| `type` | "article" |
| `article:published_time` | Publish date |
| `article:author` | Author name |

---

## Developer Platforms

### GitHub

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Repo name and description |
| `description` | Repo description |
| `image` | OpenGraph image (auto-generated) |
| `site_name` | "GitHub" |

---

### npm

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Package name |
| `description` | Package description |
| `image` | npm logo |
| `site_name` | "npm" |

---

## Music Platforms

### Spotify

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Track/Album/Artist name |
| `description` | Artist or album info |
| `image` | Album artwork |
| `audio` | Preview URL (when available) |
| `site_name` | "Spotify" |

---

### SoundCloud

**Extracted Fields:**
| Field | Example |
|-------|---------|
| `title` | Track name |
| `description` | Track description |
| `image` | Artwork |
| `site_name` | "SoundCloud" |

---

## Platform Tips

### When to use `full_render=true`

Use headless rendering for:
- Single-page applications (React, Vue, Angular)
- TikTok, Instagram
- Sites with heavy JavaScript
- Dynamic content that loads after page load

```bash
?full_render=true
```

### When to use `use_proxy=true`

Use proxy for:
- Geo-restricted content
- Sites that block datacenter IPs
- Amazon, some news paywalls
- Rate-limited sites

```bash
?use_proxy=true
```

### Combining options

For difficult sites, combine both:
```bash
?full_render=true&use_proxy=true&auto_proxy=true
```

`auto_proxy=true` will automatically retry with proxy if the first request fails.
