# MCP Client Setup

Configure OpenGraph.io MCP server for various AI clients.

## Quick Install (Recommended)

The interactive CLI auto-configures your client:

```bash
npx opengraph-io-mcp --client cursor --app-id YOUR_APP_ID
```

Supported clients: `cursor`, `claude-desktop`, `windsurf`, `vscode`, `zed`, `jetbrains`, `cline`

## Manual Configuration

### Claude Desktop

Config location:
- **macOS**: `~/Library/Application Support/Claude/claude_desktop_config.json`
- **Windows**: `%APPDATA%\Claude\claude_desktop_config.json`

```json
{
  "mcpServers": {
    "opengraph": {
      "command": "npx",
      "args": ["-y", "opengraph-io-mcp"],
      "env": {
        "OPENGRAPH_APP_ID": "YOUR_APP_ID"
      }
    }
  }
}
```

### Claude Code

One-command installation:

```bash
claude mcp add --transport stdio --env OPENGRAPH_APP_ID=YOUR_APP_ID opengraph -- npx -y opengraph-io-mcp
```

### Cursor

Config location: `~/.cursor/mcp.json`

```json
{
  "mcpServers": {
    "opengraph": {
      "command": "npx",
      "args": ["-y", "opengraph-io-mcp"],
      "env": {
        "OPENGRAPH_APP_ID": "YOUR_APP_ID"
      }
    }
  }
}
```

### VS Code

Config location: `.vscode/mcp.json` (project) or User Settings

```json
{
  "inputs": [
    {
      "type": "promptString",
      "id": "opengraph-app-id",
      "description": "OpenGraph App ID",
      "password": true
    }
  ],
  "servers": {
    "opengraph": {
      "type": "stdio",
      "command": "npx",
      "args": ["-y", "opengraph-io-mcp"],
      "env": {
        "OPENGRAPH_APP_ID": "${input:opengraph-app-id}"
      }
    }
  }
}
```

### Windsurf

Config location: `~/.codeium/windsurf/mcp_config.json`

```json
{
  "mcpServers": {
    "opengraph": {
      "command": "npx",
      "args": ["-y", "opengraph-io-mcp"],
      "env": {
        "OPENGRAPH_APP_ID": "YOUR_APP_ID"
      }
    }
  }
}
```

### JetBrains AI Assistant

Add to your JetBrains AI Assistant MCP configuration:

```json
{
  "mcpServers": {
    "opengraph": {
      "command": "npx",
      "args": ["-y", "opengraph-io-mcp"],
      "env": {
        "OPENGRAPH_APP_ID": "YOUR_APP_ID"
      }
    }
  }
}
```

### Zed

Config location: `~/.config/zed/settings.json`

Note: Zed uses `context_servers` instead of `mcpServers`:

```json
{
  "context_servers": {
    "opengraph": {
      "command": "npx",
      "args": ["-y", "opengraph-io-mcp"],
      "env": {
        "OPENGRAPH_APP_ID": "YOUR_APP_ID"
      }
    }
  }
}
```

### Cline

Config location: `~/.cline/mcp_config.json`

```json
{
  "mcpServers": {
    "opengraph": {
      "command": "npx",
      "args": ["-y", "opengraph-io-mcp"],
      "env": {
        "OPENGRAPH_APP_ID": "YOUR_APP_ID"
      }
    }
  }
}
```

## Troubleshooting

### Tools not showing up?
1. Restart your AI client after config changes
2. Check the server is running: `npx opengraph-io-mcp --help`
3. Verify your OPENGRAPH_APP_ID is valid at [dashboard.opengraph.io](https://dashboard.opengraph.io)

### Connection issues?
- Ensure Node.js 18+ is installed
- Try running manually: `OPENGRAPH_APP_ID=xxx npx opengraph-io-mcp`
- Check logs in your client's developer tools

### Rate limits?
- Free tier: 100 requests/month
- Check usage at [dashboard.opengraph.io](https://dashboard.opengraph.io)
